@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin

import com.pulumi.alicloud.ga.BasicAccelerateIpArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Global Accelerator (GA) Basic Accelerate IP resource.
 * For information about Global Accelerator (GA) Basic Accelerate IP and how to use it, see [What is Basic Accelerate IP](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-createbasicaccelerateip).
 * > **NOTE:** Available since v1.194.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const region = config.get("region") || "cn-hangzhou";
 * const _default = new alicloud.ga.BasicAccelerator("default", {
 *     duration: 1,
 *     basicAcceleratorName: "terraform-example",
 *     description: "terraform-example",
 *     bandwidthBillingType: "CDT",
 *     autoUseCoupon: "true",
 *     autoPay: true,
 * });
 * const defaultBasicIpSet = new alicloud.ga.BasicIpSet("default", {
 *     acceleratorId: _default.id,
 *     accelerateRegionId: region,
 *     ispType: "BGP",
 *     bandwidth: 5,
 * });
 * const defaultBasicAccelerateIp = new alicloud.ga.BasicAccelerateIp("default", {
 *     acceleratorId: _default.id,
 *     ipSetId: defaultBasicIpSet.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * region = config.get("region")
 * if region is None:
 *     region = "cn-hangzhou"
 * default = alicloud.ga.BasicAccelerator("default",
 *     duration=1,
 *     basic_accelerator_name="terraform-example",
 *     description="terraform-example",
 *     bandwidth_billing_type="CDT",
 *     auto_use_coupon="true",
 *     auto_pay=True)
 * default_basic_ip_set = alicloud.ga.BasicIpSet("default",
 *     accelerator_id=default.id,
 *     accelerate_region_id=region,
 *     isp_type="BGP",
 *     bandwidth=5)
 * default_basic_accelerate_ip = alicloud.ga.BasicAccelerateIp("default",
 *     accelerator_id=default.id,
 *     ip_set_id=default_basic_ip_set.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var region = config.Get("region") ?? "cn-hangzhou";
 *     var @default = new AliCloud.Ga.BasicAccelerator("default", new()
 *     {
 *         Duration = 1,
 *         BasicAcceleratorName = "terraform-example",
 *         Description = "terraform-example",
 *         BandwidthBillingType = "CDT",
 *         AutoUseCoupon = "true",
 *         AutoPay = true,
 *     });
 *     var defaultBasicIpSet = new AliCloud.Ga.BasicIpSet("default", new()
 *     {
 *         AcceleratorId = @default.Id,
 *         AccelerateRegionId = region,
 *         IspType = "BGP",
 *         Bandwidth = 5,
 *     });
 *     var defaultBasicAccelerateIp = new AliCloud.Ga.BasicAccelerateIp("default", new()
 *     {
 *         AcceleratorId = @default.Id,
 *         IpSetId = defaultBasicIpSet.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ga"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		region := "cn-hangzhou"
 * 		if param := cfg.Get("region"); param != "" {
 * 			region = param
 * 		}
 * 		_, err := ga.NewBasicAccelerator(ctx, "default", &ga.BasicAcceleratorArgs{
 * 			Duration:             pulumi.Int(1),
 * 			BasicAcceleratorName: pulumi.String("terraform-example"),
 * 			Description:          pulumi.String("terraform-example"),
 * 			BandwidthBillingType: pulumi.String("CDT"),
 * 			AutoUseCoupon:        pulumi.String("true"),
 * 			AutoPay:              pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultBasicIpSet, err := ga.NewBasicIpSet(ctx, "default", &ga.BasicIpSetArgs{
 * 			AcceleratorId:      _default.ID(),
 * 			AccelerateRegionId: pulumi.String(region),
 * 			IspType:            pulumi.String("BGP"),
 * 			Bandwidth:          pulumi.Int(5),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ga.NewBasicAccelerateIp(ctx, "default", &ga.BasicAccelerateIpArgs{
 * 			AcceleratorId: _default.ID(),
 * 			IpSetId:       defaultBasicIpSet.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ga.BasicAccelerator;
 * import com.pulumi.alicloud.ga.BasicAcceleratorArgs;
 * import com.pulumi.alicloud.ga.BasicIpSet;
 * import com.pulumi.alicloud.ga.BasicIpSetArgs;
 * import com.pulumi.alicloud.ga.BasicAccelerateIp;
 * import com.pulumi.alicloud.ga.BasicAccelerateIpArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var region = config.get("region").orElse("cn-hangzhou");
 *         var default_ = new BasicAccelerator("default", BasicAcceleratorArgs.builder()
 *             .duration(1)
 *             .basicAcceleratorName("terraform-example")
 *             .description("terraform-example")
 *             .bandwidthBillingType("CDT")
 *             .autoUseCoupon("true")
 *             .autoPay(true)
 *             .build());
 *         var defaultBasicIpSet = new BasicIpSet("defaultBasicIpSet", BasicIpSetArgs.builder()
 *             .acceleratorId(default_.id())
 *             .accelerateRegionId(region)
 *             .ispType("BGP")
 *             .bandwidth("5")
 *             .build());
 *         var defaultBasicAccelerateIp = new BasicAccelerateIp("defaultBasicAccelerateIp", BasicAccelerateIpArgs.builder()
 *             .acceleratorId(default_.id())
 *             .ipSetId(defaultBasicIpSet.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   region:
 *     type: string
 *     default: cn-hangzhou
 * resources:
 *   default:
 *     type: alicloud:ga:BasicAccelerator
 *     properties:
 *       duration: 1
 *       basicAcceleratorName: terraform-example
 *       description: terraform-example
 *       bandwidthBillingType: CDT
 *       autoUseCoupon: 'true'
 *       autoPay: true
 *   defaultBasicIpSet:
 *     type: alicloud:ga:BasicIpSet
 *     name: default
 *     properties:
 *       acceleratorId: ${default.id}
 *       accelerateRegionId: ${region}
 *       ispType: BGP
 *       bandwidth: '5'
 *   defaultBasicAccelerateIp:
 *     type: alicloud:ga:BasicAccelerateIp
 *     name: default
 *     properties:
 *       acceleratorId: ${default.id}
 *       ipSetId: ${defaultBasicIpSet.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Global Accelerator (GA) Basic Accelerate IP can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ga/basicAccelerateIp:BasicAccelerateIp example <id>
 * ```
 * @property acceleratorId The ID of the Basic GA instance.
 * @property ipSetId The ID of the Basic Ip Set.
 */
public data class BasicAccelerateIpArgs(
    public val acceleratorId: Output<String>? = null,
    public val ipSetId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ga.BasicAccelerateIpArgs> {
    override fun toJava(): com.pulumi.alicloud.ga.BasicAccelerateIpArgs =
        com.pulumi.alicloud.ga.BasicAccelerateIpArgs.builder()
            .acceleratorId(acceleratorId?.applyValue({ args0 -> args0 }))
            .ipSetId(ipSetId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BasicAccelerateIpArgs].
 */
@PulumiTagMarker
public class BasicAccelerateIpArgsBuilder internal constructor() {
    private var acceleratorId: Output<String>? = null

    private var ipSetId: Output<String>? = null

    /**
     * @param value The ID of the Basic GA instance.
     */
    @JvmName("lngpwvyrrfapxtph")
    public suspend fun acceleratorId(`value`: Output<String>) {
        this.acceleratorId = value
    }

    /**
     * @param value The ID of the Basic Ip Set.
     */
    @JvmName("pyheauyajspecujb")
    public suspend fun ipSetId(`value`: Output<String>) {
        this.ipSetId = value
    }

    /**
     * @param value The ID of the Basic GA instance.
     */
    @JvmName("ocmmcyrfitbbtpnk")
    public suspend fun acceleratorId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceleratorId = mapped
    }

    /**
     * @param value The ID of the Basic Ip Set.
     */
    @JvmName("wbyrylryvtedktwc")
    public suspend fun ipSetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipSetId = mapped
    }

    internal fun build(): BasicAccelerateIpArgs = BasicAccelerateIpArgs(
        acceleratorId = acceleratorId,
        ipSetId = ipSetId,
    )
}
