@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [BasicAccelerator].
 */
@PulumiTagMarker
public class BasicAcceleratorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BasicAcceleratorArgs = BasicAcceleratorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BasicAcceleratorArgsBuilder.() -> Unit) {
        val builder = BasicAcceleratorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BasicAccelerator {
        val builtJavaResource = com.pulumi.alicloud.ga.BasicAccelerator(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BasicAccelerator(builtJavaResource)
    }
}

/**
 * Provides a Global Accelerator (GA) Basic Accelerator resource.
 * For information about Global Accelerator (GA) Basic Accelerator and how to use it, see [What is Basic Accelerator](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-createbasicaccelerator).
 * > **NOTE:** Available since v1.194.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.ga.BasicAccelerator("default", {
 *     duration: 1,
 *     pricingCycle: "Month",
 *     basicAcceleratorName: "tf-example-value",
 *     description: "tf-example-value",
 *     bandwidthBillingType: "BandwidthPackage",
 *     autoPay: true,
 *     autoUseCoupon: "true",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.ga.BasicAccelerator("default",
 *     duration=1,
 *     pricing_cycle="Month",
 *     basic_accelerator_name="tf-example-value",
 *     description="tf-example-value",
 *     bandwidth_billing_type="BandwidthPackage",
 *     auto_pay=True,
 *     auto_use_coupon="true")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Ga.BasicAccelerator("default", new()
 *     {
 *         Duration = 1,
 *         PricingCycle = "Month",
 *         BasicAcceleratorName = "tf-example-value",
 *         Description = "tf-example-value",
 *         BandwidthBillingType = "BandwidthPackage",
 *         AutoPay = true,
 *         AutoUseCoupon = "true",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ga"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ga.NewBasicAccelerator(ctx, "default", &ga.BasicAcceleratorArgs{
 * 			Duration:             pulumi.Int(1),
 * 			PricingCycle:         pulumi.String("Month"),
 * 			BasicAcceleratorName: pulumi.String("tf-example-value"),
 * 			Description:          pulumi.String("tf-example-value"),
 * 			BandwidthBillingType: pulumi.String("BandwidthPackage"),
 * 			AutoPay:              pulumi.Bool(true),
 * 			AutoUseCoupon:        pulumi.String("true"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ga.BasicAccelerator;
 * import com.pulumi.alicloud.ga.BasicAcceleratorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new BasicAccelerator("default", BasicAcceleratorArgs.builder()
 *             .duration(1)
 *             .pricingCycle("Month")
 *             .basicAcceleratorName("tf-example-value")
 *             .description("tf-example-value")
 *             .bandwidthBillingType("BandwidthPackage")
 *             .autoPay(true)
 *             .autoUseCoupon("true")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:ga:BasicAccelerator
 *     properties:
 *       duration: 1
 *       pricingCycle: Month
 *       basicAcceleratorName: tf-example-value
 *       description: tf-example-value
 *       bandwidthBillingType: BandwidthPackage
 *       autoPay: true
 *       autoUseCoupon: 'true'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Global Accelerator (GA) Basic Accelerator can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ga/basicAccelerator:BasicAccelerator example <id>
 * ```
 */
public class BasicAccelerator internal constructor(
    override val javaResource: com.pulumi.alicloud.ga.BasicAccelerator,
) : KotlinCustomResource(javaResource, BasicAcceleratorMapper) {
    /**
     * Specifies whether to enable automatic payment. Default value: `false`. Valid values:
     */
    public val autoPay: Output<Boolean>?
        get() = javaResource.autoPay().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Specifies whether to enable auto-renewal for the GA Basic Accelerator instance. Default value: `false`. Valid values:
     */
    public val autoRenew: Output<Boolean>?
        get() = javaResource.autoRenew().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The auto-renewal period. Unit: months. Default value: `1`. Valid values: `1` to `12`. **NOTE:** This parameter is required only if `auto_renew` is set to `true`.
     */
    public val autoRenewDuration: Output<Int>?
        get() = javaResource.autoRenewDuration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether to automatically pay bills by using coupons. Default value: `false`. **NOTE:** This parameter is required only if `auto_pay` is set to `true`.
     */
    public val autoUseCoupon: Output<String>?
        get() = javaResource.autoUseCoupon().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The bandwidth billing method. Valid values: `BandwidthPackage`, `CDT`, `CDT95`.
     */
    public val bandwidthBillingType: Output<String>?
        get() = javaResource.bandwidthBillingType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the Global Accelerator Basic Accelerator instance.
     */
    public val basicAcceleratorName: Output<String>?
        get() = javaResource.basicAcceleratorName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates whether cross-border acceleration is enabled. Default value: `false`. Valid values:
     */
    public val crossBorderStatus: Output<Boolean>?
        get() = javaResource.crossBorderStatus().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The description of the Global Accelerator Basic Accelerator instance.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The subscription duration. Default value: `1`.
     * * If the `pricing_cycle` parameter is set to `Month`, the valid values for the `duration` parameter are `1` to `9`.
     * * If the `pricing_cycle` parameter is set to `Year`, the valid values for the `duration` parameter are `1` to `3`.
     */
    public val duration: Output<Int>?
        get() = javaResource.duration().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The payment type. Default value: `Subscription`. Valid values: `PayAsYouGo`, `Subscription`.
     */
    public val paymentType: Output<String>
        get() = javaResource.paymentType().applyValue({ args0 -> args0 })

    /**
     * The billing cycle. Default value: `Month`. Valid values: `Month`, `Year`.
     */
    public val pricingCycle: Output<String>?
        get() = javaResource.pricingCycle().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The code of the coupon. **NOTE:** The `promotion_option_no` takes effect only for accounts registered on the international site (alibabacloud.com).
     */
    public val promotionOptionNo: Output<String>?
        get() = javaResource.promotionOptionNo().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the resource group. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * The status of the Basic Accelerator instance.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })
}

public object BasicAcceleratorMapper : ResourceMapper<BasicAccelerator> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ga.BasicAccelerator::class == javaResource::class

    override fun map(javaResource: Resource): BasicAccelerator = BasicAccelerator(
        javaResource as
            com.pulumi.alicloud.ga.BasicAccelerator,
    )
}

/**
 * @see [BasicAccelerator].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BasicAccelerator].
 */
public suspend fun basicAccelerator(
    name: String,
    block: suspend BasicAcceleratorResourceBuilder.() -> Unit,
): BasicAccelerator {
    val builder = BasicAcceleratorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BasicAccelerator].
 * @param name The _unique_ name of the resulting resource.
 */
public fun basicAccelerator(name: String): BasicAccelerator {
    val builder = BasicAcceleratorResourceBuilder()
    builder.name(name)
    return builder.build()
}
