@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin

import com.pulumi.alicloud.ga.BasicAcceleratorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Global Accelerator (GA) Basic Accelerator resource.
 * For information about Global Accelerator (GA) Basic Accelerator and how to use it, see [What is Basic Accelerator](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-createbasicaccelerator).
 * > **NOTE:** Available since v1.194.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.ga.BasicAccelerator("default", {
 *     duration: 1,
 *     pricingCycle: "Month",
 *     basicAcceleratorName: "tf-example-value",
 *     description: "tf-example-value",
 *     bandwidthBillingType: "BandwidthPackage",
 *     autoPay: true,
 *     autoUseCoupon: "true",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.ga.BasicAccelerator("default",
 *     duration=1,
 *     pricing_cycle="Month",
 *     basic_accelerator_name="tf-example-value",
 *     description="tf-example-value",
 *     bandwidth_billing_type="BandwidthPackage",
 *     auto_pay=True,
 *     auto_use_coupon="true")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Ga.BasicAccelerator("default", new()
 *     {
 *         Duration = 1,
 *         PricingCycle = "Month",
 *         BasicAcceleratorName = "tf-example-value",
 *         Description = "tf-example-value",
 *         BandwidthBillingType = "BandwidthPackage",
 *         AutoPay = true,
 *         AutoUseCoupon = "true",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ga"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ga.NewBasicAccelerator(ctx, "default", &ga.BasicAcceleratorArgs{
 * 			Duration:             pulumi.Int(1),
 * 			PricingCycle:         pulumi.String("Month"),
 * 			BasicAcceleratorName: pulumi.String("tf-example-value"),
 * 			Description:          pulumi.String("tf-example-value"),
 * 			BandwidthBillingType: pulumi.String("BandwidthPackage"),
 * 			AutoPay:              pulumi.Bool(true),
 * 			AutoUseCoupon:        pulumi.String("true"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ga.BasicAccelerator;
 * import com.pulumi.alicloud.ga.BasicAcceleratorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new BasicAccelerator("default", BasicAcceleratorArgs.builder()
 *             .duration(1)
 *             .pricingCycle("Month")
 *             .basicAcceleratorName("tf-example-value")
 *             .description("tf-example-value")
 *             .bandwidthBillingType("BandwidthPackage")
 *             .autoPay(true)
 *             .autoUseCoupon("true")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:ga:BasicAccelerator
 *     properties:
 *       duration: 1
 *       pricingCycle: Month
 *       basicAcceleratorName: tf-example-value
 *       description: tf-example-value
 *       bandwidthBillingType: BandwidthPackage
 *       autoPay: true
 *       autoUseCoupon: 'true'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Global Accelerator (GA) Basic Accelerator can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ga/basicAccelerator:BasicAccelerator example <id>
 * ```
 * @property autoPay Specifies whether to enable automatic payment. Default value: `false`. Valid values:
 * @property autoRenew Specifies whether to enable auto-renewal for the GA Basic Accelerator instance. Default value: `false`. Valid values:
 * @property autoRenewDuration The auto-renewal period. Unit: months. Default value: `1`. Valid values: `1` to `12`. **NOTE:** This parameter is required only if `auto_renew` is set to `true`.
 * @property autoUseCoupon Specifies whether to automatically pay bills by using coupons. Default value: `false`. **NOTE:** This parameter is required only if `auto_pay` is set to `true`.
 * @property bandwidthBillingType The bandwidth billing method. Valid values: `BandwidthPackage`, `CDT`, `CDT95`.
 * @property basicAcceleratorName The name of the Global Accelerator Basic Accelerator instance.
 * @property crossBorderStatus Indicates whether cross-border acceleration is enabled. Default value: `false`. Valid values:
 * @property description The description of the Global Accelerator Basic Accelerator instance.
 * @property duration The subscription duration. Default value: `1`.
 * * If the `pricing_cycle` parameter is set to `Month`, the valid values for the `duration` parameter are `1` to `9`.
 * * If the `pricing_cycle` parameter is set to `Year`, the valid values for the `duration` parameter are `1` to `3`.
 * @property paymentType The payment type. Default value: `Subscription`. Valid values: `PayAsYouGo`, `Subscription`.
 * @property pricingCycle The billing cycle. Default value: `Month`. Valid values: `Month`, `Year`.
 * @property promotionOptionNo The code of the coupon. **NOTE:** The `promotion_option_no` takes effect only for accounts registered on the international site (alibabacloud.com).
 * @property resourceGroupId The ID of the resource group. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
 * @property tags A mapping of tags to assign to the resource.
 */
public data class BasicAcceleratorArgs(
    public val autoPay: Output<Boolean>? = null,
    public val autoRenew: Output<Boolean>? = null,
    public val autoRenewDuration: Output<Int>? = null,
    public val autoUseCoupon: Output<String>? = null,
    public val bandwidthBillingType: Output<String>? = null,
    public val basicAcceleratorName: Output<String>? = null,
    public val crossBorderStatus: Output<Boolean>? = null,
    public val description: Output<String>? = null,
    public val duration: Output<Int>? = null,
    public val paymentType: Output<String>? = null,
    public val pricingCycle: Output<String>? = null,
    public val promotionOptionNo: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ga.BasicAcceleratorArgs> {
    override fun toJava(): com.pulumi.alicloud.ga.BasicAcceleratorArgs =
        com.pulumi.alicloud.ga.BasicAcceleratorArgs.builder()
            .autoPay(autoPay?.applyValue({ args0 -> args0 }))
            .autoRenew(autoRenew?.applyValue({ args0 -> args0 }))
            .autoRenewDuration(autoRenewDuration?.applyValue({ args0 -> args0 }))
            .autoUseCoupon(autoUseCoupon?.applyValue({ args0 -> args0 }))
            .bandwidthBillingType(bandwidthBillingType?.applyValue({ args0 -> args0 }))
            .basicAcceleratorName(basicAcceleratorName?.applyValue({ args0 -> args0 }))
            .crossBorderStatus(crossBorderStatus?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .duration(duration?.applyValue({ args0 -> args0 }))
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .pricingCycle(pricingCycle?.applyValue({ args0 -> args0 }))
            .promotionOptionNo(promotionOptionNo?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [BasicAcceleratorArgs].
 */
@PulumiTagMarker
public class BasicAcceleratorArgsBuilder internal constructor() {
    private var autoPay: Output<Boolean>? = null

    private var autoRenew: Output<Boolean>? = null

    private var autoRenewDuration: Output<Int>? = null

    private var autoUseCoupon: Output<String>? = null

    private var bandwidthBillingType: Output<String>? = null

    private var basicAcceleratorName: Output<String>? = null

    private var crossBorderStatus: Output<Boolean>? = null

    private var description: Output<String>? = null

    private var duration: Output<Int>? = null

    private var paymentType: Output<String>? = null

    private var pricingCycle: Output<String>? = null

    private var promotionOptionNo: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Specifies whether to enable automatic payment. Default value: `false`. Valid values:
     */
    @JvmName("dwexqgcjxusasnsg")
    public suspend fun autoPay(`value`: Output<Boolean>) {
        this.autoPay = value
    }

    /**
     * @param value Specifies whether to enable auto-renewal for the GA Basic Accelerator instance. Default value: `false`. Valid values:
     */
    @JvmName("nbxjctakavdjmnto")
    public suspend fun autoRenew(`value`: Output<Boolean>) {
        this.autoRenew = value
    }

    /**
     * @param value The auto-renewal period. Unit: months. Default value: `1`. Valid values: `1` to `12`. **NOTE:** This parameter is required only if `auto_renew` is set to `true`.
     */
    @JvmName("lqocpknyhhcqrmvw")
    public suspend fun autoRenewDuration(`value`: Output<Int>) {
        this.autoRenewDuration = value
    }

    /**
     * @param value Specifies whether to automatically pay bills by using coupons. Default value: `false`. **NOTE:** This parameter is required only if `auto_pay` is set to `true`.
     */
    @JvmName("arnyanfyooyophfp")
    public suspend fun autoUseCoupon(`value`: Output<String>) {
        this.autoUseCoupon = value
    }

    /**
     * @param value The bandwidth billing method. Valid values: `BandwidthPackage`, `CDT`, `CDT95`.
     */
    @JvmName("ucgelsbmqbdhmqqs")
    public suspend fun bandwidthBillingType(`value`: Output<String>) {
        this.bandwidthBillingType = value
    }

    /**
     * @param value The name of the Global Accelerator Basic Accelerator instance.
     */
    @JvmName("oihgjwdmplvpfqgh")
    public suspend fun basicAcceleratorName(`value`: Output<String>) {
        this.basicAcceleratorName = value
    }

    /**
     * @param value Indicates whether cross-border acceleration is enabled. Default value: `false`. Valid values:
     */
    @JvmName("woiitwbnyyhhhkwj")
    public suspend fun crossBorderStatus(`value`: Output<Boolean>) {
        this.crossBorderStatus = value
    }

    /**
     * @param value The description of the Global Accelerator Basic Accelerator instance.
     */
    @JvmName("tvkjeqpclgartned")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The subscription duration. Default value: `1`.
     * * If the `pricing_cycle` parameter is set to `Month`, the valid values for the `duration` parameter are `1` to `9`.
     * * If the `pricing_cycle` parameter is set to `Year`, the valid values for the `duration` parameter are `1` to `3`.
     */
    @JvmName("qywfcrnxusjdbmgo")
    public suspend fun duration(`value`: Output<Int>) {
        this.duration = value
    }

    /**
     * @param value The payment type. Default value: `Subscription`. Valid values: `PayAsYouGo`, `Subscription`.
     */
    @JvmName("yhtjnsvxfuuyhvgo")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value The billing cycle. Default value: `Month`. Valid values: `Month`, `Year`.
     */
    @JvmName("svhuojffidtdesrw")
    public suspend fun pricingCycle(`value`: Output<String>) {
        this.pricingCycle = value
    }

    /**
     * @param value The code of the coupon. **NOTE:** The `promotion_option_no` takes effect only for accounts registered on the international site (alibabacloud.com).
     */
    @JvmName("yipruvixrvvpbxhm")
    public suspend fun promotionOptionNo(`value`: Output<String>) {
        this.promotionOptionNo = value
    }

    /**
     * @param value The ID of the resource group. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
     */
    @JvmName("uvkbuynutyyvnuui")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("ualidljjdbcwvxtr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies whether to enable automatic payment. Default value: `false`. Valid values:
     */
    @JvmName("utooxoqgwxphgudq")
    public suspend fun autoPay(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoPay = mapped
    }

    /**
     * @param value Specifies whether to enable auto-renewal for the GA Basic Accelerator instance. Default value: `false`. Valid values:
     */
    @JvmName("ucxyiupmeakkdlfn")
    public suspend fun autoRenew(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenew = mapped
    }

    /**
     * @param value The auto-renewal period. Unit: months. Default value: `1`. Valid values: `1` to `12`. **NOTE:** This parameter is required only if `auto_renew` is set to `true`.
     */
    @JvmName("kkwwcwpbsoqucwew")
    public suspend fun autoRenewDuration(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenewDuration = mapped
    }

    /**
     * @param value Specifies whether to automatically pay bills by using coupons. Default value: `false`. **NOTE:** This parameter is required only if `auto_pay` is set to `true`.
     */
    @JvmName("jswthrqilqeeshnh")
    public suspend fun autoUseCoupon(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoUseCoupon = mapped
    }

    /**
     * @param value The bandwidth billing method. Valid values: `BandwidthPackage`, `CDT`, `CDT95`.
     */
    @JvmName("svddbocbkgutmwbv")
    public suspend fun bandwidthBillingType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bandwidthBillingType = mapped
    }

    /**
     * @param value The name of the Global Accelerator Basic Accelerator instance.
     */
    @JvmName("edaofyjhxaxxtlba")
    public suspend fun basicAcceleratorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.basicAcceleratorName = mapped
    }

    /**
     * @param value Indicates whether cross-border acceleration is enabled. Default value: `false`. Valid values:
     */
    @JvmName("sojdkpsvebljpfip")
    public suspend fun crossBorderStatus(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.crossBorderStatus = mapped
    }

    /**
     * @param value The description of the Global Accelerator Basic Accelerator instance.
     */
    @JvmName("vhlwntmeifmlmsrq")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The subscription duration. Default value: `1`.
     * * If the `pricing_cycle` parameter is set to `Month`, the valid values for the `duration` parameter are `1` to `9`.
     * * If the `pricing_cycle` parameter is set to `Year`, the valid values for the `duration` parameter are `1` to `3`.
     */
    @JvmName("tboprwqelpdoxpiq")
    public suspend fun duration(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.duration = mapped
    }

    /**
     * @param value The payment type. Default value: `Subscription`. Valid values: `PayAsYouGo`, `Subscription`.
     */
    @JvmName("mhcqredpypuutmws")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value The billing cycle. Default value: `Month`. Valid values: `Month`, `Year`.
     */
    @JvmName("xslwlkjlcsufaqaw")
    public suspend fun pricingCycle(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pricingCycle = mapped
    }

    /**
     * @param value The code of the coupon. **NOTE:** The `promotion_option_no` takes effect only for accounts registered on the international site (alibabacloud.com).
     */
    @JvmName("aolyfoxcljwniutw")
    public suspend fun promotionOptionNo(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.promotionOptionNo = mapped
    }

    /**
     * @param value The ID of the resource group. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
     */
    @JvmName("aisafsnykfuqjyth")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("iymrlyrtarouraop")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("vpbvrhnndbmprbix")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): BasicAcceleratorArgs = BasicAcceleratorArgs(
        autoPay = autoPay,
        autoRenew = autoRenew,
        autoRenewDuration = autoRenewDuration,
        autoUseCoupon = autoUseCoupon,
        bandwidthBillingType = bandwidthBillingType,
        basicAcceleratorName = basicAcceleratorName,
        crossBorderStatus = crossBorderStatus,
        description = description,
        duration = duration,
        paymentType = paymentType,
        pricingCycle = pricingCycle,
        promotionOptionNo = promotionOptionNo,
        resourceGroupId = resourceGroupId,
        tags = tags,
    )
}
