@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [BasicEndpoint].
 */
@PulumiTagMarker
public class BasicEndpointResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BasicEndpointArgs = BasicEndpointArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BasicEndpointArgsBuilder.() -> Unit) {
        val builder = BasicEndpointArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BasicEndpoint {
        val builtJavaResource = com.pulumi.alicloud.ga.BasicEndpoint(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BasicEndpoint(builtJavaResource)
    }
}

/**
 * Provides a Global Accelerator (GA) Basic Endpoint resource.
 * For information about Global Accelerator (GA) Basic Endpoint and how to use it, see [What is Basic Endpoint](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-createbasicendpoint).
 * > **NOTE:** Available since v1.194.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const region = config.get("region") || "cn-shenzhen";
 * const endpointRegion = config.get("endpointRegion") || "cn-hangzhou";
 * const default = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: "terraform-example",
 *     cidrBlock: "172.17.3.0/24",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vswitchName: "terraform-example",
 *     cidrBlock: "172.17.3.0/24",
 *     vpcId: defaultNetwork.id,
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 * });
 * const defaultSecurityGroup = new alicloud.ecs.SecurityGroup("default", {
 *     vpcId: defaultNetwork.id,
 *     name: "terraform-example",
 * });
 * const defaultEcsNetworkInterface = new alicloud.ecs.EcsNetworkInterface("default", {
 *     vswitchId: defaultSwitch.id,
 *     securityGroupIds: [defaultSecurityGroup&#46;id],
 * });
 * const defaultBasicAccelerator = new alicloud.ga.BasicAccelerator("default", {
 *     duration: 1,
 *     basicAcceleratorName: "terraform-example",
 *     description: "terraform-example",
 *     bandwidthBillingType: "CDT",
 *     autoUseCoupon: "true",
 *     autoPay: true,
 * });
 * const defaultBasicEndpointGroup = new alicloud.ga.BasicEndpointGroup("default", {
 *     acceleratorId: defaultBasicAccelerator.id,
 *     endpointGroupRegion: region,
 *     basicEndpointGroupName: "terraform-example",
 *     description: "terraform-example",
 * });
 * const defaultBasicEndpoint = new alicloud.ga.BasicEndpoint("default", {
 *     acceleratorId: defaultBasicAccelerator.id,
 *     endpointGroupId: defaultBasicEndpointGroup.id,
 *     endpointType: "ENI",
 *     endpointAddress: defaultEcsNetworkInterface.id,
 *     endpointSubAddressType: "secondary",
 *     endpointSubAddress: "192.168.0.1",
 *     basicEndpointName: "terraform-example",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * region = config.get("region")
 * if region is None:
 *     region = "cn-shenzhen"
 * endpoint_region = config.get("endpointRegion")
 * if endpoint_region is None:
 *     endpoint_region = "cn-hangzhou"
 * default = alicloud.get_zones(available_resource_creation="VSwitch")
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name="terraform-example",
 *     cidr_block="172.17.3.0/24")
 * default_switch = alicloud.vpc.Switch("default",
 *     vswitch_name="terraform-example",
 *     cidr_block="172.17.3.0/24",
 *     vpc_id=default_network.id,
 *     zone_id=default.zones[0].id)
 * default_security_group = alicloud.ecs.SecurityGroup("default",
 *     vpc_id=default_network.id,
 *     name="terraform-example")
 * default_ecs_network_interface = alicloud.ecs.EcsNetworkInterface("default",
 *     vswitch_id=default_switch.id,
 *     security_group_ids=[default_security_group&#46;id])
 * default_basic_accelerator = alicloud.ga.BasicAccelerator("default",
 *     duration=1,
 *     basic_accelerator_name="terraform-example",
 *     description="terraform-example",
 *     bandwidth_billing_type="CDT",
 *     auto_use_coupon="true",
 *     auto_pay=True)
 * default_basic_endpoint_group = alicloud.ga.BasicEndpointGroup("default",
 *     accelerator_id=default_basic_accelerator.id,
 *     endpoint_group_region=region,
 *     basic_endpoint_group_name="terraform-example",
 *     description="terraform-example")
 * default_basic_endpoint = alicloud.ga.BasicEndpoint("default",
 *     accelerator_id=default_basic_accelerator.id,
 *     endpoint_group_id=default_basic_endpoint_group.id,
 *     endpoint_type="ENI",
 *     endpoint_address=default_ecs_network_interface.id,
 *     endpoint_sub_address_type="secondary",
 *     endpoint_sub_address="192.168.0.1",
 *     basic_endpoint_name="terraform-example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var region = config.Get("region") ?? "cn-shenzhen";
 *     var endpointRegion = config.Get("endpointRegion") ?? "cn-hangzhou";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = "terraform-example",
 *         CidrBlock = "172.17.3.0/24",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VswitchName = "terraform-example",
 *         CidrBlock = "172.17.3.0/24",
 *         VpcId = defaultNetwork.Id,
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *     });
 *     var defaultSecurityGroup = new AliCloud.Ecs.SecurityGroup("default", new()
 *     {
 *         VpcId = defaultNetwork.Id,
 *         Name = "terraform-example",
 *     });
 *     var defaultEcsNetworkInterface = new AliCloud.Ecs.EcsNetworkInterface("default", new()
 *     {
 *         VswitchId = defaultSwitch.Id,
 *         SecurityGroupIds = new[]
 *         {
 *             defaultSecurityGroup.Id,
 *         },
 *     });
 *     var defaultBasicAccelerator = new AliCloud.Ga.BasicAccelerator("default", new()
 *     {
 *         Duration = 1,
 *         BasicAcceleratorName = "terraform-example",
 *         Description = "terraform-example",
 *         BandwidthBillingType = "CDT",
 *         AutoUseCoupon = "true",
 *         AutoPay = true,
 *     });
 *     var defaultBasicEndpointGroup = new AliCloud.Ga.BasicEndpointGroup("default", new()
 *     {
 *         AcceleratorId = defaultBasicAccelerator.Id,
 *         EndpointGroupRegion = region,
 *         BasicEndpointGroupName = "terraform-example",
 *         Description = "terraform-example",
 *     });
 *     var defaultBasicEndpoint = new AliCloud.Ga.BasicEndpoint("default", new()
 *     {
 *         AcceleratorId = defaultBasicAccelerator.Id,
 *         EndpointGroupId = defaultBasicEndpointGroup.Id,
 *         EndpointType = "ENI",
 *         EndpointAddress = defaultEcsNetworkInterface.Id,
 *         EndpointSubAddressType = "secondary",
 *         EndpointSubAddress = "192.168.0.1",
 *         BasicEndpointName = "terraform-example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ga"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		region := "cn-shenzhen"
 * 		if param := cfg.Get("region"); param != "" {
 * 			region = param
 * 		}
 * 		endpointRegion := "cn-hangzhou"
 * 		if param := cfg.Get("endpointRegion"); param != "" {
 * 			endpointRegion = param
 * 		}
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String("terraform-example"),
 * 			CidrBlock: pulumi.String("172.17.3.0/24"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String("terraform-example"),
 * 			CidrBlock:   pulumi.String("172.17.3.0/24"),
 * 			VpcId:       defaultNetwork.ID(),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSecurityGroup, err := ecs.NewSecurityGroup(ctx, "default", &ecs.SecurityGroupArgs{
 * 			VpcId: defaultNetwork.ID(),
 * 			Name:  pulumi.String("terraform-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultEcsNetworkInterface, err := ecs.NewEcsNetworkInterface(ctx, "default", &ecs.EcsNetworkInterfaceArgs{
 * 			VswitchId: defaultSwitch.ID(),
 * 			SecurityGroupIds: pulumi.StringArray{
 * 				defaultSecurityGroup.ID(),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultBasicAccelerator, err := ga.NewBasicAccelerator(ctx, "default", &ga.BasicAcceleratorArgs{
 * 			Duration:             pulumi.Int(1),
 * 			BasicAcceleratorName: pulumi.String("terraform-example"),
 * 			Description:          pulumi.String("terraform-example"),
 * 			BandwidthBillingType: pulumi.String("CDT"),
 * 			AutoUseCoupon:        pulumi.String("true"),
 * 			AutoPay:              pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultBasicEndpointGroup, err := ga.NewBasicEndpointGroup(ctx, "default", &ga.BasicEndpointGroupArgs{
 * 			AcceleratorId:          defaultBasicAccelerator.ID(),
 * 			EndpointGroupRegion:    pulumi.String(region),
 * 			BasicEndpointGroupName: pulumi.String("terraform-example"),
 * 			Description:            pulumi.String("terraform-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ga.NewBasicEndpoint(ctx, "default", &ga.BasicEndpointArgs{
 * 			AcceleratorId:          defaultBasicAccelerator.ID(),
 * 			EndpointGroupId:        defaultBasicEndpointGroup.ID(),
 * 			EndpointType:           pulumi.String("ENI"),
 * 			EndpointAddress:        defaultEcsNetworkInterface.ID(),
 * 			EndpointSubAddressType: pulumi.String("secondary"),
 * 			EndpointSubAddress:     pulumi.String("192.168.0.1"),
 * 			BasicEndpointName:      pulumi.String("terraform-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.alicloud.ecs.EcsNetworkInterface;
 * import com.pulumi.alicloud.ecs.EcsNetworkInterfaceArgs;
 * import com.pulumi.alicloud.ga.BasicAccelerator;
 * import com.pulumi.alicloud.ga.BasicAcceleratorArgs;
 * import com.pulumi.alicloud.ga.BasicEndpointGroup;
 * import com.pulumi.alicloud.ga.BasicEndpointGroupArgs;
 * import com.pulumi.alicloud.ga.BasicEndpoint;
 * import com.pulumi.alicloud.ga.BasicEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var region = config.get("region").orElse("cn-shenzhen");
 *         final var endpointRegion = config.get("endpointRegion").orElse("cn-hangzhou");
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName("terraform-example")
 *             .cidrBlock("172.17.3.0/24")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vswitchName("terraform-example")
 *             .cidrBlock("172.17.3.0/24")
 *             .vpcId(defaultNetwork.id())
 *             .zoneId(default_.zones()[0].id())
 *             .build());
 *         var defaultSecurityGroup = new SecurityGroup("defaultSecurityGroup", SecurityGroupArgs.builder()
 *             .vpcId(defaultNetwork.id())
 *             .name("terraform-example")
 *             .build());
 *         var defaultEcsNetworkInterface = new EcsNetworkInterface("defaultEcsNetworkInterface", EcsNetworkInterfaceArgs.builder()
 *             .vswitchId(defaultSwitch.id())
 *             .securityGroupIds(defaultSecurityGroup.id())
 *             .build());
 *         var defaultBasicAccelerator = new BasicAccelerator("defaultBasicAccelerator", BasicAcceleratorArgs.builder()
 *             .duration(1)
 *             .basicAcceleratorName("terraform-example")
 *             .description("terraform-example")
 *             .bandwidthBillingType("CDT")
 *             .autoUseCoupon("true")
 *             .autoPay(true)
 *             .build());
 *         var defaultBasicEndpointGroup = new BasicEndpointGroup("defaultBasicEndpointGroup", BasicEndpointGroupArgs.builder()
 *             .acceleratorId(defaultBasicAccelerator.id())
 *             .endpointGroupRegion(region)
 *             .basicEndpointGroupName("terraform-example")
 *             .description("terraform-example")
 *             .build());
 *         var defaultBasicEndpoint = new BasicEndpoint("defaultBasicEndpoint", BasicEndpointArgs.builder()
 *             .acceleratorId(defaultBasicAccelerator.id())
 *             .endpointGroupId(defaultBasicEndpointGroup.id())
 *             .endpointType("ENI")
 *             .endpointAddress(defaultEcsNetworkInterface.id())
 *             .endpointSubAddressType("secondary")
 *             .endpointSubAddress("192.168.0.1")
 *             .basicEndpointName("terraform-example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   region:
 *     type: string
 *     default: cn-shenzhen
 *   endpointRegion:
 *     type: string
 *     default: cn-hangzhou
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: terraform-example
 *       cidrBlock: 172.17.3.0/24
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vswitchName: terraform-example
 *       cidrBlock: 172.17.3.0/24
 *       vpcId: ${defaultNetwork.id}
 *       zoneId: ${default.zones[0].id}
 *   defaultSecurityGroup:
 *     type: alicloud:ecs:SecurityGroup
 *     name: default
 *     properties:
 *       vpcId: ${defaultNetwork.id}
 *       name: terraform-example
 *   defaultEcsNetworkInterface:
 *     type: alicloud:ecs:EcsNetworkInterface
 *     name: default
 *     properties:
 *       vswitchId: ${defaultSwitch.id}
 *       securityGroupIds:
 *         - ${defaultSecurityGroup.id}
 *   defaultBasicAccelerator:
 *     type: alicloud:ga:BasicAccelerator
 *     name: default
 *     properties:
 *       duration: 1
 *       basicAcceleratorName: terraform-example
 *       description: terraform-example
 *       bandwidthBillingType: CDT
 *       autoUseCoupon: 'true'
 *       autoPay: true
 *   defaultBasicEndpointGroup:
 *     type: alicloud:ga:BasicEndpointGroup
 *     name: default
 *     properties:
 *       acceleratorId: ${defaultBasicAccelerator.id}
 *       endpointGroupRegion: ${region}
 *       basicEndpointGroupName: terraform-example
 *       description: terraform-example
 *   defaultBasicEndpoint:
 *     type: alicloud:ga:BasicEndpoint
 *     name: default
 *     properties:
 *       acceleratorId: ${defaultBasicAccelerator.id}
 *       endpointGroupId: ${defaultBasicEndpointGroup.id}
 *       endpointType: ENI
 *       endpointAddress: ${defaultEcsNetworkInterface.id}
 *       endpointSubAddressType: secondary
 *       endpointSubAddress: 192.168.0.1
 *       basicEndpointName: terraform-example
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Global Accelerator (GA) Basic Endpoint can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ga/basicEndpoint:BasicEndpoint example <endpoint_group_id>:<endpoint_id>
 * ```
 */
public class BasicEndpoint internal constructor(
    override val javaResource: com.pulumi.alicloud.ga.BasicEndpoint,
) : KotlinCustomResource(javaResource, BasicEndpointMapper) {
    /**
     * The ID of the Basic GA instance.
     */
    public val acceleratorId: Output<String>
        get() = javaResource.acceleratorId().applyValue({ args0 -> args0 })

    /**
     * The name of the Basic Endpoint.
     */
    public val basicEndpointName: Output<String>?
        get() = javaResource.basicEndpointName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The address of the Basic Endpoint.
     */
    public val endpointAddress: Output<String>
        get() = javaResource.endpointAddress().applyValue({ args0 -> args0 })

    /**
     * The ID of the Basic Endpoint Group.
     */
    public val endpointGroupId: Output<String>
        get() = javaResource.endpointGroupId().applyValue({ args0 -> args0 })

    /**
     * The ID of the Basic Endpoint.
     */
    public val endpointId: Output<String>
        get() = javaResource.endpointId().applyValue({ args0 -> args0 })

    /**
     * The sub address of the Basic Endpoint.
     */
    public val endpointSubAddress: Output<String>?
        get() = javaResource.endpointSubAddress().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The sub address type of the Basic Endpoint. Valid values: `primary`, `secondary`.
     */
    public val endpointSubAddressType: Output<String>?
        get() = javaResource.endpointSubAddressType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of the Basic Endpoint. Valid values: `ENI`, `SLB`, `ECS` and `NLB`.
     */
    public val endpointType: Output<String>
        get() = javaResource.endpointType().applyValue({ args0 -> args0 })

    /**
     * The zone id of the Basic Endpoint.
     */
    public val endpointZoneId: Output<String>?
        get() = javaResource.endpointZoneId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The status of the Basic Endpoint.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object BasicEndpointMapper : ResourceMapper<BasicEndpoint> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ga.BasicEndpoint::class == javaResource::class

    override fun map(javaResource: Resource): BasicEndpoint = BasicEndpoint(
        javaResource as
            com.pulumi.alicloud.ga.BasicEndpoint,
    )
}

/**
 * @see [BasicEndpoint].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BasicEndpoint].
 */
public suspend fun basicEndpoint(
    name: String,
    block: suspend BasicEndpointResourceBuilder.() -> Unit,
): BasicEndpoint {
    val builder = BasicEndpointResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BasicEndpoint].
 * @param name The _unique_ name of the resulting resource.
 */
public fun basicEndpoint(name: String): BasicEndpoint {
    val builder = BasicEndpointResourceBuilder()
    builder.name(name)
    return builder.build()
}
