@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin

import com.pulumi.alicloud.ga.BasicEndpointArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Global Accelerator (GA) Basic Endpoint resource.
 * For information about Global Accelerator (GA) Basic Endpoint and how to use it, see [What is Basic Endpoint](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-createbasicendpoint).
 * > **NOTE:** Available since v1.194.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const region = config.get("region") || "cn-shenzhen";
 * const endpointRegion = config.get("endpointRegion") || "cn-hangzhou";
 * const default = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: "terraform-example",
 *     cidrBlock: "172.17.3.0/24",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vswitchName: "terraform-example",
 *     cidrBlock: "172.17.3.0/24",
 *     vpcId: defaultNetwork.id,
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 * });
 * const defaultSecurityGroup = new alicloud.ecs.SecurityGroup("default", {
 *     vpcId: defaultNetwork.id,
 *     name: "terraform-example",
 * });
 * const defaultEcsNetworkInterface = new alicloud.ecs.EcsNetworkInterface("default", {
 *     vswitchId: defaultSwitch.id,
 *     securityGroupIds: [defaultSecurityGroup&#46;id],
 * });
 * const defaultBasicAccelerator = new alicloud.ga.BasicAccelerator("default", {
 *     duration: 1,
 *     basicAcceleratorName: "terraform-example",
 *     description: "terraform-example",
 *     bandwidthBillingType: "CDT",
 *     autoUseCoupon: "true",
 *     autoPay: true,
 * });
 * const defaultBasicEndpointGroup = new alicloud.ga.BasicEndpointGroup("default", {
 *     acceleratorId: defaultBasicAccelerator.id,
 *     endpointGroupRegion: region,
 *     basicEndpointGroupName: "terraform-example",
 *     description: "terraform-example",
 * });
 * const defaultBasicEndpoint = new alicloud.ga.BasicEndpoint("default", {
 *     acceleratorId: defaultBasicAccelerator.id,
 *     endpointGroupId: defaultBasicEndpointGroup.id,
 *     endpointType: "ENI",
 *     endpointAddress: defaultEcsNetworkInterface.id,
 *     endpointSubAddressType: "secondary",
 *     endpointSubAddress: "192.168.0.1",
 *     basicEndpointName: "terraform-example",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * region = config.get("region")
 * if region is None:
 *     region = "cn-shenzhen"
 * endpoint_region = config.get("endpointRegion")
 * if endpoint_region is None:
 *     endpoint_region = "cn-hangzhou"
 * default = alicloud.get_zones(available_resource_creation="VSwitch")
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name="terraform-example",
 *     cidr_block="172.17.3.0/24")
 * default_switch = alicloud.vpc.Switch("default",
 *     vswitch_name="terraform-example",
 *     cidr_block="172.17.3.0/24",
 *     vpc_id=default_network.id,
 *     zone_id=default.zones[0].id)
 * default_security_group = alicloud.ecs.SecurityGroup("default",
 *     vpc_id=default_network.id,
 *     name="terraform-example")
 * default_ecs_network_interface = alicloud.ecs.EcsNetworkInterface("default",
 *     vswitch_id=default_switch.id,
 *     security_group_ids=[default_security_group&#46;id])
 * default_basic_accelerator = alicloud.ga.BasicAccelerator("default",
 *     duration=1,
 *     basic_accelerator_name="terraform-example",
 *     description="terraform-example",
 *     bandwidth_billing_type="CDT",
 *     auto_use_coupon="true",
 *     auto_pay=True)
 * default_basic_endpoint_group = alicloud.ga.BasicEndpointGroup("default",
 *     accelerator_id=default_basic_accelerator.id,
 *     endpoint_group_region=region,
 *     basic_endpoint_group_name="terraform-example",
 *     description="terraform-example")
 * default_basic_endpoint = alicloud.ga.BasicEndpoint("default",
 *     accelerator_id=default_basic_accelerator.id,
 *     endpoint_group_id=default_basic_endpoint_group.id,
 *     endpoint_type="ENI",
 *     endpoint_address=default_ecs_network_interface.id,
 *     endpoint_sub_address_type="secondary",
 *     endpoint_sub_address="192.168.0.1",
 *     basic_endpoint_name="terraform-example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var region = config.Get("region") ?? "cn-shenzhen";
 *     var endpointRegion = config.Get("endpointRegion") ?? "cn-hangzhou";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = "terraform-example",
 *         CidrBlock = "172.17.3.0/24",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VswitchName = "terraform-example",
 *         CidrBlock = "172.17.3.0/24",
 *         VpcId = defaultNetwork.Id,
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *     });
 *     var defaultSecurityGroup = new AliCloud.Ecs.SecurityGroup("default", new()
 *     {
 *         VpcId = defaultNetwork.Id,
 *         Name = "terraform-example",
 *     });
 *     var defaultEcsNetworkInterface = new AliCloud.Ecs.EcsNetworkInterface("default", new()
 *     {
 *         VswitchId = defaultSwitch.Id,
 *         SecurityGroupIds = new[]
 *         {
 *             defaultSecurityGroup.Id,
 *         },
 *     });
 *     var defaultBasicAccelerator = new AliCloud.Ga.BasicAccelerator("default", new()
 *     {
 *         Duration = 1,
 *         BasicAcceleratorName = "terraform-example",
 *         Description = "terraform-example",
 *         BandwidthBillingType = "CDT",
 *         AutoUseCoupon = "true",
 *         AutoPay = true,
 *     });
 *     var defaultBasicEndpointGroup = new AliCloud.Ga.BasicEndpointGroup("default", new()
 *     {
 *         AcceleratorId = defaultBasicAccelerator.Id,
 *         EndpointGroupRegion = region,
 *         BasicEndpointGroupName = "terraform-example",
 *         Description = "terraform-example",
 *     });
 *     var defaultBasicEndpoint = new AliCloud.Ga.BasicEndpoint("default", new()
 *     {
 *         AcceleratorId = defaultBasicAccelerator.Id,
 *         EndpointGroupId = defaultBasicEndpointGroup.Id,
 *         EndpointType = "ENI",
 *         EndpointAddress = defaultEcsNetworkInterface.Id,
 *         EndpointSubAddressType = "secondary",
 *         EndpointSubAddress = "192.168.0.1",
 *         BasicEndpointName = "terraform-example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ga"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		region := "cn-shenzhen"
 * 		if param := cfg.Get("region"); param != "" {
 * 			region = param
 * 		}
 * 		endpointRegion := "cn-hangzhou"
 * 		if param := cfg.Get("endpointRegion"); param != "" {
 * 			endpointRegion = param
 * 		}
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String("terraform-example"),
 * 			CidrBlock: pulumi.String("172.17.3.0/24"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String("terraform-example"),
 * 			CidrBlock:   pulumi.String("172.17.3.0/24"),
 * 			VpcId:       defaultNetwork.ID(),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSecurityGroup, err := ecs.NewSecurityGroup(ctx, "default", &ecs.SecurityGroupArgs{
 * 			VpcId: defaultNetwork.ID(),
 * 			Name:  pulumi.String("terraform-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultEcsNetworkInterface, err := ecs.NewEcsNetworkInterface(ctx, "default", &ecs.EcsNetworkInterfaceArgs{
 * 			VswitchId: defaultSwitch.ID(),
 * 			SecurityGroupIds: pulumi.StringArray{
 * 				defaultSecurityGroup.ID(),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultBasicAccelerator, err := ga.NewBasicAccelerator(ctx, "default", &ga.BasicAcceleratorArgs{
 * 			Duration:             pulumi.Int(1),
 * 			BasicAcceleratorName: pulumi.String("terraform-example"),
 * 			Description:          pulumi.String("terraform-example"),
 * 			BandwidthBillingType: pulumi.String("CDT"),
 * 			AutoUseCoupon:        pulumi.String("true"),
 * 			AutoPay:              pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultBasicEndpointGroup, err := ga.NewBasicEndpointGroup(ctx, "default", &ga.BasicEndpointGroupArgs{
 * 			AcceleratorId:          defaultBasicAccelerator.ID(),
 * 			EndpointGroupRegion:    pulumi.String(region),
 * 			BasicEndpointGroupName: pulumi.String("terraform-example"),
 * 			Description:            pulumi.String("terraform-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ga.NewBasicEndpoint(ctx, "default", &ga.BasicEndpointArgs{
 * 			AcceleratorId:          defaultBasicAccelerator.ID(),
 * 			EndpointGroupId:        defaultBasicEndpointGroup.ID(),
 * 			EndpointType:           pulumi.String("ENI"),
 * 			EndpointAddress:        defaultEcsNetworkInterface.ID(),
 * 			EndpointSubAddressType: pulumi.String("secondary"),
 * 			EndpointSubAddress:     pulumi.String("192.168.0.1"),
 * 			BasicEndpointName:      pulumi.String("terraform-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.alicloud.ecs.EcsNetworkInterface;
 * import com.pulumi.alicloud.ecs.EcsNetworkInterfaceArgs;
 * import com.pulumi.alicloud.ga.BasicAccelerator;
 * import com.pulumi.alicloud.ga.BasicAcceleratorArgs;
 * import com.pulumi.alicloud.ga.BasicEndpointGroup;
 * import com.pulumi.alicloud.ga.BasicEndpointGroupArgs;
 * import com.pulumi.alicloud.ga.BasicEndpoint;
 * import com.pulumi.alicloud.ga.BasicEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var region = config.get("region").orElse("cn-shenzhen");
 *         final var endpointRegion = config.get("endpointRegion").orElse("cn-hangzhou");
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName("terraform-example")
 *             .cidrBlock("172.17.3.0/24")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vswitchName("terraform-example")
 *             .cidrBlock("172.17.3.0/24")
 *             .vpcId(defaultNetwork.id())
 *             .zoneId(default_.zones()[0].id())
 *             .build());
 *         var defaultSecurityGroup = new SecurityGroup("defaultSecurityGroup", SecurityGroupArgs.builder()
 *             .vpcId(defaultNetwork.id())
 *             .name("terraform-example")
 *             .build());
 *         var defaultEcsNetworkInterface = new EcsNetworkInterface("defaultEcsNetworkInterface", EcsNetworkInterfaceArgs.builder()
 *             .vswitchId(defaultSwitch.id())
 *             .securityGroupIds(defaultSecurityGroup.id())
 *             .build());
 *         var defaultBasicAccelerator = new BasicAccelerator("defaultBasicAccelerator", BasicAcceleratorArgs.builder()
 *             .duration(1)
 *             .basicAcceleratorName("terraform-example")
 *             .description("terraform-example")
 *             .bandwidthBillingType("CDT")
 *             .autoUseCoupon("true")
 *             .autoPay(true)
 *             .build());
 *         var defaultBasicEndpointGroup = new BasicEndpointGroup("defaultBasicEndpointGroup", BasicEndpointGroupArgs.builder()
 *             .acceleratorId(defaultBasicAccelerator.id())
 *             .endpointGroupRegion(region)
 *             .basicEndpointGroupName("terraform-example")
 *             .description("terraform-example")
 *             .build());
 *         var defaultBasicEndpoint = new BasicEndpoint("defaultBasicEndpoint", BasicEndpointArgs.builder()
 *             .acceleratorId(defaultBasicAccelerator.id())
 *             .endpointGroupId(defaultBasicEndpointGroup.id())
 *             .endpointType("ENI")
 *             .endpointAddress(defaultEcsNetworkInterface.id())
 *             .endpointSubAddressType("secondary")
 *             .endpointSubAddress("192.168.0.1")
 *             .basicEndpointName("terraform-example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   region:
 *     type: string
 *     default: cn-shenzhen
 *   endpointRegion:
 *     type: string
 *     default: cn-hangzhou
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: terraform-example
 *       cidrBlock: 172.17.3.0/24
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vswitchName: terraform-example
 *       cidrBlock: 172.17.3.0/24
 *       vpcId: ${defaultNetwork.id}
 *       zoneId: ${default.zones[0].id}
 *   defaultSecurityGroup:
 *     type: alicloud:ecs:SecurityGroup
 *     name: default
 *     properties:
 *       vpcId: ${defaultNetwork.id}
 *       name: terraform-example
 *   defaultEcsNetworkInterface:
 *     type: alicloud:ecs:EcsNetworkInterface
 *     name: default
 *     properties:
 *       vswitchId: ${defaultSwitch.id}
 *       securityGroupIds:
 *         - ${defaultSecurityGroup.id}
 *   defaultBasicAccelerator:
 *     type: alicloud:ga:BasicAccelerator
 *     name: default
 *     properties:
 *       duration: 1
 *       basicAcceleratorName: terraform-example
 *       description: terraform-example
 *       bandwidthBillingType: CDT
 *       autoUseCoupon: 'true'
 *       autoPay: true
 *   defaultBasicEndpointGroup:
 *     type: alicloud:ga:BasicEndpointGroup
 *     name: default
 *     properties:
 *       acceleratorId: ${defaultBasicAccelerator.id}
 *       endpointGroupRegion: ${region}
 *       basicEndpointGroupName: terraform-example
 *       description: terraform-example
 *   defaultBasicEndpoint:
 *     type: alicloud:ga:BasicEndpoint
 *     name: default
 *     properties:
 *       acceleratorId: ${defaultBasicAccelerator.id}
 *       endpointGroupId: ${defaultBasicEndpointGroup.id}
 *       endpointType: ENI
 *       endpointAddress: ${defaultEcsNetworkInterface.id}
 *       endpointSubAddressType: secondary
 *       endpointSubAddress: 192.168.0.1
 *       basicEndpointName: terraform-example
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Global Accelerator (GA) Basic Endpoint can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ga/basicEndpoint:BasicEndpoint example <endpoint_group_id>:<endpoint_id>
 * ```
 * @property acceleratorId The ID of the Basic GA instance.
 * @property basicEndpointName The name of the Basic Endpoint.
 * @property endpointAddress The address of the Basic Endpoint.
 * @property endpointGroupId The ID of the Basic Endpoint Group.
 * @property endpointSubAddress The sub address of the Basic Endpoint.
 * @property endpointSubAddressType The sub address type of the Basic Endpoint. Valid values: `primary`, `secondary`.
 * @property endpointType The type of the Basic Endpoint. Valid values: `ENI`, `SLB`, `ECS` and `NLB`.
 * @property endpointZoneId The zone id of the Basic Endpoint.
 */
public data class BasicEndpointArgs(
    public val acceleratorId: Output<String>? = null,
    public val basicEndpointName: Output<String>? = null,
    public val endpointAddress: Output<String>? = null,
    public val endpointGroupId: Output<String>? = null,
    public val endpointSubAddress: Output<String>? = null,
    public val endpointSubAddressType: Output<String>? = null,
    public val endpointType: Output<String>? = null,
    public val endpointZoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ga.BasicEndpointArgs> {
    override fun toJava(): com.pulumi.alicloud.ga.BasicEndpointArgs =
        com.pulumi.alicloud.ga.BasicEndpointArgs.builder()
            .acceleratorId(acceleratorId?.applyValue({ args0 -> args0 }))
            .basicEndpointName(basicEndpointName?.applyValue({ args0 -> args0 }))
            .endpointAddress(endpointAddress?.applyValue({ args0 -> args0 }))
            .endpointGroupId(endpointGroupId?.applyValue({ args0 -> args0 }))
            .endpointSubAddress(endpointSubAddress?.applyValue({ args0 -> args0 }))
            .endpointSubAddressType(endpointSubAddressType?.applyValue({ args0 -> args0 }))
            .endpointType(endpointType?.applyValue({ args0 -> args0 }))
            .endpointZoneId(endpointZoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BasicEndpointArgs].
 */
@PulumiTagMarker
public class BasicEndpointArgsBuilder internal constructor() {
    private var acceleratorId: Output<String>? = null

    private var basicEndpointName: Output<String>? = null

    private var endpointAddress: Output<String>? = null

    private var endpointGroupId: Output<String>? = null

    private var endpointSubAddress: Output<String>? = null

    private var endpointSubAddressType: Output<String>? = null

    private var endpointType: Output<String>? = null

    private var endpointZoneId: Output<String>? = null

    /**
     * @param value The ID of the Basic GA instance.
     */
    @JvmName("emvxvncyamsdulrj")
    public suspend fun acceleratorId(`value`: Output<String>) {
        this.acceleratorId = value
    }

    /**
     * @param value The name of the Basic Endpoint.
     */
    @JvmName("ethmymqlvakshfdo")
    public suspend fun basicEndpointName(`value`: Output<String>) {
        this.basicEndpointName = value
    }

    /**
     * @param value The address of the Basic Endpoint.
     */
    @JvmName("mgrqigpmvrbptvpq")
    public suspend fun endpointAddress(`value`: Output<String>) {
        this.endpointAddress = value
    }

    /**
     * @param value The ID of the Basic Endpoint Group.
     */
    @JvmName("xqrjggykvheuawto")
    public suspend fun endpointGroupId(`value`: Output<String>) {
        this.endpointGroupId = value
    }

    /**
     * @param value The sub address of the Basic Endpoint.
     */
    @JvmName("ubmetkcdsshqbbpm")
    public suspend fun endpointSubAddress(`value`: Output<String>) {
        this.endpointSubAddress = value
    }

    /**
     * @param value The sub address type of the Basic Endpoint. Valid values: `primary`, `secondary`.
     */
    @JvmName("dqafpmfhxwjeujkr")
    public suspend fun endpointSubAddressType(`value`: Output<String>) {
        this.endpointSubAddressType = value
    }

    /**
     * @param value The type of the Basic Endpoint. Valid values: `ENI`, `SLB`, `ECS` and `NLB`.
     */
    @JvmName("tgbvjsictgbrbqkv")
    public suspend fun endpointType(`value`: Output<String>) {
        this.endpointType = value
    }

    /**
     * @param value The zone id of the Basic Endpoint.
     */
    @JvmName("ofwvkjcvdeqikkdn")
    public suspend fun endpointZoneId(`value`: Output<String>) {
        this.endpointZoneId = value
    }

    /**
     * @param value The ID of the Basic GA instance.
     */
    @JvmName("fsssdcxfkehoywjg")
    public suspend fun acceleratorId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceleratorId = mapped
    }

    /**
     * @param value The name of the Basic Endpoint.
     */
    @JvmName("kondmcmdesdccfwu")
    public suspend fun basicEndpointName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.basicEndpointName = mapped
    }

    /**
     * @param value The address of the Basic Endpoint.
     */
    @JvmName("fcdjalxspcnunkrn")
    public suspend fun endpointAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointAddress = mapped
    }

    /**
     * @param value The ID of the Basic Endpoint Group.
     */
    @JvmName("bkxouelbwnrltsty")
    public suspend fun endpointGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointGroupId = mapped
    }

    /**
     * @param value The sub address of the Basic Endpoint.
     */
    @JvmName("rydyrdcytsepqlqi")
    public suspend fun endpointSubAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointSubAddress = mapped
    }

    /**
     * @param value The sub address type of the Basic Endpoint. Valid values: `primary`, `secondary`.
     */
    @JvmName("gdjtpfqjgwvogroo")
    public suspend fun endpointSubAddressType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointSubAddressType = mapped
    }

    /**
     * @param value The type of the Basic Endpoint. Valid values: `ENI`, `SLB`, `ECS` and `NLB`.
     */
    @JvmName("uclvcuvreexrtipt")
    public suspend fun endpointType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointType = mapped
    }

    /**
     * @param value The zone id of the Basic Endpoint.
     */
    @JvmName("sexfucqslqkfeusl")
    public suspend fun endpointZoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointZoneId = mapped
    }

    internal fun build(): BasicEndpointArgs = BasicEndpointArgs(
        acceleratorId = acceleratorId,
        basicEndpointName = basicEndpointName,
        endpointAddress = endpointAddress,
        endpointGroupId = endpointGroupId,
        endpointSubAddress = endpointSubAddress,
        endpointSubAddressType = endpointSubAddressType,
        endpointType = endpointType,
        endpointZoneId = endpointZoneId,
    )
}
