@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin

import com.pulumi.alicloud.ga.BasicEndpointGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Global Accelerator (GA) Basic Endpoint Group resource.
 * For information about Global Accelerator (GA) Basic Endpoint Group and how to use it, see [What is Basic Endpoint Group](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-createbasicendpointgroup).
 * > **NOTE:** Available since v1.194.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const region = config.get("region") || "cn-hangzhou";
 * const endpointGroupRegion = config.get("endpointGroupRegion") || "cn-beijing";
 * const default = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: "terraform-example",
 *     cidrBlock: "172.17.3.0/24",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vswitchName: "terraform-example",
 *     cidrBlock: "172.17.3.0/24",
 *     vpcId: defaultNetwork.id,
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 * });
 * const defaultApplicationLoadBalancer = new alicloud.slb.ApplicationLoadBalancer("default", {
 *     loadBalancerName: "terraform-example",
 *     vswitchId: defaultSwitch.id,
 *     loadBalancerSpec: "slb.s2.small",
 *     addressType: "intranet",
 * });
 * const defaultBasicAccelerator = new alicloud.ga.BasicAccelerator("default", {
 *     duration: 1,
 *     basicAcceleratorName: "terraform-example",
 *     description: "terraform-example",
 *     bandwidthBillingType: "CDT",
 *     autoUseCoupon: "true",
 *     autoPay: true,
 * });
 * const defaultBasicEndpointGroup = new alicloud.ga.BasicEndpointGroup("default", {
 *     acceleratorId: defaultBasicAccelerator.id,
 *     endpointGroupRegion: endpointGroupRegion,
 *     endpointType: "SLB",
 *     endpointAddress: defaultApplicationLoadBalancer.id,
 *     endpointSubAddress: "192.168.0.1",
 *     basicEndpointGroupName: "terraform-example",
 *     description: "terraform-example",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * region = config.get("region")
 * if region is None:
 *     region = "cn-hangzhou"
 * endpoint_group_region = config.get("endpointGroupRegion")
 * if endpoint_group_region is None:
 *     endpoint_group_region = "cn-beijing"
 * default = alicloud.get_zones(available_resource_creation="VSwitch")
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name="terraform-example",
 *     cidr_block="172.17.3.0/24")
 * default_switch = alicloud.vpc.Switch("default",
 *     vswitch_name="terraform-example",
 *     cidr_block="172.17.3.0/24",
 *     vpc_id=default_network.id,
 *     zone_id=default.zones[0].id)
 * default_application_load_balancer = alicloud.slb.ApplicationLoadBalancer("default",
 *     load_balancer_name="terraform-example",
 *     vswitch_id=default_switch.id,
 *     load_balancer_spec="slb.s2.small",
 *     address_type="intranet")
 * default_basic_accelerator = alicloud.ga.BasicAccelerator("default",
 *     duration=1,
 *     basic_accelerator_name="terraform-example",
 *     description="terraform-example",
 *     bandwidth_billing_type="CDT",
 *     auto_use_coupon="true",
 *     auto_pay=True)
 * default_basic_endpoint_group = alicloud.ga.BasicEndpointGroup("default",
 *     accelerator_id=default_basic_accelerator.id,
 *     endpoint_group_region=endpoint_group_region,
 *     endpoint_type="SLB",
 *     endpoint_address=default_application_load_balancer.id,
 *     endpoint_sub_address="192.168.0.1",
 *     basic_endpoint_group_name="terraform-example",
 *     description="terraform-example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var region = config.Get("region") ?? "cn-hangzhou";
 *     var endpointGroupRegion = config.Get("endpointGroupRegion") ?? "cn-beijing";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = "terraform-example",
 *         CidrBlock = "172.17.3.0/24",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VswitchName = "terraform-example",
 *         CidrBlock = "172.17.3.0/24",
 *         VpcId = defaultNetwork.Id,
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *     });
 *     var defaultApplicationLoadBalancer = new AliCloud.Slb.ApplicationLoadBalancer("default", new()
 *     {
 *         LoadBalancerName = "terraform-example",
 *         VswitchId = defaultSwitch.Id,
 *         LoadBalancerSpec = "slb.s2.small",
 *         AddressType = "intranet",
 *     });
 *     var defaultBasicAccelerator = new AliCloud.Ga.BasicAccelerator("default", new()
 *     {
 *         Duration = 1,
 *         BasicAcceleratorName = "terraform-example",
 *         Description = "terraform-example",
 *         BandwidthBillingType = "CDT",
 *         AutoUseCoupon = "true",
 *         AutoPay = true,
 *     });
 *     var defaultBasicEndpointGroup = new AliCloud.Ga.BasicEndpointGroup("default", new()
 *     {
 *         AcceleratorId = defaultBasicAccelerator.Id,
 *         EndpointGroupRegion = endpointGroupRegion,
 *         EndpointType = "SLB",
 *         EndpointAddress = defaultApplicationLoadBalancer.Id,
 *         EndpointSubAddress = "192.168.0.1",
 *         BasicEndpointGroupName = "terraform-example",
 *         Description = "terraform-example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ga"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/slb"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		region := "cn-hangzhou"
 * 		if param := cfg.Get("region"); param != "" {
 * 			region = param
 * 		}
 * 		endpointGroupRegion := "cn-beijing"
 * 		if param := cfg.Get("endpointGroupRegion"); param != "" {
 * 			endpointGroupRegion = param
 * 		}
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String("terraform-example"),
 * 			CidrBlock: pulumi.String("172.17.3.0/24"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String("terraform-example"),
 * 			CidrBlock:   pulumi.String("172.17.3.0/24"),
 * 			VpcId:       defaultNetwork.ID(),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultApplicationLoadBalancer, err := slb.NewApplicationLoadBalancer(ctx, "default", &slb.ApplicationLoadBalancerArgs{
 * 			LoadBalancerName: pulumi.String("terraform-example"),
 * 			VswitchId:        defaultSwitch.ID(),
 * 			LoadBalancerSpec: pulumi.String("slb.s2.small"),
 * 			AddressType:      pulumi.String("intranet"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultBasicAccelerator, err := ga.NewBasicAccelerator(ctx, "default", &ga.BasicAcceleratorArgs{
 * 			Duration:             pulumi.Int(1),
 * 			BasicAcceleratorName: pulumi.String("terraform-example"),
 * 			Description:          pulumi.String("terraform-example"),
 * 			BandwidthBillingType: pulumi.String("CDT"),
 * 			AutoUseCoupon:        pulumi.String("true"),
 * 			AutoPay:              pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ga.NewBasicEndpointGroup(ctx, "default", &ga.BasicEndpointGroupArgs{
 * 			AcceleratorId:          defaultBasicAccelerator.ID(),
 * 			EndpointGroupRegion:    pulumi.String(endpointGroupRegion),
 * 			EndpointType:           pulumi.String("SLB"),
 * 			EndpointAddress:        defaultApplicationLoadBalancer.ID(),
 * 			EndpointSubAddress:     pulumi.String("192.168.0.1"),
 * 			BasicEndpointGroupName: pulumi.String("terraform-example"),
 * 			Description:            pulumi.String("terraform-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.slb.ApplicationLoadBalancer;
 * import com.pulumi.alicloud.slb.ApplicationLoadBalancerArgs;
 * import com.pulumi.alicloud.ga.BasicAccelerator;
 * import com.pulumi.alicloud.ga.BasicAcceleratorArgs;
 * import com.pulumi.alicloud.ga.BasicEndpointGroup;
 * import com.pulumi.alicloud.ga.BasicEndpointGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var region = config.get("region").orElse("cn-hangzhou");
 *         final var endpointGroupRegion = config.get("endpointGroupRegion").orElse("cn-beijing");
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName("terraform-example")
 *             .cidrBlock("172.17.3.0/24")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vswitchName("terraform-example")
 *             .cidrBlock("172.17.3.0/24")
 *             .vpcId(defaultNetwork.id())
 *             .zoneId(default_.zones()[0].id())
 *             .build());
 *         var defaultApplicationLoadBalancer = new ApplicationLoadBalancer("defaultApplicationLoadBalancer", ApplicationLoadBalancerArgs.builder()
 *             .loadBalancerName("terraform-example")
 *             .vswitchId(defaultSwitch.id())
 *             .loadBalancerSpec("slb.s2.small")
 *             .addressType("intranet")
 *             .build());
 *         var defaultBasicAccelerator = new BasicAccelerator("defaultBasicAccelerator", BasicAcceleratorArgs.builder()
 *             .duration(1)
 *             .basicAcceleratorName("terraform-example")
 *             .description("terraform-example")
 *             .bandwidthBillingType("CDT")
 *             .autoUseCoupon("true")
 *             .autoPay(true)
 *             .build());
 *         var defaultBasicEndpointGroup = new BasicEndpointGroup("defaultBasicEndpointGroup", BasicEndpointGroupArgs.builder()
 *             .acceleratorId(defaultBasicAccelerator.id())
 *             .endpointGroupRegion(endpointGroupRegion)
 *             .endpointType("SLB")
 *             .endpointAddress(defaultApplicationLoadBalancer.id())
 *             .endpointSubAddress("192.168.0.1")
 *             .basicEndpointGroupName("terraform-example")
 *             .description("terraform-example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   region:
 *     type: string
 *     default: cn-hangzhou
 *   endpointGroupRegion:
 *     type: string
 *     default: cn-beijing
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: terraform-example
 *       cidrBlock: 172.17.3.0/24
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vswitchName: terraform-example
 *       cidrBlock: 172.17.3.0/24
 *       vpcId: ${defaultNetwork.id}
 *       zoneId: ${default.zones[0].id}
 *   defaultApplicationLoadBalancer:
 *     type: alicloud:slb:ApplicationLoadBalancer
 *     name: default
 *     properties:
 *       loadBalancerName: terraform-example
 *       vswitchId: ${defaultSwitch.id}
 *       loadBalancerSpec: slb.s2.small
 *       addressType: intranet
 *   defaultBasicAccelerator:
 *     type: alicloud:ga:BasicAccelerator
 *     name: default
 *     properties:
 *       duration: 1
 *       basicAcceleratorName: terraform-example
 *       description: terraform-example
 *       bandwidthBillingType: CDT
 *       autoUseCoupon: 'true'
 *       autoPay: true
 *   defaultBasicEndpointGroup:
 *     type: alicloud:ga:BasicEndpointGroup
 *     name: default
 *     properties:
 *       acceleratorId: ${defaultBasicAccelerator.id}
 *       endpointGroupRegion: ${endpointGroupRegion}
 *       endpointType: SLB
 *       endpointAddress: ${defaultApplicationLoadBalancer.id}
 *       endpointSubAddress: 192.168.0.1
 *       basicEndpointGroupName: terraform-example
 *       description: terraform-example
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Global Accelerator (GA) Basic Endpoint Group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ga/basicEndpointGroup:BasicEndpointGroup example <id>
 * ```
 * @property acceleratorId The ID of the basic GA instance.
 * @property basicEndpointGroupName The name of the endpoint group. The `basic_endpoint_group_name` must be 2 to 128 characters in length, and can contain letters, digits, underscores (_), and hyphens (-). The name must start with a letter.
 * @property description The description of the endpoint group. The `description` cannot exceed 256 characters in length and cannot contain http:// or https://.
 * @property endpointAddress The address of the endpoint.
 * @property endpointGroupRegion The ID of the region where you want to create the endpoint group.
 * @property endpointSubAddress The sub address of the endpoint.
 * @property endpointType The type of the endpoint. Valid values: `ENI`, `SLB` and `ECS`.
 */
public data class BasicEndpointGroupArgs(
    public val acceleratorId: Output<String>? = null,
    public val basicEndpointGroupName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val endpointAddress: Output<String>? = null,
    public val endpointGroupRegion: Output<String>? = null,
    public val endpointSubAddress: Output<String>? = null,
    public val endpointType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ga.BasicEndpointGroupArgs> {
    override fun toJava(): com.pulumi.alicloud.ga.BasicEndpointGroupArgs =
        com.pulumi.alicloud.ga.BasicEndpointGroupArgs.builder()
            .acceleratorId(acceleratorId?.applyValue({ args0 -> args0 }))
            .basicEndpointGroupName(basicEndpointGroupName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .endpointAddress(endpointAddress?.applyValue({ args0 -> args0 }))
            .endpointGroupRegion(endpointGroupRegion?.applyValue({ args0 -> args0 }))
            .endpointSubAddress(endpointSubAddress?.applyValue({ args0 -> args0 }))
            .endpointType(endpointType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BasicEndpointGroupArgs].
 */
@PulumiTagMarker
public class BasicEndpointGroupArgsBuilder internal constructor() {
    private var acceleratorId: Output<String>? = null

    private var basicEndpointGroupName: Output<String>? = null

    private var description: Output<String>? = null

    private var endpointAddress: Output<String>? = null

    private var endpointGroupRegion: Output<String>? = null

    private var endpointSubAddress: Output<String>? = null

    private var endpointType: Output<String>? = null

    /**
     * @param value The ID of the basic GA instance.
     */
    @JvmName("avmnsmogweusniev")
    public suspend fun acceleratorId(`value`: Output<String>) {
        this.acceleratorId = value
    }

    /**
     * @param value The name of the endpoint group. The `basic_endpoint_group_name` must be 2 to 128 characters in length, and can contain letters, digits, underscores (_), and hyphens (-). The name must start with a letter.
     */
    @JvmName("jpyvgivgfeoxemya")
    public suspend fun basicEndpointGroupName(`value`: Output<String>) {
        this.basicEndpointGroupName = value
    }

    /**
     * @param value The description of the endpoint group. The `description` cannot exceed 256 characters in length and cannot contain http:// or https://.
     */
    @JvmName("lxacskhfwcxxevkv")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The address of the endpoint.
     */
    @JvmName("dmwtrpfcmvedwpek")
    public suspend fun endpointAddress(`value`: Output<String>) {
        this.endpointAddress = value
    }

    /**
     * @param value The ID of the region where you want to create the endpoint group.
     */
    @JvmName("fhowhbelxfpwrqrv")
    public suspend fun endpointGroupRegion(`value`: Output<String>) {
        this.endpointGroupRegion = value
    }

    /**
     * @param value The sub address of the endpoint.
     */
    @JvmName("jptftvrxrdbnigse")
    public suspend fun endpointSubAddress(`value`: Output<String>) {
        this.endpointSubAddress = value
    }

    /**
     * @param value The type of the endpoint. Valid values: `ENI`, `SLB` and `ECS`.
     */
    @JvmName("jeskcpogxdqnibqj")
    public suspend fun endpointType(`value`: Output<String>) {
        this.endpointType = value
    }

    /**
     * @param value The ID of the basic GA instance.
     */
    @JvmName("vxforfkfvvjoumgd")
    public suspend fun acceleratorId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceleratorId = mapped
    }

    /**
     * @param value The name of the endpoint group. The `basic_endpoint_group_name` must be 2 to 128 characters in length, and can contain letters, digits, underscores (_), and hyphens (-). The name must start with a letter.
     */
    @JvmName("cvvoutaedkukviom")
    public suspend fun basicEndpointGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.basicEndpointGroupName = mapped
    }

    /**
     * @param value The description of the endpoint group. The `description` cannot exceed 256 characters in length and cannot contain http:// or https://.
     */
    @JvmName("tycurqpveqjbsboj")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The address of the endpoint.
     */
    @JvmName("fpubrootuupbixob")
    public suspend fun endpointAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointAddress = mapped
    }

    /**
     * @param value The ID of the region where you want to create the endpoint group.
     */
    @JvmName("udwgcsmkfjgaetoe")
    public suspend fun endpointGroupRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointGroupRegion = mapped
    }

    /**
     * @param value The sub address of the endpoint.
     */
    @JvmName("nhjffpbluasiagix")
    public suspend fun endpointSubAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointSubAddress = mapped
    }

    /**
     * @param value The type of the endpoint. Valid values: `ENI`, `SLB` and `ECS`.
     */
    @JvmName("wxyfwscsvylkfsbj")
    public suspend fun endpointType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointType = mapped
    }

    internal fun build(): BasicEndpointGroupArgs = BasicEndpointGroupArgs(
        acceleratorId = acceleratorId,
        basicEndpointGroupName = basicEndpointGroupName,
        description = description,
        endpointAddress = endpointAddress,
        endpointGroupRegion = endpointGroupRegion,
        endpointSubAddress = endpointSubAddress,
        endpointType = endpointType,
    )
}
