@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [BasicIpSet].
 */
@PulumiTagMarker
public class BasicIpSetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BasicIpSetArgs = BasicIpSetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BasicIpSetArgsBuilder.() -> Unit) {
        val builder = BasicIpSetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BasicIpSet {
        val builtJavaResource = com.pulumi.alicloud.ga.BasicIpSet(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BasicIpSet(builtJavaResource)
    }
}

/**
 * Provides a Global Accelerator (GA) Basic Ip Set resource.
 * For information about Global Accelerator (GA) Basic Ip Set and how to use it, see [What is Basic Ip Set](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-createbasicipset).
 * > **NOTE:** Available since v1.194.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const region = config.get("region") || "cn-hangzhou";
 * const _default = new alicloud.ga.BasicAccelerator("default", {
 *     duration: 1,
 *     pricingCycle: "Month",
 *     bandwidthBillingType: "CDT",
 *     autoPay: true,
 *     autoUseCoupon: "true",
 *     autoRenew: false,
 *     autoRenewDuration: 1,
 * });
 * const defaultBasicIpSet = new alicloud.ga.BasicIpSet("default", {
 *     acceleratorId: _default.id,
 *     accelerateRegionId: region,
 *     ispType: "BGP",
 *     bandwidth: 5,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * region = config.get("region")
 * if region is None:
 *     region = "cn-hangzhou"
 * default = alicloud.ga.BasicAccelerator("default",
 *     duration=1,
 *     pricing_cycle="Month",
 *     bandwidth_billing_type="CDT",
 *     auto_pay=True,
 *     auto_use_coupon="true",
 *     auto_renew=False,
 *     auto_renew_duration=1)
 * default_basic_ip_set = alicloud.ga.BasicIpSet("default",
 *     accelerator_id=default.id,
 *     accelerate_region_id=region,
 *     isp_type="BGP",
 *     bandwidth=5)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var region = config.Get("region") ?? "cn-hangzhou";
 *     var @default = new AliCloud.Ga.BasicAccelerator("default", new()
 *     {
 *         Duration = 1,
 *         PricingCycle = "Month",
 *         BandwidthBillingType = "CDT",
 *         AutoPay = true,
 *         AutoUseCoupon = "true",
 *         AutoRenew = false,
 *         AutoRenewDuration = 1,
 *     });
 *     var defaultBasicIpSet = new AliCloud.Ga.BasicIpSet("default", new()
 *     {
 *         AcceleratorId = @default.Id,
 *         AccelerateRegionId = region,
 *         IspType = "BGP",
 *         Bandwidth = 5,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ga"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		region := "cn-hangzhou"
 * 		if param := cfg.Get("region"); param != "" {
 * 			region = param
 * 		}
 * 		_, err := ga.NewBasicAccelerator(ctx, "default", &ga.BasicAcceleratorArgs{
 * 			Duration:             pulumi.Int(1),
 * 			PricingCycle:         pulumi.String("Month"),
 * 			BandwidthBillingType: pulumi.String("CDT"),
 * 			AutoPay:              pulumi.Bool(true),
 * 			AutoUseCoupon:        pulumi.String("true"),
 * 			AutoRenew:            pulumi.Bool(false),
 * 			AutoRenewDuration:    pulumi.Int(1),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ga.NewBasicIpSet(ctx, "default", &ga.BasicIpSetArgs{
 * 			AcceleratorId:      _default.ID(),
 * 			AccelerateRegionId: pulumi.String(region),
 * 			IspType:            pulumi.String("BGP"),
 * 			Bandwidth:          pulumi.Int(5),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ga.BasicAccelerator;
 * import com.pulumi.alicloud.ga.BasicAcceleratorArgs;
 * import com.pulumi.alicloud.ga.BasicIpSet;
 * import com.pulumi.alicloud.ga.BasicIpSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var region = config.get("region").orElse("cn-hangzhou");
 *         var default_ = new BasicAccelerator("default", BasicAcceleratorArgs.builder()
 *             .duration(1)
 *             .pricingCycle("Month")
 *             .bandwidthBillingType("CDT")
 *             .autoPay(true)
 *             .autoUseCoupon("true")
 *             .autoRenew(false)
 *             .autoRenewDuration(1)
 *             .build());
 *         var defaultBasicIpSet = new BasicIpSet("defaultBasicIpSet", BasicIpSetArgs.builder()
 *             .acceleratorId(default_.id())
 *             .accelerateRegionId(region)
 *             .ispType("BGP")
 *             .bandwidth("5")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   region:
 *     type: string
 *     default: cn-hangzhou
 * resources:
 *   default:
 *     type: alicloud:ga:BasicAccelerator
 *     properties:
 *       duration: 1
 *       pricingCycle: Month
 *       bandwidthBillingType: CDT
 *       autoPay: true
 *       autoUseCoupon: 'true'
 *       autoRenew: false
 *       autoRenewDuration: 1
 *   defaultBasicIpSet:
 *     type: alicloud:ga:BasicIpSet
 *     name: default
 *     properties:
 *       acceleratorId: ${default.id}
 *       accelerateRegionId: ${region}
 *       ispType: BGP
 *       bandwidth: '5'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Global Accelerator (GA) Basic Ip Set can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ga/basicIpSet:BasicIpSet example <id>
 * ```
 */
public class BasicIpSet internal constructor(
    override val javaResource: com.pulumi.alicloud.ga.BasicIpSet,
) : KotlinCustomResource(javaResource, BasicIpSetMapper) {
    /**
     * The ID of the acceleration region.
     */
    public val accelerateRegionId: Output<String>
        get() = javaResource.accelerateRegionId().applyValue({ args0 -> args0 })

    /**
     * The ID of the basic GA instance.
     */
    public val acceleratorId: Output<String>
        get() = javaResource.acceleratorId().applyValue({ args0 -> args0 })

    /**
     * The bandwidth of the acceleration region. Unit: Mbit/s.
     */
    public val bandwidth: Output<Int>
        get() = javaResource.bandwidth().applyValue({ args0 -> args0 })

    /**
     * The line type of the elastic IP address (EIP) in the acceleration region. Default value: `BGP`. Valid values: `BGP`, `BGP_PRO`, `ChinaTelecom`, `ChinaUnicom`, `ChinaMobile`, `ChinaTelecom_L2`, `ChinaUnicom_L2`, `ChinaMobile_L2`.
     */
    public val ispType: Output<String>
        get() = javaResource.ispType().applyValue({ args0 -> args0 })

    /**
     * The status of the Basic Ip Set instance.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object BasicIpSetMapper : ResourceMapper<BasicIpSet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ga.BasicIpSet::class == javaResource::class

    override fun map(javaResource: Resource): BasicIpSet = BasicIpSet(
        javaResource as
            com.pulumi.alicloud.ga.BasicIpSet,
    )
}

/**
 * @see [BasicIpSet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BasicIpSet].
 */
public suspend fun basicIpSet(name: String, block: suspend BasicIpSetResourceBuilder.() -> Unit): BasicIpSet {
    val builder = BasicIpSetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BasicIpSet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun basicIpSet(name: String): BasicIpSet {
    val builder = BasicIpSetResourceBuilder()
    builder.name(name)
    return builder.build()
}
