@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin

import com.pulumi.alicloud.ga.BasicIpSetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Global Accelerator (GA) Basic Ip Set resource.
 * For information about Global Accelerator (GA) Basic Ip Set and how to use it, see [What is Basic Ip Set](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-createbasicipset).
 * > **NOTE:** Available since v1.194.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const region = config.get("region") || "cn-hangzhou";
 * const _default = new alicloud.ga.BasicAccelerator("default", {
 *     duration: 1,
 *     pricingCycle: "Month",
 *     bandwidthBillingType: "CDT",
 *     autoPay: true,
 *     autoUseCoupon: "true",
 *     autoRenew: false,
 *     autoRenewDuration: 1,
 * });
 * const defaultBasicIpSet = new alicloud.ga.BasicIpSet("default", {
 *     acceleratorId: _default.id,
 *     accelerateRegionId: region,
 *     ispType: "BGP",
 *     bandwidth: 5,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * region = config.get("region")
 * if region is None:
 *     region = "cn-hangzhou"
 * default = alicloud.ga.BasicAccelerator("default",
 *     duration=1,
 *     pricing_cycle="Month",
 *     bandwidth_billing_type="CDT",
 *     auto_pay=True,
 *     auto_use_coupon="true",
 *     auto_renew=False,
 *     auto_renew_duration=1)
 * default_basic_ip_set = alicloud.ga.BasicIpSet("default",
 *     accelerator_id=default.id,
 *     accelerate_region_id=region,
 *     isp_type="BGP",
 *     bandwidth=5)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var region = config.Get("region") ?? "cn-hangzhou";
 *     var @default = new AliCloud.Ga.BasicAccelerator("default", new()
 *     {
 *         Duration = 1,
 *         PricingCycle = "Month",
 *         BandwidthBillingType = "CDT",
 *         AutoPay = true,
 *         AutoUseCoupon = "true",
 *         AutoRenew = false,
 *         AutoRenewDuration = 1,
 *     });
 *     var defaultBasicIpSet = new AliCloud.Ga.BasicIpSet("default", new()
 *     {
 *         AcceleratorId = @default.Id,
 *         AccelerateRegionId = region,
 *         IspType = "BGP",
 *         Bandwidth = 5,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ga"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		region := "cn-hangzhou"
 * 		if param := cfg.Get("region"); param != "" {
 * 			region = param
 * 		}
 * 		_, err := ga.NewBasicAccelerator(ctx, "default", &ga.BasicAcceleratorArgs{
 * 			Duration:             pulumi.Int(1),
 * 			PricingCycle:         pulumi.String("Month"),
 * 			BandwidthBillingType: pulumi.String("CDT"),
 * 			AutoPay:              pulumi.Bool(true),
 * 			AutoUseCoupon:        pulumi.String("true"),
 * 			AutoRenew:            pulumi.Bool(false),
 * 			AutoRenewDuration:    pulumi.Int(1),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ga.NewBasicIpSet(ctx, "default", &ga.BasicIpSetArgs{
 * 			AcceleratorId:      _default.ID(),
 * 			AccelerateRegionId: pulumi.String(region),
 * 			IspType:            pulumi.String("BGP"),
 * 			Bandwidth:          pulumi.Int(5),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ga.BasicAccelerator;
 * import com.pulumi.alicloud.ga.BasicAcceleratorArgs;
 * import com.pulumi.alicloud.ga.BasicIpSet;
 * import com.pulumi.alicloud.ga.BasicIpSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var region = config.get("region").orElse("cn-hangzhou");
 *         var default_ = new BasicAccelerator("default", BasicAcceleratorArgs.builder()
 *             .duration(1)
 *             .pricingCycle("Month")
 *             .bandwidthBillingType("CDT")
 *             .autoPay(true)
 *             .autoUseCoupon("true")
 *             .autoRenew(false)
 *             .autoRenewDuration(1)
 *             .build());
 *         var defaultBasicIpSet = new BasicIpSet("defaultBasicIpSet", BasicIpSetArgs.builder()
 *             .acceleratorId(default_.id())
 *             .accelerateRegionId(region)
 *             .ispType("BGP")
 *             .bandwidth("5")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   region:
 *     type: string
 *     default: cn-hangzhou
 * resources:
 *   default:
 *     type: alicloud:ga:BasicAccelerator
 *     properties:
 *       duration: 1
 *       pricingCycle: Month
 *       bandwidthBillingType: CDT
 *       autoPay: true
 *       autoUseCoupon: 'true'
 *       autoRenew: false
 *       autoRenewDuration: 1
 *   defaultBasicIpSet:
 *     type: alicloud:ga:BasicIpSet
 *     name: default
 *     properties:
 *       acceleratorId: ${default.id}
 *       accelerateRegionId: ${region}
 *       ispType: BGP
 *       bandwidth: '5'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Global Accelerator (GA) Basic Ip Set can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ga/basicIpSet:BasicIpSet example <id>
 * ```
 * @property accelerateRegionId The ID of the acceleration region.
 * @property acceleratorId The ID of the basic GA instance.
 * @property bandwidth The bandwidth of the acceleration region. Unit: Mbit/s.
 * @property ispType The line type of the elastic IP address (EIP) in the acceleration region. Default value: `BGP`. Valid values: `BGP`, `BGP_PRO`, `ChinaTelecom`, `ChinaUnicom`, `ChinaMobile`, `ChinaTelecom_L2`, `ChinaUnicom_L2`, `ChinaMobile_L2`.
 */
public data class BasicIpSetArgs(
    public val accelerateRegionId: Output<String>? = null,
    public val acceleratorId: Output<String>? = null,
    public val bandwidth: Output<Int>? = null,
    public val ispType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ga.BasicIpSetArgs> {
    override fun toJava(): com.pulumi.alicloud.ga.BasicIpSetArgs =
        com.pulumi.alicloud.ga.BasicIpSetArgs.builder()
            .accelerateRegionId(accelerateRegionId?.applyValue({ args0 -> args0 }))
            .acceleratorId(acceleratorId?.applyValue({ args0 -> args0 }))
            .bandwidth(bandwidth?.applyValue({ args0 -> args0 }))
            .ispType(ispType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BasicIpSetArgs].
 */
@PulumiTagMarker
public class BasicIpSetArgsBuilder internal constructor() {
    private var accelerateRegionId: Output<String>? = null

    private var acceleratorId: Output<String>? = null

    private var bandwidth: Output<Int>? = null

    private var ispType: Output<String>? = null

    /**
     * @param value The ID of the acceleration region.
     */
    @JvmName("creijddlshipeiwq")
    public suspend fun accelerateRegionId(`value`: Output<String>) {
        this.accelerateRegionId = value
    }

    /**
     * @param value The ID of the basic GA instance.
     */
    @JvmName("msqcctygbmmfahcw")
    public suspend fun acceleratorId(`value`: Output<String>) {
        this.acceleratorId = value
    }

    /**
     * @param value The bandwidth of the acceleration region. Unit: Mbit/s.
     */
    @JvmName("riyngmjtpbriqcba")
    public suspend fun bandwidth(`value`: Output<Int>) {
        this.bandwidth = value
    }

    /**
     * @param value The line type of the elastic IP address (EIP) in the acceleration region. Default value: `BGP`. Valid values: `BGP`, `BGP_PRO`, `ChinaTelecom`, `ChinaUnicom`, `ChinaMobile`, `ChinaTelecom_L2`, `ChinaUnicom_L2`, `ChinaMobile_L2`.
     */
    @JvmName("kahyxobdvudjeied")
    public suspend fun ispType(`value`: Output<String>) {
        this.ispType = value
    }

    /**
     * @param value The ID of the acceleration region.
     */
    @JvmName("wffdabqavunryysg")
    public suspend fun accelerateRegionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accelerateRegionId = mapped
    }

    /**
     * @param value The ID of the basic GA instance.
     */
    @JvmName("uneonolvjloxemmy")
    public suspend fun acceleratorId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceleratorId = mapped
    }

    /**
     * @param value The bandwidth of the acceleration region. Unit: Mbit/s.
     */
    @JvmName("tevrbeethapuiohd")
    public suspend fun bandwidth(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bandwidth = mapped
    }

    /**
     * @param value The line type of the elastic IP address (EIP) in the acceleration region. Default value: `BGP`. Valid values: `BGP`, `BGP_PRO`, `ChinaTelecom`, `ChinaUnicom`, `ChinaMobile`, `ChinaTelecom_L2`, `ChinaUnicom_L2`, `ChinaMobile_L2`.
     */
    @JvmName("glsjpeuvqxtevgwm")
    public suspend fun ispType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ispType = mapped
    }

    internal fun build(): BasicIpSetArgs = BasicIpSetArgs(
        accelerateRegionId = accelerateRegionId,
        acceleratorId = acceleratorId,
        bandwidth = bandwidth,
        ispType = ispType,
    )
}
