@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin

import com.pulumi.alicloud.ga.CustomRoutingEndpointGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Global Accelerator (GA) Custom Routing Endpoint Group resource.
 * For information about Global Accelerator (GA) Custom Routing Endpoint Group and how to use it, see [What is Custom Routing Endpoint Group](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-createcustomroutingendpointgroups).
 * > **NOTE:** Available since v1.197.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const region = config.get("region") || "cn-hangzhou";
 * const _default = new alicloud.ga.Accelerator("default", {
 *     duration: 1,
 *     autoUseCoupon: true,
 *     spec: "1",
 * });
 * const defaultBandwidthPackage = new alicloud.ga.BandwidthPackage("default", {
 *     bandwidth: 100,
 *     type: "Basic",
 *     bandwidthType: "Basic",
 *     paymentType: "PayAsYouGo",
 *     billingType: "PayBy95",
 *     ratio: 30,
 * });
 * const defaultBandwidthPackageAttachment = new alicloud.ga.BandwidthPackageAttachment("default", {
 *     acceleratorId: _default.id,
 *     bandwidthPackageId: defaultBandwidthPackage.id,
 * });
 * const defaultListener = new alicloud.ga.Listener("default", {
 *     acceleratorId: defaultBandwidthPackageAttachment.acceleratorId,
 *     listenerType: "CustomRouting",
 *     portRanges: [{
 *         fromPort: 10000,
 *         toPort: 16000,
 *     }],
 * });
 * const defaultCustomRoutingEndpointGroup = new alicloud.ga.CustomRoutingEndpointGroup("default", {
 *     acceleratorId: defaultListener.acceleratorId,
 *     listenerId: defaultListener.id,
 *     endpointGroupRegion: region,
 *     customRoutingEndpointGroupName: "terraform-example",
 *     description: "terraform-example",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * region = config.get("region")
 * if region is None:
 *     region = "cn-hangzhou"
 * default = alicloud.ga.Accelerator("default",
 *     duration=1,
 *     auto_use_coupon=True,
 *     spec="1")
 * default_bandwidth_package = alicloud.ga.BandwidthPackage("default",
 *     bandwidth=100,
 *     type="Basic",
 *     bandwidth_type="Basic",
 *     payment_type="PayAsYouGo",
 *     billing_type="PayBy95",
 *     ratio=30)
 * default_bandwidth_package_attachment = alicloud.ga.BandwidthPackageAttachment("default",
 *     accelerator_id=default.id,
 *     bandwidth_package_id=default_bandwidth_package.id)
 * default_listener = alicloud.ga.Listener("default",
 *     accelerator_id=default_bandwidth_package_attachment.accelerator_id,
 *     listener_type="CustomRouting",
 *     port_ranges=[{
 *         "from_port": 10000,
 *         "to_port": 16000,
 *     }])
 * default_custom_routing_endpoint_group = alicloud.ga.CustomRoutingEndpointGroup("default",
 *     accelerator_id=default_listener.accelerator_id,
 *     listener_id=default_listener.id,
 *     endpoint_group_region=region,
 *     custom_routing_endpoint_group_name="terraform-example",
 *     description="terraform-example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var region = config.Get("region") ?? "cn-hangzhou";
 *     var @default = new AliCloud.Ga.Accelerator("default", new()
 *     {
 *         Duration = 1,
 *         AutoUseCoupon = true,
 *         Spec = "1",
 *     });
 *     var defaultBandwidthPackage = new AliCloud.Ga.BandwidthPackage("default", new()
 *     {
 *         Bandwidth = 100,
 *         Type = "Basic",
 *         BandwidthType = "Basic",
 *         PaymentType = "PayAsYouGo",
 *         BillingType = "PayBy95",
 *         Ratio = 30,
 *     });
 *     var defaultBandwidthPackageAttachment = new AliCloud.Ga.BandwidthPackageAttachment("default", new()
 *     {
 *         AcceleratorId = @default.Id,
 *         BandwidthPackageId = defaultBandwidthPackage.Id,
 *     });
 *     var defaultListener = new AliCloud.Ga.Listener("default", new()
 *     {
 *         AcceleratorId = defaultBandwidthPackageAttachment.AcceleratorId,
 *         ListenerType = "CustomRouting",
 *         PortRanges = new[]
 *         {
 *             new AliCloud.Ga.Inputs.ListenerPortRangeArgs
 *             {
 *                 FromPort = 10000,
 *                 ToPort = 16000,
 *             },
 *         },
 *     });
 *     var defaultCustomRoutingEndpointGroup = new AliCloud.Ga.CustomRoutingEndpointGroup("default", new()
 *     {
 *         AcceleratorId = defaultListener.AcceleratorId,
 *         ListenerId = defaultListener.Id,
 *         EndpointGroupRegion = region,
 *         CustomRoutingEndpointGroupName = "terraform-example",
 *         Description = "terraform-example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ga"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		region := "cn-hangzhou"
 * 		if param := cfg.Get("region"); param != "" {
 * 			region = param
 * 		}
 * 		_, err := ga.NewAccelerator(ctx, "default", &ga.AcceleratorArgs{
 * 			Duration:      pulumi.Int(1),
 * 			AutoUseCoupon: pulumi.Bool(true),
 * 			Spec:          pulumi.String("1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultBandwidthPackage, err := ga.NewBandwidthPackage(ctx, "default", &ga.BandwidthPackageArgs{
 * 			Bandwidth:     pulumi.Int(100),
 * 			Type:          pulumi.String("Basic"),
 * 			BandwidthType: pulumi.String("Basic"),
 * 			PaymentType:   pulumi.String("PayAsYouGo"),
 * 			BillingType:   pulumi.String("PayBy95"),
 * 			Ratio:         pulumi.Int(30),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultBandwidthPackageAttachment, err := ga.NewBandwidthPackageAttachment(ctx, "default", &ga.BandwidthPackageAttachmentArgs{
 * 			AcceleratorId:      _default.ID(),
 * 			BandwidthPackageId: defaultBandwidthPackage.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultListener, err := ga.NewListener(ctx, "default", &ga.ListenerArgs{
 * 			AcceleratorId: defaultBandwidthPackageAttachment.AcceleratorId,
 * 			ListenerType:  pulumi.String("CustomRouting"),
 * 			PortRanges: ga.ListenerPortRangeArray{
 * 				&ga.ListenerPortRangeArgs{
 * 					FromPort: pulumi.Int(10000),
 * 					ToPort:   pulumi.Int(16000),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ga.NewCustomRoutingEndpointGroup(ctx, "default", &ga.CustomRoutingEndpointGroupArgs{
 * 			AcceleratorId:                  defaultListener.AcceleratorId,
 * 			ListenerId:                     defaultListener.ID(),
 * 			EndpointGroupRegion:            pulumi.String(region),
 * 			CustomRoutingEndpointGroupName: pulumi.String("terraform-example"),
 * 			Description:                    pulumi.String("terraform-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ga.Accelerator;
 * import com.pulumi.alicloud.ga.AcceleratorArgs;
 * import com.pulumi.alicloud.ga.BandwidthPackage;
 * import com.pulumi.alicloud.ga.BandwidthPackageArgs;
 * import com.pulumi.alicloud.ga.BandwidthPackageAttachment;
 * import com.pulumi.alicloud.ga.BandwidthPackageAttachmentArgs;
 * import com.pulumi.alicloud.ga.Listener;
 * import com.pulumi.alicloud.ga.ListenerArgs;
 * import com.pulumi.alicloud.ga.inputs.ListenerPortRangeArgs;
 * import com.pulumi.alicloud.ga.CustomRoutingEndpointGroup;
 * import com.pulumi.alicloud.ga.CustomRoutingEndpointGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var region = config.get("region").orElse("cn-hangzhou");
 *         var default_ = new Accelerator("default", AcceleratorArgs.builder()
 *             .duration(1)
 *             .autoUseCoupon(true)
 *             .spec("1")
 *             .build());
 *         var defaultBandwidthPackage = new BandwidthPackage("defaultBandwidthPackage", BandwidthPackageArgs.builder()
 *             .bandwidth(100)
 *             .type("Basic")
 *             .bandwidthType("Basic")
 *             .paymentType("PayAsYouGo")
 *             .billingType("PayBy95")
 *             .ratio(30)
 *             .build());
 *         var defaultBandwidthPackageAttachment = new BandwidthPackageAttachment("defaultBandwidthPackageAttachment", BandwidthPackageAttachmentArgs.builder()
 *             .acceleratorId(default_.id())
 *             .bandwidthPackageId(defaultBandwidthPackage.id())
 *             .build());
 *         var defaultListener = new Listener("defaultListener", ListenerArgs.builder()
 *             .acceleratorId(defaultBandwidthPackageAttachment.acceleratorId())
 *             .listenerType("CustomRouting")
 *             .portRanges(ListenerPortRangeArgs.builder()
 *                 .fromPort(10000)
 *                 .toPort(16000)
 *                 .build())
 *             .build());
 *         var defaultCustomRoutingEndpointGroup = new CustomRoutingEndpointGroup("defaultCustomRoutingEndpointGroup", CustomRoutingEndpointGroupArgs.builder()
 *             .acceleratorId(defaultListener.acceleratorId())
 *             .listenerId(defaultListener.id())
 *             .endpointGroupRegion(region)
 *             .customRoutingEndpointGroupName("terraform-example")
 *             .description("terraform-example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   region:
 *     type: string
 *     default: cn-hangzhou
 * resources:
 *   default:
 *     type: alicloud:ga:Accelerator
 *     properties:
 *       duration: 1
 *       autoUseCoupon: true
 *       spec: '1'
 *   defaultBandwidthPackage:
 *     type: alicloud:ga:BandwidthPackage
 *     name: default
 *     properties:
 *       bandwidth: 100
 *       type: Basic
 *       bandwidthType: Basic
 *       paymentType: PayAsYouGo
 *       billingType: PayBy95
 *       ratio: 30
 *   defaultBandwidthPackageAttachment:
 *     type: alicloud:ga:BandwidthPackageAttachment
 *     name: default
 *     properties:
 *       acceleratorId: ${default.id}
 *       bandwidthPackageId: ${defaultBandwidthPackage.id}
 *   defaultListener:
 *     type: alicloud:ga:Listener
 *     name: default
 *     properties:
 *       acceleratorId: ${defaultBandwidthPackageAttachment.acceleratorId}
 *       listenerType: CustomRouting
 *       portRanges:
 *         - fromPort: 10000
 *           toPort: 16000
 *   defaultCustomRoutingEndpointGroup:
 *     type: alicloud:ga:CustomRoutingEndpointGroup
 *     name: default
 *     properties:
 *       acceleratorId: ${defaultListener.acceleratorId}
 *       listenerId: ${defaultListener.id}
 *       endpointGroupRegion: ${region}
 *       customRoutingEndpointGroupName: terraform-example
 *       description: terraform-example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Global Accelerator (GA) Custom Routing Endpoint Group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ga/customRoutingEndpointGroup:CustomRoutingEndpointGroup example <id>
 * ```
 * @property acceleratorId The ID of the GA instance.
 * @property customRoutingEndpointGroupName The name of the endpoint group.
 * @property description The description of the endpoint group.
 * @property endpointGroupRegion The ID of the region in which to create the endpoint group.
 * @property listenerId The ID of the custom routing listener.
 */
public data class CustomRoutingEndpointGroupArgs(
    public val acceleratorId: Output<String>? = null,
    public val customRoutingEndpointGroupName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val endpointGroupRegion: Output<String>? = null,
    public val listenerId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ga.CustomRoutingEndpointGroupArgs> {
    override fun toJava(): com.pulumi.alicloud.ga.CustomRoutingEndpointGroupArgs =
        com.pulumi.alicloud.ga.CustomRoutingEndpointGroupArgs.builder()
            .acceleratorId(acceleratorId?.applyValue({ args0 -> args0 }))
            .customRoutingEndpointGroupName(customRoutingEndpointGroupName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .endpointGroupRegion(endpointGroupRegion?.applyValue({ args0 -> args0 }))
            .listenerId(listenerId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomRoutingEndpointGroupArgs].
 */
@PulumiTagMarker
public class CustomRoutingEndpointGroupArgsBuilder internal constructor() {
    private var acceleratorId: Output<String>? = null

    private var customRoutingEndpointGroupName: Output<String>? = null

    private var description: Output<String>? = null

    private var endpointGroupRegion: Output<String>? = null

    private var listenerId: Output<String>? = null

    /**
     * @param value The ID of the GA instance.
     */
    @JvmName("vfqunarurdlskbxc")
    public suspend fun acceleratorId(`value`: Output<String>) {
        this.acceleratorId = value
    }

    /**
     * @param value The name of the endpoint group.
     */
    @JvmName("iijnbwimdjbsbmux")
    public suspend fun customRoutingEndpointGroupName(`value`: Output<String>) {
        this.customRoutingEndpointGroupName = value
    }

    /**
     * @param value The description of the endpoint group.
     */
    @JvmName("qoucxtsoslccctbo")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The ID of the region in which to create the endpoint group.
     */
    @JvmName("sqckmcrwpofmcydm")
    public suspend fun endpointGroupRegion(`value`: Output<String>) {
        this.endpointGroupRegion = value
    }

    /**
     * @param value The ID of the custom routing listener.
     */
    @JvmName("conlpewbmbkglbdg")
    public suspend fun listenerId(`value`: Output<String>) {
        this.listenerId = value
    }

    /**
     * @param value The ID of the GA instance.
     */
    @JvmName("dsctxygwlwlxrbbd")
    public suspend fun acceleratorId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceleratorId = mapped
    }

    /**
     * @param value The name of the endpoint group.
     */
    @JvmName("xigyujpusreorxqq")
    public suspend fun customRoutingEndpointGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customRoutingEndpointGroupName = mapped
    }

    /**
     * @param value The description of the endpoint group.
     */
    @JvmName("jkhjifxgkivilpvh")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The ID of the region in which to create the endpoint group.
     */
    @JvmName("nqtoxtdqlgigsnod")
    public suspend fun endpointGroupRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointGroupRegion = mapped
    }

    /**
     * @param value The ID of the custom routing listener.
     */
    @JvmName("dhyrdtdvkrkkkfgk")
    public suspend fun listenerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.listenerId = mapped
    }

    internal fun build(): CustomRoutingEndpointGroupArgs = CustomRoutingEndpointGroupArgs(
        acceleratorId = acceleratorId,
        customRoutingEndpointGroupName = customRoutingEndpointGroupName,
        description = description,
        endpointGroupRegion = endpointGroupRegion,
        listenerId = listenerId,
    )
}
