@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin

import com.pulumi.alicloud.ga.CustomRoutingEndpointGroupDestinationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Global Accelerator (GA) Custom Routing Endpoint Group Destination resource.
 * For information about Global Accelerator (GA) Custom Routing Endpoint Group Destination and how to use it, see [What is Custom Routing Endpoint Group Destination](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-createcustomroutingendpointgroupdestinations).
 * > **NOTE:** Available since v1.197.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const region = config.get("region") || "cn-hangzhou";
 * const _default = new alicloud.ga.Accelerator("default", {
 *     duration: 1,
 *     autoUseCoupon: true,
 *     spec: "1",
 * });
 * const defaultBandwidthPackage = new alicloud.ga.BandwidthPackage("default", {
 *     bandwidth: 100,
 *     type: "Basic",
 *     bandwidthType: "Basic",
 *     paymentType: "PayAsYouGo",
 *     billingType: "PayBy95",
 *     ratio: 30,
 * });
 * const defaultBandwidthPackageAttachment = new alicloud.ga.BandwidthPackageAttachment("default", {
 *     acceleratorId: _default.id,
 *     bandwidthPackageId: defaultBandwidthPackage.id,
 * });
 * const defaultListener = new alicloud.ga.Listener("default", {
 *     acceleratorId: defaultBandwidthPackageAttachment.acceleratorId,
 *     listenerType: "CustomRouting",
 *     portRanges: [{
 *         fromPort: 10000,
 *         toPort: 16000,
 *     }],
 * });
 * const defaultCustomRoutingEndpointGroup = new alicloud.ga.CustomRoutingEndpointGroup("default", {
 *     acceleratorId: defaultListener.acceleratorId,
 *     listenerId: defaultListener.id,
 *     endpointGroupRegion: region,
 *     customRoutingEndpointGroupName: "terraform-example",
 *     description: "terraform-example",
 * });
 * const defaultCustomRoutingEndpointGroupDestination = new alicloud.ga.CustomRoutingEndpointGroupDestination("default", {
 *     endpointGroupId: defaultCustomRoutingEndpointGroup.id,
 *     protocols: ["TCP"],
 *     fromPort: 1,
 *     toPort: 2,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * region = config.get("region")
 * if region is None:
 *     region = "cn-hangzhou"
 * default = alicloud.ga.Accelerator("default",
 *     duration=1,
 *     auto_use_coupon=True,
 *     spec="1")
 * default_bandwidth_package = alicloud.ga.BandwidthPackage("default",
 *     bandwidth=100,
 *     type="Basic",
 *     bandwidth_type="Basic",
 *     payment_type="PayAsYouGo",
 *     billing_type="PayBy95",
 *     ratio=30)
 * default_bandwidth_package_attachment = alicloud.ga.BandwidthPackageAttachment("default",
 *     accelerator_id=default.id,
 *     bandwidth_package_id=default_bandwidth_package.id)
 * default_listener = alicloud.ga.Listener("default",
 *     accelerator_id=default_bandwidth_package_attachment.accelerator_id,
 *     listener_type="CustomRouting",
 *     port_ranges=[{
 *         "from_port": 10000,
 *         "to_port": 16000,
 *     }])
 * default_custom_routing_endpoint_group = alicloud.ga.CustomRoutingEndpointGroup("default",
 *     accelerator_id=default_listener.accelerator_id,
 *     listener_id=default_listener.id,
 *     endpoint_group_region=region,
 *     custom_routing_endpoint_group_name="terraform-example",
 *     description="terraform-example")
 * default_custom_routing_endpoint_group_destination = alicloud.ga.CustomRoutingEndpointGroupDestination("default",
 *     endpoint_group_id=default_custom_routing_endpoint_group.id,
 *     protocols=["TCP"],
 *     from_port=1,
 *     to_port=2)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var region = config.Get("region") ?? "cn-hangzhou";
 *     var @default = new AliCloud.Ga.Accelerator("default", new()
 *     {
 *         Duration = 1,
 *         AutoUseCoupon = true,
 *         Spec = "1",
 *     });
 *     var defaultBandwidthPackage = new AliCloud.Ga.BandwidthPackage("default", new()
 *     {
 *         Bandwidth = 100,
 *         Type = "Basic",
 *         BandwidthType = "Basic",
 *         PaymentType = "PayAsYouGo",
 *         BillingType = "PayBy95",
 *         Ratio = 30,
 *     });
 *     var defaultBandwidthPackageAttachment = new AliCloud.Ga.BandwidthPackageAttachment("default", new()
 *     {
 *         AcceleratorId = @default.Id,
 *         BandwidthPackageId = defaultBandwidthPackage.Id,
 *     });
 *     var defaultListener = new AliCloud.Ga.Listener("default", new()
 *     {
 *         AcceleratorId = defaultBandwidthPackageAttachment.AcceleratorId,
 *         ListenerType = "CustomRouting",
 *         PortRanges = new[]
 *         {
 *             new AliCloud.Ga.Inputs.ListenerPortRangeArgs
 *             {
 *                 FromPort = 10000,
 *                 ToPort = 16000,
 *             },
 *         },
 *     });
 *     var defaultCustomRoutingEndpointGroup = new AliCloud.Ga.CustomRoutingEndpointGroup("default", new()
 *     {
 *         AcceleratorId = defaultListener.AcceleratorId,
 *         ListenerId = defaultListener.Id,
 *         EndpointGroupRegion = region,
 *         CustomRoutingEndpointGroupName = "terraform-example",
 *         Description = "terraform-example",
 *     });
 *     var defaultCustomRoutingEndpointGroupDestination = new AliCloud.Ga.CustomRoutingEndpointGroupDestination("default", new()
 *     {
 *         EndpointGroupId = defaultCustomRoutingEndpointGroup.Id,
 *         Protocols = new[]
 *         {
 *             "TCP",
 *         },
 *         FromPort = 1,
 *         ToPort = 2,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ga"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		region := "cn-hangzhou"
 * 		if param := cfg.Get("region"); param != "" {
 * 			region = param
 * 		}
 * 		_, err := ga.NewAccelerator(ctx, "default", &ga.AcceleratorArgs{
 * 			Duration:      pulumi.Int(1),
 * 			AutoUseCoupon: pulumi.Bool(true),
 * 			Spec:          pulumi.String("1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultBandwidthPackage, err := ga.NewBandwidthPackage(ctx, "default", &ga.BandwidthPackageArgs{
 * 			Bandwidth:     pulumi.Int(100),
 * 			Type:          pulumi.String("Basic"),
 * 			BandwidthType: pulumi.String("Basic"),
 * 			PaymentType:   pulumi.String("PayAsYouGo"),
 * 			BillingType:   pulumi.String("PayBy95"),
 * 			Ratio:         pulumi.Int(30),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultBandwidthPackageAttachment, err := ga.NewBandwidthPackageAttachment(ctx, "default", &ga.BandwidthPackageAttachmentArgs{
 * 			AcceleratorId:      _default.ID(),
 * 			BandwidthPackageId: defaultBandwidthPackage.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultListener, err := ga.NewListener(ctx, "default", &ga.ListenerArgs{
 * 			AcceleratorId: defaultBandwidthPackageAttachment.AcceleratorId,
 * 			ListenerType:  pulumi.String("CustomRouting"),
 * 			PortRanges: ga.ListenerPortRangeArray{
 * 				&ga.ListenerPortRangeArgs{
 * 					FromPort: pulumi.Int(10000),
 * 					ToPort:   pulumi.Int(16000),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultCustomRoutingEndpointGroup, err := ga.NewCustomRoutingEndpointGroup(ctx, "default", &ga.CustomRoutingEndpointGroupArgs{
 * 			AcceleratorId:                  defaultListener.AcceleratorId,
 * 			ListenerId:                     defaultListener.ID(),
 * 			EndpointGroupRegion:            pulumi.String(region),
 * 			CustomRoutingEndpointGroupName: pulumi.String("terraform-example"),
 * 			Description:                    pulumi.String("terraform-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ga.NewCustomRoutingEndpointGroupDestination(ctx, "default", &ga.CustomRoutingEndpointGroupDestinationArgs{
 * 			EndpointGroupId: defaultCustomRoutingEndpointGroup.ID(),
 * 			Protocols: pulumi.StringArray{
 * 				pulumi.String("TCP"),
 * 			},
 * 			FromPort: pulumi.Int(1),
 * 			ToPort:   pulumi.Int(2),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ga.Accelerator;
 * import com.pulumi.alicloud.ga.AcceleratorArgs;
 * import com.pulumi.alicloud.ga.BandwidthPackage;
 * import com.pulumi.alicloud.ga.BandwidthPackageArgs;
 * import com.pulumi.alicloud.ga.BandwidthPackageAttachment;
 * import com.pulumi.alicloud.ga.BandwidthPackageAttachmentArgs;
 * import com.pulumi.alicloud.ga.Listener;
 * import com.pulumi.alicloud.ga.ListenerArgs;
 * import com.pulumi.alicloud.ga.inputs.ListenerPortRangeArgs;
 * import com.pulumi.alicloud.ga.CustomRoutingEndpointGroup;
 * import com.pulumi.alicloud.ga.CustomRoutingEndpointGroupArgs;
 * import com.pulumi.alicloud.ga.CustomRoutingEndpointGroupDestination;
 * import com.pulumi.alicloud.ga.CustomRoutingEndpointGroupDestinationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var region = config.get("region").orElse("cn-hangzhou");
 *         var default_ = new Accelerator("default", AcceleratorArgs.builder()
 *             .duration(1)
 *             .autoUseCoupon(true)
 *             .spec("1")
 *             .build());
 *         var defaultBandwidthPackage = new BandwidthPackage("defaultBandwidthPackage", BandwidthPackageArgs.builder()
 *             .bandwidth(100)
 *             .type("Basic")
 *             .bandwidthType("Basic")
 *             .paymentType("PayAsYouGo")
 *             .billingType("PayBy95")
 *             .ratio(30)
 *             .build());
 *         var defaultBandwidthPackageAttachment = new BandwidthPackageAttachment("defaultBandwidthPackageAttachment", BandwidthPackageAttachmentArgs.builder()
 *             .acceleratorId(default_.id())
 *             .bandwidthPackageId(defaultBandwidthPackage.id())
 *             .build());
 *         var defaultListener = new Listener("defaultListener", ListenerArgs.builder()
 *             .acceleratorId(defaultBandwidthPackageAttachment.acceleratorId())
 *             .listenerType("CustomRouting")
 *             .portRanges(ListenerPortRangeArgs.builder()
 *                 .fromPort(10000)
 *                 .toPort(16000)
 *                 .build())
 *             .build());
 *         var defaultCustomRoutingEndpointGroup = new CustomRoutingEndpointGroup("defaultCustomRoutingEndpointGroup", CustomRoutingEndpointGroupArgs.builder()
 *             .acceleratorId(defaultListener.acceleratorId())
 *             .listenerId(defaultListener.id())
 *             .endpointGroupRegion(region)
 *             .customRoutingEndpointGroupName("terraform-example")
 *             .description("terraform-example")
 *             .build());
 *         var defaultCustomRoutingEndpointGroupDestination = new CustomRoutingEndpointGroupDestination("defaultCustomRoutingEndpointGroupDestination", CustomRoutingEndpointGroupDestinationArgs.builder()
 *             .endpointGroupId(defaultCustomRoutingEndpointGroup.id())
 *             .protocols("TCP")
 *             .fromPort(1)
 *             .toPort(2)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   region:
 *     type: string
 *     default: cn-hangzhou
 * resources:
 *   default:
 *     type: alicloud:ga:Accelerator
 *     properties:
 *       duration: 1
 *       autoUseCoupon: true
 *       spec: '1'
 *   defaultBandwidthPackage:
 *     type: alicloud:ga:BandwidthPackage
 *     name: default
 *     properties:
 *       bandwidth: 100
 *       type: Basic
 *       bandwidthType: Basic
 *       paymentType: PayAsYouGo
 *       billingType: PayBy95
 *       ratio: 30
 *   defaultBandwidthPackageAttachment:
 *     type: alicloud:ga:BandwidthPackageAttachment
 *     name: default
 *     properties:
 *       acceleratorId: ${default.id}
 *       bandwidthPackageId: ${defaultBandwidthPackage.id}
 *   defaultListener:
 *     type: alicloud:ga:Listener
 *     name: default
 *     properties:
 *       acceleratorId: ${defaultBandwidthPackageAttachment.acceleratorId}
 *       listenerType: CustomRouting
 *       portRanges:
 *         - fromPort: 10000
 *           toPort: 16000
 *   defaultCustomRoutingEndpointGroup:
 *     type: alicloud:ga:CustomRoutingEndpointGroup
 *     name: default
 *     properties:
 *       acceleratorId: ${defaultListener.acceleratorId}
 *       listenerId: ${defaultListener.id}
 *       endpointGroupRegion: ${region}
 *       customRoutingEndpointGroupName: terraform-example
 *       description: terraform-example
 *   defaultCustomRoutingEndpointGroupDestination:
 *     type: alicloud:ga:CustomRoutingEndpointGroupDestination
 *     name: default
 *     properties:
 *       endpointGroupId: ${defaultCustomRoutingEndpointGroup.id}
 *       protocols:
 *         - TCP
 *       fromPort: 1
 *       toPort: 2
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Global Accelerator (GA) Custom Routing Endpoint Group Destination can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ga/customRoutingEndpointGroupDestination:CustomRoutingEndpointGroupDestination example <endpoint_group_id>:<custom_routing_endpoint_group_destination_id>
 * ```
 * @property endpointGroupId The ID of the endpoint group.
 * @property fromPort The start port of the backend service port range of the endpoint group. The `from_port` value must be smaller than or equal to the `to_port` value. Valid values: `1` to `65499`.
 * @property protocols The backend service protocol of the endpoint group. Valid values: `TCP`, `UDP`, `TCP, UDP`.
 * @property toPort The end port of the backend service port range of the endpoint group. The `from_port` value must be smaller than or equal to the `to_port` value. Valid values: `1` to `65499`.
 */
public data class CustomRoutingEndpointGroupDestinationArgs(
    public val endpointGroupId: Output<String>? = null,
    public val fromPort: Output<Int>? = null,
    public val protocols: Output<List<String>>? = null,
    public val toPort: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ga.CustomRoutingEndpointGroupDestinationArgs> {
    override fun toJava(): com.pulumi.alicloud.ga.CustomRoutingEndpointGroupDestinationArgs =
        com.pulumi.alicloud.ga.CustomRoutingEndpointGroupDestinationArgs.builder()
            .endpointGroupId(endpointGroupId?.applyValue({ args0 -> args0 }))
            .fromPort(fromPort?.applyValue({ args0 -> args0 }))
            .protocols(protocols?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .toPort(toPort?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomRoutingEndpointGroupDestinationArgs].
 */
@PulumiTagMarker
public class CustomRoutingEndpointGroupDestinationArgsBuilder internal constructor() {
    private var endpointGroupId: Output<String>? = null

    private var fromPort: Output<Int>? = null

    private var protocols: Output<List<String>>? = null

    private var toPort: Output<Int>? = null

    /**
     * @param value The ID of the endpoint group.
     */
    @JvmName("cmcjdekuihwylluy")
    public suspend fun endpointGroupId(`value`: Output<String>) {
        this.endpointGroupId = value
    }

    /**
     * @param value The start port of the backend service port range of the endpoint group. The `from_port` value must be smaller than or equal to the `to_port` value. Valid values: `1` to `65499`.
     */
    @JvmName("ftvoyafoajyagswc")
    public suspend fun fromPort(`value`: Output<Int>) {
        this.fromPort = value
    }

    /**
     * @param value The backend service protocol of the endpoint group. Valid values: `TCP`, `UDP`, `TCP, UDP`.
     */
    @JvmName("emqgfoxvdtlllfvq")
    public suspend fun protocols(`value`: Output<List<String>>) {
        this.protocols = value
    }

    @JvmName("invyjcxkdomxeoqu")
    public suspend fun protocols(vararg values: Output<String>) {
        this.protocols = Output.all(values.asList())
    }

    /**
     * @param values The backend service protocol of the endpoint group. Valid values: `TCP`, `UDP`, `TCP, UDP`.
     */
    @JvmName("dgxqegnjpssytnim")
    public suspend fun protocols(values: List<Output<String>>) {
        this.protocols = Output.all(values)
    }

    /**
     * @param value The end port of the backend service port range of the endpoint group. The `from_port` value must be smaller than or equal to the `to_port` value. Valid values: `1` to `65499`.
     */
    @JvmName("apoqqxqrautyjsno")
    public suspend fun toPort(`value`: Output<Int>) {
        this.toPort = value
    }

    /**
     * @param value The ID of the endpoint group.
     */
    @JvmName("rgqquaiakyhlyulw")
    public suspend fun endpointGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointGroupId = mapped
    }

    /**
     * @param value The start port of the backend service port range of the endpoint group. The `from_port` value must be smaller than or equal to the `to_port` value. Valid values: `1` to `65499`.
     */
    @JvmName("dyeixatsrwhjfkxy")
    public suspend fun fromPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fromPort = mapped
    }

    /**
     * @param value The backend service protocol of the endpoint group. Valid values: `TCP`, `UDP`, `TCP, UDP`.
     */
    @JvmName("quxqcsxraaubfwov")
    public suspend fun protocols(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocols = mapped
    }

    /**
     * @param values The backend service protocol of the endpoint group. Valid values: `TCP`, `UDP`, `TCP, UDP`.
     */
    @JvmName("swdmnjdfmhbpfyhu")
    public suspend fun protocols(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocols = mapped
    }

    /**
     * @param value The end port of the backend service port range of the endpoint group. The `from_port` value must be smaller than or equal to the `to_port` value. Valid values: `1` to `65499`.
     */
    @JvmName("trperxwtksteapnh")
    public suspend fun toPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.toPort = mapped
    }

    internal fun build(): CustomRoutingEndpointGroupDestinationArgs =
        CustomRoutingEndpointGroupDestinationArgs(
            endpointGroupId = endpointGroupId,
            fromPort = fromPort,
            protocols = protocols,
            toPort = toPort,
        )
}
