@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Domain].
 */
@PulumiTagMarker
public class DomainResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DomainArgs = DomainArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DomainArgsBuilder.() -> Unit) {
        val builder = DomainArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Domain {
        val builtJavaResource = com.pulumi.alicloud.ga.Domain(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Domain(builtJavaResource)
    }
}

/**
 * Provides a Ga Domain resource.
 * For information about Ga Domain and how to use it, see [What is Domain](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-createdomain).
 * > **NOTE:** Available since v1.197.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.ga.Accelerator("default", {
 *     duration: 1,
 *     autoUseCoupon: true,
 *     spec: "1",
 * });
 * const defaultDomain = new alicloud.ga.Domain("default", {
 *     domain: "changes.com.cn",
 *     acceleratorId: _default.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.ga.Accelerator("default",
 *     duration=1,
 *     auto_use_coupon=True,
 *     spec="1")
 * default_domain = alicloud.ga.Domain("default",
 *     domain="changes.com.cn",
 *     accelerator_id=default.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Ga.Accelerator("default", new()
 *     {
 *         Duration = 1,
 *         AutoUseCoupon = true,
 *         Spec = "1",
 *     });
 *     var defaultDomain = new AliCloud.Ga.Domain("default", new()
 *     {
 *         AcceleratedDomain = "changes.com.cn",
 *         AcceleratorId = @default.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ga"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ga.NewAccelerator(ctx, "default", &ga.AcceleratorArgs{
 * 			Duration:      pulumi.Int(1),
 * 			AutoUseCoupon: pulumi.Bool(true),
 * 			Spec:          pulumi.String("1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ga.NewDomain(ctx, "default", &ga.DomainArgs{
 * 			Domain:        pulumi.String("changes.com.cn"),
 * 			AcceleratorId: _default.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ga.Accelerator;
 * import com.pulumi.alicloud.ga.AcceleratorArgs;
 * import com.pulumi.alicloud.ga.Domain;
 * import com.pulumi.alicloud.ga.DomainArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Accelerator("default", AcceleratorArgs.builder()
 *             .duration(1)
 *             .autoUseCoupon(true)
 *             .spec("1")
 *             .build());
 *         var defaultDomain = new Domain("defaultDomain", DomainArgs.builder()
 *             .domain("changes.com.cn")
 *             .acceleratorId(default_.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:ga:Accelerator
 *     properties:
 *       duration: 1
 *       autoUseCoupon: true
 *       spec: '1'
 *   defaultDomain:
 *     type: alicloud:ga:Domain
 *     name: default
 *     properties:
 *       domain: changes.com.cn
 *       acceleratorId: ${default.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Ga Domain can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ga/domain:Domain example <accelerator_id>:<domain>
 * ```
 */
public class Domain internal constructor(
    override val javaResource: com.pulumi.alicloud.ga.Domain,
) : KotlinCustomResource(javaResource, DomainMapper) {
    /**
     * The ID of the global acceleration instance.
     */
    public val acceleratorId: Output<String>
        get() = javaResource.acceleratorId().applyValue({ args0 -> args0 })

    /**
     * The accelerated domain name to be added. only top-level domain names are supported, such as 'example.com'.
     */
    public val domain: Output<String>
        get() = javaResource.domain().applyValue({ args0 -> args0 })

    /**
     * The status of the resource
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object DomainMapper : ResourceMapper<Domain> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ga.Domain::class == javaResource::class

    override fun map(javaResource: Resource): Domain = Domain(
        javaResource as
            com.pulumi.alicloud.ga.Domain,
    )
}

/**
 * @see [Domain].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Domain].
 */
public suspend fun domain(name: String, block: suspend DomainResourceBuilder.() -> Unit): Domain {
    val builder = DomainResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Domain].
 * @param name The _unique_ name of the resulting resource.
 */
public fun domain(name: String): Domain {
    val builder = DomainResourceBuilder()
    builder.name(name)
    return builder.build()
}
