@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin

import com.pulumi.alicloud.ga.DomainArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Ga Domain resource.
 * For information about Ga Domain and how to use it, see [What is Domain](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-createdomain).
 * > **NOTE:** Available since v1.197.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.ga.Accelerator("default", {
 *     duration: 1,
 *     autoUseCoupon: true,
 *     spec: "1",
 * });
 * const defaultDomain = new alicloud.ga.Domain("default", {
 *     domain: "changes.com.cn",
 *     acceleratorId: _default.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.ga.Accelerator("default",
 *     duration=1,
 *     auto_use_coupon=True,
 *     spec="1")
 * default_domain = alicloud.ga.Domain("default",
 *     domain="changes.com.cn",
 *     accelerator_id=default.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Ga.Accelerator("default", new()
 *     {
 *         Duration = 1,
 *         AutoUseCoupon = true,
 *         Spec = "1",
 *     });
 *     var defaultDomain = new AliCloud.Ga.Domain("default", new()
 *     {
 *         AcceleratedDomain = "changes.com.cn",
 *         AcceleratorId = @default.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ga"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ga.NewAccelerator(ctx, "default", &ga.AcceleratorArgs{
 * 			Duration:      pulumi.Int(1),
 * 			AutoUseCoupon: pulumi.Bool(true),
 * 			Spec:          pulumi.String("1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ga.NewDomain(ctx, "default", &ga.DomainArgs{
 * 			Domain:        pulumi.String("changes.com.cn"),
 * 			AcceleratorId: _default.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ga.Accelerator;
 * import com.pulumi.alicloud.ga.AcceleratorArgs;
 * import com.pulumi.alicloud.ga.Domain;
 * import com.pulumi.alicloud.ga.DomainArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Accelerator("default", AcceleratorArgs.builder()
 *             .duration(1)
 *             .autoUseCoupon(true)
 *             .spec("1")
 *             .build());
 *         var defaultDomain = new Domain("defaultDomain", DomainArgs.builder()
 *             .domain("changes.com.cn")
 *             .acceleratorId(default_.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:ga:Accelerator
 *     properties:
 *       duration: 1
 *       autoUseCoupon: true
 *       spec: '1'
 *   defaultDomain:
 *     type: alicloud:ga:Domain
 *     name: default
 *     properties:
 *       domain: changes.com.cn
 *       acceleratorId: ${default.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Ga Domain can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ga/domain:Domain example <accelerator_id>:<domain>
 * ```
 * @property acceleratorId The ID of the global acceleration instance.
 * @property domain The accelerated domain name to be added. only top-level domain names are supported, such as 'example.com'.
 */
public data class DomainArgs(
    public val acceleratorId: Output<String>? = null,
    public val domain: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ga.DomainArgs> {
    override fun toJava(): com.pulumi.alicloud.ga.DomainArgs =
        com.pulumi.alicloud.ga.DomainArgs.builder()
            .acceleratorId(acceleratorId?.applyValue({ args0 -> args0 }))
            .domain(domain?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainArgs].
 */
@PulumiTagMarker
public class DomainArgsBuilder internal constructor() {
    private var acceleratorId: Output<String>? = null

    private var domain: Output<String>? = null

    /**
     * @param value The ID of the global acceleration instance.
     */
    @JvmName("abegefucwhimgngu")
    public suspend fun acceleratorId(`value`: Output<String>) {
        this.acceleratorId = value
    }

    /**
     * @param value The accelerated domain name to be added. only top-level domain names are supported, such as 'example.com'.
     */
    @JvmName("xpmtalpwucamtnbl")
    public suspend fun domain(`value`: Output<String>) {
        this.domain = value
    }

    /**
     * @param value The ID of the global acceleration instance.
     */
    @JvmName("pogknfdhscmqytqp")
    public suspend fun acceleratorId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceleratorId = mapped
    }

    /**
     * @param value The accelerated domain name to be added. only top-level domain names are supported, such as 'example.com'.
     */
    @JvmName("ynwmnuqahelidppu")
    public suspend fun domain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domain = mapped
    }

    internal fun build(): DomainArgs = DomainArgs(
        acceleratorId = acceleratorId,
        domain = domain,
    )
}
