@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin

import com.pulumi.alicloud.ga.kotlin.outputs.EndpointGroupEndpointConfiguration
import com.pulumi.alicloud.ga.kotlin.outputs.EndpointGroupPortOverrides
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.ga.kotlin.outputs.EndpointGroupEndpointConfiguration.Companion.toKotlin as endpointGroupEndpointConfigurationToKotlin
import com.pulumi.alicloud.ga.kotlin.outputs.EndpointGroupPortOverrides.Companion.toKotlin as endpointGroupPortOverridesToKotlin

/**
 * Builder for [EndpointGroup].
 */
@PulumiTagMarker
public class EndpointGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EndpointGroupArgs = EndpointGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EndpointGroupArgsBuilder.() -> Unit) {
        val builder = EndpointGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EndpointGroup {
        val builtJavaResource = com.pulumi.alicloud.ga.EndpointGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EndpointGroup(builtJavaResource)
    }
}

/**
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const region = config.get("region") || "cn-hangzhou";
 * const _default = new alicloud.ga.Accelerator("default", {
 *     duration: 1,
 *     autoUseCoupon: true,
 *     spec: "1",
 * });
 * const defaultBandwidthPackage = new alicloud.ga.BandwidthPackage("default", {
 *     bandwidth: 100,
 *     type: "Basic",
 *     bandwidthType: "Basic",
 *     paymentType: "PayAsYouGo",
 *     billingType: "PayBy95",
 *     ratio: 30,
 * });
 * const defaultBandwidthPackageAttachment = new alicloud.ga.BandwidthPackageAttachment("default", {
 *     acceleratorId: _default.id,
 *     bandwidthPackageId: defaultBandwidthPackage.id,
 * });
 * const defaultListener = new alicloud.ga.Listener("default", {
 *     acceleratorId: defaultBandwidthPackageAttachment.acceleratorId,
 *     portRanges: [{
 *         fromPort: 60,
 *         toPort: 70,
 *     }],
 *     clientAffinity: "SOURCE_IP",
 *     protocol: "UDP",
 *     name: "terraform-example",
 * });
 * const defaultEipAddress: alicloud.ecs.EipAddress[] = [];
 * for (const range = {value: 0}; range.value < 2; range.value++) {
 *     defaultEipAddress.push(new alicloud.ecs.EipAddress(`default-${range.value}`, {
 *         bandwidth: "10",
 *         internetChargeType: "PayByBandwidth",
 *         addressName: "terraform-example",
 *     }));
 * }
 * const defaultEndpointGroup = new alicloud.ga.EndpointGroup("default", {
 *     acceleratorId: _default.id,
 *     endpointConfigurations: [
 *         {
 *             endpoint: defaultEipAddress[0].ipAddress,
 *             type: "PublicIp",
 *             weight: 20,
 *         },
 *         {
 *             endpoint: defaultEipAddress[1].ipAddress,
 *             type: "PublicIp",
 *             weight: 20,
 *         },
 *     ],
 *     endpointGroupRegion: region,
 *     listenerId: defaultListener.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * region = config.get("region")
 * if region is None:
 *     region = "cn-hangzhou"
 * default = alicloud.ga.Accelerator("default",
 *     duration=1,
 *     auto_use_coupon=True,
 *     spec="1")
 * default_bandwidth_package = alicloud.ga.BandwidthPackage("default",
 *     bandwidth=100,
 *     type="Basic",
 *     bandwidth_type="Basic",
 *     payment_type="PayAsYouGo",
 *     billing_type="PayBy95",
 *     ratio=30)
 * default_bandwidth_package_attachment = alicloud.ga.BandwidthPackageAttachment("default",
 *     accelerator_id=default.id,
 *     bandwidth_package_id=default_bandwidth_package.id)
 * default_listener = alicloud.ga.Listener("default",
 *     accelerator_id=default_bandwidth_package_attachment.accelerator_id,
 *     port_ranges=[{
 *         "from_port": 60,
 *         "to_port": 70,
 *     }],
 *     client_affinity="SOURCE_IP",
 *     protocol="UDP",
 *     name="terraform-example")
 * default_eip_address = []
 * for range in [{"value": i} for i in range(0, 2)]:
 *     default_eip_address.append(alicloud.ecs.EipAddress(f"default-{range['value']}",
 *         bandwidth="10",
 *         internet_charge_type="PayByBandwidth",
 *         address_name="terraform-example"))
 * default_endpoint_group = alicloud.ga.EndpointGroup("default",
 *     accelerator_id=default.id,
 *     endpoint_configurations=[
 *         {
 *             "endpoint": default_eip_address[0].ip_address,
 *             "type": "PublicIp",
 *             "weight": 20,
 *         },
 *         {
 *             "endpoint": default_eip_address[1].ip_address,
 *             "type": "PublicIp",
 *             "weight": 20,
 *         },
 *     ],
 *     endpoint_group_region=region,
 *     listener_id=default_listener.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var region = config.Get("region") ?? "cn-hangzhou";
 *     var @default = new AliCloud.Ga.Accelerator("default", new()
 *     {
 *         Duration = 1,
 *         AutoUseCoupon = true,
 *         Spec = "1",
 *     });
 *     var defaultBandwidthPackage = new AliCloud.Ga.BandwidthPackage("default", new()
 *     {
 *         Bandwidth = 100,
 *         Type = "Basic",
 *         BandwidthType = "Basic",
 *         PaymentType = "PayAsYouGo",
 *         BillingType = "PayBy95",
 *         Ratio = 30,
 *     });
 *     var defaultBandwidthPackageAttachment = new AliCloud.Ga.BandwidthPackageAttachment("default", new()
 *     {
 *         AcceleratorId = @default.Id,
 *         BandwidthPackageId = defaultBandwidthPackage.Id,
 *     });
 *     var defaultListener = new AliCloud.Ga.Listener("default", new()
 *     {
 *         AcceleratorId = defaultBandwidthPackageAttachment.AcceleratorId,
 *         PortRanges = new[]
 *         {
 *             new AliCloud.Ga.Inputs.ListenerPortRangeArgs
 *             {
 *                 FromPort = 60,
 *                 ToPort = 70,
 *             },
 *         },
 *         ClientAffinity = "SOURCE_IP",
 *         Protocol = "UDP",
 *         Name = "terraform-example",
 *     });
 *     var defaultEipAddress = new List<AliCloud.Ecs.EipAddress>();
 *     for (var rangeIndex = 0; rangeIndex < 2; rangeIndex++)
 *     {
 *         var range = new { Value = rangeIndex };
 *         defaultEipAddress.Add(new AliCloud.Ecs.EipAddress($"default-{range.Value}", new()
 *         {
 *             Bandwidth = "10",
 *             InternetChargeType = "PayByBandwidth",
 *             AddressName = "terraform-example",
 *         }));
 *     }
 *     var defaultEndpointGroup = new AliCloud.Ga.EndpointGroup("default", new()
 *     {
 *         AcceleratorId = @default.Id,
 *         EndpointConfigurations = new[]
 *         {
 *             new AliCloud.Ga.Inputs.EndpointGroupEndpointConfigurationArgs
 *             {
 *                 Endpoint = defaultEipAddress[0].IpAddress,
 *                 Type = "PublicIp",
 *                 Weight = 20,
 *             },
 *             new AliCloud.Ga.Inputs.EndpointGroupEndpointConfigurationArgs
 *             {
 *                 Endpoint = defaultEipAddress[1].IpAddress,
 *                 Type = "PublicIp",
 *                 Weight = 20,
 *             },
 *         },
 *         EndpointGroupRegion = region,
 *         ListenerId = defaultListener.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ga"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		region := "cn-hangzhou"
 * 		if param := cfg.Get("region"); param != "" {
 * 			region = param
 * 		}
 * 		_, err := ga.NewAccelerator(ctx, "default", &ga.AcceleratorArgs{
 * 			Duration:      pulumi.Int(1),
 * 			AutoUseCoupon: pulumi.Bool(true),
 * 			Spec:          pulumi.String("1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultBandwidthPackage, err := ga.NewBandwidthPackage(ctx, "default", &ga.BandwidthPackageArgs{
 * 			Bandwidth:     pulumi.Int(100),
 * 			Type:          pulumi.String("Basic"),
 * 			BandwidthType: pulumi.String("Basic"),
 * 			PaymentType:   pulumi.String("PayAsYouGo"),
 * 			BillingType:   pulumi.String("PayBy95"),
 * 			Ratio:         pulumi.Int(30),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultBandwidthPackageAttachment, err := ga.NewBandwidthPackageAttachment(ctx, "default", &ga.BandwidthPackageAttachmentArgs{
 * 			AcceleratorId:      _default.ID(),
 * 			BandwidthPackageId: defaultBandwidthPackage.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultListener, err := ga.NewListener(ctx, "default", &ga.ListenerArgs{
 * 			AcceleratorId: defaultBandwidthPackageAttachment.AcceleratorId,
 * 			PortRanges: ga.ListenerPortRangeArray{
 * 				&ga.ListenerPortRangeArgs{
 * 					FromPort: pulumi.Int(60),
 * 					ToPort:   pulumi.Int(70),
 * 				},
 * 			},
 * 			ClientAffinity: pulumi.String("SOURCE_IP"),
 * 			Protocol:       pulumi.String("UDP"),
 * 			Name:           pulumi.String("terraform-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		var defaultEipAddress []*ecs.EipAddress
 * 		for index := 0; index < 2; index++ {
 * 			key0 := index
 * 			_ := index
 * 			__res, err := ecs.NewEipAddress(ctx, fmt.Sprintf("default-%v", key0), &ecs.EipAddressArgs{
 * 				Bandwidth:          pulumi.String("10"),
 * 				InternetChargeType: pulumi.String("PayByBandwidth"),
 * 				AddressName:        pulumi.String("terraform-example"),
 * 			})
 * 			if err != nil {
 * 				return err
 * 			}
 * 			defaultEipAddress = append(defaultEipAddress, __res)
 * 		}
 * 		_, err = ga.NewEndpointGroup(ctx, "default", &ga.EndpointGroupArgs{
 * 			AcceleratorId: _default.ID(),
 * 			EndpointConfigurations: ga.EndpointGroupEndpointConfigurationArray{
 * 				&ga.EndpointGroupEndpointConfigurationArgs{
 * 					Endpoint: defaultEipAddress[0].IpAddress,
 * 					Type:     pulumi.String("PublicIp"),
 * 					Weight:   pulumi.Int(20),
 * 				},
 * 				&ga.EndpointGroupEndpointConfigurationArgs{
 * 					Endpoint: defaultEipAddress[1].IpAddress,
 * 					Type:     pulumi.String("PublicIp"),
 * 					Weight:   pulumi.Int(20),
 * 				},
 * 			},
 * 			EndpointGroupRegion: pulumi.String(region),
 * 			ListenerId:          defaultListener.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ga.Accelerator;
 * import com.pulumi.alicloud.ga.AcceleratorArgs;
 * import com.pulumi.alicloud.ga.BandwidthPackage;
 * import com.pulumi.alicloud.ga.BandwidthPackageArgs;
 * import com.pulumi.alicloud.ga.BandwidthPackageAttachment;
 * import com.pulumi.alicloud.ga.BandwidthPackageAttachmentArgs;
 * import com.pulumi.alicloud.ga.Listener;
 * import com.pulumi.alicloud.ga.ListenerArgs;
 * import com.pulumi.alicloud.ga.inputs.ListenerPortRangeArgs;
 * import com.pulumi.alicloud.ecs.EipAddress;
 * import com.pulumi.alicloud.ecs.EipAddressArgs;
 * import com.pulumi.alicloud.ga.EndpointGroup;
 * import com.pulumi.alicloud.ga.EndpointGroupArgs;
 * import com.pulumi.alicloud.ga.inputs.EndpointGroupEndpointConfigurationArgs;
 * import com.pulumi.codegen.internal.KeyedValue;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var region = config.get("region").orElse("cn-hangzhou");
 *         var default_ = new Accelerator("default", AcceleratorArgs.builder()
 *             .duration(1)
 *             .autoUseCoupon(true)
 *             .spec("1")
 *             .build());
 *         var defaultBandwidthPackage = new BandwidthPackage("defaultBandwidthPackage", BandwidthPackageArgs.builder()
 *             .bandwidth(100)
 *             .type("Basic")
 *             .bandwidthType("Basic")
 *             .paymentType("PayAsYouGo")
 *             .billingType("PayBy95")
 *             .ratio(30)
 *             .build());
 *         var defaultBandwidthPackageAttachment = new BandwidthPackageAttachment("defaultBandwidthPackageAttachment", BandwidthPackageAttachmentArgs.builder()
 *             .acceleratorId(default_.id())
 *             .bandwidthPackageId(defaultBandwidthPackage.id())
 *             .build());
 *         var defaultListener = new Listener("defaultListener", ListenerArgs.builder()
 *             .acceleratorId(defaultBandwidthPackageAttachment.acceleratorId())
 *             .portRanges(ListenerPortRangeArgs.builder()
 *                 .fromPort(60)
 *                 .toPort(70)
 *                 .build())
 *             .clientAffinity("SOURCE_IP")
 *             .protocol("UDP")
 *             .name("terraform-example")
 *             .build());
 *         for (var i = 0; i < 2; i++) {
 *             new EipAddress("defaultEipAddress-" + i, EipAddressArgs.builder()
 *                 .bandwidth("10")
 *                 .internetChargeType("PayByBandwidth")
 *                 .addressName("terraform-example")
 *                 .build());
 * }
 *         var defaultEndpointGroup = new EndpointGroup("defaultEndpointGroup", EndpointGroupArgs.builder()
 *             .acceleratorId(default_.id())
 *             .endpointConfigurations(
 *                 EndpointGroupEndpointConfigurationArgs.builder()
 *                     .endpoint(defaultEipAddress[0].ipAddress())
 *                     .type("PublicIp")
 *                     .weight("20")
 *                     .build(),
 *                 EndpointGroupEndpointConfigurationArgs.builder()
 *                     .endpoint(defaultEipAddress[1].ipAddress())
 *                     .type("PublicIp")
 *                     .weight("20")
 *                     .build())
 *             .endpointGroupRegion(region)
 *             .listenerId(defaultListener.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   region:
 *     type: string
 *     default: cn-hangzhou
 * resources:
 *   default:
 *     type: alicloud:ga:Accelerator
 *     properties:
 *       duration: 1
 *       autoUseCoupon: true
 *       spec: '1'
 *   defaultBandwidthPackage:
 *     type: alicloud:ga:BandwidthPackage
 *     name: default
 *     properties:
 *       bandwidth: 100
 *       type: Basic
 *       bandwidthType: Basic
 *       paymentType: PayAsYouGo
 *       billingType: PayBy95
 *       ratio: 30
 *   defaultBandwidthPackageAttachment:
 *     type: alicloud:ga:BandwidthPackageAttachment
 *     name: default
 *     properties:
 *       acceleratorId: ${default.id}
 *       bandwidthPackageId: ${defaultBandwidthPackage.id}
 *   defaultListener:
 *     type: alicloud:ga:Listener
 *     name: default
 *     properties:
 *       acceleratorId: ${defaultBandwidthPackageAttachment.acceleratorId}
 *       portRanges:
 *         - fromPort: 60
 *           toPort: 70
 *       clientAffinity: SOURCE_IP
 *       protocol: UDP
 *       name: terraform-example
 *   defaultEipAddress:
 *     type: alicloud:ecs:EipAddress
 *     name: default
 *     properties:
 *       bandwidth: '10'
 *       internetChargeType: PayByBandwidth
 *       addressName: terraform-example
 *     options: {}
 *   defaultEndpointGroup:
 *     type: alicloud:ga:EndpointGroup
 *     name: default
 *     properties:
 *       acceleratorId: ${default.id}
 *       endpointConfigurations:
 *         - endpoint: ${defaultEipAddress[0].ipAddress}
 *           type: PublicIp
 *           weight: '20'
 *         - endpoint: ${defaultEipAddress[1].ipAddress}
 *           type: PublicIp
 *           weight: '20'
 *       endpointGroupRegion: ${region}
 *       listenerId: ${defaultListener.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Ga Endpoint Group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ga/endpointGroup:EndpointGroup example <id>
 * ```
 */
public class EndpointGroup internal constructor(
    override val javaResource: com.pulumi.alicloud.ga.EndpointGroup,
) : KotlinCustomResource(javaResource, EndpointGroupMapper) {
    /**
     * The ID of the Global Accelerator instance to which the endpoint group will be added.
     */
    public val acceleratorId: Output<String>
        get() = javaResource.acceleratorId().applyValue({ args0 -> args0 })

    /**
     * The description of the endpoint group.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The endpointConfigurations of the endpoint group. See `endpoint_configurations` below.
     */
    public val endpointConfigurations: Output<List<EndpointGroupEndpointConfiguration>>
        get() = javaResource.endpointConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> endpointGroupEndpointConfigurationToKotlin(args0) })
            })
        })

    /**
     * (Available since v1.213.0) The active endpoint IP addresses of the endpoint group. `endpoint_group_ip_list` will change with the growth of network traffic. You can run `pulumi up` to query the latest CIDR blocks and IP addresses.
     */
    public val endpointGroupIpLists: Output<List<String>>
        get() = javaResource.endpointGroupIpLists().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The ID of the region where the endpoint group is deployed.
     */
    public val endpointGroupRegion: Output<String>
        get() = javaResource.endpointGroupRegion().applyValue({ args0 -> args0 })

    /**
     * The endpoint group type. Default value: `default`. Valid values: `default`, `virtual`.
     * > **NOTE:** Currently, only `HTTP` or `HTTPS` protocol listener can directly create a `virtual` Endpoint Group. If it is `TCP` protocol listener, and you want to create a `virtual` Endpoint Group, please ensure that the `default` Endpoint Group has been created.
     */
    public val endpointGroupType: Output<String>
        get() = javaResource.endpointGroupType().applyValue({ args0 -> args0 })

    /**
     * The endpoint request protocol. Valid values: `HTTP`, `HTTPS`.
     * > **NOTE:** This item is only supported when creating terminal node group for listening instance of HTTP or HTTPS protocol. For the listening instance of HTTP protocol, the back-end service protocol supports and only supports HTTP.
     */
    public val endpointRequestProtocol: Output<String>
        get() = javaResource.endpointRequestProtocol().applyValue({ args0 -> args0 })

    /**
     * Specifies whether to enable the health check feature. Valid values:
     */
    public val healthCheckEnabled: Output<Boolean>?
        get() = javaResource.healthCheckEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The interval between two consecutive health checks. Unit: seconds.
     */
    public val healthCheckIntervalSeconds: Output<Int>?
        get() = javaResource.healthCheckIntervalSeconds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The path specified as the destination of the targets for health checks.
     */
    public val healthCheckPath: Output<String>?
        get() = javaResource.healthCheckPath().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The port that is used for health checks.
     */
    public val healthCheckPort: Output<Int>?
        get() = javaResource.healthCheckPort().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The protocol that is used to connect to the targets for health checks. Valid values:
     * - `TCP` or `tcp`: TCP protocol.
     * - `HTTP` or `http`: HTTP protocol.
     * - `HTTPS` or `https`: HTTPS protocol.
     * > **NOTE:** From version 1.223.0, `health_check_protocol` can be set to `TCP`, `HTTP`, `HTTPS`.
     */
    public val healthCheckProtocol: Output<String>?
        get() = javaResource.healthCheckProtocol().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the listener that is associated with the endpoint group.
     */
    public val listenerId: Output<String>
        get() = javaResource.listenerId().applyValue({ args0 -> args0 })

    /**
     * The name of the endpoint group.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Mapping between listening port and forwarding port of boarding point. See `port_overrides` below.
     * > **NOTE:** Port mapping is only supported when creating terminal node group for listening instance of HTTP or HTTPS protocol. The listening port in the port map must be consistent with the listening port of the current listening instance.
     */
    public val portOverrides: Output<EndpointGroupPortOverrides>?
        get() = javaResource.portOverrides().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> endpointGroupPortOverridesToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The status of the endpoint group.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The number of consecutive failed heath checks that must occur before the endpoint is deemed unhealthy. Default value: `3`.
     */
    public val thresholdCount: Output<Int>
        get() = javaResource.thresholdCount().applyValue({ args0 -> args0 })

    /**
     * The weight of the endpoint group when the corresponding listener is associated with multiple endpoint groups.
     */
    public val trafficPercentage: Output<Int>?
        get() = javaResource.trafficPercentage().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object EndpointGroupMapper : ResourceMapper<EndpointGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ga.EndpointGroup::class == javaResource::class

    override fun map(javaResource: Resource): EndpointGroup = EndpointGroup(
        javaResource as
            com.pulumi.alicloud.ga.EndpointGroup,
    )
}

/**
 * @see [EndpointGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EndpointGroup].
 */
public suspend fun endpointGroup(
    name: String,
    block: suspend EndpointGroupResourceBuilder.() -> Unit,
): EndpointGroup {
    val builder = EndpointGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EndpointGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun endpointGroup(name: String): EndpointGroup {
    val builder = EndpointGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
