@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin

import com.pulumi.alicloud.ga.EndpointGroupArgs.builder
import com.pulumi.alicloud.ga.kotlin.inputs.EndpointGroupEndpointConfigurationArgs
import com.pulumi.alicloud.ga.kotlin.inputs.EndpointGroupEndpointConfigurationArgsBuilder
import com.pulumi.alicloud.ga.kotlin.inputs.EndpointGroupPortOverridesArgs
import com.pulumi.alicloud.ga.kotlin.inputs.EndpointGroupPortOverridesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const region = config.get("region") || "cn-hangzhou";
 * const _default = new alicloud.ga.Accelerator("default", {
 *     duration: 1,
 *     autoUseCoupon: true,
 *     spec: "1",
 * });
 * const defaultBandwidthPackage = new alicloud.ga.BandwidthPackage("default", {
 *     bandwidth: 100,
 *     type: "Basic",
 *     bandwidthType: "Basic",
 *     paymentType: "PayAsYouGo",
 *     billingType: "PayBy95",
 *     ratio: 30,
 * });
 * const defaultBandwidthPackageAttachment = new alicloud.ga.BandwidthPackageAttachment("default", {
 *     acceleratorId: _default.id,
 *     bandwidthPackageId: defaultBandwidthPackage.id,
 * });
 * const defaultListener = new alicloud.ga.Listener("default", {
 *     acceleratorId: defaultBandwidthPackageAttachment.acceleratorId,
 *     portRanges: [{
 *         fromPort: 60,
 *         toPort: 70,
 *     }],
 *     clientAffinity: "SOURCE_IP",
 *     protocol: "UDP",
 *     name: "terraform-example",
 * });
 * const defaultEipAddress: alicloud.ecs.EipAddress[] = [];
 * for (const range = {value: 0}; range.value < 2; range.value++) {
 *     defaultEipAddress.push(new alicloud.ecs.EipAddress(`default-${range.value}`, {
 *         bandwidth: "10",
 *         internetChargeType: "PayByBandwidth",
 *         addressName: "terraform-example",
 *     }));
 * }
 * const defaultEndpointGroup = new alicloud.ga.EndpointGroup("default", {
 *     acceleratorId: _default.id,
 *     endpointConfigurations: [
 *         {
 *             endpoint: defaultEipAddress[0].ipAddress,
 *             type: "PublicIp",
 *             weight: 20,
 *         },
 *         {
 *             endpoint: defaultEipAddress[1].ipAddress,
 *             type: "PublicIp",
 *             weight: 20,
 *         },
 *     ],
 *     endpointGroupRegion: region,
 *     listenerId: defaultListener.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * region = config.get("region")
 * if region is None:
 *     region = "cn-hangzhou"
 * default = alicloud.ga.Accelerator("default",
 *     duration=1,
 *     auto_use_coupon=True,
 *     spec="1")
 * default_bandwidth_package = alicloud.ga.BandwidthPackage("default",
 *     bandwidth=100,
 *     type="Basic",
 *     bandwidth_type="Basic",
 *     payment_type="PayAsYouGo",
 *     billing_type="PayBy95",
 *     ratio=30)
 * default_bandwidth_package_attachment = alicloud.ga.BandwidthPackageAttachment("default",
 *     accelerator_id=default.id,
 *     bandwidth_package_id=default_bandwidth_package.id)
 * default_listener = alicloud.ga.Listener("default",
 *     accelerator_id=default_bandwidth_package_attachment.accelerator_id,
 *     port_ranges=[{
 *         "from_port": 60,
 *         "to_port": 70,
 *     }],
 *     client_affinity="SOURCE_IP",
 *     protocol="UDP",
 *     name="terraform-example")
 * default_eip_address = []
 * for range in [{"value": i} for i in range(0, 2)]:
 *     default_eip_address.append(alicloud.ecs.EipAddress(f"default-{range['value']}",
 *         bandwidth="10",
 *         internet_charge_type="PayByBandwidth",
 *         address_name="terraform-example"))
 * default_endpoint_group = alicloud.ga.EndpointGroup("default",
 *     accelerator_id=default.id,
 *     endpoint_configurations=[
 *         {
 *             "endpoint": default_eip_address[0].ip_address,
 *             "type": "PublicIp",
 *             "weight": 20,
 *         },
 *         {
 *             "endpoint": default_eip_address[1].ip_address,
 *             "type": "PublicIp",
 *             "weight": 20,
 *         },
 *     ],
 *     endpoint_group_region=region,
 *     listener_id=default_listener.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var region = config.Get("region") ?? "cn-hangzhou";
 *     var @default = new AliCloud.Ga.Accelerator("default", new()
 *     {
 *         Duration = 1,
 *         AutoUseCoupon = true,
 *         Spec = "1",
 *     });
 *     var defaultBandwidthPackage = new AliCloud.Ga.BandwidthPackage("default", new()
 *     {
 *         Bandwidth = 100,
 *         Type = "Basic",
 *         BandwidthType = "Basic",
 *         PaymentType = "PayAsYouGo",
 *         BillingType = "PayBy95",
 *         Ratio = 30,
 *     });
 *     var defaultBandwidthPackageAttachment = new AliCloud.Ga.BandwidthPackageAttachment("default", new()
 *     {
 *         AcceleratorId = @default.Id,
 *         BandwidthPackageId = defaultBandwidthPackage.Id,
 *     });
 *     var defaultListener = new AliCloud.Ga.Listener("default", new()
 *     {
 *         AcceleratorId = defaultBandwidthPackageAttachment.AcceleratorId,
 *         PortRanges = new[]
 *         {
 *             new AliCloud.Ga.Inputs.ListenerPortRangeArgs
 *             {
 *                 FromPort = 60,
 *                 ToPort = 70,
 *             },
 *         },
 *         ClientAffinity = "SOURCE_IP",
 *         Protocol = "UDP",
 *         Name = "terraform-example",
 *     });
 *     var defaultEipAddress = new List<AliCloud.Ecs.EipAddress>();
 *     for (var rangeIndex = 0; rangeIndex < 2; rangeIndex++)
 *     {
 *         var range = new { Value = rangeIndex };
 *         defaultEipAddress.Add(new AliCloud.Ecs.EipAddress($"default-{range.Value}", new()
 *         {
 *             Bandwidth = "10",
 *             InternetChargeType = "PayByBandwidth",
 *             AddressName = "terraform-example",
 *         }));
 *     }
 *     var defaultEndpointGroup = new AliCloud.Ga.EndpointGroup("default", new()
 *     {
 *         AcceleratorId = @default.Id,
 *         EndpointConfigurations = new[]
 *         {
 *             new AliCloud.Ga.Inputs.EndpointGroupEndpointConfigurationArgs
 *             {
 *                 Endpoint = defaultEipAddress[0].IpAddress,
 *                 Type = "PublicIp",
 *                 Weight = 20,
 *             },
 *             new AliCloud.Ga.Inputs.EndpointGroupEndpointConfigurationArgs
 *             {
 *                 Endpoint = defaultEipAddress[1].IpAddress,
 *                 Type = "PublicIp",
 *                 Weight = 20,
 *             },
 *         },
 *         EndpointGroupRegion = region,
 *         ListenerId = defaultListener.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ga"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		region := "cn-hangzhou"
 * 		if param := cfg.Get("region"); param != "" {
 * 			region = param
 * 		}
 * 		_, err := ga.NewAccelerator(ctx, "default", &ga.AcceleratorArgs{
 * 			Duration:      pulumi.Int(1),
 * 			AutoUseCoupon: pulumi.Bool(true),
 * 			Spec:          pulumi.String("1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultBandwidthPackage, err := ga.NewBandwidthPackage(ctx, "default", &ga.BandwidthPackageArgs{
 * 			Bandwidth:     pulumi.Int(100),
 * 			Type:          pulumi.String("Basic"),
 * 			BandwidthType: pulumi.String("Basic"),
 * 			PaymentType:   pulumi.String("PayAsYouGo"),
 * 			BillingType:   pulumi.String("PayBy95"),
 * 			Ratio:         pulumi.Int(30),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultBandwidthPackageAttachment, err := ga.NewBandwidthPackageAttachment(ctx, "default", &ga.BandwidthPackageAttachmentArgs{
 * 			AcceleratorId:      _default.ID(),
 * 			BandwidthPackageId: defaultBandwidthPackage.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultListener, err := ga.NewListener(ctx, "default", &ga.ListenerArgs{
 * 			AcceleratorId: defaultBandwidthPackageAttachment.AcceleratorId,
 * 			PortRanges: ga.ListenerPortRangeArray{
 * 				&ga.ListenerPortRangeArgs{
 * 					FromPort: pulumi.Int(60),
 * 					ToPort:   pulumi.Int(70),
 * 				},
 * 			},
 * 			ClientAffinity: pulumi.String("SOURCE_IP"),
 * 			Protocol:       pulumi.String("UDP"),
 * 			Name:           pulumi.String("terraform-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		var defaultEipAddress []*ecs.EipAddress
 * 		for index := 0; index < 2; index++ {
 * 			key0 := index
 * 			_ := index
 * 			__res, err := ecs.NewEipAddress(ctx, fmt.Sprintf("default-%v", key0), &ecs.EipAddressArgs{
 * 				Bandwidth:          pulumi.String("10"),
 * 				InternetChargeType: pulumi.String("PayByBandwidth"),
 * 				AddressName:        pulumi.String("terraform-example"),
 * 			})
 * 			if err != nil {
 * 				return err
 * 			}
 * 			defaultEipAddress = append(defaultEipAddress, __res)
 * 		}
 * 		_, err = ga.NewEndpointGroup(ctx, "default", &ga.EndpointGroupArgs{
 * 			AcceleratorId: _default.ID(),
 * 			EndpointConfigurations: ga.EndpointGroupEndpointConfigurationArray{
 * 				&ga.EndpointGroupEndpointConfigurationArgs{
 * 					Endpoint: defaultEipAddress[0].IpAddress,
 * 					Type:     pulumi.String("PublicIp"),
 * 					Weight:   pulumi.Int(20),
 * 				},
 * 				&ga.EndpointGroupEndpointConfigurationArgs{
 * 					Endpoint: defaultEipAddress[1].IpAddress,
 * 					Type:     pulumi.String("PublicIp"),
 * 					Weight:   pulumi.Int(20),
 * 				},
 * 			},
 * 			EndpointGroupRegion: pulumi.String(region),
 * 			ListenerId:          defaultListener.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ga.Accelerator;
 * import com.pulumi.alicloud.ga.AcceleratorArgs;
 * import com.pulumi.alicloud.ga.BandwidthPackage;
 * import com.pulumi.alicloud.ga.BandwidthPackageArgs;
 * import com.pulumi.alicloud.ga.BandwidthPackageAttachment;
 * import com.pulumi.alicloud.ga.BandwidthPackageAttachmentArgs;
 * import com.pulumi.alicloud.ga.Listener;
 * import com.pulumi.alicloud.ga.ListenerArgs;
 * import com.pulumi.alicloud.ga.inputs.ListenerPortRangeArgs;
 * import com.pulumi.alicloud.ecs.EipAddress;
 * import com.pulumi.alicloud.ecs.EipAddressArgs;
 * import com.pulumi.alicloud.ga.EndpointGroup;
 * import com.pulumi.alicloud.ga.EndpointGroupArgs;
 * import com.pulumi.alicloud.ga.inputs.EndpointGroupEndpointConfigurationArgs;
 * import com.pulumi.codegen.internal.KeyedValue;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var region = config.get("region").orElse("cn-hangzhou");
 *         var default_ = new Accelerator("default", AcceleratorArgs.builder()
 *             .duration(1)
 *             .autoUseCoupon(true)
 *             .spec("1")
 *             .build());
 *         var defaultBandwidthPackage = new BandwidthPackage("defaultBandwidthPackage", BandwidthPackageArgs.builder()
 *             .bandwidth(100)
 *             .type("Basic")
 *             .bandwidthType("Basic")
 *             .paymentType("PayAsYouGo")
 *             .billingType("PayBy95")
 *             .ratio(30)
 *             .build());
 *         var defaultBandwidthPackageAttachment = new BandwidthPackageAttachment("defaultBandwidthPackageAttachment", BandwidthPackageAttachmentArgs.builder()
 *             .acceleratorId(default_.id())
 *             .bandwidthPackageId(defaultBandwidthPackage.id())
 *             .build());
 *         var defaultListener = new Listener("defaultListener", ListenerArgs.builder()
 *             .acceleratorId(defaultBandwidthPackageAttachment.acceleratorId())
 *             .portRanges(ListenerPortRangeArgs.builder()
 *                 .fromPort(60)
 *                 .toPort(70)
 *                 .build())
 *             .clientAffinity("SOURCE_IP")
 *             .protocol("UDP")
 *             .name("terraform-example")
 *             .build());
 *         for (var i = 0; i < 2; i++) {
 *             new EipAddress("defaultEipAddress-" + i, EipAddressArgs.builder()
 *                 .bandwidth("10")
 *                 .internetChargeType("PayByBandwidth")
 *                 .addressName("terraform-example")
 *                 .build());
 * }
 *         var defaultEndpointGroup = new EndpointGroup("defaultEndpointGroup", EndpointGroupArgs.builder()
 *             .acceleratorId(default_.id())
 *             .endpointConfigurations(
 *                 EndpointGroupEndpointConfigurationArgs.builder()
 *                     .endpoint(defaultEipAddress[0].ipAddress())
 *                     .type("PublicIp")
 *                     .weight("20")
 *                     .build(),
 *                 EndpointGroupEndpointConfigurationArgs.builder()
 *                     .endpoint(defaultEipAddress[1].ipAddress())
 *                     .type("PublicIp")
 *                     .weight("20")
 *                     .build())
 *             .endpointGroupRegion(region)
 *             .listenerId(defaultListener.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   region:
 *     type: string
 *     default: cn-hangzhou
 * resources:
 *   default:
 *     type: alicloud:ga:Accelerator
 *     properties:
 *       duration: 1
 *       autoUseCoupon: true
 *       spec: '1'
 *   defaultBandwidthPackage:
 *     type: alicloud:ga:BandwidthPackage
 *     name: default
 *     properties:
 *       bandwidth: 100
 *       type: Basic
 *       bandwidthType: Basic
 *       paymentType: PayAsYouGo
 *       billingType: PayBy95
 *       ratio: 30
 *   defaultBandwidthPackageAttachment:
 *     type: alicloud:ga:BandwidthPackageAttachment
 *     name: default
 *     properties:
 *       acceleratorId: ${default.id}
 *       bandwidthPackageId: ${defaultBandwidthPackage.id}
 *   defaultListener:
 *     type: alicloud:ga:Listener
 *     name: default
 *     properties:
 *       acceleratorId: ${defaultBandwidthPackageAttachment.acceleratorId}
 *       portRanges:
 *         - fromPort: 60
 *           toPort: 70
 *       clientAffinity: SOURCE_IP
 *       protocol: UDP
 *       name: terraform-example
 *   defaultEipAddress:
 *     type: alicloud:ecs:EipAddress
 *     name: default
 *     properties:
 *       bandwidth: '10'
 *       internetChargeType: PayByBandwidth
 *       addressName: terraform-example
 *     options: {}
 *   defaultEndpointGroup:
 *     type: alicloud:ga:EndpointGroup
 *     name: default
 *     properties:
 *       acceleratorId: ${default.id}
 *       endpointConfigurations:
 *         - endpoint: ${defaultEipAddress[0].ipAddress}
 *           type: PublicIp
 *           weight: '20'
 *         - endpoint: ${defaultEipAddress[1].ipAddress}
 *           type: PublicIp
 *           weight: '20'
 *       endpointGroupRegion: ${region}
 *       listenerId: ${defaultListener.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Ga Endpoint Group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ga/endpointGroup:EndpointGroup example <id>
 * ```
 * @property acceleratorId The ID of the Global Accelerator instance to which the endpoint group will be added.
 * @property description The description of the endpoint group.
 * @property endpointConfigurations The endpointConfigurations of the endpoint group. See `endpoint_configurations` below.
 * @property endpointGroupRegion The ID of the region where the endpoint group is deployed.
 * @property endpointGroupType The endpoint group type. Default value: `default`. Valid values: `default`, `virtual`.
 * > **NOTE:** Currently, only `HTTP` or `HTTPS` protocol listener can directly create a `virtual` Endpoint Group. If it is `TCP` protocol listener, and you want to create a `virtual` Endpoint Group, please ensure that the `default` Endpoint Group has been created.
 * @property endpointRequestProtocol The endpoint request protocol. Valid values: `HTTP`, `HTTPS`.
 * > **NOTE:** This item is only supported when creating terminal node group for listening instance of HTTP or HTTPS protocol. For the listening instance of HTTP protocol, the back-end service protocol supports and only supports HTTP.
 * @property healthCheckEnabled Specifies whether to enable the health check feature. Valid values:
 * @property healthCheckIntervalSeconds The interval between two consecutive health checks. Unit: seconds.
 * @property healthCheckPath The path specified as the destination of the targets for health checks.
 * @property healthCheckPort The port that is used for health checks.
 * @property healthCheckProtocol The protocol that is used to connect to the targets for health checks. Valid values:
 * - `TCP` or `tcp`: TCP protocol.
 * - `HTTP` or `http`: HTTP protocol.
 * - `HTTPS` or `https`: HTTPS protocol.
 * > **NOTE:** From version 1.223.0, `health_check_protocol` can be set to `TCP`, `HTTP`, `HTTPS`.
 * @property listenerId The ID of the listener that is associated with the endpoint group.
 * @property name The name of the endpoint group.
 * @property portOverrides Mapping between listening port and forwarding port of boarding point. See `port_overrides` below.
 * > **NOTE:** Port mapping is only supported when creating terminal node group for listening instance of HTTP or HTTPS protocol. The listening port in the port map must be consistent with the listening port of the current listening instance.
 * @property tags A mapping of tags to assign to the resource.
 * @property thresholdCount The number of consecutive failed heath checks that must occur before the endpoint is deemed unhealthy. Default value: `3`.
 * @property trafficPercentage The weight of the endpoint group when the corresponding listener is associated with multiple endpoint groups.
 */
public data class EndpointGroupArgs(
    public val acceleratorId: Output<String>? = null,
    public val description: Output<String>? = null,
    public val endpointConfigurations: Output<List<EndpointGroupEndpointConfigurationArgs>>? = null,
    public val endpointGroupRegion: Output<String>? = null,
    public val endpointGroupType: Output<String>? = null,
    public val endpointRequestProtocol: Output<String>? = null,
    public val healthCheckEnabled: Output<Boolean>? = null,
    public val healthCheckIntervalSeconds: Output<Int>? = null,
    public val healthCheckPath: Output<String>? = null,
    public val healthCheckPort: Output<Int>? = null,
    public val healthCheckProtocol: Output<String>? = null,
    public val listenerId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val portOverrides: Output<EndpointGroupPortOverridesArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val thresholdCount: Output<Int>? = null,
    public val trafficPercentage: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ga.EndpointGroupArgs> {
    override fun toJava(): com.pulumi.alicloud.ga.EndpointGroupArgs =
        com.pulumi.alicloud.ga.EndpointGroupArgs.builder()
            .acceleratorId(acceleratorId?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .endpointConfigurations(
                endpointConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .endpointGroupRegion(endpointGroupRegion?.applyValue({ args0 -> args0 }))
            .endpointGroupType(endpointGroupType?.applyValue({ args0 -> args0 }))
            .endpointRequestProtocol(endpointRequestProtocol?.applyValue({ args0 -> args0 }))
            .healthCheckEnabled(healthCheckEnabled?.applyValue({ args0 -> args0 }))
            .healthCheckIntervalSeconds(healthCheckIntervalSeconds?.applyValue({ args0 -> args0 }))
            .healthCheckPath(healthCheckPath?.applyValue({ args0 -> args0 }))
            .healthCheckPort(healthCheckPort?.applyValue({ args0 -> args0 }))
            .healthCheckProtocol(healthCheckProtocol?.applyValue({ args0 -> args0 }))
            .listenerId(listenerId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .portOverrides(portOverrides?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .thresholdCount(thresholdCount?.applyValue({ args0 -> args0 }))
            .trafficPercentage(trafficPercentage?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointGroupArgs].
 */
@PulumiTagMarker
public class EndpointGroupArgsBuilder internal constructor() {
    private var acceleratorId: Output<String>? = null

    private var description: Output<String>? = null

    private var endpointConfigurations: Output<List<EndpointGroupEndpointConfigurationArgs>>? = null

    private var endpointGroupRegion: Output<String>? = null

    private var endpointGroupType: Output<String>? = null

    private var endpointRequestProtocol: Output<String>? = null

    private var healthCheckEnabled: Output<Boolean>? = null

    private var healthCheckIntervalSeconds: Output<Int>? = null

    private var healthCheckPath: Output<String>? = null

    private var healthCheckPort: Output<Int>? = null

    private var healthCheckProtocol: Output<String>? = null

    private var listenerId: Output<String>? = null

    private var name: Output<String>? = null

    private var portOverrides: Output<EndpointGroupPortOverridesArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var thresholdCount: Output<Int>? = null

    private var trafficPercentage: Output<Int>? = null

    /**
     * @param value The ID of the Global Accelerator instance to which the endpoint group will be added.
     */
    @JvmName("oqwucquvuastrbgl")
    public suspend fun acceleratorId(`value`: Output<String>) {
        this.acceleratorId = value
    }

    /**
     * @param value The description of the endpoint group.
     */
    @JvmName("nhtsefbhyhdxanpe")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The endpointConfigurations of the endpoint group. See `endpoint_configurations` below.
     */
    @JvmName("xngouskvyphtolgh")
    public suspend fun endpointConfigurations(`value`: Output<List<EndpointGroupEndpointConfigurationArgs>>) {
        this.endpointConfigurations = value
    }

    @JvmName("jjhnewvltjhdjtee")
    public suspend fun endpointConfigurations(vararg values: Output<EndpointGroupEndpointConfigurationArgs>) {
        this.endpointConfigurations = Output.all(values.asList())
    }

    /**
     * @param values The endpointConfigurations of the endpoint group. See `endpoint_configurations` below.
     */
    @JvmName("rodogqktouqdyenr")
    public suspend fun endpointConfigurations(values: List<Output<EndpointGroupEndpointConfigurationArgs>>) {
        this.endpointConfigurations = Output.all(values)
    }

    /**
     * @param value The ID of the region where the endpoint group is deployed.
     */
    @JvmName("agnqcdltfwbduuyv")
    public suspend fun endpointGroupRegion(`value`: Output<String>) {
        this.endpointGroupRegion = value
    }

    /**
     * @param value The endpoint group type. Default value: `default`. Valid values: `default`, `virtual`.
     * > **NOTE:** Currently, only `HTTP` or `HTTPS` protocol listener can directly create a `virtual` Endpoint Group. If it is `TCP` protocol listener, and you want to create a `virtual` Endpoint Group, please ensure that the `default` Endpoint Group has been created.
     */
    @JvmName("kovqdoqicseoarka")
    public suspend fun endpointGroupType(`value`: Output<String>) {
        this.endpointGroupType = value
    }

    /**
     * @param value The endpoint request protocol. Valid values: `HTTP`, `HTTPS`.
     * > **NOTE:** This item is only supported when creating terminal node group for listening instance of HTTP or HTTPS protocol. For the listening instance of HTTP protocol, the back-end service protocol supports and only supports HTTP.
     */
    @JvmName("hivlpehbkjenedtv")
    public suspend fun endpointRequestProtocol(`value`: Output<String>) {
        this.endpointRequestProtocol = value
    }

    /**
     * @param value Specifies whether to enable the health check feature. Valid values:
     */
    @JvmName("oyyefcyvjjrknmrl")
    public suspend fun healthCheckEnabled(`value`: Output<Boolean>) {
        this.healthCheckEnabled = value
    }

    /**
     * @param value The interval between two consecutive health checks. Unit: seconds.
     */
    @JvmName("tjspsripeajcjvtp")
    public suspend fun healthCheckIntervalSeconds(`value`: Output<Int>) {
        this.healthCheckIntervalSeconds = value
    }

    /**
     * @param value The path specified as the destination of the targets for health checks.
     */
    @JvmName("ydrxunxjfwrjkvrb")
    public suspend fun healthCheckPath(`value`: Output<String>) {
        this.healthCheckPath = value
    }

    /**
     * @param value The port that is used for health checks.
     */
    @JvmName("telqawlcuvlogyox")
    public suspend fun healthCheckPort(`value`: Output<Int>) {
        this.healthCheckPort = value
    }

    /**
     * @param value The protocol that is used to connect to the targets for health checks. Valid values:
     * - `TCP` or `tcp`: TCP protocol.
     * - `HTTP` or `http`: HTTP protocol.
     * - `HTTPS` or `https`: HTTPS protocol.
     * > **NOTE:** From version 1.223.0, `health_check_protocol` can be set to `TCP`, `HTTP`, `HTTPS`.
     */
    @JvmName("tkmgcewvxqbkcorc")
    public suspend fun healthCheckProtocol(`value`: Output<String>) {
        this.healthCheckProtocol = value
    }

    /**
     * @param value The ID of the listener that is associated with the endpoint group.
     */
    @JvmName("srkdogcpsmcqfixp")
    public suspend fun listenerId(`value`: Output<String>) {
        this.listenerId = value
    }

    /**
     * @param value The name of the endpoint group.
     */
    @JvmName("ltoxfjflelafhmyh")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Mapping between listening port and forwarding port of boarding point. See `port_overrides` below.
     * > **NOTE:** Port mapping is only supported when creating terminal node group for listening instance of HTTP or HTTPS protocol. The listening port in the port map must be consistent with the listening port of the current listening instance.
     */
    @JvmName("rtmotweksralquxk")
    public suspend fun portOverrides(`value`: Output<EndpointGroupPortOverridesArgs>) {
        this.portOverrides = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("pswqfeyqnjrbsbpm")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The number of consecutive failed heath checks that must occur before the endpoint is deemed unhealthy. Default value: `3`.
     */
    @JvmName("pccqgiiqsgvvntwl")
    public suspend fun thresholdCount(`value`: Output<Int>) {
        this.thresholdCount = value
    }

    /**
     * @param value The weight of the endpoint group when the corresponding listener is associated with multiple endpoint groups.
     */
    @JvmName("dwayjjdkcgiadvfq")
    public suspend fun trafficPercentage(`value`: Output<Int>) {
        this.trafficPercentage = value
    }

    /**
     * @param value The ID of the Global Accelerator instance to which the endpoint group will be added.
     */
    @JvmName("yrdokdmgvqmsehvo")
    public suspend fun acceleratorId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceleratorId = mapped
    }

    /**
     * @param value The description of the endpoint group.
     */
    @JvmName("hpjntpjspymtnrxj")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The endpointConfigurations of the endpoint group. See `endpoint_configurations` below.
     */
    @JvmName("axrfeaecoyurwrwe")
    public suspend fun endpointConfigurations(`value`: List<EndpointGroupEndpointConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointConfigurations = mapped
    }

    /**
     * @param argument The endpointConfigurations of the endpoint group. See `endpoint_configurations` below.
     */
    @JvmName("jewulqscpiyqfqga")
    public suspend fun endpointConfigurations(argument: List<suspend EndpointGroupEndpointConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EndpointGroupEndpointConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.endpointConfigurations = mapped
    }

    /**
     * @param argument The endpointConfigurations of the endpoint group. See `endpoint_configurations` below.
     */
    @JvmName("ruevvdduluvmwgll")
    public suspend fun endpointConfigurations(vararg argument: suspend EndpointGroupEndpointConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EndpointGroupEndpointConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.endpointConfigurations = mapped
    }

    /**
     * @param argument The endpointConfigurations of the endpoint group. See `endpoint_configurations` below.
     */
    @JvmName("atbrdovbshywyngm")
    public suspend fun endpointConfigurations(argument: suspend EndpointGroupEndpointConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            EndpointGroupEndpointConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.endpointConfigurations = mapped
    }

    /**
     * @param values The endpointConfigurations of the endpoint group. See `endpoint_configurations` below.
     */
    @JvmName("eyowarvbnfhuvryf")
    public suspend fun endpointConfigurations(vararg values: EndpointGroupEndpointConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpointConfigurations = mapped
    }

    /**
     * @param value The ID of the region where the endpoint group is deployed.
     */
    @JvmName("aebmkqagahrnjqff")
    public suspend fun endpointGroupRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointGroupRegion = mapped
    }

    /**
     * @param value The endpoint group type. Default value: `default`. Valid values: `default`, `virtual`.
     * > **NOTE:** Currently, only `HTTP` or `HTTPS` protocol listener can directly create a `virtual` Endpoint Group. If it is `TCP` protocol listener, and you want to create a `virtual` Endpoint Group, please ensure that the `default` Endpoint Group has been created.
     */
    @JvmName("cfstdmuqdnjpiepa")
    public suspend fun endpointGroupType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointGroupType = mapped
    }

    /**
     * @param value The endpoint request protocol. Valid values: `HTTP`, `HTTPS`.
     * > **NOTE:** This item is only supported when creating terminal node group for listening instance of HTTP or HTTPS protocol. For the listening instance of HTTP protocol, the back-end service protocol supports and only supports HTTP.
     */
    @JvmName("wcxincwuvivdjvfd")
    public suspend fun endpointRequestProtocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointRequestProtocol = mapped
    }

    /**
     * @param value Specifies whether to enable the health check feature. Valid values:
     */
    @JvmName("rrrthcgdsgjrsuij")
    public suspend fun healthCheckEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckEnabled = mapped
    }

    /**
     * @param value The interval between two consecutive health checks. Unit: seconds.
     */
    @JvmName("kxifbnyfextthaln")
    public suspend fun healthCheckIntervalSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckIntervalSeconds = mapped
    }

    /**
     * @param value The path specified as the destination of the targets for health checks.
     */
    @JvmName("mxqfepbxtgfasduf")
    public suspend fun healthCheckPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckPath = mapped
    }

    /**
     * @param value The port that is used for health checks.
     */
    @JvmName("apsfmrkyhxvpxmlr")
    public suspend fun healthCheckPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckPort = mapped
    }

    /**
     * @param value The protocol that is used to connect to the targets for health checks. Valid values:
     * - `TCP` or `tcp`: TCP protocol.
     * - `HTTP` or `http`: HTTP protocol.
     * - `HTTPS` or `https`: HTTPS protocol.
     * > **NOTE:** From version 1.223.0, `health_check_protocol` can be set to `TCP`, `HTTP`, `HTTPS`.
     */
    @JvmName("juacggligvexqltm")
    public suspend fun healthCheckProtocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckProtocol = mapped
    }

    /**
     * @param value The ID of the listener that is associated with the endpoint group.
     */
    @JvmName("wrghisiglomcrnxm")
    public suspend fun listenerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.listenerId = mapped
    }

    /**
     * @param value The name of the endpoint group.
     */
    @JvmName("mgpldysbywfcotqn")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Mapping between listening port and forwarding port of boarding point. See `port_overrides` below.
     * > **NOTE:** Port mapping is only supported when creating terminal node group for listening instance of HTTP or HTTPS protocol. The listening port in the port map must be consistent with the listening port of the current listening instance.
     */
    @JvmName("ypoqgkloheqwmlia")
    public suspend fun portOverrides(`value`: EndpointGroupPortOverridesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.portOverrides = mapped
    }

    /**
     * @param argument Mapping between listening port and forwarding port of boarding point. See `port_overrides` below.
     * > **NOTE:** Port mapping is only supported when creating terminal node group for listening instance of HTTP or HTTPS protocol. The listening port in the port map must be consistent with the listening port of the current listening instance.
     */
    @JvmName("emswpyctesoxxvvg")
    public suspend fun portOverrides(argument: suspend EndpointGroupPortOverridesArgsBuilder.() -> Unit) {
        val toBeMapped = EndpointGroupPortOverridesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.portOverrides = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("xnvdmcgmghnhocse")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("kenykleqqlsljnfs")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The number of consecutive failed heath checks that must occur before the endpoint is deemed unhealthy. Default value: `3`.
     */
    @JvmName("fwnnwapgnurkrbjr")
    public suspend fun thresholdCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.thresholdCount = mapped
    }

    /**
     * @param value The weight of the endpoint group when the corresponding listener is associated with multiple endpoint groups.
     */
    @JvmName("jtieikomfkkrrjdd")
    public suspend fun trafficPercentage(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trafficPercentage = mapped
    }

    internal fun build(): EndpointGroupArgs = EndpointGroupArgs(
        acceleratorId = acceleratorId,
        description = description,
        endpointConfigurations = endpointConfigurations,
        endpointGroupRegion = endpointGroupRegion,
        endpointGroupType = endpointGroupType,
        endpointRequestProtocol = endpointRequestProtocol,
        healthCheckEnabled = healthCheckEnabled,
        healthCheckIntervalSeconds = healthCheckIntervalSeconds,
        healthCheckPath = healthCheckPath,
        healthCheckPort = healthCheckPort,
        healthCheckProtocol = healthCheckProtocol,
        listenerId = listenerId,
        name = name,
        portOverrides = portOverrides,
        tags = tags,
        thresholdCount = thresholdCount,
        trafficPercentage = trafficPercentage,
    )
}
