@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin

import com.pulumi.alicloud.ga.GaFunctions.getAcceleratorSpareIpAttachmentsPlain
import com.pulumi.alicloud.ga.GaFunctions.getAcceleratorsPlain
import com.pulumi.alicloud.ga.GaFunctions.getAclsPlain
import com.pulumi.alicloud.ga.GaFunctions.getAdditionalCertificatesPlain
import com.pulumi.alicloud.ga.GaFunctions.getBandwidthPackagesPlain
import com.pulumi.alicloud.ga.GaFunctions.getBasicAccelerateIpEndpointRelationsPlain
import com.pulumi.alicloud.ga.GaFunctions.getBasicAccelerateIpsPlain
import com.pulumi.alicloud.ga.GaFunctions.getBasicAcceleratorsPlain
import com.pulumi.alicloud.ga.GaFunctions.getBasicEndpointsPlain
import com.pulumi.alicloud.ga.GaFunctions.getCustomRoutingEndpointGroupDestinationsPlain
import com.pulumi.alicloud.ga.GaFunctions.getCustomRoutingEndpointGroupsPlain
import com.pulumi.alicloud.ga.GaFunctions.getCustomRoutingEndpointTrafficPoliciesPlain
import com.pulumi.alicloud.ga.GaFunctions.getCustomRoutingEndpointsPlain
import com.pulumi.alicloud.ga.GaFunctions.getCustomRoutingPortMappingsPlain
import com.pulumi.alicloud.ga.GaFunctions.getDomainsPlain
import com.pulumi.alicloud.ga.GaFunctions.getEndpointGroupIpAddressCidrBlocksPlain
import com.pulumi.alicloud.ga.GaFunctions.getEndpointGroupsPlain
import com.pulumi.alicloud.ga.GaFunctions.getForwardingRulesPlain
import com.pulumi.alicloud.ga.GaFunctions.getIpSetsPlain
import com.pulumi.alicloud.ga.GaFunctions.getListenersPlain
import com.pulumi.alicloud.ga.kotlin.inputs.GetAcceleratorSpareIpAttachmentsPlainArgs
import com.pulumi.alicloud.ga.kotlin.inputs.GetAcceleratorSpareIpAttachmentsPlainArgsBuilder
import com.pulumi.alicloud.ga.kotlin.inputs.GetAcceleratorsPlainArgs
import com.pulumi.alicloud.ga.kotlin.inputs.GetAcceleratorsPlainArgsBuilder
import com.pulumi.alicloud.ga.kotlin.inputs.GetAclsPlainArgs
import com.pulumi.alicloud.ga.kotlin.inputs.GetAclsPlainArgsBuilder
import com.pulumi.alicloud.ga.kotlin.inputs.GetAdditionalCertificatesPlainArgs
import com.pulumi.alicloud.ga.kotlin.inputs.GetAdditionalCertificatesPlainArgsBuilder
import com.pulumi.alicloud.ga.kotlin.inputs.GetBandwidthPackagesPlainArgs
import com.pulumi.alicloud.ga.kotlin.inputs.GetBandwidthPackagesPlainArgsBuilder
import com.pulumi.alicloud.ga.kotlin.inputs.GetBasicAccelerateIpEndpointRelationsPlainArgs
import com.pulumi.alicloud.ga.kotlin.inputs.GetBasicAccelerateIpEndpointRelationsPlainArgsBuilder
import com.pulumi.alicloud.ga.kotlin.inputs.GetBasicAccelerateIpsPlainArgs
import com.pulumi.alicloud.ga.kotlin.inputs.GetBasicAccelerateIpsPlainArgsBuilder
import com.pulumi.alicloud.ga.kotlin.inputs.GetBasicAcceleratorsPlainArgs
import com.pulumi.alicloud.ga.kotlin.inputs.GetBasicAcceleratorsPlainArgsBuilder
import com.pulumi.alicloud.ga.kotlin.inputs.GetBasicEndpointsPlainArgs
import com.pulumi.alicloud.ga.kotlin.inputs.GetBasicEndpointsPlainArgsBuilder
import com.pulumi.alicloud.ga.kotlin.inputs.GetCustomRoutingEndpointGroupDestinationsPlainArgs
import com.pulumi.alicloud.ga.kotlin.inputs.GetCustomRoutingEndpointGroupDestinationsPlainArgsBuilder
import com.pulumi.alicloud.ga.kotlin.inputs.GetCustomRoutingEndpointGroupsPlainArgs
import com.pulumi.alicloud.ga.kotlin.inputs.GetCustomRoutingEndpointGroupsPlainArgsBuilder
import com.pulumi.alicloud.ga.kotlin.inputs.GetCustomRoutingEndpointTrafficPoliciesPlainArgs
import com.pulumi.alicloud.ga.kotlin.inputs.GetCustomRoutingEndpointTrafficPoliciesPlainArgsBuilder
import com.pulumi.alicloud.ga.kotlin.inputs.GetCustomRoutingEndpointsPlainArgs
import com.pulumi.alicloud.ga.kotlin.inputs.GetCustomRoutingEndpointsPlainArgsBuilder
import com.pulumi.alicloud.ga.kotlin.inputs.GetCustomRoutingPortMappingsPlainArgs
import com.pulumi.alicloud.ga.kotlin.inputs.GetCustomRoutingPortMappingsPlainArgsBuilder
import com.pulumi.alicloud.ga.kotlin.inputs.GetDomainsPlainArgs
import com.pulumi.alicloud.ga.kotlin.inputs.GetDomainsPlainArgsBuilder
import com.pulumi.alicloud.ga.kotlin.inputs.GetEndpointGroupIpAddressCidrBlocksPlainArgs
import com.pulumi.alicloud.ga.kotlin.inputs.GetEndpointGroupIpAddressCidrBlocksPlainArgsBuilder
import com.pulumi.alicloud.ga.kotlin.inputs.GetEndpointGroupsPlainArgs
import com.pulumi.alicloud.ga.kotlin.inputs.GetEndpointGroupsPlainArgsBuilder
import com.pulumi.alicloud.ga.kotlin.inputs.GetForwardingRulesPlainArgs
import com.pulumi.alicloud.ga.kotlin.inputs.GetForwardingRulesPlainArgsBuilder
import com.pulumi.alicloud.ga.kotlin.inputs.GetIpSetsPlainArgs
import com.pulumi.alicloud.ga.kotlin.inputs.GetIpSetsPlainArgsBuilder
import com.pulumi.alicloud.ga.kotlin.inputs.GetListenersPlainArgs
import com.pulumi.alicloud.ga.kotlin.inputs.GetListenersPlainArgsBuilder
import com.pulumi.alicloud.ga.kotlin.outputs.GetAcceleratorSpareIpAttachmentsResult
import com.pulumi.alicloud.ga.kotlin.outputs.GetAcceleratorsResult
import com.pulumi.alicloud.ga.kotlin.outputs.GetAclsResult
import com.pulumi.alicloud.ga.kotlin.outputs.GetAdditionalCertificatesResult
import com.pulumi.alicloud.ga.kotlin.outputs.GetBandwidthPackagesResult
import com.pulumi.alicloud.ga.kotlin.outputs.GetBasicAccelerateIpEndpointRelationsResult
import com.pulumi.alicloud.ga.kotlin.outputs.GetBasicAccelerateIpsResult
import com.pulumi.alicloud.ga.kotlin.outputs.GetBasicAcceleratorsResult
import com.pulumi.alicloud.ga.kotlin.outputs.GetBasicEndpointsResult
import com.pulumi.alicloud.ga.kotlin.outputs.GetCustomRoutingEndpointGroupDestinationsResult
import com.pulumi.alicloud.ga.kotlin.outputs.GetCustomRoutingEndpointGroupsResult
import com.pulumi.alicloud.ga.kotlin.outputs.GetCustomRoutingEndpointTrafficPoliciesResult
import com.pulumi.alicloud.ga.kotlin.outputs.GetCustomRoutingEndpointsResult
import com.pulumi.alicloud.ga.kotlin.outputs.GetCustomRoutingPortMappingsResult
import com.pulumi.alicloud.ga.kotlin.outputs.GetDomainsResult
import com.pulumi.alicloud.ga.kotlin.outputs.GetEndpointGroupIpAddressCidrBlocksResult
import com.pulumi.alicloud.ga.kotlin.outputs.GetEndpointGroupsResult
import com.pulumi.alicloud.ga.kotlin.outputs.GetForwardingRulesResult
import com.pulumi.alicloud.ga.kotlin.outputs.GetIpSetsResult
import com.pulumi.alicloud.ga.kotlin.outputs.GetListenersResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.ga.kotlin.outputs.GetAcceleratorSpareIpAttachmentsResult.Companion.toKotlin as getAcceleratorSpareIpAttachmentsResultToKotlin
import com.pulumi.alicloud.ga.kotlin.outputs.GetAcceleratorsResult.Companion.toKotlin as getAcceleratorsResultToKotlin
import com.pulumi.alicloud.ga.kotlin.outputs.GetAclsResult.Companion.toKotlin as getAclsResultToKotlin
import com.pulumi.alicloud.ga.kotlin.outputs.GetAdditionalCertificatesResult.Companion.toKotlin as getAdditionalCertificatesResultToKotlin
import com.pulumi.alicloud.ga.kotlin.outputs.GetBandwidthPackagesResult.Companion.toKotlin as getBandwidthPackagesResultToKotlin
import com.pulumi.alicloud.ga.kotlin.outputs.GetBasicAccelerateIpEndpointRelationsResult.Companion.toKotlin as getBasicAccelerateIpEndpointRelationsResultToKotlin
import com.pulumi.alicloud.ga.kotlin.outputs.GetBasicAccelerateIpsResult.Companion.toKotlin as getBasicAccelerateIpsResultToKotlin
import com.pulumi.alicloud.ga.kotlin.outputs.GetBasicAcceleratorsResult.Companion.toKotlin as getBasicAcceleratorsResultToKotlin
import com.pulumi.alicloud.ga.kotlin.outputs.GetBasicEndpointsResult.Companion.toKotlin as getBasicEndpointsResultToKotlin
import com.pulumi.alicloud.ga.kotlin.outputs.GetCustomRoutingEndpointGroupDestinationsResult.Companion.toKotlin as getCustomRoutingEndpointGroupDestinationsResultToKotlin
import com.pulumi.alicloud.ga.kotlin.outputs.GetCustomRoutingEndpointGroupsResult.Companion.toKotlin as getCustomRoutingEndpointGroupsResultToKotlin
import com.pulumi.alicloud.ga.kotlin.outputs.GetCustomRoutingEndpointTrafficPoliciesResult.Companion.toKotlin as getCustomRoutingEndpointTrafficPoliciesResultToKotlin
import com.pulumi.alicloud.ga.kotlin.outputs.GetCustomRoutingEndpointsResult.Companion.toKotlin as getCustomRoutingEndpointsResultToKotlin
import com.pulumi.alicloud.ga.kotlin.outputs.GetCustomRoutingPortMappingsResult.Companion.toKotlin as getCustomRoutingPortMappingsResultToKotlin
import com.pulumi.alicloud.ga.kotlin.outputs.GetDomainsResult.Companion.toKotlin as getDomainsResultToKotlin
import com.pulumi.alicloud.ga.kotlin.outputs.GetEndpointGroupIpAddressCidrBlocksResult.Companion.toKotlin as getEndpointGroupIpAddressCidrBlocksResultToKotlin
import com.pulumi.alicloud.ga.kotlin.outputs.GetEndpointGroupsResult.Companion.toKotlin as getEndpointGroupsResultToKotlin
import com.pulumi.alicloud.ga.kotlin.outputs.GetForwardingRulesResult.Companion.toKotlin as getForwardingRulesResultToKotlin
import com.pulumi.alicloud.ga.kotlin.outputs.GetIpSetsResult.Companion.toKotlin as getIpSetsResultToKotlin
import com.pulumi.alicloud.ga.kotlin.outputs.GetListenersResult.Companion.toKotlin as getListenersResultToKotlin

public object GaFunctions {
    /**
     * This data source provides the Ga Accelerator Spare Ip Attachments of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.167.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.ga.getAcceleratorSpareIpAttachments({
     *     acceleratorId: "example_value",
     *     ids: [
     *         "example_value-1",
     *         "example_value-2",
     *     ],
     * });
     * export const gaAcceleratorSpareIpAttachmentId1 = ids.then(ids => ids.attachments?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.ga.get_accelerator_spare_ip_attachments(accelerator_id="example_value",
     *     ids=[
     *         "example_value-1",
     *         "example_value-2",
     *     ])
     * pulumi.export("gaAcceleratorSpareIpAttachmentId1", ids.attachments[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Ga.GetAcceleratorSpareIpAttachments.Invoke(new()
     *     {
     *         AcceleratorId = "example_value",
     *         Ids = new[]
     *         {
     *             "example_value-1",
     *             "example_value-2",
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["gaAcceleratorSpareIpAttachmentId1"] = ids&#46;Apply(getAcceleratorSpareIpAttachmentsResult => getAcceleratorSpareIpAttachmentsResult&#46;Attachments[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ga"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := ga.GetAcceleratorSpareIpAttachments(ctx, &ga.GetAcceleratorSpareIpAttachmentsArgs{
     * 			AcceleratorId: "example_value",
     * 			Ids: []string{
     * 				"example_value-1",
     * 				"example_value-2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("gaAcceleratorSpareIpAttachmentId1", ids.Attachments[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ga.GaFunctions;
     * import com.pulumi.alicloud.ga.inputs.GetAcceleratorSpareIpAttachmentsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = GaFunctions.getAcceleratorSpareIpAttachments(GetAcceleratorSpareIpAttachmentsArgs.builder()
     *             .acceleratorId("example_value")
     *             .ids(
     *                 "example_value-1",
     *                 "example_value-2")
     *             .build());
     *         ctx.export("gaAcceleratorSpareIpAttachmentId1", ids.applyValue(getAcceleratorSpareIpAttachmentsResult -> getAcceleratorSpareIpAttachmentsResult.attachments()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:ga:getAcceleratorSpareIpAttachments
     *       Arguments:
     *         acceleratorId: example_value
     *         ids:
     *           - example_value-1
     *           - example_value-2
     * outputs:
     *   gaAcceleratorSpareIpAttachmentId1: ${ids.attachments[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAcceleratorSpareIpAttachments.
     * @return A collection of values returned by getAcceleratorSpareIpAttachments.
     */
    public suspend fun getAcceleratorSpareIpAttachments(argument: GetAcceleratorSpareIpAttachmentsPlainArgs): GetAcceleratorSpareIpAttachmentsResult =
        getAcceleratorSpareIpAttachmentsResultToKotlin(getAcceleratorSpareIpAttachmentsPlain(argument.toJava()).await())

    /**
     * @see [getAcceleratorSpareIpAttachments].
     * @param acceleratorId The ID of the global acceleration instance.
     * @param ids A list of Accelerator Spare Ip Attachment IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the standby CNAME IP address. Valid values: `active`, `inuse`.
     * @return A collection of values returned by getAcceleratorSpareIpAttachments.
     */
    public suspend fun getAcceleratorSpareIpAttachments(
        acceleratorId: String,
        ids: List<String>? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetAcceleratorSpareIpAttachmentsResult {
        val argument = GetAcceleratorSpareIpAttachmentsPlainArgs(
            acceleratorId = acceleratorId,
            ids = ids,
            outputFile = outputFile,
            status = status,
        )
        return getAcceleratorSpareIpAttachmentsResultToKotlin(getAcceleratorSpareIpAttachmentsPlain(argument.toJava()).await())
    }

    /**
     * @see [getAcceleratorSpareIpAttachments].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ga&#46;kotlin&#46;inputs&#46;GetAcceleratorSpareIpAttachmentsPlainArgs].
     * @return A collection of values returned by getAcceleratorSpareIpAttachments.
     */
    public suspend fun getAcceleratorSpareIpAttachments(argument: suspend GetAcceleratorSpareIpAttachmentsPlainArgsBuilder.() -> Unit): GetAcceleratorSpareIpAttachmentsResult {
        val builder = GetAcceleratorSpareIpAttachmentsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAcceleratorSpareIpAttachmentsResultToKotlin(getAcceleratorSpareIpAttachmentsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Global Accelerator (GA) Accelerators of the current Alibaba Cloud user.
     * > **NOTE:** Available since v1.111.0.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.ga.getAccelerators({
     *     nameRegex: "tf",
     * });
     * export const firstGaAcceleratorId = example.then(example => example.accelerators?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.ga.get_accelerators(name_regex="tf")
     * pulumi.export("firstGaAcceleratorId", example.accelerators[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Ga.GetAccelerators.Invoke(new()
     *     {
     *         NameRegex = "tf",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstGaAcceleratorId"] = example&#46;Apply(getAcceleratorsResult => getAcceleratorsResult&#46;Accelerators[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ga"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := ga.GetAccelerators(ctx, &ga.GetAcceleratorsArgs{
     * 			NameRegex: pulumi.StringRef("tf"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstGaAcceleratorId", example.Accelerators[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ga.GaFunctions;
     * import com.pulumi.alicloud.ga.inputs.GetAcceleratorsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = GaFunctions.getAccelerators(GetAcceleratorsArgs.builder()
     *             .nameRegex("tf")
     *             .build());
     *         ctx.export("firstGaAcceleratorId", example.applyValue(getAcceleratorsResult -> getAcceleratorsResult.accelerators()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:ga:getAccelerators
     *       Arguments:
     *         nameRegex: tf
     * outputs:
     *   firstGaAcceleratorId: ${example.accelerators[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAccelerators.
     * @return A collection of values returned by getAccelerators.
     */
    public suspend fun getAccelerators(argument: GetAcceleratorsPlainArgs): GetAcceleratorsResult =
        getAcceleratorsResultToKotlin(getAcceleratorsPlain(argument.toJava()).await())

    /**
     * @see [getAccelerators].
     * @param bandwidthBillingType The bandwidth billing method. Default value: `BandwidthPackage`. Valid values:
     * - `BandwidthPackage`: billed based on bandwidth plans.
     * - `CDT`: billed based on data transfer.
     * @param ids A list of Accelerator IDs.
     * @param nameRegex A regex string to filter results by Accelerator name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the GA instance. Valid values: `active`, `binding`, `configuring`, `deleting`, `finacialLocked`, `init`, `unbinding`.
     * @return A collection of values returned by getAccelerators.
     */
    public suspend fun getAccelerators(
        bandwidthBillingType: String? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetAcceleratorsResult {
        val argument = GetAcceleratorsPlainArgs(
            bandwidthBillingType = bandwidthBillingType,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
        )
        return getAcceleratorsResultToKotlin(getAcceleratorsPlain(argument.toJava()).await())
    }

    /**
     * @see [getAccelerators].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ga&#46;kotlin&#46;inputs&#46;GetAcceleratorsPlainArgs].
     * @return A collection of values returned by getAccelerators.
     */
    public suspend fun getAccelerators(argument: suspend GetAcceleratorsPlainArgsBuilder.() -> Unit): GetAcceleratorsResult {
        val builder = GetAcceleratorsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAcceleratorsResultToKotlin(getAcceleratorsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Ga Acls of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.150.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.ga.getAcls({});
     * export const gaAclId1 = ids.then(ids => ids.acls?.[0]?.id);
     * const nameRegex = alicloud.ga.getAcls({
     *     nameRegex: "^my-Acl",
     * });
     * export const gaAclId2 = nameRegex.then(nameRegex => nameRegex.acls?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.ga.get_acls()
     * pulumi.export("gaAclId1", ids.acls[0].id)
     * name_regex = alicloud.ga.get_acls(name_regex="^my-Acl")
     * pulumi.export("gaAclId2", name_regex.acls[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Ga.GetAcls.Invoke();
     *     var nameRegex = AliCloud.Ga.GetAcls.Invoke(new()
     *     {
     *         NameRegex = "^my-Acl",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["gaAclId1"] = ids&#46;Apply(getAclsResult => getAclsResult&#46;Acls[0]?.Id),
     *         ["gaAclId2"] = nameRegex&#46;Apply(getAclsResult => getAclsResult&#46;Acls[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ga"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := ga.GetAcls(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("gaAclId1", ids.Acls[0].Id)
     * 		nameRegex, err := ga.GetAcls(ctx, &ga.GetAclsArgs{
     * 			NameRegex: pulumi.StringRef("^my-Acl"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("gaAclId2", nameRegex.Acls[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ga.GaFunctions;
     * import com.pulumi.alicloud.ga.inputs.GetAclsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = GaFunctions.getAcls();
     *         ctx.export("gaAclId1", ids.applyValue(getAclsResult -> getAclsResult.acls()[0].id()));
     *         final var nameRegex = GaFunctions.getAcls(GetAclsArgs.builder()
     *             .nameRegex("^my-Acl")
     *             .build());
     *         ctx.export("gaAclId2", nameRegex.applyValue(getAclsResult -> getAclsResult.acls()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:ga:getAcls
     *       Arguments: {}
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:ga:getAcls
     *       Arguments:
     *         nameRegex: ^my-Acl
     * outputs:
     *   gaAclId1: ${ids.acls[0].id}
     *   gaAclId2: ${nameRegex.acls[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAcls.
     * @return A collection of values returned by getAcls.
     */
    public suspend fun getAcls(argument: GetAclsPlainArgs): GetAclsResult =
        getAclsResultToKotlin(getAclsPlain(argument.toJava()).await())

    /**
     * @see [getAcls].
     * @param aclName The name of the acl.
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param ids A list of Acl IDs.
     * @param nameRegex A regex string to filter results by Acl name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the resource. Valid values: `active`, `configuring`, `deleting`, `init`.
     * @return A collection of values returned by getAcls.
     */
    public suspend fun getAcls(
        aclName: String? = null,
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetAclsResult {
        val argument = GetAclsPlainArgs(
            aclName = aclName,
            enableDetails = enableDetails,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
        )
        return getAclsResultToKotlin(getAclsPlain(argument.toJava()).await())
    }

    /**
     * @see [getAcls].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ga&#46;kotlin&#46;inputs&#46;GetAclsPlainArgs].
     * @return A collection of values returned by getAcls.
     */
    public suspend fun getAcls(argument: suspend GetAclsPlainArgsBuilder.() -> Unit): GetAclsResult {
        val builder = GetAclsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAclsResultToKotlin(getAclsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Ga Additional Certificates of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.150.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.ga.getAdditionalCertificates({
     *     acceleratorId: "example_value",
     *     listenerId: "example_value",
     *     ids: [
     *         "example_value-1",
     *         "example_value-2",
     *     ],
     * });
     * export const gaAdditionalCertificateId1 = ids.then(ids => ids.certificates?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.ga.get_additional_certificates(accelerator_id="example_value",
     *     listener_id="example_value",
     *     ids=[
     *         "example_value-1",
     *         "example_value-2",
     *     ])
     * pulumi.export("gaAdditionalCertificateId1", ids.certificates[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Ga.GetAdditionalCertificates.Invoke(new()
     *     {
     *         AcceleratorId = "example_value",
     *         ListenerId = "example_value",
     *         Ids = new[]
     *         {
     *             "example_value-1",
     *             "example_value-2",
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["gaAdditionalCertificateId1"] = ids&#46;Apply(getAdditionalCertificatesResult => getAdditionalCertificatesResult&#46;Certificates[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ga"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := ga.GetAdditionalCertificates(ctx, &ga.GetAdditionalCertificatesArgs{
     * 			AcceleratorId: "example_value",
     * 			ListenerId:    "example_value",
     * 			Ids: []string{
     * 				"example_value-1",
     * 				"example_value-2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("gaAdditionalCertificateId1", ids.Certificates[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ga.GaFunctions;
     * import com.pulumi.alicloud.ga.inputs.GetAdditionalCertificatesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = GaFunctions.getAdditionalCertificates(GetAdditionalCertificatesArgs.builder()
     *             .acceleratorId("example_value")
     *             .listenerId("example_value")
     *             .ids(
     *                 "example_value-1",
     *                 "example_value-2")
     *             .build());
     *         ctx.export("gaAdditionalCertificateId1", ids.applyValue(getAdditionalCertificatesResult -> getAdditionalCertificatesResult.certificates()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:ga:getAdditionalCertificates
     *       Arguments:
     *         acceleratorId: example_value
     *         listenerId: example_value
     *         ids:
     *           - example_value-1
     *           - example_value-2
     * outputs:
     *   gaAdditionalCertificateId1: ${ids.certificates[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAdditionalCertificates.
     * @return A collection of values returned by getAdditionalCertificates.
     */
    public suspend fun getAdditionalCertificates(argument: GetAdditionalCertificatesPlainArgs): GetAdditionalCertificatesResult =
        getAdditionalCertificatesResultToKotlin(getAdditionalCertificatesPlain(argument.toJava()).await())

    /**
     * @see [getAdditionalCertificates].
     * @param acceleratorId The ID of the GA instance.
     * @param ids A list of Additional Certificate IDs.
     * @param listenerId The ID of the listener. Only HTTPS listeners support this parameter.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getAdditionalCertificates.
     */
    public suspend fun getAdditionalCertificates(
        acceleratorId: String,
        ids: List<String>? = null,
        listenerId: String,
        outputFile: String? = null,
    ): GetAdditionalCertificatesResult {
        val argument = GetAdditionalCertificatesPlainArgs(
            acceleratorId = acceleratorId,
            ids = ids,
            listenerId = listenerId,
            outputFile = outputFile,
        )
        return getAdditionalCertificatesResultToKotlin(getAdditionalCertificatesPlain(argument.toJava()).await())
    }

    /**
     * @see [getAdditionalCertificates].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ga&#46;kotlin&#46;inputs&#46;GetAdditionalCertificatesPlainArgs].
     * @return A collection of values returned by getAdditionalCertificates.
     */
    public suspend fun getAdditionalCertificates(argument: suspend GetAdditionalCertificatesPlainArgsBuilder.() -> Unit): GetAdditionalCertificatesResult {
        val builder = GetAdditionalCertificatesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAdditionalCertificatesResultToKotlin(getAdditionalCertificatesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Global Accelerator (GA) Bandwidth Packages of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.112.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.ga.getBandwidthPackages({
     *     ids: ["example_value"],
     *     nameRegex: "the_resource_name",
     * });
     * export const firstGaBandwidthPackageId = example.then(example => example.packages?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.ga.get_bandwidth_packages(ids=["example_value"],
     *     name_regex="the_resource_name")
     * pulumi.export("firstGaBandwidthPackageId", example.packages[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Ga.GetBandwidthPackages.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_value",
     *         },
     *         NameRegex = "the_resource_name",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstGaBandwidthPackageId"] = example&#46;Apply(getBandwidthPackagesResult => getBandwidthPackagesResult&#46;Packages[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ga"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := ga.GetBandwidthPackages(ctx, &ga.GetBandwidthPackagesArgs{
     * 			Ids: []string{
     * 				"example_value",
     * 			},
     * 			NameRegex: pulumi.StringRef("the_resource_name"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstGaBandwidthPackageId", example.Packages[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ga.GaFunctions;
     * import com.pulumi.alicloud.ga.inputs.GetBandwidthPackagesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = GaFunctions.getBandwidthPackages(GetBandwidthPackagesArgs.builder()
     *             .ids("example_value")
     *             .nameRegex("the_resource_name")
     *             .build());
     *         ctx.export("firstGaBandwidthPackageId", example.applyValue(getBandwidthPackagesResult -> getBandwidthPackagesResult.packages()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:ga:getBandwidthPackages
     *       Arguments:
     *         ids:
     *           - example_value
     *         nameRegex: the_resource_name
     * outputs:
     *   firstGaBandwidthPackageId: ${example.packages[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getBandwidthPackages.
     * @return A collection of values returned by getBandwidthPackages.
     */
    public suspend fun getBandwidthPackages(argument: GetBandwidthPackagesPlainArgs): GetBandwidthPackagesResult =
        getBandwidthPackagesResultToKotlin(getBandwidthPackagesPlain(argument.toJava()).await())

    /**
     * @see [getBandwidthPackages].
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param ids A list of Bandwidth Package IDs.
     * @param nameRegex A regex string to filter results by Bandwidth Package name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the bandwidth plan. Valid values: `active`, `binded`, `binding`, `finacialLocked`, `init`, `unbinding`, `updating`.
     * @param type The type of the bandwidth plan. Valid values: `Basic`, `CrossDomain`.
     * @return A collection of values returned by getBandwidthPackages.
     */
    public suspend fun getBandwidthPackages(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
        type: String? = null,
    ): GetBandwidthPackagesResult {
        val argument = GetBandwidthPackagesPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
            type = type,
        )
        return getBandwidthPackagesResultToKotlin(getBandwidthPackagesPlain(argument.toJava()).await())
    }

    /**
     * @see [getBandwidthPackages].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ga&#46;kotlin&#46;inputs&#46;GetBandwidthPackagesPlainArgs].
     * @return A collection of values returned by getBandwidthPackages.
     */
    public suspend fun getBandwidthPackages(argument: suspend GetBandwidthPackagesPlainArgsBuilder.() -> Unit): GetBandwidthPackagesResult {
        val builder = GetBandwidthPackagesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBandwidthPackagesResultToKotlin(getBandwidthPackagesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Global Accelerator (GA) Basic Accelerate Ip Endpoint Relations of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.194.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.ga.getBasicAccelerateIpEndpointRelations({
     *     ids: ["example_id"],
     *     acceleratorId: "example_id",
     * });
     * export const gaBasicAccelerateIpEndpointRelationsId1 = ids.then(ids => ids.relations?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.ga.get_basic_accelerate_ip_endpoint_relations(ids=["example_id"],
     *     accelerator_id="example_id")
     * pulumi.export("gaBasicAccelerateIpEndpointRelationsId1", ids.relations[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Ga.GetBasicAccelerateIpEndpointRelations.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *         AcceleratorId = "example_id",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["gaBasicAccelerateIpEndpointRelationsId1"] = ids&#46;Apply(getBasicAccelerateIpEndpointRelationsResult => getBasicAccelerateIpEndpointRelationsResult&#46;Relations[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ga"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := ga.GetBasicAccelerateIpEndpointRelations(ctx, &ga.GetBasicAccelerateIpEndpointRelationsArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 			AcceleratorId: "example_id",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("gaBasicAccelerateIpEndpointRelationsId1", ids.Relations[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ga.GaFunctions;
     * import com.pulumi.alicloud.ga.inputs.GetBasicAccelerateIpEndpointRelationsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = GaFunctions.getBasicAccelerateIpEndpointRelations(GetBasicAccelerateIpEndpointRelationsArgs.builder()
     *             .ids("example_id")
     *             .acceleratorId("example_id")
     *             .build());
     *         ctx.export("gaBasicAccelerateIpEndpointRelationsId1", ids.applyValue(getBasicAccelerateIpEndpointRelationsResult -> getBasicAccelerateIpEndpointRelationsResult.relations()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:ga:getBasicAccelerateIpEndpointRelations
     *       Arguments:
     *         ids:
     *           - example_id
     *         acceleratorId: example_id
     * outputs:
     *   gaBasicAccelerateIpEndpointRelationsId1: ${ids.relations[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getBasicAccelerateIpEndpointRelations.
     * @return A collection of values returned by getBasicAccelerateIpEndpointRelations.
     */
    public suspend fun getBasicAccelerateIpEndpointRelations(argument: GetBasicAccelerateIpEndpointRelationsPlainArgs): GetBasicAccelerateIpEndpointRelationsResult =
        getBasicAccelerateIpEndpointRelationsResultToKotlin(getBasicAccelerateIpEndpointRelationsPlain(argument.toJava()).await())

    /**
     * @see [getBasicAccelerateIpEndpointRelations].
     * @param accelerateIpId The ID of the Basic Accelerate IP.
     * @param acceleratorId The ID of the Global Accelerator Basic Accelerator instance.
     * @param endpointId The ID of the Basic Endpoint.
     * @param ids A list of Global Accelerator Basic Accelerate Ip Endpoint Relations IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the Global Accelerator Basic Accelerate Ip Endpoint Relation. Valid Value: `active`.
     * @return A collection of values returned by getBasicAccelerateIpEndpointRelations.
     */
    public suspend fun getBasicAccelerateIpEndpointRelations(
        accelerateIpId: String? = null,
        acceleratorId: String,
        endpointId: String? = null,
        ids: List<String>? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetBasicAccelerateIpEndpointRelationsResult {
        val argument = GetBasicAccelerateIpEndpointRelationsPlainArgs(
            accelerateIpId = accelerateIpId,
            acceleratorId = acceleratorId,
            endpointId = endpointId,
            ids = ids,
            outputFile = outputFile,
            status = status,
        )
        return getBasicAccelerateIpEndpointRelationsResultToKotlin(getBasicAccelerateIpEndpointRelationsPlain(argument.toJava()).await())
    }

    /**
     * @see [getBasicAccelerateIpEndpointRelations].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ga&#46;kotlin&#46;inputs&#46;GetBasicAccelerateIpEndpointRelationsPlainArgs].
     * @return A collection of values returned by getBasicAccelerateIpEndpointRelations.
     */
    public suspend fun getBasicAccelerateIpEndpointRelations(argument: suspend GetBasicAccelerateIpEndpointRelationsPlainArgsBuilder.() -> Unit): GetBasicAccelerateIpEndpointRelationsResult {
        val builder = GetBasicAccelerateIpEndpointRelationsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBasicAccelerateIpEndpointRelationsResultToKotlin(getBasicAccelerateIpEndpointRelationsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Global Accelerator (GA) Basic Accelerate IPs of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.194.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.ga.getBasicAccelerateIps({
     *     ids: ["example_id"],
     *     ipSetId: "example_ip_set_id",
     * });
     * export const gaBasicAccelerateIpId1 = ids.then(ids => ids.ips?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.ga.get_basic_accelerate_ips(ids=["example_id"],
     *     ip_set_id="example_ip_set_id")
     * pulumi.export("gaBasicAccelerateIpId1", ids.ips[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Ga.GetBasicAccelerateIps.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *         IpSetId = "example_ip_set_id",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["gaBasicAccelerateIpId1"] = ids&#46;Apply(getBasicAccelerateIpsResult => getBasicAccelerateIpsResult&#46;Ips[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ga"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := ga.GetBasicAccelerateIps(ctx, &ga.GetBasicAccelerateIpsArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 			IpSetId: "example_ip_set_id",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("gaBasicAccelerateIpId1", ids.Ips[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ga.GaFunctions;
     * import com.pulumi.alicloud.ga.inputs.GetBasicAccelerateIpsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = GaFunctions.getBasicAccelerateIps(GetBasicAccelerateIpsArgs.builder()
     *             .ids("example_id")
     *             .ipSetId("example_ip_set_id")
     *             .build());
     *         ctx.export("gaBasicAccelerateIpId1", ids.applyValue(getBasicAccelerateIpsResult -> getBasicAccelerateIpsResult.ips()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:ga:getBasicAccelerateIps
     *       Arguments:
     *         ids:
     *           - example_id
     *         ipSetId: example_ip_set_id
     * outputs:
     *   gaBasicAccelerateIpId1: ${ids.ips[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getBasicAccelerateIps.
     * @return A collection of values returned by getBasicAccelerateIps.
     */
    public suspend fun getBasicAccelerateIps(argument: GetBasicAccelerateIpsPlainArgs): GetBasicAccelerateIpsResult =
        getBasicAccelerateIpsResultToKotlin(getBasicAccelerateIpsPlain(argument.toJava()).await())

    /**
     * @see [getBasicAccelerateIps].
     * @param accelerateIpAddress The address of the Basic Accelerate IP.
     * @param accelerateIpId The id of the Basic Accelerate IP.
     * @param ids A list of Global Accelerator Basic Accelerate IP IDs.
     * @param ipSetId The ID of the Basic Ip Set.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the Global Accelerator Basic Accelerate IP instance. Valid Value: `active`, `binding`, `bound`, `unbinding`, `deleting`.
     * @return A collection of values returned by getBasicAccelerateIps.
     */
    public suspend fun getBasicAccelerateIps(
        accelerateIpAddress: String? = null,
        accelerateIpId: String? = null,
        ids: List<String>? = null,
        ipSetId: String,
        outputFile: String? = null,
        status: String? = null,
    ): GetBasicAccelerateIpsResult {
        val argument = GetBasicAccelerateIpsPlainArgs(
            accelerateIpAddress = accelerateIpAddress,
            accelerateIpId = accelerateIpId,
            ids = ids,
            ipSetId = ipSetId,
            outputFile = outputFile,
            status = status,
        )
        return getBasicAccelerateIpsResultToKotlin(getBasicAccelerateIpsPlain(argument.toJava()).await())
    }

    /**
     * @see [getBasicAccelerateIps].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ga&#46;kotlin&#46;inputs&#46;GetBasicAccelerateIpsPlainArgs].
     * @return A collection of values returned by getBasicAccelerateIps.
     */
    public suspend fun getBasicAccelerateIps(argument: suspend GetBasicAccelerateIpsPlainArgsBuilder.() -> Unit): GetBasicAccelerateIpsResult {
        val builder = GetBasicAccelerateIpsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBasicAccelerateIpsResultToKotlin(getBasicAccelerateIpsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Global Accelerator (GA) Basic Accelerators of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.194.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.ga.getBasicAccelerators({
     *     ids: ["example_id"],
     * });
     * export const gaBasicAcceleratorId1 = ids.then(ids => ids.accelerators?.[0]?.id);
     * const nameRegex = alicloud.ga.getBasicAccelerators({
     *     nameRegex: "tf-example",
     * });
     * export const gaBasicAcceleratorId2 = nameRegex.then(nameRegex => nameRegex.accelerators?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.ga.get_basic_accelerators(ids=["example_id"])
     * pulumi.export("gaBasicAcceleratorId1", ids.accelerators[0].id)
     * name_regex = alicloud.ga.get_basic_accelerators(name_regex="tf-example")
     * pulumi.export("gaBasicAcceleratorId2", name_regex.accelerators[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Ga.GetBasicAccelerators.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *     });
     *     var nameRegex = AliCloud.Ga.GetBasicAccelerators.Invoke(new()
     *     {
     *         NameRegex = "tf-example",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["gaBasicAcceleratorId1"] = ids&#46;Apply(getBasicAcceleratorsResult => getBasicAcceleratorsResult&#46;Accelerators[0]?.Id),
     *         ["gaBasicAcceleratorId2"] = nameRegex&#46;Apply(getBasicAcceleratorsResult => getBasicAcceleratorsResult&#46;Accelerators[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ga"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := ga.GetBasicAccelerators(ctx, &ga.GetBasicAcceleratorsArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("gaBasicAcceleratorId1", ids.Accelerators[0].Id)
     * 		nameRegex, err := ga.GetBasicAccelerators(ctx, &ga.GetBasicAcceleratorsArgs{
     * 			NameRegex: pulumi.StringRef("tf-example"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("gaBasicAcceleratorId2", nameRegex.Accelerators[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ga.GaFunctions;
     * import com.pulumi.alicloud.ga.inputs.GetBasicAcceleratorsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = GaFunctions.getBasicAccelerators(GetBasicAcceleratorsArgs.builder()
     *             .ids("example_id")
     *             .build());
     *         ctx.export("gaBasicAcceleratorId1", ids.applyValue(getBasicAcceleratorsResult -> getBasicAcceleratorsResult.accelerators()[0].id()));
     *         final var nameRegex = GaFunctions.getBasicAccelerators(GetBasicAcceleratorsArgs.builder()
     *             .nameRegex("tf-example")
     *             .build());
     *         ctx.export("gaBasicAcceleratorId2", nameRegex.applyValue(getBasicAcceleratorsResult -> getBasicAcceleratorsResult.accelerators()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:ga:getBasicAccelerators
     *       Arguments:
     *         ids:
     *           - example_id
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:ga:getBasicAccelerators
     *       Arguments:
     *         nameRegex: tf-example
     * outputs:
     *   gaBasicAcceleratorId1: ${ids.accelerators[0].id}
     *   gaBasicAcceleratorId2: ${nameRegex.accelerators[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getBasicAccelerators.
     * @return A collection of values returned by getBasicAccelerators.
     */
    public suspend fun getBasicAccelerators(argument: GetBasicAcceleratorsPlainArgs): GetBasicAcceleratorsResult =
        getBasicAcceleratorsResultToKotlin(getBasicAcceleratorsPlain(argument.toJava()).await())

    /**
     * @see [getBasicAccelerators].
     * @param acceleratorId The ID of the Global Accelerator Basic Accelerator instance.
     * @param ids A list of Global Accelerator Basic Accelerator IDs.
     * @param nameRegex A regex string to filter results by Global Accelerator Basic Accelerator name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @param status The status of the Global Accelerator Basic Accelerator instance. Valid Value: `init`, `active`, `configuring`, `binding`, `unbinding`, `deleting`, `finacialLocked`.
     * @return A collection of values returned by getBasicAccelerators.
     */
    public suspend fun getBasicAccelerators(
        acceleratorId: String? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
        status: String? = null,
    ): GetBasicAcceleratorsResult {
        val argument = GetBasicAcceleratorsPlainArgs(
            acceleratorId = acceleratorId,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
            status = status,
        )
        return getBasicAcceleratorsResultToKotlin(getBasicAcceleratorsPlain(argument.toJava()).await())
    }

    /**
     * @see [getBasicAccelerators].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ga&#46;kotlin&#46;inputs&#46;GetBasicAcceleratorsPlainArgs].
     * @return A collection of values returned by getBasicAccelerators.
     */
    public suspend fun getBasicAccelerators(argument: suspend GetBasicAcceleratorsPlainArgsBuilder.() -> Unit): GetBasicAcceleratorsResult {
        val builder = GetBasicAcceleratorsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBasicAcceleratorsResultToKotlin(getBasicAcceleratorsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Global Accelerator (GA) Basic Endpoints of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.194.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.ga.getBasicEndpoints({
     *     ids: ["example_id"],
     *     endpointGroupId: "example_id",
     * });
     * export const gaBasicEndpointsId1 = ids.then(ids => ids.endpoints?.[0]?.id);
     * const nameRegex = alicloud.ga.getBasicEndpoints({
     *     nameRegex: "tf-example",
     *     endpointGroupId: "example_id",
     * });
     * export const gaBasicEndpointsId2 = nameRegex.then(nameRegex => nameRegex.endpoints?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.ga.get_basic_endpoints(ids=["example_id"],
     *     endpoint_group_id="example_id")
     * pulumi.export("gaBasicEndpointsId1", ids.endpoints[0].id)
     * name_regex = alicloud.ga.get_basic_endpoints(name_regex="tf-example",
     *     endpoint_group_id="example_id")
     * pulumi.export("gaBasicEndpointsId2", name_regex.endpoints[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Ga.GetBasicEndpoints.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *         EndpointGroupId = "example_id",
     *     });
     *     var nameRegex = AliCloud.Ga.GetBasicEndpoints.Invoke(new()
     *     {
     *         NameRegex = "tf-example",
     *         EndpointGroupId = "example_id",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["gaBasicEndpointsId1"] = ids&#46;Apply(getBasicEndpointsResult => getBasicEndpointsResult&#46;Endpoints[0]?.Id),
     *         ["gaBasicEndpointsId2"] = nameRegex&#46;Apply(getBasicEndpointsResult => getBasicEndpointsResult&#46;Endpoints[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ga"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := ga.GetBasicEndpoints(ctx, &ga.GetBasicEndpointsArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 			EndpointGroupId: "example_id",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("gaBasicEndpointsId1", ids.Endpoints[0].Id)
     * 		nameRegex, err := ga.GetBasicEndpoints(ctx, &ga.GetBasicEndpointsArgs{
     * 			NameRegex:       pulumi.StringRef("tf-example"),
     * 			EndpointGroupId: "example_id",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("gaBasicEndpointsId2", nameRegex.Endpoints[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ga.GaFunctions;
     * import com.pulumi.alicloud.ga.inputs.GetBasicEndpointsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = GaFunctions.getBasicEndpoints(GetBasicEndpointsArgs.builder()
     *             .ids("example_id")
     *             .endpointGroupId("example_id")
     *             .build());
     *         ctx.export("gaBasicEndpointsId1", ids.applyValue(getBasicEndpointsResult -> getBasicEndpointsResult.endpoints()[0].id()));
     *         final var nameRegex = GaFunctions.getBasicEndpoints(GetBasicEndpointsArgs.builder()
     *             .nameRegex("tf-example")
     *             .endpointGroupId("example_id")
     *             .build());
     *         ctx.export("gaBasicEndpointsId2", nameRegex.applyValue(getBasicEndpointsResult -> getBasicEndpointsResult.endpoints()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:ga:getBasicEndpoints
     *       Arguments:
     *         ids:
     *           - example_id
     *         endpointGroupId: example_id
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:ga:getBasicEndpoints
     *       Arguments:
     *         nameRegex: tf-example
     *         endpointGroupId: example_id
     * outputs:
     *   gaBasicEndpointsId1: ${ids.endpoints[0].id}
     *   gaBasicEndpointsId2: ${nameRegex.endpoints[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getBasicEndpoints.
     * @return A collection of values returned by getBasicEndpoints.
     */
    public suspend fun getBasicEndpoints(argument: GetBasicEndpointsPlainArgs): GetBasicEndpointsResult =
        getBasicEndpointsResultToKotlin(getBasicEndpointsPlain(argument.toJava()).await())

    /**
     * @see [getBasicEndpoints].
     * @param endpointGroupId The ID of the Basic Endpoint Group.
     * @param endpointId The ID of the Basic Endpoint.
     * @param endpointType The type of the Basic Endpoint. Valid values: `ENI`, `SLB`, `ECS` and `NLB`.
     * @param ids A list of Global Accelerator Basic Endpoints IDs.
     * @param name The name of the Basic Endpoint.
     * @param nameRegex A regex string to filter results by Global Accelerator Basic Endpoints name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the Global Accelerator Basic Endpoint. Valid Value: `init`, `active`, `updating`, `binding`, `unbinding`, `deleting`, `bound`.
     * @return A collection of values returned by getBasicEndpoints.
     */
    public suspend fun getBasicEndpoints(
        endpointGroupId: String,
        endpointId: String? = null,
        endpointType: String? = null,
        ids: List<String>? = null,
        name: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetBasicEndpointsResult {
        val argument = GetBasicEndpointsPlainArgs(
            endpointGroupId = endpointGroupId,
            endpointId = endpointId,
            endpointType = endpointType,
            ids = ids,
            name = name,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
        )
        return getBasicEndpointsResultToKotlin(getBasicEndpointsPlain(argument.toJava()).await())
    }

    /**
     * @see [getBasicEndpoints].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ga&#46;kotlin&#46;inputs&#46;GetBasicEndpointsPlainArgs].
     * @return A collection of values returned by getBasicEndpoints.
     */
    public suspend fun getBasicEndpoints(argument: suspend GetBasicEndpointsPlainArgsBuilder.() -> Unit): GetBasicEndpointsResult {
        val builder = GetBasicEndpointsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBasicEndpointsResultToKotlin(getBasicEndpointsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Global Accelerator (GA) Custom Routing Endpoint Group Destinations of the current Alibaba Cloud user.
     * > **NOTE:** Available in 1.197.0+
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.ga.getCustomRoutingEndpointGroupDestinations({
     *     ids: ["example_id"],
     *     acceleratorId: "your_accelerator_id",
     * });
     * export const gaCustomRoutingEndpointGroupDestinationsId1 = ids.then(ids => ids.customRoutingEndpointGroupDestinations?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.ga.get_custom_routing_endpoint_group_destinations(ids=["example_id"],
     *     accelerator_id="your_accelerator_id")
     * pulumi.export("gaCustomRoutingEndpointGroupDestinationsId1", ids.custom_routing_endpoint_group_destinations[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Ga.GetCustomRoutingEndpointGroupDestinations.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *         AcceleratorId = "your_accelerator_id",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["gaCustomRoutingEndpointGroupDestinationsId1"] = ids&#46;Apply(getCustomRoutingEndpointGroupDestinationsResult => getCustomRoutingEndpointGroupDestinationsResult&#46;CustomRoutingEndpointGroupDestinations[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ga"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := ga.GetCustomRoutingEndpointGroupDestinations(ctx, &ga.GetCustomRoutingEndpointGroupDestinationsArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 			AcceleratorId: "your_accelerator_id",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("gaCustomRoutingEndpointGroupDestinationsId1", ids.CustomRoutingEndpointGroupDestinations[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ga.GaFunctions;
     * import com.pulumi.alicloud.ga.inputs.GetCustomRoutingEndpointGroupDestinationsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = GaFunctions.getCustomRoutingEndpointGroupDestinations(GetCustomRoutingEndpointGroupDestinationsArgs.builder()
     *             .ids("example_id")
     *             .acceleratorId("your_accelerator_id")
     *             .build());
     *         ctx.export("gaCustomRoutingEndpointGroupDestinationsId1", ids.applyValue(getCustomRoutingEndpointGroupDestinationsResult -> getCustomRoutingEndpointGroupDestinationsResult.customRoutingEndpointGroupDestinations()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:ga:getCustomRoutingEndpointGroupDestinations
     *       Arguments:
     *         ids:
     *           - example_id
     *         acceleratorId: your_accelerator_id
     * outputs:
     *   gaCustomRoutingEndpointGroupDestinationsId1: ${ids.customRoutingEndpointGroupDestinations[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getCustomRoutingEndpointGroupDestinations.
     * @return A collection of values returned by getCustomRoutingEndpointGroupDestinations.
     */
    public suspend fun getCustomRoutingEndpointGroupDestinations(argument: GetCustomRoutingEndpointGroupDestinationsPlainArgs): GetCustomRoutingEndpointGroupDestinationsResult =
        getCustomRoutingEndpointGroupDestinationsResultToKotlin(getCustomRoutingEndpointGroupDestinationsPlain(argument.toJava()).await())

    /**
     * @see [getCustomRoutingEndpointGroupDestinations].
     * @param acceleratorId The ID of the GA instance.
     * @param endpointGroupId The ID of the endpoint group.
     * @param fromPort The start port of the backend service port range of the endpoint group. The `from_port` value must be smaller than or equal to the `to_port` value. Valid values: `1` to `65499`.
     * @param ids A list of Custom Routing Endpoint Group Destination IDs.
     * @param listenerId The ID of the listener.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @param protocols The backend service protocol of the endpoint group. Valid values: `TCP`, `UDP`, `TCP, UDP`.
     * @param toPort The end port of the backend service port range of the endpoint group. The `from_port` value must be smaller than or equal to the `to_port` value. Valid values: `1` to `65499`.
     * @return A collection of values returned by getCustomRoutingEndpointGroupDestinations.
     */
    public suspend fun getCustomRoutingEndpointGroupDestinations(
        acceleratorId: String,
        endpointGroupId: String? = null,
        fromPort: Int? = null,
        ids: List<String>? = null,
        listenerId: String? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
        protocols: List<String>? = null,
        toPort: Int? = null,
    ): GetCustomRoutingEndpointGroupDestinationsResult {
        val argument = GetCustomRoutingEndpointGroupDestinationsPlainArgs(
            acceleratorId = acceleratorId,
            endpointGroupId = endpointGroupId,
            fromPort = fromPort,
            ids = ids,
            listenerId = listenerId,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
            protocols = protocols,
            toPort = toPort,
        )
        return getCustomRoutingEndpointGroupDestinationsResultToKotlin(getCustomRoutingEndpointGroupDestinationsPlain(argument.toJava()).await())
    }

    /**
     * @see [getCustomRoutingEndpointGroupDestinations].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ga&#46;kotlin&#46;inputs&#46;GetCustomRoutingEndpointGroupDestinationsPlainArgs].
     * @return A collection of values returned by getCustomRoutingEndpointGroupDestinations.
     */
    public suspend fun getCustomRoutingEndpointGroupDestinations(argument: suspend GetCustomRoutingEndpointGroupDestinationsPlainArgsBuilder.() -> Unit): GetCustomRoutingEndpointGroupDestinationsResult {
        val builder = GetCustomRoutingEndpointGroupDestinationsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCustomRoutingEndpointGroupDestinationsResultToKotlin(getCustomRoutingEndpointGroupDestinationsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Global Accelerator (GA) Custom Routing Endpoint Groups of the current Alibaba Cloud user.
     * > **NOTE:** Available in 1.197.0+
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.ga.getCustomRoutingEndpointGroups({
     *     ids: ["example_id"],
     *     acceleratorId: "your_accelerator_id",
     * });
     * export const gaCustomRoutingEndpointGroupsId1 = ids.then(ids => ids.groups?.[0]?.id);
     * const nameRegex = alicloud.ga.getCustomRoutingEndpointGroups({
     *     nameRegex: "tf-example",
     *     acceleratorId: "your_accelerator_id",
     * });
     * export const gaCustomRoutingEndpointGroupsId2 = nameRegex.then(nameRegex => nameRegex.groups?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.ga.get_custom_routing_endpoint_groups(ids=["example_id"],
     *     accelerator_id="your_accelerator_id")
     * pulumi.export("gaCustomRoutingEndpointGroupsId1", ids.groups[0].id)
     * name_regex = alicloud.ga.get_custom_routing_endpoint_groups(name_regex="tf-example",
     *     accelerator_id="your_accelerator_id")
     * pulumi.export("gaCustomRoutingEndpointGroupsId2", name_regex.groups[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Ga.GetCustomRoutingEndpointGroups.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *         AcceleratorId = "your_accelerator_id",
     *     });
     *     var nameRegex = AliCloud.Ga.GetCustomRoutingEndpointGroups.Invoke(new()
     *     {
     *         NameRegex = "tf-example",
     *         AcceleratorId = "your_accelerator_id",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["gaCustomRoutingEndpointGroupsId1"] = ids&#46;Apply(getCustomRoutingEndpointGroupsResult => getCustomRoutingEndpointGroupsResult&#46;Groups[0]?.Id),
     *         ["gaCustomRoutingEndpointGroupsId2"] = nameRegex&#46;Apply(getCustomRoutingEndpointGroupsResult => getCustomRoutingEndpointGroupsResult&#46;Groups[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ga"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := ga.GetCustomRoutingEndpointGroups(ctx, &ga.GetCustomRoutingEndpointGroupsArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 			AcceleratorId: "your_accelerator_id",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("gaCustomRoutingEndpointGroupsId1", ids.Groups[0].Id)
     * 		nameRegex, err := ga.GetCustomRoutingEndpointGroups(ctx, &ga.GetCustomRoutingEndpointGroupsArgs{
     * 			NameRegex:     pulumi.StringRef("tf-example"),
     * 			AcceleratorId: "your_accelerator_id",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("gaCustomRoutingEndpointGroupsId2", nameRegex.Groups[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ga.GaFunctions;
     * import com.pulumi.alicloud.ga.inputs.GetCustomRoutingEndpointGroupsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = GaFunctions.getCustomRoutingEndpointGroups(GetCustomRoutingEndpointGroupsArgs.builder()
     *             .ids("example_id")
     *             .acceleratorId("your_accelerator_id")
     *             .build());
     *         ctx.export("gaCustomRoutingEndpointGroupsId1", ids.applyValue(getCustomRoutingEndpointGroupsResult -> getCustomRoutingEndpointGroupsResult.groups()[0].id()));
     *         final var nameRegex = GaFunctions.getCustomRoutingEndpointGroups(GetCustomRoutingEndpointGroupsArgs.builder()
     *             .nameRegex("tf-example")
     *             .acceleratorId("your_accelerator_id")
     *             .build());
     *         ctx.export("gaCustomRoutingEndpointGroupsId2", nameRegex.applyValue(getCustomRoutingEndpointGroupsResult -> getCustomRoutingEndpointGroupsResult.groups()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:ga:getCustomRoutingEndpointGroups
     *       Arguments:
     *         ids:
     *           - example_id
     *         acceleratorId: your_accelerator_id
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:ga:getCustomRoutingEndpointGroups
     *       Arguments:
     *         nameRegex: tf-example
     *         acceleratorId: your_accelerator_id
     * outputs:
     *   gaCustomRoutingEndpointGroupsId1: ${ids.groups[0].id}
     *   gaCustomRoutingEndpointGroupsId2: ${nameRegex.groups[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getCustomRoutingEndpointGroups.
     * @return A collection of values returned by getCustomRoutingEndpointGroups.
     */
    public suspend fun getCustomRoutingEndpointGroups(argument: GetCustomRoutingEndpointGroupsPlainArgs): GetCustomRoutingEndpointGroupsResult =
        getCustomRoutingEndpointGroupsResultToKotlin(getCustomRoutingEndpointGroupsPlain(argument.toJava()).await())

    /**
     * @see [getCustomRoutingEndpointGroups].
     * @param acceleratorId The ID of the GA instance.
     * @param endpointGroupId The ID of the endpoint group.
     * @param ids A list of Custom Routing Endpoint Group IDs.
     * @param listenerId The ID of the custom routing listener.
     * @param nameRegex A regex string to filter results by Custom Routing Endpoint Group name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @param status The status of the endpoint group. Valid Values: `init`, `active`, `updating`, `deleting`.
     * @return A collection of values returned by getCustomRoutingEndpointGroups.
     */
    public suspend fun getCustomRoutingEndpointGroups(
        acceleratorId: String,
        endpointGroupId: String? = null,
        ids: List<String>? = null,
        listenerId: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
        status: String? = null,
    ): GetCustomRoutingEndpointGroupsResult {
        val argument = GetCustomRoutingEndpointGroupsPlainArgs(
            acceleratorId = acceleratorId,
            endpointGroupId = endpointGroupId,
            ids = ids,
            listenerId = listenerId,
            nameRegex = nameRegex,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
            status = status,
        )
        return getCustomRoutingEndpointGroupsResultToKotlin(getCustomRoutingEndpointGroupsPlain(argument.toJava()).await())
    }

    /**
     * @see [getCustomRoutingEndpointGroups].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ga&#46;kotlin&#46;inputs&#46;GetCustomRoutingEndpointGroupsPlainArgs].
     * @return A collection of values returned by getCustomRoutingEndpointGroups.
     */
    public suspend fun getCustomRoutingEndpointGroups(argument: suspend GetCustomRoutingEndpointGroupsPlainArgsBuilder.() -> Unit): GetCustomRoutingEndpointGroupsResult {
        val builder = GetCustomRoutingEndpointGroupsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCustomRoutingEndpointGroupsResultToKotlin(getCustomRoutingEndpointGroupsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Global Accelerator (GA) Custom Routing Endpoint Traffic Policies of the current Alibaba Cloud user.
     * > **NOTE:** Available in 1.197.0+
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.ga.getCustomRoutingEndpointTrafficPolicies({
     *     ids: ["example_id"],
     *     acceleratorId: "your_accelerator_id",
     * });
     * export const gaCustomRoutingEndpointTrafficPoliciesId1 = ids.then(ids => ids.customRoutingEndpointTrafficPolicies?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.ga.get_custom_routing_endpoint_traffic_policies(ids=["example_id"],
     *     accelerator_id="your_accelerator_id")
     * pulumi.export("gaCustomRoutingEndpointTrafficPoliciesId1", ids.custom_routing_endpoint_traffic_policies[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Ga.GetCustomRoutingEndpointTrafficPolicies.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *         AcceleratorId = "your_accelerator_id",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["gaCustomRoutingEndpointTrafficPoliciesId1"] = ids&#46;Apply(getCustomRoutingEndpointTrafficPoliciesResult => getCustomRoutingEndpointTrafficPoliciesResult&#46;CustomRoutingEndpointTrafficPolicies[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ga"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := ga.GetCustomRoutingEndpointTrafficPolicies(ctx, &ga.GetCustomRoutingEndpointTrafficPoliciesArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 			AcceleratorId: "your_accelerator_id",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("gaCustomRoutingEndpointTrafficPoliciesId1", ids.CustomRoutingEndpointTrafficPolicies[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ga.GaFunctions;
     * import com.pulumi.alicloud.ga.inputs.GetCustomRoutingEndpointTrafficPoliciesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = GaFunctions.getCustomRoutingEndpointTrafficPolicies(GetCustomRoutingEndpointTrafficPoliciesArgs.builder()
     *             .ids("example_id")
     *             .acceleratorId("your_accelerator_id")
     *             .build());
     *         ctx.export("gaCustomRoutingEndpointTrafficPoliciesId1", ids.applyValue(getCustomRoutingEndpointTrafficPoliciesResult -> getCustomRoutingEndpointTrafficPoliciesResult.customRoutingEndpointTrafficPolicies()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:ga:getCustomRoutingEndpointTrafficPolicies
     *       Arguments:
     *         ids:
     *           - example_id
     *         acceleratorId: your_accelerator_id
     * outputs:
     *   gaCustomRoutingEndpointTrafficPoliciesId1: ${ids.customRoutingEndpointTrafficPolicies[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getCustomRoutingEndpointTrafficPolicies.
     * @return A collection of values returned by getCustomRoutingEndpointTrafficPolicies.
     */
    public suspend fun getCustomRoutingEndpointTrafficPolicies(argument: GetCustomRoutingEndpointTrafficPoliciesPlainArgs): GetCustomRoutingEndpointTrafficPoliciesResult =
        getCustomRoutingEndpointTrafficPoliciesResultToKotlin(getCustomRoutingEndpointTrafficPoliciesPlain(argument.toJava()).await())

    /**
     * @see [getCustomRoutingEndpointTrafficPolicies].
     * @param acceleratorId The ID of the GA instance to which the traffic policies belong.
     * @param address The IP addresses of the traffic policies.
     * @param endpointGroupId The ID of the endpoint group to which the traffic policies belong.
     * @param endpointId The ID of the endpoint to which the traffic policies belong.
     * @param ids A list of Custom Routing Endpoint Traffic Policy IDs.
     * @param listenerId The ID of the listener to which the traffic policies belong.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @return A collection of values returned by getCustomRoutingEndpointTrafficPolicies.
     */
    public suspend fun getCustomRoutingEndpointTrafficPolicies(
        acceleratorId: String,
        address: String? = null,
        endpointGroupId: String? = null,
        endpointId: String? = null,
        ids: List<String>? = null,
        listenerId: String? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
    ): GetCustomRoutingEndpointTrafficPoliciesResult {
        val argument = GetCustomRoutingEndpointTrafficPoliciesPlainArgs(
            acceleratorId = acceleratorId,
            address = address,
            endpointGroupId = endpointGroupId,
            endpointId = endpointId,
            ids = ids,
            listenerId = listenerId,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
        )
        return getCustomRoutingEndpointTrafficPoliciesResultToKotlin(getCustomRoutingEndpointTrafficPoliciesPlain(argument.toJava()).await())
    }

    /**
     * @see [getCustomRoutingEndpointTrafficPolicies].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ga&#46;kotlin&#46;inputs&#46;GetCustomRoutingEndpointTrafficPoliciesPlainArgs].
     * @return A collection of values returned by getCustomRoutingEndpointTrafficPolicies.
     */
    public suspend fun getCustomRoutingEndpointTrafficPolicies(argument: suspend GetCustomRoutingEndpointTrafficPoliciesPlainArgsBuilder.() -> Unit): GetCustomRoutingEndpointTrafficPoliciesResult {
        val builder = GetCustomRoutingEndpointTrafficPoliciesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCustomRoutingEndpointTrafficPoliciesResultToKotlin(getCustomRoutingEndpointTrafficPoliciesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Global Accelerator (GA) Custom Routing Endpoints of the current Alibaba Cloud user.
     * > **NOTE:** Available in 1.197.0+
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.ga.getCustomRoutingEndpoints({
     *     ids: ["example_id"],
     *     acceleratorId: "your_accelerator_id",
     * });
     * export const gaCustomRoutingEndpointsId1 = ids.then(ids => ids.customRoutingEndpoints?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.ga.get_custom_routing_endpoints(ids=["example_id"],
     *     accelerator_id="your_accelerator_id")
     * pulumi.export("gaCustomRoutingEndpointsId1", ids.custom_routing_endpoints[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Ga.GetCustomRoutingEndpoints.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *         AcceleratorId = "your_accelerator_id",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["gaCustomRoutingEndpointsId1"] = ids&#46;Apply(getCustomRoutingEndpointsResult => getCustomRoutingEndpointsResult&#46;CustomRoutingEndpoints[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ga"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := ga.GetCustomRoutingEndpoints(ctx, &ga.GetCustomRoutingEndpointsArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 			AcceleratorId: "your_accelerator_id",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("gaCustomRoutingEndpointsId1", ids.CustomRoutingEndpoints[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ga.GaFunctions;
     * import com.pulumi.alicloud.ga.inputs.GetCustomRoutingEndpointsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = GaFunctions.getCustomRoutingEndpoints(GetCustomRoutingEndpointsArgs.builder()
     *             .ids("example_id")
     *             .acceleratorId("your_accelerator_id")
     *             .build());
     *         ctx.export("gaCustomRoutingEndpointsId1", ids.applyValue(getCustomRoutingEndpointsResult -> getCustomRoutingEndpointsResult.customRoutingEndpoints()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:ga:getCustomRoutingEndpoints
     *       Arguments:
     *         ids:
     *           - example_id
     *         acceleratorId: your_accelerator_id
     * outputs:
     *   gaCustomRoutingEndpointsId1: ${ids.customRoutingEndpoints[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getCustomRoutingEndpoints.
     * @return A collection of values returned by getCustomRoutingEndpoints.
     */
    public suspend fun getCustomRoutingEndpoints(argument: GetCustomRoutingEndpointsPlainArgs): GetCustomRoutingEndpointsResult =
        getCustomRoutingEndpointsResultToKotlin(getCustomRoutingEndpointsPlain(argument.toJava()).await())

    /**
     * @see [getCustomRoutingEndpoints].
     * @param acceleratorId The ID of the GA instance.
     * @param endpointGroupId The ID of the endpoint group.
     * @param ids A list of Custom Routing Endpoint IDs.
     * @param listenerId The ID of the custom routing listener.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @return A collection of values returned by getCustomRoutingEndpoints.
     */
    public suspend fun getCustomRoutingEndpoints(
        acceleratorId: String,
        endpointGroupId: String? = null,
        ids: List<String>? = null,
        listenerId: String? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
    ): GetCustomRoutingEndpointsResult {
        val argument = GetCustomRoutingEndpointsPlainArgs(
            acceleratorId = acceleratorId,
            endpointGroupId = endpointGroupId,
            ids = ids,
            listenerId = listenerId,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
        )
        return getCustomRoutingEndpointsResultToKotlin(getCustomRoutingEndpointsPlain(argument.toJava()).await())
    }

    /**
     * @see [getCustomRoutingEndpoints].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ga&#46;kotlin&#46;inputs&#46;GetCustomRoutingEndpointsPlainArgs].
     * @return A collection of values returned by getCustomRoutingEndpoints.
     */
    public suspend fun getCustomRoutingEndpoints(argument: suspend GetCustomRoutingEndpointsPlainArgsBuilder.() -> Unit): GetCustomRoutingEndpointsResult {
        val builder = GetCustomRoutingEndpointsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCustomRoutingEndpointsResultToKotlin(getCustomRoutingEndpointsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Global Accelerator (GA) Custom Routing Port Mappings of the current Alibaba Cloud user.
     * > **NOTE:** Available in 1.197.0+
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.ga.getCustomRoutingPortMappings({
     *     acceleratorId: "your_accelerator_id",
     * });
     * export const gaCustomRoutingPortMappingsAcceleratorId1 = _default.then(_default => _default.customRoutingPortMappings?.[0]?.acceleratorId);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.ga.get_custom_routing_port_mappings(accelerator_id="your_accelerator_id")
     * pulumi.export("gaCustomRoutingPortMappingsAcceleratorId1", default.custom_routing_port_mappings[0].accelerator_id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Ga.GetCustomRoutingPortMappings.Invoke(new()
     *     {
     *         AcceleratorId = "your_accelerator_id",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["gaCustomRoutingPortMappingsAcceleratorId1"] = @default&#46;Apply(@default => @default&#46;Apply(getCustomRoutingPortMappingsResult => getCustomRoutingPortMappingsResult&#46;CustomRoutingPortMappings[0]?.AcceleratorId)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ga"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := ga.GetCustomRoutingPortMappings(ctx, &ga.GetCustomRoutingPortMappingsArgs{
     * 			AcceleratorId: "your_accelerator_id",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("gaCustomRoutingPortMappingsAcceleratorId1", _default.CustomRoutingPortMappings[0].AcceleratorId)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ga.GaFunctions;
     * import com.pulumi.alicloud.ga.inputs.GetCustomRoutingPortMappingsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = GaFunctions.getCustomRoutingPortMappings(GetCustomRoutingPortMappingsArgs.builder()
     *             .acceleratorId("your_accelerator_id")
     *             .build());
     *         ctx.export("gaCustomRoutingPortMappingsAcceleratorId1", default_.customRoutingPortMappings()[0].acceleratorId());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:ga:getCustomRoutingPortMappings
     *       Arguments:
     *         acceleratorId: your_accelerator_id
     * outputs:
     *   gaCustomRoutingPortMappingsAcceleratorId1: ${default.customRoutingPortMappings[0].acceleratorId}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getCustomRoutingPortMappings.
     * @return A collection of values returned by getCustomRoutingPortMappings.
     */
    public suspend fun getCustomRoutingPortMappings(argument: GetCustomRoutingPortMappingsPlainArgs): GetCustomRoutingPortMappingsResult =
        getCustomRoutingPortMappingsResultToKotlin(getCustomRoutingPortMappingsPlain(argument.toJava()).await())

    /**
     * @see [getCustomRoutingPortMappings].
     * @param acceleratorId The ID of the GA instance.
     * @param endpointGroupId The ID of the endpoint group.
     * @param listenerId The ID of the listener.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @param status The access policy of traffic for the backend instance. Valid Values: `allow`, `deny`.
     * @return A collection of values returned by getCustomRoutingPortMappings.
     */
    public suspend fun getCustomRoutingPortMappings(
        acceleratorId: String,
        endpointGroupId: String? = null,
        listenerId: String? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
        status: String? = null,
    ): GetCustomRoutingPortMappingsResult {
        val argument = GetCustomRoutingPortMappingsPlainArgs(
            acceleratorId = acceleratorId,
            endpointGroupId = endpointGroupId,
            listenerId = listenerId,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
            status = status,
        )
        return getCustomRoutingPortMappingsResultToKotlin(getCustomRoutingPortMappingsPlain(argument.toJava()).await())
    }

    /**
     * @see [getCustomRoutingPortMappings].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ga&#46;kotlin&#46;inputs&#46;GetCustomRoutingPortMappingsPlainArgs].
     * @return A collection of values returned by getCustomRoutingPortMappings.
     */
    public suspend fun getCustomRoutingPortMappings(argument: suspend GetCustomRoutingPortMappingsPlainArgsBuilder.() -> Unit): GetCustomRoutingPortMappingsResult {
        val builder = GetCustomRoutingPortMappingsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCustomRoutingPortMappingsResultToKotlin(getCustomRoutingPortMappingsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides Ga Domain available to the user.[What is Domain](https://www.alibabacloud.com/help/en/global-accelerator/latest/createdomain)
     * > **NOTE:** Available in 1.197.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * export = async () => {
     *     const default = await alicloud.ga.getAccelerators({
     *         status: "active",
     *     });
     *     const defaultAccelerator: alicloud.ga.Accelerator[] = [];
     *     for (const range = {value: 0}; range.value < (_default.accelerators.length > 0 ? 0 : 1); range.value++) {
     *         defaultAccelerator.push(new alicloud.ga.Accelerator(`default-${range.value}`, {
     *             duration: 1,
     *             autoUseCoupon: true,
     *             spec: "1",
     *         }));
     *     }
     *     const acceleratorId = _default.accelerators.length > 0 ? _default.accelerators?.[0]?&#46;id : defaultAccelerator[0].id;
     *     const defaultGetDomains = await alicloud.ga.getDomains({
     *         acceleratorId: acceleratorIdLocals,
     *         domain: "your_domain",
     *     });
     *     return {
     *         alicloudGaDomainExampleId: defaultGetDomains.domains?.[0]?.id,
     *     };
     * }
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.ga.get_accelerators(status="active")
     * default_accelerator = []
     * for range in [{"value": i} for i in range(0, 0 if len(default&#46;accelerators) > 0 else 1)]:
     *     default_accelerator.append(alicloud.ga.Accelerator(f"default-{range['value']}",
     *         duration=1,
     *         auto_use_coupon=True,
     *         spec="1"))
     * accelerator_id = default.accelerators[0]&#46;id if len(default&#46;accelerators) > 0 else default_accelerator[0].id
     * default_get_domains = alicloud.ga.get_domains(accelerator_id=accelerator_id_locals,
     *     domain="your_domain")
     * pulumi.export("alicloudGaDomainExampleId", default_get_domains.domains[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using System.Threading.Tasks;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(async() =>
     * {
     *     var @default = await AliCloud.Ga.GetAccelerators.InvokeAsync(new()
     *     {
     *         Status = "active",
     *     });
     *     var defaultAccelerator = new List<AliCloud.Ga.Accelerator>();
     *     for (var rangeIndex = 0; rangeIndex < @default.Accelerators.Length > 0 ? 0 : 1; rangeIndex++)
     *     {
     *         var range = new { Value = rangeIndex };
     *         defaultAccelerator.Add(new AliCloud.Ga.Accelerator($"default-{range.Value}", new()
     *         {
     *             Duration = 1,
     *             AutoUseCoupon = true,
     *             Spec = "1",
     *         }));
     *     }
     *     var acceleratorId = @default.Accelerators.Length > 0 ? @default.Accelerators[0]?&#46;Id : defaultAccelerator[0].Id;
     *     var defaultGetDomains = await AliCloud.Ga.GetDomains.InvokeAsync(new()
     *     {
     *         AcceleratorId = acceleratorIdLocals,
     *         Domain = "your_domain",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["alicloudGaDomainExampleId"] = defaultGetDomains&#46;Domains[0]?.Id,
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ga"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := ga.GetAccelerators(ctx, &ga.GetAcceleratorsArgs{
     * 			Status: pulumi.StringRef("active"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		var tmp0 float64
     * 		if pulumi.Float64(len(_default.Accelerators)) > 0 {
     * 			tmp0 = 0
     * 		} else {
     * 			tmp0 = 1
     * 		}
     * 		var defaultAccelerator []*ga.Accelerator
     * 		for index := 0; index < tmp0; index++ {
     * 			key0 := index
     * 			_ := index
     * 			__res, err := ga.NewAccelerator(ctx, fmt.Sprintf("default-%v", key0), &ga.AcceleratorArgs{
     * 				Duration:      pulumi.Int(1),
     * 				AutoUseCoupon: pulumi.Bool(true),
     * 				Spec:          pulumi.String("1"),
     * 			})
     * 			if err != nil {
     * 				return err
     * 			}
     * 			defaultAccelerator = append(defaultAccelerator, __res)
     * 		}
     * 		var tmp1 *string
     * 		if pulumi.Float64(len(_default.Accelerators)) > 0 {
     * 			tmp1 = _default.Accelerators[0].Id
     * 		} else {
     * 			tmp1 = defaultAccelerator[0].ID()
     * 		}
     * 		_ := tmp1
     * 		defaultGetDomains, err := ga.GetDomains(ctx, &ga.GetDomainsArgs{
     * 			AcceleratorId: pulumi.StringRef(acceleratorIdLocals),
     * 			Domain:        pulumi.StringRef("your_domain"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("alicloudGaDomainExampleId", defaultGetDomains.Domains[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ga.GaFunctions;
     * import com.pulumi.alicloud.ga.inputs.GetAcceleratorsArgs;
     * import com.pulumi.alicloud.ga.Accelerator;
     * import com.pulumi.alicloud.ga.AcceleratorArgs;
     * import com.pulumi.alicloud.ga.inputs.GetDomainsArgs;
     * import com.pulumi.codegen.internal.KeyedValue;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = GaFunctions.getAccelerators(GetAcceleratorsArgs.builder()
     *             .status("active")
     *             .build());
     *         for (var i = 0; i < default_.accelerators().length() > 0 ? 0 : 1; i++) {
     *             new Accelerator("defaultAccelerator-" + i, AcceleratorArgs.builder()
     *                 .duration(1)
     *                 .autoUseCoupon(true)
     *                 .spec("1")
     *                 .build());
     * }
     *         final var acceleratorId = default_.accelerators().length() > 0 ? default_.accelerators()[0]&#46;id() : defaultAccelerator[0].id();
     *         final var defaultGetDomains = GaFunctions.getDomains(GetDomainsArgs.builder()
     *             .acceleratorId(acceleratorIdLocals)
     *             .domain("your_domain")
     *             .build());
     *         ctx.export("alicloudGaDomainExampleId", defaultGetDomains.applyValue(getDomainsResult -> getDomainsResult.domains()[0].id()));
     *     }
     * }
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getDomains.
     * @return A collection of values returned by getDomains.
     */
    public suspend fun getDomains(argument: GetDomainsPlainArgs): GetDomainsResult =
        getDomainsResultToKotlin(getDomainsPlain(argument.toJava()).await())

    /**
     * @see [getDomains].
     * @param acceleratorId The ID of the global acceleration instance.
     * @param domain The accelerated domain name to be added. only top-level domain names are supported, such as 'example.com'.
     * @param ids A list of Ga Domain IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @param status The status of the resource. Valid values: `illegal`, `inactive`, `active`, `unknown`.
     * @return A collection of values returned by getDomains.
     */
    public suspend fun getDomains(
        acceleratorId: String? = null,
        domain: String? = null,
        ids: List<String>? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
        status: String? = null,
    ): GetDomainsResult {
        val argument = GetDomainsPlainArgs(
            acceleratorId = acceleratorId,
            domain = domain,
            ids = ids,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
            status = status,
        )
        return getDomainsResultToKotlin(getDomainsPlain(argument.toJava()).await())
    }

    /**
     * @see [getDomains].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ga&#46;kotlin&#46;inputs&#46;GetDomainsPlainArgs].
     * @return A collection of values returned by getDomains.
     */
    public suspend fun getDomains(argument: suspend GetDomainsPlainArgsBuilder.() -> Unit): GetDomainsResult {
        val builder = GetDomainsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDomainsResultToKotlin(getDomainsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Global Accelerator (GA) Endpoint Group Ip Address Cidr Blocks of the current Alibaba Cloud user.
     * > **NOTE:** Available since v1.213.0.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.ga.getEndpointGroupIpAddressCidrBlocks({
     *     endpointGroupRegion: "cn-hangzhou",
     * });
     * export const gaEndpointGroupIpAddressCidrBlocksEndpointGroupRegion = _default.then(_default => _default.endpointGroupIpAddressCidrBlocks?.[0]?.endpointGroupRegion);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.ga.get_endpoint_group_ip_address_cidr_blocks(endpoint_group_region="cn-hangzhou")
     * pulumi.export("gaEndpointGroupIpAddressCidrBlocksEndpointGroupRegion", default.endpoint_group_ip_address_cidr_blocks[0].endpoint_group_region)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Ga.GetEndpointGroupIpAddressCidrBlocks.Invoke(new()
     *     {
     *         EndpointGroupRegion = "cn-hangzhou",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["gaEndpointGroupIpAddressCidrBlocksEndpointGroupRegion"] = @default&#46;Apply(@default => @default&#46;Apply(getEndpointGroupIpAddressCidrBlocksResult => getEndpointGroupIpAddressCidrBlocksResult&#46;EndpointGroupIpAddressCidrBlocks[0]?.EndpointGroupRegion)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ga"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := ga.GetEndpointGroupIpAddressCidrBlocks(ctx, &ga.GetEndpointGroupIpAddressCidrBlocksArgs{
     * 			EndpointGroupRegion: "cn-hangzhou",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("gaEndpointGroupIpAddressCidrBlocksEndpointGroupRegion", _default.EndpointGroupIpAddressCidrBlocks[0].EndpointGroupRegion)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ga.GaFunctions;
     * import com.pulumi.alicloud.ga.inputs.GetEndpointGroupIpAddressCidrBlocksArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = GaFunctions.getEndpointGroupIpAddressCidrBlocks(GetEndpointGroupIpAddressCidrBlocksArgs.builder()
     *             .endpointGroupRegion("cn-hangzhou")
     *             .build());
     *         ctx.export("gaEndpointGroupIpAddressCidrBlocksEndpointGroupRegion", default_.endpointGroupIpAddressCidrBlocks()[0].endpointGroupRegion());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:ga:getEndpointGroupIpAddressCidrBlocks
     *       Arguments:
     *         endpointGroupRegion: cn-hangzhou
     * outputs:
     *   gaEndpointGroupIpAddressCidrBlocksEndpointGroupRegion: ${default.endpointGroupIpAddressCidrBlocks[0].endpointGroupRegion}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getEndpointGroupIpAddressCidrBlocks.
     * @return A collection of values returned by getEndpointGroupIpAddressCidrBlocks.
     */
    public suspend fun getEndpointGroupIpAddressCidrBlocks(argument: GetEndpointGroupIpAddressCidrBlocksPlainArgs): GetEndpointGroupIpAddressCidrBlocksResult =
        getEndpointGroupIpAddressCidrBlocksResultToKotlin(getEndpointGroupIpAddressCidrBlocksPlain(argument.toJava()).await())

    /**
     * @see [getEndpointGroupIpAddressCidrBlocks].
     * @param endpointGroupRegion The region ID of the endpoint group.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getEndpointGroupIpAddressCidrBlocks.
     */
    public suspend fun getEndpointGroupIpAddressCidrBlocks(
        endpointGroupRegion: String,
        outputFile: String? = null,
    ): GetEndpointGroupIpAddressCidrBlocksResult {
        val argument = GetEndpointGroupIpAddressCidrBlocksPlainArgs(
            endpointGroupRegion = endpointGroupRegion,
            outputFile = outputFile,
        )
        return getEndpointGroupIpAddressCidrBlocksResultToKotlin(getEndpointGroupIpAddressCidrBlocksPlain(argument.toJava()).await())
    }

    /**
     * @see [getEndpointGroupIpAddressCidrBlocks].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ga&#46;kotlin&#46;inputs&#46;GetEndpointGroupIpAddressCidrBlocksPlainArgs].
     * @return A collection of values returned by getEndpointGroupIpAddressCidrBlocks.
     */
    public suspend fun getEndpointGroupIpAddressCidrBlocks(argument: suspend GetEndpointGroupIpAddressCidrBlocksPlainArgsBuilder.() -> Unit): GetEndpointGroupIpAddressCidrBlocksResult {
        val builder = GetEndpointGroupIpAddressCidrBlocksPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEndpointGroupIpAddressCidrBlocksResultToKotlin(getEndpointGroupIpAddressCidrBlocksPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Global Accelerator (GA) Endpoint Groups of the current Alibaba Cloud user.
     * > **NOTE:** Available since v1.113.0.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const config = new pulumi.Config();
     * const region = config.get("region") || "cn-hangzhou";
     * const name = config.get("name") || "tf-example";
     * const default = alicloud.ga.getAccelerators({
     *     status: "active",
     * });
     * const defaultBandwidthPackage = new alicloud.ga.BandwidthPackage("default", {
     *     bandwidth: 100,
     *     type: "Basic",
     *     bandwidthType: "Basic",
     *     paymentType: "PayAsYouGo",
     *     billingType: "PayBy95",
     *     ratio: 30,
     *     bandwidthPackageName: name,
     *     autoPay: true,
     *     autoUseCoupon: true,
     * });
     * const defaultBandwidthPackageAttachment = new alicloud.ga.BandwidthPackageAttachment("default", {
     *     acceleratorId: _default.then(_default => _default.ids?.[0]),
     *     bandwidthPackageId: defaultBandwidthPackage.id,
     * });
     * const defaultListener = new alicloud.ga.Listener("default", {
     *     acceleratorId: defaultBandwidthPackageAttachment.acceleratorId,
     *     clientAffinity: "SOURCE_IP",
     *     protocol: "UDP",
     *     name: name,
     *     portRanges: [{
     *         fromPort: 60,
     *         toPort: 70,
     *     }],
     * });
     * const defaultEipAddress = new alicloud.ecs.EipAddress("default", {
     *     bandwidth: "10",
     *     internetChargeType: "PayByBandwidth",
     *     addressName: name,
     * });
     * const defaultEndpointGroup = new alicloud.ga.EndpointGroup("default", {
     *     acceleratorId: defaultListener.acceleratorId,
     *     listenerId: defaultListener.id,
     *     description: name,
     *     name: name,
     *     thresholdCount: 4,
     *     trafficPercentage: 20,
     *     endpointGroupRegion: "cn-hangzhou",
     *     healthCheckIntervalSeconds: 3,
     *     healthCheckPath: "/healthcheck",
     *     healthCheckPort: 9999,
     *     healthCheckProtocol: "http",
     *     portOverrides: {
     *         endpointPort: 10,
     *         listenerPort: 60,
     *     },
     *     endpointConfigurations: [{
     *         endpoint: defaultEipAddress.ipAddress,
     *         type: "PublicIp",
     *         weight: 20,
     *     }],
     * });
     * const defaultGetEndpointGroups = alicloud.ga.getEndpointGroupsOutput({
     *     acceleratorId: defaultEndpointGroup.acceleratorId,
     *     ids: [defaultEndpointGroup&#46;id],
     * });
     * export const firstGaEndpointGroupId = defaultGetEndpointGroups.apply(defaultGetEndpointGroups => defaultGetEndpointGroups.groups?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * config = pulumi.Config()
     * region = config.get("region")
     * if region is None:
     *     region = "cn-hangzhou"
     * name = config.get("name")
     * if name is None:
     *     name = "tf-example"
     * default = alicloud.ga.get_accelerators(status="active")
     * default_bandwidth_package = alicloud.ga.BandwidthPackage("default",
     *     bandwidth=100,
     *     type="Basic",
     *     bandwidth_type="Basic",
     *     payment_type="PayAsYouGo",
     *     billing_type="PayBy95",
     *     ratio=30,
     *     bandwidth_package_name=name,
     *     auto_pay=True,
     *     auto_use_coupon=True)
     * default_bandwidth_package_attachment = alicloud.ga.BandwidthPackageAttachment("default",
     *     accelerator_id=default.ids[0],
     *     bandwidth_package_id=default_bandwidth_package.id)
     * default_listener = alicloud.ga.Listener("default",
     *     accelerator_id=default_bandwidth_package_attachment.accelerator_id,
     *     client_affinity="SOURCE_IP",
     *     protocol="UDP",
     *     name=name,
     *     port_ranges=[{
     *         "from_port": 60,
     *         "to_port": 70,
     *     }])
     * default_eip_address = alicloud.ecs.EipAddress("default",
     *     bandwidth="10",
     *     internet_charge_type="PayByBandwidth",
     *     address_name=name)
     * default_endpoint_group = alicloud.ga.EndpointGroup("default",
     *     accelerator_id=default_listener.accelerator_id,
     *     listener_id=default_listener.id,
     *     description=name,
     *     name=name,
     *     threshold_count=4,
     *     traffic_percentage=20,
     *     endpoint_group_region="cn-hangzhou",
     *     health_check_interval_seconds=3,
     *     health_check_path="/healthcheck",
     *     health_check_port=9999,
     *     health_check_protocol="http",
     *     port_overrides={
     *         "endpoint_port": 10,
     *         "listener_port": 60,
     *     },
     *     endpoint_configurations=[{
     *         "endpoint": default_eip_address.ip_address,
     *         "type": "PublicIp",
     *         "weight": 20,
     *     }])
     * default_get_endpoint_groups = alicloud.ga.get_endpoint_groups_output(accelerator_id=default_endpoint_group.accelerator_id,
     *     ids=[default_endpoint_group&#46;id])
     * pulumi.export("firstGaEndpointGroupId", default_get_endpoint_groups.groups[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var config = new Config();
     *     var region = config.Get("region") ?? "cn-hangzhou";
     *     var name = config.Get("name") ?? "tf-example";
     *     var @default = AliCloud.Ga.GetAccelerators.Invoke(new()
     *     {
     *         Status = "active",
     *     });
     *     var defaultBandwidthPackage = new AliCloud.Ga.BandwidthPackage("default", new()
     *     {
     *         Bandwidth = 100,
     *         Type = "Basic",
     *         BandwidthType = "Basic",
     *         PaymentType = "PayAsYouGo",
     *         BillingType = "PayBy95",
     *         Ratio = 30,
     *         BandwidthPackageName = name,
     *         AutoPay = true,
     *         AutoUseCoupon = true,
     *     });
     *     var defaultBandwidthPackageAttachment = new AliCloud.Ga.BandwidthPackageAttachment("default", new()
     *     {
     *         AcceleratorId = @default.Apply(@default => @default.Apply(getAcceleratorsResult => getAcceleratorsResult.Ids[0])),
     *         BandwidthPackageId = defaultBandwidthPackage.Id,
     *     });
     *     var defaultListener = new AliCloud.Ga.Listener("default", new()
     *     {
     *         AcceleratorId = defaultBandwidthPackageAttachment.AcceleratorId,
     *         ClientAffinity = "SOURCE_IP",
     *         Protocol = "UDP",
     *         Name = name,
     *         PortRanges = new[]
     *         {
     *             new AliCloud.Ga.Inputs.ListenerPortRangeArgs
     *             {
     *                 FromPort = 60,
     *                 ToPort = 70,
     *             },
     *         },
     *     });
     *     var defaultEipAddress = new AliCloud.Ecs.EipAddress("default", new()
     *     {
     *         Bandwidth = "10",
     *         InternetChargeType = "PayByBandwidth",
     *         AddressName = name,
     *     });
     *     var defaultEndpointGroup = new AliCloud.Ga.EndpointGroup("default", new()
     *     {
     *         AcceleratorId = defaultListener.AcceleratorId,
     *         ListenerId = defaultListener.Id,
     *         Description = name,
     *         Name = name,
     *         ThresholdCount = 4,
     *         TrafficPercentage = 20,
     *         EndpointGroupRegion = "cn-hangzhou",
     *         HealthCheckIntervalSeconds = 3,
     *         HealthCheckPath = "/healthcheck",
     *         HealthCheckPort = 9999,
     *         HealthCheckProtocol = "http",
     *         PortOverrides = new AliCloud.Ga.Inputs.EndpointGroupPortOverridesArgs
     *         {
     *             EndpointPort = 10,
     *             ListenerPort = 60,
     *         },
     *         EndpointConfigurations = new[]
     *         {
     *             new AliCloud.Ga.Inputs.EndpointGroupEndpointConfigurationArgs
     *             {
     *                 Endpoint = defaultEipAddress.IpAddress,
     *                 Type = "PublicIp",
     *                 Weight = 20,
     *             },
     *         },
     *     });
     *     var defaultGetEndpointGroups = AliCloud.Ga.GetEndpointGroups.Invoke(new()
     *     {
     *         AcceleratorId = defaultEndpointGroup.AcceleratorId,
     *         Ids = new[]
     *         {
     *             defaultEndpointGroup.Id,
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstGaEndpointGroupId"] = defaultGetEndpointGroups&#46;Apply(getEndpointGroupsResult => getEndpointGroupsResult&#46;Groups[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ga"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		cfg := config.New(ctx, "")
     * 		region := "cn-hangzhou"
     * 		if param := cfg.Get("region"); param != "" {
     * 			region = param
     * 		}
     * 		name := "tf-example"
     * 		if param := cfg.Get("name"); param != "" {
     * 			name = param
     * 		}
     * 		_default, err := ga.GetAccelerators(ctx, &ga.GetAcceleratorsArgs{
     * 			Status: pulumi.StringRef("active"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultBandwidthPackage, err := ga.NewBandwidthPackage(ctx, "default", &ga.BandwidthPackageArgs{
     * 			Bandwidth:            pulumi.Int(100),
     * 			Type:                 pulumi.String("Basic"),
     * 			BandwidthType:        pulumi.String("Basic"),
     * 			PaymentType:          pulumi.String("PayAsYouGo"),
     * 			BillingType:          pulumi.String("PayBy95"),
     * 			Ratio:                pulumi.Int(30),
     * 			BandwidthPackageName: pulumi.String(name),
     * 			AutoPay:              pulumi.Bool(true),
     * 			AutoUseCoupon:        pulumi.Bool(true),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultBandwidthPackageAttachment, err := ga.NewBandwidthPackageAttachment(ctx, "default", &ga.BandwidthPackageAttachmentArgs{
     * 			AcceleratorId:      pulumi.String(_default.Ids[0]),
     * 			BandwidthPackageId: defaultBandwidthPackage.ID(),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultListener, err := ga.NewListener(ctx, "default", &ga.ListenerArgs{
     * 			AcceleratorId:  defaultBandwidthPackageAttachment.AcceleratorId,
     * 			ClientAffinity: pulumi.String("SOURCE_IP"),
     * 			Protocol:       pulumi.String("UDP"),
     * 			Name:           pulumi.String(name),
     * 			PortRanges: ga.ListenerPortRangeArray{
     * 				&ga.ListenerPortRangeArgs{
     * 					FromPort: pulumi.Int(60),
     * 					ToPort:   pulumi.Int(70),
     * 				},
     * 			},
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultEipAddress, err := ecs.NewEipAddress(ctx, "default", &ecs.EipAddressArgs{
     * 			Bandwidth:          pulumi.String("10"),
     * 			InternetChargeType: pulumi.String("PayByBandwidth"),
     * 			AddressName:        pulumi.String(name),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultEndpointGroup, err := ga.NewEndpointGroup(ctx, "default", &ga.EndpointGroupArgs{
     * 			AcceleratorId:              defaultListener.AcceleratorId,
     * 			ListenerId:                 defaultListener.ID(),
     * 			Description:                pulumi.String(name),
     * 			Name:                       pulumi.String(name),
     * 			ThresholdCount:             pulumi.Int(4),
     * 			TrafficPercentage:          pulumi.Int(20),
     * 			EndpointGroupRegion:        pulumi.String("cn-hangzhou"),
     * 			HealthCheckIntervalSeconds: pulumi.Int(3),
     * 			HealthCheckPath:            pulumi.String("/healthcheck"),
     * 			HealthCheckPort:            pulumi.Int(9999),
     * 			HealthCheckProtocol:        pulumi.String("http"),
     * 			PortOverrides: &ga.EndpointGroupPortOverridesArgs{
     * 				EndpointPort: pulumi.Int(10),
     * 				ListenerPort: pulumi.Int(60),
     * 			},
     * 			EndpointConfigurations: ga.EndpointGroupEndpointConfigurationArray{
     * 				&ga.EndpointGroupEndpointConfigurationArgs{
     * 					Endpoint: defaultEipAddress.IpAddress,
     * 					Type:     pulumi.String("PublicIp"),
     * 					Weight:   pulumi.Int(20),
     * 				},
     * 			},
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultGetEndpointGroups := ga.GetEndpointGroupsOutput(ctx, ga.GetEndpointGroupsOutputArgs{
     * 			AcceleratorId: defaultEndpointGroup.AcceleratorId,
     * 			Ids: pulumi.StringArray{
     * 				defaultEndpointGroup.ID(),
     * 			},
     * 		}, nil)
     * 		ctx.Export("firstGaEndpointGroupId", defaultGetEndpointGroups.ApplyT(func(defaultGetEndpointGroups ga.GetEndpointGroupsResult) (*string, error) {
     * 			return &defaultGetEndpointGroups.Groups[0].Id, nil
     * 		}).(pulumi.StringPtrOutput))
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ga.GaFunctions;
     * import com.pulumi.alicloud.ga.inputs.GetAcceleratorsArgs;
     * import com.pulumi.alicloud.ga.BandwidthPackage;
     * import com.pulumi.alicloud.ga.BandwidthPackageArgs;
     * import com.pulumi.alicloud.ga.BandwidthPackageAttachment;
     * import com.pulumi.alicloud.ga.BandwidthPackageAttachmentArgs;
     * import com.pulumi.alicloud.ga.Listener;
     * import com.pulumi.alicloud.ga.ListenerArgs;
     * import com.pulumi.alicloud.ga.inputs.ListenerPortRangeArgs;
     * import com.pulumi.alicloud.ecs.EipAddress;
     * import com.pulumi.alicloud.ecs.EipAddressArgs;
     * import com.pulumi.alicloud.ga.EndpointGroup;
     * import com.pulumi.alicloud.ga.EndpointGroupArgs;
     * import com.pulumi.alicloud.ga.inputs.EndpointGroupPortOverridesArgs;
     * import com.pulumi.alicloud.ga.inputs.EndpointGroupEndpointConfigurationArgs;
     * import com.pulumi.alicloud.ga.inputs.GetEndpointGroupsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var region = config.get("region").orElse("cn-hangzhou");
     *         final var name = config.get("name").orElse("tf-example");
     *         final var default = GaFunctions.getAccelerators(GetAcceleratorsArgs.builder()
     *             .status("active")
     *             .build());
     *         var defaultBandwidthPackage = new BandwidthPackage("defaultBandwidthPackage", BandwidthPackageArgs.builder()
     *             .bandwidth(100)
     *             .type("Basic")
     *             .bandwidthType("Basic")
     *             .paymentType("PayAsYouGo")
     *             .billingType("PayBy95")
     *             .ratio(30)
     *             .bandwidthPackageName(name)
     *             .autoPay(true)
     *             .autoUseCoupon(true)
     *             .build());
     *         var defaultBandwidthPackageAttachment = new BandwidthPackageAttachment("defaultBandwidthPackageAttachment", BandwidthPackageAttachmentArgs.builder()
     *             .acceleratorId(default_.ids()[0])
     *             .bandwidthPackageId(defaultBandwidthPackage.id())
     *             .build());
     *         var defaultListener = new Listener("defaultListener", ListenerArgs.builder()
     *             .acceleratorId(defaultBandwidthPackageAttachment.acceleratorId())
     *             .clientAffinity("SOURCE_IP")
     *             .protocol("UDP")
     *             .name(name)
     *             .portRanges(ListenerPortRangeArgs.builder()
     *                 .fromPort("60")
     *                 .toPort("70")
     *                 .build())
     *             .build());
     *         var defaultEipAddress = new EipAddress("defaultEipAddress", EipAddressArgs.builder()
     *             .bandwidth("10")
     *             .internetChargeType("PayByBandwidth")
     *             .addressName(name)
     *             .build());
     *         var defaultEndpointGroup = new EndpointGroup("defaultEndpointGroup", EndpointGroupArgs.builder()
     *             .acceleratorId(defaultListener.acceleratorId())
     *             .listenerId(defaultListener.id())
     *             .description(name)
     *             .name(name)
     *             .thresholdCount(4)
     *             .trafficPercentage(20)
     *             .endpointGroupRegion("cn-hangzhou")
     *             .healthCheckIntervalSeconds("3")
     *             .healthCheckPath("/healthcheck")
     *             .healthCheckPort("9999")
     *             .healthCheckProtocol("http")
     *             .portOverrides(EndpointGroupPortOverridesArgs.builder()
     *                 .endpointPort("10")
     *                 .listenerPort("60")
     *                 .build())
     *             .endpointConfigurations(EndpointGroupEndpointConfigurationArgs.builder()
     *                 .endpoint(defaultEipAddress.ipAddress())
     *                 .type("PublicIp")
     *                 .weight("20")
     *                 .build())
     *             .build());
     *         final var defaultGetEndpointGroups = GaFunctions.getEndpointGroups(GetEndpointGroupsArgs.builder()
     *             .acceleratorId(defaultEndpointGroup.acceleratorId())
     *             .ids(defaultEndpointGroup.id())
     *             .build());
     *         ctx.export("firstGaEndpointGroupId", defaultGetEndpointGroups.applyValue(getEndpointGroupsResult -> getEndpointGroupsResult).applyValue(defaultGetEndpointGroups -> defaultGetEndpointGroups.applyValue(getEndpointGroupsResult -> getEndpointGroupsResult.groups()[0].id())));
     *     }
     * }
     * ```
     * ```yaml
     * configuration:
     *   region:
     *     type: string
     *     default: cn-hangzhou
     *   name:
     *     type: string
     *     default: tf-example
     * resources:
     *   defaultBandwidthPackage:
     *     type: alicloud:ga:BandwidthPackage
     *     name: default
     *     properties:
     *       bandwidth: 100
     *       type: Basic
     *       bandwidthType: Basic
     *       paymentType: PayAsYouGo
     *       billingType: PayBy95
     *       ratio: 30
     *       bandwidthPackageName: ${name}
     *       autoPay: true
     *       autoUseCoupon: true
     *   defaultBandwidthPackageAttachment:
     *     type: alicloud:ga:BandwidthPackageAttachment
     *     name: default
     *     properties:
     *       acceleratorId: ${default.ids[0]}
     *       bandwidthPackageId: ${defaultBandwidthPackage.id}
     *   defaultListener:
     *     type: alicloud:ga:Listener
     *     name: default
     *     properties:
     *       acceleratorId: ${defaultBandwidthPackageAttachment.acceleratorId}
     *       clientAffinity: SOURCE_IP
     *       protocol: UDP
     *       name: ${name}
     *       portRanges:
     *         - fromPort: '60'
     *           toPort: '70'
     *   defaultEipAddress:
     *     type: alicloud:ecs:EipAddress
     *     name: default
     *     properties:
     *       bandwidth: '10'
     *       internetChargeType: PayByBandwidth
     *       addressName: ${name}
     *   defaultEndpointGroup:
     *     type: alicloud:ga:EndpointGroup
     *     name: default
     *     properties:
     *       acceleratorId: ${defaultListener.acceleratorId}
     *       listenerId: ${defaultListener.id}
     *       description: ${name}
     *       name: ${name}
     *       thresholdCount: 4
     *       trafficPercentage: 20
     *       endpointGroupRegion: cn-hangzhou
     *       healthCheckIntervalSeconds: '3'
     *       healthCheckPath: /healthcheck
     *       healthCheckPort: '9999'
     *       healthCheckProtocol: http
     *       portOverrides:
     *         endpointPort: '10'
     *         listenerPort: '60'
     *       endpointConfigurations:
     *         - endpoint: ${defaultEipAddress.ipAddress}
     *           type: PublicIp
     *           weight: '20'
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:ga:getAccelerators
     *       Arguments:
     *         status: active
     *   defaultGetEndpointGroups:
     *     fn::invoke:
     *       Function: alicloud:ga:getEndpointGroups
     *       Arguments:
     *         acceleratorId: ${defaultEndpointGroup.acceleratorId}
     *         ids:
     *           - ${defaultEndpointGroup.id}
     * outputs:
     *   firstGaEndpointGroupId: ${defaultGetEndpointGroups.groups[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getEndpointGroups.
     * @return A collection of values returned by getEndpointGroups.
     */
    public suspend fun getEndpointGroups(argument: GetEndpointGroupsPlainArgs): GetEndpointGroupsResult =
        getEndpointGroupsResultToKotlin(getEndpointGroupsPlain(argument.toJava()).await())

    /**
     * @see [getEndpointGroups].
     * @param acceleratorId The ID of the Global Accelerator instance to which the endpoint group will be added.
     * @param endpointGroupType The endpoint group type. Default value: `default`. Valid values: `default`, `virtual`.
     * @param ids A list of Endpoint Group IDs.
     * @param listenerId The ID of the listener that is associated with the endpoint group.
     * @param nameRegex A regex string to filter results by Endpoint Group name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the endpoint group. Valid values: `active`, `configuring`, `creating`, `init`.
     * @return A collection of values returned by getEndpointGroups.
     */
    public suspend fun getEndpointGroups(
        acceleratorId: String,
        endpointGroupType: String? = null,
        ids: List<String>? = null,
        listenerId: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetEndpointGroupsResult {
        val argument = GetEndpointGroupsPlainArgs(
            acceleratorId = acceleratorId,
            endpointGroupType = endpointGroupType,
            ids = ids,
            listenerId = listenerId,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
        )
        return getEndpointGroupsResultToKotlin(getEndpointGroupsPlain(argument.toJava()).await())
    }

    /**
     * @see [getEndpointGroups].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ga&#46;kotlin&#46;inputs&#46;GetEndpointGroupsPlainArgs].
     * @return A collection of values returned by getEndpointGroups.
     */
    public suspend fun getEndpointGroups(argument: suspend GetEndpointGroupsPlainArgsBuilder.() -> Unit): GetEndpointGroupsResult {
        val builder = GetEndpointGroupsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEndpointGroupsResultToKotlin(getEndpointGroupsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Global Accelerator (GA) Forwarding Rules of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.120.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.ga.getForwardingRules({
     *     acceleratorId: "example_value",
     *     listenerId: "example_value",
     *     ids: ["example_value"],
     * });
     * export const firstGaForwardingRuleId = example.then(example => example.forwardingRules?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.ga.get_forwarding_rules(accelerator_id="example_value",
     *     listener_id="example_value",
     *     ids=["example_value"])
     * pulumi.export("firstGaForwardingRuleId", example.forwarding_rules[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Ga.GetForwardingRules.Invoke(new()
     *     {
     *         AcceleratorId = "example_value",
     *         ListenerId = "example_value",
     *         Ids = new[]
     *         {
     *             "example_value",
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstGaForwardingRuleId"] = example&#46;Apply(getForwardingRulesResult => getForwardingRulesResult&#46;ForwardingRules[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ga"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := ga.GetForwardingRules(ctx, &ga.GetForwardingRulesArgs{
     * 			AcceleratorId: "example_value",
     * 			ListenerId:    "example_value",
     * 			Ids: []string{
     * 				"example_value",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstGaForwardingRuleId", example.ForwardingRules[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ga.GaFunctions;
     * import com.pulumi.alicloud.ga.inputs.GetForwardingRulesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = GaFunctions.getForwardingRules(GetForwardingRulesArgs.builder()
     *             .acceleratorId("example_value")
     *             .listenerId("example_value")
     *             .ids("example_value")
     *             .build());
     *         ctx.export("firstGaForwardingRuleId", example.applyValue(getForwardingRulesResult -> getForwardingRulesResult.forwardingRules()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:ga:getForwardingRules
     *       Arguments:
     *         acceleratorId: example_value
     *         listenerId: example_value
     *         ids:
     *           - example_value
     * outputs:
     *   firstGaForwardingRuleId: ${example.forwardingRules[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getForwardingRules.
     * @return A collection of values returned by getForwardingRules.
     */
    public suspend fun getForwardingRules(argument: GetForwardingRulesPlainArgs): GetForwardingRulesResult =
        getForwardingRulesResultToKotlin(getForwardingRulesPlain(argument.toJava()).await())

    /**
     * @see [getForwardingRules].
     * @param acceleratorId The ID of the Global Accelerator instance.
     * @param ids A list of Forwarding Rule IDs.
     * @param listenerId The ID of the listener.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the acceleration region. Valid values: `active`, `configuring`.
     * @return A collection of values returned by getForwardingRules.
     */
    public suspend fun getForwardingRules(
        acceleratorId: String,
        ids: List<String>? = null,
        listenerId: String,
        outputFile: String? = null,
        status: String? = null,
    ): GetForwardingRulesResult {
        val argument = GetForwardingRulesPlainArgs(
            acceleratorId = acceleratorId,
            ids = ids,
            listenerId = listenerId,
            outputFile = outputFile,
            status = status,
        )
        return getForwardingRulesResultToKotlin(getForwardingRulesPlain(argument.toJava()).await())
    }

    /**
     * @see [getForwardingRules].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ga&#46;kotlin&#46;inputs&#46;GetForwardingRulesPlainArgs].
     * @return A collection of values returned by getForwardingRules.
     */
    public suspend fun getForwardingRules(argument: suspend GetForwardingRulesPlainArgsBuilder.() -> Unit): GetForwardingRulesResult {
        val builder = GetForwardingRulesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getForwardingRulesResultToKotlin(getForwardingRulesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Global Accelerator (GA) Ip Sets of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.113.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.ga.getIpSets({
     *     acceleratorId: "example_value",
     *     ids: ["example_value"],
     * });
     * export const firstGaIpSetId = example.then(example => example.sets?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.ga.get_ip_sets(accelerator_id="example_value",
     *     ids=["example_value"])
     * pulumi.export("firstGaIpSetId", example.sets[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Ga.GetIpSets.Invoke(new()
     *     {
     *         AcceleratorId = "example_value",
     *         Ids = new[]
     *         {
     *             "example_value",
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstGaIpSetId"] = example&#46;Apply(getIpSetsResult => getIpSetsResult&#46;Sets[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ga"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := ga.GetIpSets(ctx, &ga.GetIpSetsArgs{
     * 			AcceleratorId: "example_value",
     * 			Ids: []string{
     * 				"example_value",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstGaIpSetId", example.Sets[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ga.GaFunctions;
     * import com.pulumi.alicloud.ga.inputs.GetIpSetsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = GaFunctions.getIpSets(GetIpSetsArgs.builder()
     *             .acceleratorId("example_value")
     *             .ids("example_value")
     *             .build());
     *         ctx.export("firstGaIpSetId", example.applyValue(getIpSetsResult -> getIpSetsResult.sets()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:ga:getIpSets
     *       Arguments:
     *         acceleratorId: example_value
     *         ids:
     *           - example_value
     * outputs:
     *   firstGaIpSetId: ${example.sets[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getIpSets.
     * @return A collection of values returned by getIpSets.
     */
    public suspend fun getIpSets(argument: GetIpSetsPlainArgs): GetIpSetsResult =
        getIpSetsResultToKotlin(getIpSetsPlain(argument.toJava()).await())

    /**
     * @see [getIpSets].
     * @param acceleratorId The ID of the Global Accelerator (GA) instance.
     * @param ids A list of Ip Set IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the acceleration region. Valid values: `active`, `deleting`, `init`, `updating`.
     * @return A collection of values returned by getIpSets.
     */
    public suspend fun getIpSets(
        acceleratorId: String,
        ids: List<String>? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetIpSetsResult {
        val argument = GetIpSetsPlainArgs(
            acceleratorId = acceleratorId,
            ids = ids,
            outputFile = outputFile,
            status = status,
        )
        return getIpSetsResultToKotlin(getIpSetsPlain(argument.toJava()).await())
    }

    /**
     * @see [getIpSets].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ga&#46;kotlin&#46;inputs&#46;GetIpSetsPlainArgs].
     * @return A collection of values returned by getIpSets.
     */
    public suspend fun getIpSets(argument: suspend GetIpSetsPlainArgsBuilder.() -> Unit): GetIpSetsResult {
        val builder = GetIpSetsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIpSetsResultToKotlin(getIpSetsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Global Accelerator (GA) Listeners of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.111.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.ga.getListeners({
     *     acceleratorId: "example_value",
     *     ids: ["example_value"],
     *     nameRegex: "the_resource_name",
     * });
     * export const firstGaListenerId = example.then(example => example.listeners?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.ga.get_listeners(accelerator_id="example_value",
     *     ids=["example_value"],
     *     name_regex="the_resource_name")
     * pulumi.export("firstGaListenerId", example.listeners[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Ga.GetListeners.Invoke(new()
     *     {
     *         AcceleratorId = "example_value",
     *         Ids = new[]
     *         {
     *             "example_value",
     *         },
     *         NameRegex = "the_resource_name",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstGaListenerId"] = example&#46;Apply(getListenersResult => getListenersResult&#46;Listeners[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ga"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := ga.GetListeners(ctx, &ga.GetListenersArgs{
     * 			AcceleratorId: "example_value",
     * 			Ids: []string{
     * 				"example_value",
     * 			},
     * 			NameRegex: pulumi.StringRef("the_resource_name"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstGaListenerId", example.Listeners[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ga.GaFunctions;
     * import com.pulumi.alicloud.ga.inputs.GetListenersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = GaFunctions.getListeners(GetListenersArgs.builder()
     *             .acceleratorId("example_value")
     *             .ids("example_value")
     *             .nameRegex("the_resource_name")
     *             .build());
     *         ctx.export("firstGaListenerId", example.applyValue(getListenersResult -> getListenersResult.listeners()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:ga:getListeners
     *       Arguments:
     *         acceleratorId: example_value
     *         ids:
     *           - example_value
     *         nameRegex: the_resource_name
     * outputs:
     *   firstGaListenerId: ${example.listeners[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getListeners.
     * @return A collection of values returned by getListeners.
     */
    public suspend fun getListeners(argument: GetListenersPlainArgs): GetListenersResult =
        getListenersResultToKotlin(getListenersPlain(argument.toJava()).await())

    /**
     * @see [getListeners].
     * @param acceleratorId The accelerator id.
     * @param ids A list of Listener IDs.
     * @param nameRegex A regex string to filter results by Listener name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the listener. Valid values: `active`, `configuring`, `creating`.
     * @return A collection of values returned by getListeners.
     */
    public suspend fun getListeners(
        acceleratorId: String,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetListenersResult {
        val argument = GetListenersPlainArgs(
            acceleratorId = acceleratorId,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
        )
        return getListenersResultToKotlin(getListenersPlain(argument.toJava()).await())
    }

    /**
     * @see [getListeners].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ga&#46;kotlin&#46;inputs&#46;GetListenersPlainArgs].
     * @return A collection of values returned by getListeners.
     */
    public suspend fun getListeners(argument: suspend GetListenersPlainArgsBuilder.() -> Unit): GetListenersResult {
        val builder = GetListenersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getListenersResultToKotlin(getListenersPlain(builtArgument.toJava()).await())
    }
}
