@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin

import com.pulumi.alicloud.ga.ListenerArgs.builder
import com.pulumi.alicloud.ga.kotlin.inputs.ListenerCertificateArgs
import com.pulumi.alicloud.ga.kotlin.inputs.ListenerCertificateArgsBuilder
import com.pulumi.alicloud.ga.kotlin.inputs.ListenerForwardedForConfigArgs
import com.pulumi.alicloud.ga.kotlin.inputs.ListenerForwardedForConfigArgsBuilder
import com.pulumi.alicloud.ga.kotlin.inputs.ListenerPortRangeArgs
import com.pulumi.alicloud.ga.kotlin.inputs.ListenerPortRangeArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Global Accelerator (GA) Listener resource.
 * For information about Global Accelerator (GA) Listener and how to use it, see [What is Listener](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-createlistener).
 * > **NOTE:** Available since v1.111.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.ga.Accelerator("default", {
 *     duration: 1,
 *     autoUseCoupon: true,
 *     spec: "1",
 * });
 * const defaultBandwidthPackage = new alicloud.ga.BandwidthPackage("default", {
 *     bandwidth: 100,
 *     type: "Basic",
 *     bandwidthType: "Basic",
 *     paymentType: "PayAsYouGo",
 *     billingType: "PayBy95",
 *     ratio: 30,
 * });
 * const defaultBandwidthPackageAttachment = new alicloud.ga.BandwidthPackageAttachment("default", {
 *     acceleratorId: _default.id,
 *     bandwidthPackageId: defaultBandwidthPackage.id,
 * });
 * const defaultListener = new alicloud.ga.Listener("default", {
 *     acceleratorId: defaultBandwidthPackageAttachment.acceleratorId,
 *     portRanges: [{
 *         fromPort: 80,
 *         toPort: 80,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.ga.Accelerator("default",
 *     duration=1,
 *     auto_use_coupon=True,
 *     spec="1")
 * default_bandwidth_package = alicloud.ga.BandwidthPackage("default",
 *     bandwidth=100,
 *     type="Basic",
 *     bandwidth_type="Basic",
 *     payment_type="PayAsYouGo",
 *     billing_type="PayBy95",
 *     ratio=30)
 * default_bandwidth_package_attachment = alicloud.ga.BandwidthPackageAttachment("default",
 *     accelerator_id=default.id,
 *     bandwidth_package_id=default_bandwidth_package.id)
 * default_listener = alicloud.ga.Listener("default",
 *     accelerator_id=default_bandwidth_package_attachment.accelerator_id,
 *     port_ranges=[{
 *         "from_port": 80,
 *         "to_port": 80,
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Ga.Accelerator("default", new()
 *     {
 *         Duration = 1,
 *         AutoUseCoupon = true,
 *         Spec = "1",
 *     });
 *     var defaultBandwidthPackage = new AliCloud.Ga.BandwidthPackage("default", new()
 *     {
 *         Bandwidth = 100,
 *         Type = "Basic",
 *         BandwidthType = "Basic",
 *         PaymentType = "PayAsYouGo",
 *         BillingType = "PayBy95",
 *         Ratio = 30,
 *     });
 *     var defaultBandwidthPackageAttachment = new AliCloud.Ga.BandwidthPackageAttachment("default", new()
 *     {
 *         AcceleratorId = @default.Id,
 *         BandwidthPackageId = defaultBandwidthPackage.Id,
 *     });
 *     var defaultListener = new AliCloud.Ga.Listener("default", new()
 *     {
 *         AcceleratorId = defaultBandwidthPackageAttachment.AcceleratorId,
 *         PortRanges = new[]
 *         {
 *             new AliCloud.Ga.Inputs.ListenerPortRangeArgs
 *             {
 *                 FromPort = 80,
 *                 ToPort = 80,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ga"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ga.NewAccelerator(ctx, "default", &ga.AcceleratorArgs{
 * 			Duration:      pulumi.Int(1),
 * 			AutoUseCoupon: pulumi.Bool(true),
 * 			Spec:          pulumi.String("1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultBandwidthPackage, err := ga.NewBandwidthPackage(ctx, "default", &ga.BandwidthPackageArgs{
 * 			Bandwidth:     pulumi.Int(100),
 * 			Type:          pulumi.String("Basic"),
 * 			BandwidthType: pulumi.String("Basic"),
 * 			PaymentType:   pulumi.String("PayAsYouGo"),
 * 			BillingType:   pulumi.String("PayBy95"),
 * 			Ratio:         pulumi.Int(30),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultBandwidthPackageAttachment, err := ga.NewBandwidthPackageAttachment(ctx, "default", &ga.BandwidthPackageAttachmentArgs{
 * 			AcceleratorId:      _default.ID(),
 * 			BandwidthPackageId: defaultBandwidthPackage.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ga.NewListener(ctx, "default", &ga.ListenerArgs{
 * 			AcceleratorId: defaultBandwidthPackageAttachment.AcceleratorId,
 * 			PortRanges: ga.ListenerPortRangeArray{
 * 				&ga.ListenerPortRangeArgs{
 * 					FromPort: pulumi.Int(80),
 * 					ToPort:   pulumi.Int(80),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ga.Accelerator;
 * import com.pulumi.alicloud.ga.AcceleratorArgs;
 * import com.pulumi.alicloud.ga.BandwidthPackage;
 * import com.pulumi.alicloud.ga.BandwidthPackageArgs;
 * import com.pulumi.alicloud.ga.BandwidthPackageAttachment;
 * import com.pulumi.alicloud.ga.BandwidthPackageAttachmentArgs;
 * import com.pulumi.alicloud.ga.Listener;
 * import com.pulumi.alicloud.ga.ListenerArgs;
 * import com.pulumi.alicloud.ga.inputs.ListenerPortRangeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Accelerator("default", AcceleratorArgs.builder()
 *             .duration(1)
 *             .autoUseCoupon(true)
 *             .spec("1")
 *             .build());
 *         var defaultBandwidthPackage = new BandwidthPackage("defaultBandwidthPackage", BandwidthPackageArgs.builder()
 *             .bandwidth(100)
 *             .type("Basic")
 *             .bandwidthType("Basic")
 *             .paymentType("PayAsYouGo")
 *             .billingType("PayBy95")
 *             .ratio(30)
 *             .build());
 *         var defaultBandwidthPackageAttachment = new BandwidthPackageAttachment("defaultBandwidthPackageAttachment", BandwidthPackageAttachmentArgs.builder()
 *             .acceleratorId(default_.id())
 *             .bandwidthPackageId(defaultBandwidthPackage.id())
 *             .build());
 *         var defaultListener = new Listener("defaultListener", ListenerArgs.builder()
 *             .acceleratorId(defaultBandwidthPackageAttachment.acceleratorId())
 *             .portRanges(ListenerPortRangeArgs.builder()
 *                 .fromPort(80)
 *                 .toPort(80)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:ga:Accelerator
 *     properties:
 *       duration: 1
 *       autoUseCoupon: true
 *       spec: '1'
 *   defaultBandwidthPackage:
 *     type: alicloud:ga:BandwidthPackage
 *     name: default
 *     properties:
 *       bandwidth: 100
 *       type: Basic
 *       bandwidthType: Basic
 *       paymentType: PayAsYouGo
 *       billingType: PayBy95
 *       ratio: 30
 *   defaultBandwidthPackageAttachment:
 *     type: alicloud:ga:BandwidthPackageAttachment
 *     name: default
 *     properties:
 *       acceleratorId: ${default.id}
 *       bandwidthPackageId: ${defaultBandwidthPackage.id}
 *   defaultListener:
 *     type: alicloud:ga:Listener
 *     name: default
 *     properties:
 *       acceleratorId: ${defaultBandwidthPackageAttachment.acceleratorId}
 *       portRanges:
 *         - fromPort: 80
 *           toPort: 80
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Ga Listener can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ga/listener:Listener example <id>
 * ```
 * @property acceleratorId The accelerator id.
 * @property certificates The certificates of the listener. See `certificates` below.
 * > **NOTE:** This parameter needs to be configured only for monitoring of the `HTTPS` protocol.
 * @property clientAffinity The clientAffinity of the listener. Default value: `NONE`. Valid values:
 * - `NONE`: client affinity is not maintained, that is, connection requests from the same client cannot always be directed to the same terminal node.
 * - `SOURCE_IP`: maintain client affinity. When a client accesses a stateful application, all requests from the same client can be directed to the same terminal node, regardless of the source port and protocol.
 * @property description The description of the listener.
 * @property forwardedForConfig The XForward headers. See `forwarded_for_config` below.
 * @property httpVersion The maximum version of the HTTP protocol. Default Value: `http2`. Valid values: `http1.1`, `http2`, `http3`.
 * > **NOTE:** `http_version` is only valid when `protocol` is `HTTPS`.
 * @property idleTimeout The timeout period of idle connections. Unit: seconds. Valid values:
 * - If you set `protocol` to `TCP`. Default Value: `900`. Valid values: `10` to `900`.
 * - If you set `protocol` to `UDP`. Default Value: `20`. Valid values: `10` to `20`.
 * - If you set `protocol` to `HTTP` or `HTTPS`. Default Value: `15`. Valid values: `1` to `60`.
 * @property listenerType The routing type of the listener. Default Value: `Standard`. Valid values:
 * - `Standard`: intelligent routing.
 * - `CustomRouting`: custom routing.
 * @property name The name of the listener. The length of the name is 2-128 characters. It starts with uppercase and lowercase letters or Chinese characters. It can contain numbers and underscores and dashes.
 * @property portRanges The portRanges of the listener. See `port_ranges` below.
 * > **NOTE:** For `HTTP` or `HTTPS` protocol monitoring, only one monitoring port can be configured, that is, the start monitoring port and end monitoring port should be the same.
 * @property protocol Type of network transport protocol monitored. Default value: `TCP`. Valid values: `TCP`, `UDP`, `HTTP`, `HTTPS`.
 * @property proxyProtocol The proxy protocol of the listener. Default value: `false`. Valid values:
 * @property requestTimeout The timeout period for HTTP or HTTPS requests. Unit: seconds. Default Value: `60`. Valid values: `1` to `180`.
 * > **NOTE:** `request_timeout` is only valid when `protocol` is `HTTP` or `HTTPS`.
 * @property securityPolicyId The ID of the security policy. **NOTE:** Only `HTTPS` listeners support this parameter. Valid values:
 */
public data class ListenerArgs(
    public val acceleratorId: Output<String>? = null,
    public val certificates: Output<List<ListenerCertificateArgs>>? = null,
    public val clientAffinity: Output<String>? = null,
    public val description: Output<String>? = null,
    public val forwardedForConfig: Output<ListenerForwardedForConfigArgs>? = null,
    public val httpVersion: Output<String>? = null,
    public val idleTimeout: Output<Int>? = null,
    public val listenerType: Output<String>? = null,
    public val name: Output<String>? = null,
    public val portRanges: Output<List<ListenerPortRangeArgs>>? = null,
    public val protocol: Output<String>? = null,
    public val proxyProtocol: Output<Boolean>? = null,
    public val requestTimeout: Output<Int>? = null,
    public val securityPolicyId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ga.ListenerArgs> {
    override fun toJava(): com.pulumi.alicloud.ga.ListenerArgs =
        com.pulumi.alicloud.ga.ListenerArgs.builder()
            .acceleratorId(acceleratorId?.applyValue({ args0 -> args0 }))
            .certificates(
                certificates?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .clientAffinity(clientAffinity?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .forwardedForConfig(
                forwardedForConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .httpVersion(httpVersion?.applyValue({ args0 -> args0 }))
            .idleTimeout(idleTimeout?.applyValue({ args0 -> args0 }))
            .listenerType(listenerType?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .portRanges(
                portRanges?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .protocol(protocol?.applyValue({ args0 -> args0 }))
            .proxyProtocol(proxyProtocol?.applyValue({ args0 -> args0 }))
            .requestTimeout(requestTimeout?.applyValue({ args0 -> args0 }))
            .securityPolicyId(securityPolicyId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ListenerArgs].
 */
@PulumiTagMarker
public class ListenerArgsBuilder internal constructor() {
    private var acceleratorId: Output<String>? = null

    private var certificates: Output<List<ListenerCertificateArgs>>? = null

    private var clientAffinity: Output<String>? = null

    private var description: Output<String>? = null

    private var forwardedForConfig: Output<ListenerForwardedForConfigArgs>? = null

    private var httpVersion: Output<String>? = null

    private var idleTimeout: Output<Int>? = null

    private var listenerType: Output<String>? = null

    private var name: Output<String>? = null

    private var portRanges: Output<List<ListenerPortRangeArgs>>? = null

    private var protocol: Output<String>? = null

    private var proxyProtocol: Output<Boolean>? = null

    private var requestTimeout: Output<Int>? = null

    private var securityPolicyId: Output<String>? = null

    /**
     * @param value The accelerator id.
     */
    @JvmName("uvroxnrxpddqlnxa")
    public suspend fun acceleratorId(`value`: Output<String>) {
        this.acceleratorId = value
    }

    /**
     * @param value The certificates of the listener. See `certificates` below.
     * > **NOTE:** This parameter needs to be configured only for monitoring of the `HTTPS` protocol.
     */
    @JvmName("oiyxymgtwdfacplv")
    public suspend fun certificates(`value`: Output<List<ListenerCertificateArgs>>) {
        this.certificates = value
    }

    @JvmName("vmwqlaoejtruosph")
    public suspend fun certificates(vararg values: Output<ListenerCertificateArgs>) {
        this.certificates = Output.all(values.asList())
    }

    /**
     * @param values The certificates of the listener. See `certificates` below.
     * > **NOTE:** This parameter needs to be configured only for monitoring of the `HTTPS` protocol.
     */
    @JvmName("iwecijwycsceyfkm")
    public suspend fun certificates(values: List<Output<ListenerCertificateArgs>>) {
        this.certificates = Output.all(values)
    }

    /**
     * @param value The clientAffinity of the listener. Default value: `NONE`. Valid values:
     * - `NONE`: client affinity is not maintained, that is, connection requests from the same client cannot always be directed to the same terminal node.
     * - `SOURCE_IP`: maintain client affinity. When a client accesses a stateful application, all requests from the same client can be directed to the same terminal node, regardless of the source port and protocol.
     */
    @JvmName("rckkjevenbwhhfci")
    public suspend fun clientAffinity(`value`: Output<String>) {
        this.clientAffinity = value
    }

    /**
     * @param value The description of the listener.
     */
    @JvmName("kvtcsdkrhybyjiqw")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The XForward headers. See `forwarded_for_config` below.
     */
    @JvmName("hscskllnfwfrsgjx")
    public suspend fun forwardedForConfig(`value`: Output<ListenerForwardedForConfigArgs>) {
        this.forwardedForConfig = value
    }

    /**
     * @param value The maximum version of the HTTP protocol. Default Value: `http2`. Valid values: `http1.1`, `http2`, `http3`.
     * > **NOTE:** `http_version` is only valid when `protocol` is `HTTPS`.
     */
    @JvmName("iejkeqphcjthofdo")
    public suspend fun httpVersion(`value`: Output<String>) {
        this.httpVersion = value
    }

    /**
     * @param value The timeout period of idle connections. Unit: seconds. Valid values:
     * - If you set `protocol` to `TCP`. Default Value: `900`. Valid values: `10` to `900`.
     * - If you set `protocol` to `UDP`. Default Value: `20`. Valid values: `10` to `20`.
     * - If you set `protocol` to `HTTP` or `HTTPS`. Default Value: `15`. Valid values: `1` to `60`.
     */
    @JvmName("mhxjjvuxfddximcd")
    public suspend fun idleTimeout(`value`: Output<Int>) {
        this.idleTimeout = value
    }

    /**
     * @param value The routing type of the listener. Default Value: `Standard`. Valid values:
     * - `Standard`: intelligent routing.
     * - `CustomRouting`: custom routing.
     */
    @JvmName("kswpcscatemkpnhc")
    public suspend fun listenerType(`value`: Output<String>) {
        this.listenerType = value
    }

    /**
     * @param value The name of the listener. The length of the name is 2-128 characters. It starts with uppercase and lowercase letters or Chinese characters. It can contain numbers and underscores and dashes.
     */
    @JvmName("ywpxkwqtibfwnonw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The portRanges of the listener. See `port_ranges` below.
     * > **NOTE:** For `HTTP` or `HTTPS` protocol monitoring, only one monitoring port can be configured, that is, the start monitoring port and end monitoring port should be the same.
     */
    @JvmName("otyvkuwojrtmouvx")
    public suspend fun portRanges(`value`: Output<List<ListenerPortRangeArgs>>) {
        this.portRanges = value
    }

    @JvmName("lfndhjwgulgamoeh")
    public suspend fun portRanges(vararg values: Output<ListenerPortRangeArgs>) {
        this.portRanges = Output.all(values.asList())
    }

    /**
     * @param values The portRanges of the listener. See `port_ranges` below.
     * > **NOTE:** For `HTTP` or `HTTPS` protocol monitoring, only one monitoring port can be configured, that is, the start monitoring port and end monitoring port should be the same.
     */
    @JvmName("jbmntpxpmjvlkicy")
    public suspend fun portRanges(values: List<Output<ListenerPortRangeArgs>>) {
        this.portRanges = Output.all(values)
    }

    /**
     * @param value Type of network transport protocol monitored. Default value: `TCP`. Valid values: `TCP`, `UDP`, `HTTP`, `HTTPS`.
     */
    @JvmName("mcdylwqvfufigwud")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value The proxy protocol of the listener. Default value: `false`. Valid values:
     */
    @JvmName("qrjhnrvdtrhkupnw")
    public suspend fun proxyProtocol(`value`: Output<Boolean>) {
        this.proxyProtocol = value
    }

    /**
     * @param value The timeout period for HTTP or HTTPS requests. Unit: seconds. Default Value: `60`. Valid values: `1` to `180`.
     * > **NOTE:** `request_timeout` is only valid when `protocol` is `HTTP` or `HTTPS`.
     */
    @JvmName("sikmjjrpxoekpkhe")
    public suspend fun requestTimeout(`value`: Output<Int>) {
        this.requestTimeout = value
    }

    /**
     * @param value The ID of the security policy. **NOTE:** Only `HTTPS` listeners support this parameter. Valid values:
     */
    @JvmName("okffmrowsxtvajqe")
    public suspend fun securityPolicyId(`value`: Output<String>) {
        this.securityPolicyId = value
    }

    /**
     * @param value The accelerator id.
     */
    @JvmName("htaqnmpsrbgxbmqd")
    public suspend fun acceleratorId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceleratorId = mapped
    }

    /**
     * @param value The certificates of the listener. See `certificates` below.
     * > **NOTE:** This parameter needs to be configured only for monitoring of the `HTTPS` protocol.
     */
    @JvmName("ncvrsayeowfvboob")
    public suspend fun certificates(`value`: List<ListenerCertificateArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificates = mapped
    }

    /**
     * @param argument The certificates of the listener. See `certificates` below.
     * > **NOTE:** This parameter needs to be configured only for monitoring of the `HTTPS` protocol.
     */
    @JvmName("dpkpexcutyjcmsij")
    public suspend fun certificates(argument: List<suspend ListenerCertificateArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ListenerCertificateArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.certificates = mapped
    }

    /**
     * @param argument The certificates of the listener. See `certificates` below.
     * > **NOTE:** This parameter needs to be configured only for monitoring of the `HTTPS` protocol.
     */
    @JvmName("duaorowkjutpvkps")
    public suspend fun certificates(vararg argument: suspend ListenerCertificateArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ListenerCertificateArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.certificates = mapped
    }

    /**
     * @param argument The certificates of the listener. See `certificates` below.
     * > **NOTE:** This parameter needs to be configured only for monitoring of the `HTTPS` protocol.
     */
    @JvmName("xwclpnjhmkvjptav")
    public suspend fun certificates(argument: suspend ListenerCertificateArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ListenerCertificateArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.certificates = mapped
    }

    /**
     * @param values The certificates of the listener. See `certificates` below.
     * > **NOTE:** This parameter needs to be configured only for monitoring of the `HTTPS` protocol.
     */
    @JvmName("xjsbwmnifwkllsxu")
    public suspend fun certificates(vararg values: ListenerCertificateArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.certificates = mapped
    }

    /**
     * @param value The clientAffinity of the listener. Default value: `NONE`. Valid values:
     * - `NONE`: client affinity is not maintained, that is, connection requests from the same client cannot always be directed to the same terminal node.
     * - `SOURCE_IP`: maintain client affinity. When a client accesses a stateful application, all requests from the same client can be directed to the same terminal node, regardless of the source port and protocol.
     */
    @JvmName("jdevxqbusabsjdvo")
    public suspend fun clientAffinity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientAffinity = mapped
    }

    /**
     * @param value The description of the listener.
     */
    @JvmName("gaykcqsbqmiscyqc")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The XForward headers. See `forwarded_for_config` below.
     */
    @JvmName("exgmnahedircstoh")
    public suspend fun forwardedForConfig(`value`: ListenerForwardedForConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forwardedForConfig = mapped
    }

    /**
     * @param argument The XForward headers. See `forwarded_for_config` below.
     */
    @JvmName("qniuvtqjvkjrldbp")
    public suspend fun forwardedForConfig(argument: suspend ListenerForwardedForConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ListenerForwardedForConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.forwardedForConfig = mapped
    }

    /**
     * @param value The maximum version of the HTTP protocol. Default Value: `http2`. Valid values: `http1.1`, `http2`, `http3`.
     * > **NOTE:** `http_version` is only valid when `protocol` is `HTTPS`.
     */
    @JvmName("umisyaagimnytofq")
    public suspend fun httpVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpVersion = mapped
    }

    /**
     * @param value The timeout period of idle connections. Unit: seconds. Valid values:
     * - If you set `protocol` to `TCP`. Default Value: `900`. Valid values: `10` to `900`.
     * - If you set `protocol` to `UDP`. Default Value: `20`. Valid values: `10` to `20`.
     * - If you set `protocol` to `HTTP` or `HTTPS`. Default Value: `15`. Valid values: `1` to `60`.
     */
    @JvmName("denvjpxiecnblepc")
    public suspend fun idleTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.idleTimeout = mapped
    }

    /**
     * @param value The routing type of the listener. Default Value: `Standard`. Valid values:
     * - `Standard`: intelligent routing.
     * - `CustomRouting`: custom routing.
     */
    @JvmName("aryxfghudlfdkebq")
    public suspend fun listenerType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.listenerType = mapped
    }

    /**
     * @param value The name of the listener. The length of the name is 2-128 characters. It starts with uppercase and lowercase letters or Chinese characters. It can contain numbers and underscores and dashes.
     */
    @JvmName("vklyvdqngpjxcvem")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The portRanges of the listener. See `port_ranges` below.
     * > **NOTE:** For `HTTP` or `HTTPS` protocol monitoring, only one monitoring port can be configured, that is, the start monitoring port and end monitoring port should be the same.
     */
    @JvmName("brulwgrwlyxtmotp")
    public suspend fun portRanges(`value`: List<ListenerPortRangeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.portRanges = mapped
    }

    /**
     * @param argument The portRanges of the listener. See `port_ranges` below.
     * > **NOTE:** For `HTTP` or `HTTPS` protocol monitoring, only one monitoring port can be configured, that is, the start monitoring port and end monitoring port should be the same.
     */
    @JvmName("fkteshejcjxpluam")
    public suspend fun portRanges(argument: List<suspend ListenerPortRangeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ListenerPortRangeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.portRanges = mapped
    }

    /**
     * @param argument The portRanges of the listener. See `port_ranges` below.
     * > **NOTE:** For `HTTP` or `HTTPS` protocol monitoring, only one monitoring port can be configured, that is, the start monitoring port and end monitoring port should be the same.
     */
    @JvmName("vetunpkljurhmqbp")
    public suspend fun portRanges(vararg argument: suspend ListenerPortRangeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ListenerPortRangeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.portRanges = mapped
    }

    /**
     * @param argument The portRanges of the listener. See `port_ranges` below.
     * > **NOTE:** For `HTTP` or `HTTPS` protocol monitoring, only one monitoring port can be configured, that is, the start monitoring port and end monitoring port should be the same.
     */
    @JvmName("eivmohqokklpknhh")
    public suspend fun portRanges(argument: suspend ListenerPortRangeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ListenerPortRangeArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.portRanges = mapped
    }

    /**
     * @param values The portRanges of the listener. See `port_ranges` below.
     * > **NOTE:** For `HTTP` or `HTTPS` protocol monitoring, only one monitoring port can be configured, that is, the start monitoring port and end monitoring port should be the same.
     */
    @JvmName("qyxsqasfwnckijbb")
    public suspend fun portRanges(vararg values: ListenerPortRangeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.portRanges = mapped
    }

    /**
     * @param value Type of network transport protocol monitored. Default value: `TCP`. Valid values: `TCP`, `UDP`, `HTTP`, `HTTPS`.
     */
    @JvmName("wivedrhorpfaockp")
    public suspend fun protocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The proxy protocol of the listener. Default value: `false`. Valid values:
     */
    @JvmName("nrfmdsbuxtrnshry")
    public suspend fun proxyProtocol(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.proxyProtocol = mapped
    }

    /**
     * @param value The timeout period for HTTP or HTTPS requests. Unit: seconds. Default Value: `60`. Valid values: `1` to `180`.
     * > **NOTE:** `request_timeout` is only valid when `protocol` is `HTTP` or `HTTPS`.
     */
    @JvmName("ggpirewrghkndptu")
    public suspend fun requestTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestTimeout = mapped
    }

    /**
     * @param value The ID of the security policy. **NOTE:** Only `HTTPS` listeners support this parameter. Valid values:
     */
    @JvmName("omlaotvgvlsqphwd")
    public suspend fun securityPolicyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityPolicyId = mapped
    }

    internal fun build(): ListenerArgs = ListenerArgs(
        acceleratorId = acceleratorId,
        certificates = certificates,
        clientAffinity = clientAffinity,
        description = description,
        forwardedForConfig = forwardedForConfig,
        httpVersion = httpVersion,
        idleTimeout = idleTimeout,
        listenerType = listenerType,
        name = name,
        portRanges = portRanges,
        protocol = protocol,
        proxyProtocol = proxyProtocol,
        requestTimeout = requestTimeout,
        securityPolicyId = securityPolicyId,
    )
}
