@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.inputs

import com.pulumi.alicloud.ga.inputs.AclAclEntryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property entry The IP address(192.168.XX.XX) or CIDR(10.0.XX.XX/24) block that you want to add to the network ACL.
 * @property entryDescription The description of the IP entry. The description must be `1` to `256` characters in length, and can contain letters, digits, hyphens (-), forward slashes (/), periods (.),and underscores (_).
 */
public data class AclAclEntryArgs(
    public val entry: Output<String>? = null,
    public val entryDescription: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ga.inputs.AclAclEntryArgs> {
    override fun toJava(): com.pulumi.alicloud.ga.inputs.AclAclEntryArgs =
        com.pulumi.alicloud.ga.inputs.AclAclEntryArgs.builder()
            .entry(entry?.applyValue({ args0 -> args0 }))
            .entryDescription(entryDescription?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AclAclEntryArgs].
 */
@PulumiTagMarker
public class AclAclEntryArgsBuilder internal constructor() {
    private var entry: Output<String>? = null

    private var entryDescription: Output<String>? = null

    /**
     * @param value The IP address(192.168.XX.XX) or CIDR(10.0.XX.XX/24) block that you want to add to the network ACL.
     */
    @JvmName("belmkbqlyxcidgmm")
    public suspend fun entry(`value`: Output<String>) {
        this.entry = value
    }

    /**
     * @param value The description of the IP entry. The description must be `1` to `256` characters in length, and can contain letters, digits, hyphens (-), forward slashes (/), periods (.),and underscores (_).
     */
    @JvmName("epsikcnpwlmyqvsy")
    public suspend fun entryDescription(`value`: Output<String>) {
        this.entryDescription = value
    }

    /**
     * @param value The IP address(192.168.XX.XX) or CIDR(10.0.XX.XX/24) block that you want to add to the network ACL.
     */
    @JvmName("ooifyiqudjxdgdin")
    public suspend fun entry(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.entry = mapped
    }

    /**
     * @param value The description of the IP entry. The description must be `1` to `256` characters in length, and can contain letters, digits, hyphens (-), forward slashes (/), periods (.),and underscores (_).
     */
    @JvmName("umevdtmknaveejeh")
    public suspend fun entryDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.entryDescription = mapped
    }

    internal fun build(): AclAclEntryArgs = AclAclEntryArgs(
        entry = entry,
        entryDescription = entryDescription,
    )
}
