@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.inputs

import com.pulumi.alicloud.ga.inputs.CustomRoutingEndpointTrafficPolicyPortRangeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property fromPort The start port of the port range of the traffic destination. The specified port must fall within the port range of the specified endpoint group.
 * @property toPort The end port of the port range of the traffic destination. The specified port must fall within the port range of the specified endpoint group.
 */
public data class CustomRoutingEndpointTrafficPolicyPortRangeArgs(
    public val fromPort: Output<Int>? = null,
    public val toPort: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ga.inputs.CustomRoutingEndpointTrafficPolicyPortRangeArgs> {
    override fun toJava(): com.pulumi.alicloud.ga.inputs.CustomRoutingEndpointTrafficPolicyPortRangeArgs =
        com.pulumi.alicloud.ga.inputs.CustomRoutingEndpointTrafficPolicyPortRangeArgs.builder()
            .fromPort(fromPort?.applyValue({ args0 -> args0 }))
            .toPort(toPort?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomRoutingEndpointTrafficPolicyPortRangeArgs].
 */
@PulumiTagMarker
public class CustomRoutingEndpointTrafficPolicyPortRangeArgsBuilder internal constructor() {
    private var fromPort: Output<Int>? = null

    private var toPort: Output<Int>? = null

    /**
     * @param value The start port of the port range of the traffic destination. The specified port must fall within the port range of the specified endpoint group.
     */
    @JvmName("psdjsecdxgvdtofo")
    public suspend fun fromPort(`value`: Output<Int>) {
        this.fromPort = value
    }

    /**
     * @param value The end port of the port range of the traffic destination. The specified port must fall within the port range of the specified endpoint group.
     */
    @JvmName("jpmcsqtgqgyssksb")
    public suspend fun toPort(`value`: Output<Int>) {
        this.toPort = value
    }

    /**
     * @param value The start port of the port range of the traffic destination. The specified port must fall within the port range of the specified endpoint group.
     */
    @JvmName("dlxbpovhyulfgaqx")
    public suspend fun fromPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fromPort = mapped
    }

    /**
     * @param value The end port of the port range of the traffic destination. The specified port must fall within the port range of the specified endpoint group.
     */
    @JvmName("oumggisqraogtqqf")
    public suspend fun toPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.toPort = mapped
    }

    internal fun build(): CustomRoutingEndpointTrafficPolicyPortRangeArgs =
        CustomRoutingEndpointTrafficPolicyPortRangeArgs(
            fromPort = fromPort,
            toPort = toPort,
        )
}
