@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.inputs

import com.pulumi.alicloud.ga.inputs.EndpointGroupEndpointConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enableClientipPreservation Indicates whether client IP addresses are reserved. Default Value: `false`. Valid values:
 * @property enableProxyProtocol Specifies whether to preserve client IP addresses by using the ProxyProtocol module. Default Value: `false`. Valid values:
 * @property endpoint The IP address or domain name of Endpoint N in the endpoint group.
 * @property type The type of Endpoint N in the endpoint group. Valid values:
 * - `Domain`: a custom domain name.
 * - `Ip`: a custom IP address.
 * - `PublicIp`: an Alibaba Cloud public IP address.
 * - `ECS`: an Alibaba Cloud Elastic Compute Service (ECS) instance.
 * - `SLB`: an Alibaba Cloud Server Load Balancer (SLB) instance.
 * > **NOTE:** When the terminal node type is ECS or SLB, if the service association role does not exist, the system will automatically create a service association role named aliyunserviceroleforgavpcndpoint.
 * @property weight The weight of Endpoint N in the endpoint group. Valid values: `0` to `255`.
 * > **NOTE:** If the weight of a terminal node is set to 0, global acceleration will terminate the distribution of traffic to the terminal node. Please be careful.
 */
public data class EndpointGroupEndpointConfigurationArgs(
    public val enableClientipPreservation: Output<Boolean>? = null,
    public val enableProxyProtocol: Output<Boolean>? = null,
    public val endpoint: Output<String>,
    public val type: Output<String>,
    public val weight: Output<Int>,
) : ConvertibleToJava<com.pulumi.alicloud.ga.inputs.EndpointGroupEndpointConfigurationArgs> {
    override fun toJava(): com.pulumi.alicloud.ga.inputs.EndpointGroupEndpointConfigurationArgs =
        com.pulumi.alicloud.ga.inputs.EndpointGroupEndpointConfigurationArgs.builder()
            .enableClientipPreservation(enableClientipPreservation?.applyValue({ args0 -> args0 }))
            .enableProxyProtocol(enableProxyProtocol?.applyValue({ args0 -> args0 }))
            .endpoint(endpoint.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .weight(weight.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointGroupEndpointConfigurationArgs].
 */
@PulumiTagMarker
public class EndpointGroupEndpointConfigurationArgsBuilder internal constructor() {
    private var enableClientipPreservation: Output<Boolean>? = null

    private var enableProxyProtocol: Output<Boolean>? = null

    private var endpoint: Output<String>? = null

    private var type: Output<String>? = null

    private var weight: Output<Int>? = null

    /**
     * @param value Indicates whether client IP addresses are reserved. Default Value: `false`. Valid values:
     */
    @JvmName("wcpxnpavgwtrjobq")
    public suspend fun enableClientipPreservation(`value`: Output<Boolean>) {
        this.enableClientipPreservation = value
    }

    /**
     * @param value Specifies whether to preserve client IP addresses by using the ProxyProtocol module. Default Value: `false`. Valid values:
     */
    @JvmName("rsthcvytswxscqnj")
    public suspend fun enableProxyProtocol(`value`: Output<Boolean>) {
        this.enableProxyProtocol = value
    }

    /**
     * @param value The IP address or domain name of Endpoint N in the endpoint group.
     */
    @JvmName("mqpyhgplexknmvjs")
    public suspend fun endpoint(`value`: Output<String>) {
        this.endpoint = value
    }

    /**
     * @param value The type of Endpoint N in the endpoint group. Valid values:
     * - `Domain`: a custom domain name.
     * - `Ip`: a custom IP address.
     * - `PublicIp`: an Alibaba Cloud public IP address.
     * - `ECS`: an Alibaba Cloud Elastic Compute Service (ECS) instance.
     * - `SLB`: an Alibaba Cloud Server Load Balancer (SLB) instance.
     * > **NOTE:** When the terminal node type is ECS or SLB, if the service association role does not exist, the system will automatically create a service association role named aliyunserviceroleforgavpcndpoint.
     */
    @JvmName("yelxjjmxwenlfuri")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The weight of Endpoint N in the endpoint group. Valid values: `0` to `255`.
     * > **NOTE:** If the weight of a terminal node is set to 0, global acceleration will terminate the distribution of traffic to the terminal node. Please be careful.
     */
    @JvmName("erggodyadysgkyrd")
    public suspend fun weight(`value`: Output<Int>) {
        this.weight = value
    }

    /**
     * @param value Indicates whether client IP addresses are reserved. Default Value: `false`. Valid values:
     */
    @JvmName("ejqlusudwkunyeug")
    public suspend fun enableClientipPreservation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableClientipPreservation = mapped
    }

    /**
     * @param value Specifies whether to preserve client IP addresses by using the ProxyProtocol module. Default Value: `false`. Valid values:
     */
    @JvmName("mcfyglygothjpyhn")
    public suspend fun enableProxyProtocol(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableProxyProtocol = mapped
    }

    /**
     * @param value The IP address or domain name of Endpoint N in the endpoint group.
     */
    @JvmName("togdkbdrmdeedwds")
    public suspend fun endpoint(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpoint = mapped
    }

    /**
     * @param value The type of Endpoint N in the endpoint group. Valid values:
     * - `Domain`: a custom domain name.
     * - `Ip`: a custom IP address.
     * - `PublicIp`: an Alibaba Cloud public IP address.
     * - `ECS`: an Alibaba Cloud Elastic Compute Service (ECS) instance.
     * - `SLB`: an Alibaba Cloud Server Load Balancer (SLB) instance.
     * > **NOTE:** When the terminal node type is ECS or SLB, if the service association role does not exist, the system will automatically create a service association role named aliyunserviceroleforgavpcndpoint.
     */
    @JvmName("kruworcqiqwdhbrv")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The weight of Endpoint N in the endpoint group. Valid values: `0` to `255`.
     * > **NOTE:** If the weight of a terminal node is set to 0, global acceleration will terminate the distribution of traffic to the terminal node. Please be careful.
     */
    @JvmName("ohfvvlihjnbaxqbt")
    public suspend fun weight(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.weight = mapped
    }

    internal fun build(): EndpointGroupEndpointConfigurationArgs =
        EndpointGroupEndpointConfigurationArgs(
            enableClientipPreservation = enableClientipPreservation,
            enableProxyProtocol = enableProxyProtocol,
            endpoint = endpoint ?: throw PulumiNullFieldException("endpoint"),
            type = type ?: throw PulumiNullFieldException("type"),
            weight = weight ?: throw PulumiNullFieldException("weight"),
        )
}
