@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.inputs

import com.pulumi.alicloud.ga.inputs.EndpointGroupPortOverridesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property endpointPort Forwarding port.
 * @property listenerPort Listener port.
 */
public data class EndpointGroupPortOverridesArgs(
    public val endpointPort: Output<Int>? = null,
    public val listenerPort: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ga.inputs.EndpointGroupPortOverridesArgs> {
    override fun toJava(): com.pulumi.alicloud.ga.inputs.EndpointGroupPortOverridesArgs =
        com.pulumi.alicloud.ga.inputs.EndpointGroupPortOverridesArgs.builder()
            .endpointPort(endpointPort?.applyValue({ args0 -> args0 }))
            .listenerPort(listenerPort?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointGroupPortOverridesArgs].
 */
@PulumiTagMarker
public class EndpointGroupPortOverridesArgsBuilder internal constructor() {
    private var endpointPort: Output<Int>? = null

    private var listenerPort: Output<Int>? = null

    /**
     * @param value Forwarding port.
     */
    @JvmName("wsunlufupfudawgg")
    public suspend fun endpointPort(`value`: Output<Int>) {
        this.endpointPort = value
    }

    /**
     * @param value Listener port.
     */
    @JvmName("cldosgqvkjoulked")
    public suspend fun listenerPort(`value`: Output<Int>) {
        this.listenerPort = value
    }

    /**
     * @param value Forwarding port.
     */
    @JvmName("okbdyuwivilimlup")
    public suspend fun endpointPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointPort = mapped
    }

    /**
     * @param value Listener port.
     */
    @JvmName("lvwinjkvnkjsalgq")
    public suspend fun listenerPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.listenerPort = mapped
    }

    internal fun build(): EndpointGroupPortOverridesArgs = EndpointGroupPortOverridesArgs(
        endpointPort = endpointPort,
        listenerPort = listenerPort,
    )
}
