@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.inputs

import com.pulumi.alicloud.ga.inputs.ForwardingRuleRuleActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property forwardGroupConfig Forwarding configuration. See `forward_group_config` below.
 * > **NOTE:** From version 1.207.0, We recommend that you do not use `forward_group_config`, and we recommend that you use the `rule_action_type` and `rule_action_value` to configure forwarding actions.
 * @property order Forwarding priority.
 * @property ruleActionType Forward action type.
 * @property ruleActionValue The value of the forwarding action type. For more information, see [How to use it](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-createforwardingrules).
 */
public data class ForwardingRuleRuleActionArgs(
    public val forwardGroupConfig: Output<ForwardingRuleRuleActionForwardGroupConfigArgs>? = null,
    public val order: Output<Int>,
    public val ruleActionType: Output<String>,
    public val ruleActionValue: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ga.inputs.ForwardingRuleRuleActionArgs> {
    override fun toJava(): com.pulumi.alicloud.ga.inputs.ForwardingRuleRuleActionArgs =
        com.pulumi.alicloud.ga.inputs.ForwardingRuleRuleActionArgs.builder()
            .forwardGroupConfig(
                forwardGroupConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .order(order.applyValue({ args0 -> args0 }))
            .ruleActionType(ruleActionType.applyValue({ args0 -> args0 }))
            .ruleActionValue(ruleActionValue?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ForwardingRuleRuleActionArgs].
 */
@PulumiTagMarker
public class ForwardingRuleRuleActionArgsBuilder internal constructor() {
    private var forwardGroupConfig: Output<ForwardingRuleRuleActionForwardGroupConfigArgs>? = null

    private var order: Output<Int>? = null

    private var ruleActionType: Output<String>? = null

    private var ruleActionValue: Output<String>? = null

    /**
     * @param value Forwarding configuration. See `forward_group_config` below.
     * > **NOTE:** From version 1.207.0, We recommend that you do not use `forward_group_config`, and we recommend that you use the `rule_action_type` and `rule_action_value` to configure forwarding actions.
     */
    @JvmName("spngtvvpajsifxdg")
    public suspend fun forwardGroupConfig(`value`: Output<ForwardingRuleRuleActionForwardGroupConfigArgs>) {
        this.forwardGroupConfig = value
    }

    /**
     * @param value Forwarding priority.
     */
    @JvmName("dkoygniqrokdhkgy")
    public suspend fun order(`value`: Output<Int>) {
        this.order = value
    }

    /**
     * @param value Forward action type.
     */
    @JvmName("ermelfewixvxafun")
    public suspend fun ruleActionType(`value`: Output<String>) {
        this.ruleActionType = value
    }

    /**
     * @param value The value of the forwarding action type. For more information, see [How to use it](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-createforwardingrules).
     */
    @JvmName("qfxpkuoqgygsysrc")
    public suspend fun ruleActionValue(`value`: Output<String>) {
        this.ruleActionValue = value
    }

    /**
     * @param value Forwarding configuration. See `forward_group_config` below.
     * > **NOTE:** From version 1.207.0, We recommend that you do not use `forward_group_config`, and we recommend that you use the `rule_action_type` and `rule_action_value` to configure forwarding actions.
     */
    @JvmName("cqxqhnfyyduwnote")
    public suspend fun forwardGroupConfig(`value`: ForwardingRuleRuleActionForwardGroupConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forwardGroupConfig = mapped
    }

    /**
     * @param argument Forwarding configuration. See `forward_group_config` below.
     * > **NOTE:** From version 1.207.0, We recommend that you do not use `forward_group_config`, and we recommend that you use the `rule_action_type` and `rule_action_value` to configure forwarding actions.
     */
    @JvmName("ccectbyyvqfgipnq")
    public suspend fun forwardGroupConfig(argument: suspend ForwardingRuleRuleActionForwardGroupConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ForwardingRuleRuleActionForwardGroupConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.forwardGroupConfig = mapped
    }

    /**
     * @param value Forwarding priority.
     */
    @JvmName("gaosjpfrecdwaqbg")
    public suspend fun order(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.order = mapped
    }

    /**
     * @param value Forward action type.
     */
    @JvmName("tgcvioegidgukiky")
    public suspend fun ruleActionType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleActionType = mapped
    }

    /**
     * @param value The value of the forwarding action type. For more information, see [How to use it](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-createforwardingrules).
     */
    @JvmName("pxoujluevubdbkrw")
    public suspend fun ruleActionValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleActionValue = mapped
    }

    internal fun build(): ForwardingRuleRuleActionArgs = ForwardingRuleRuleActionArgs(
        forwardGroupConfig = forwardGroupConfig,
        order = order ?: throw PulumiNullFieldException("order"),
        ruleActionType = ruleActionType ?: throw PulumiNullFieldException("ruleActionType"),
        ruleActionValue = ruleActionValue,
    )
}
