@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.inputs

import com.pulumi.alicloud.ga.inputs.ForwardingRuleRuleActionForwardGroupConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property serverGroupTuples The information about the endpoint group. See `server_group_tuples` below.
 */
public data class ForwardingRuleRuleActionForwardGroupConfigArgs(
    public val serverGroupTuples: Output<List<ForwardingRuleRuleActionForwardGroupConfigServerGroupTupleArgs>>,
) : ConvertibleToJava<com.pulumi.alicloud.ga.inputs.ForwardingRuleRuleActionForwardGroupConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.ga.inputs.ForwardingRuleRuleActionForwardGroupConfigArgs =
        com.pulumi.alicloud.ga.inputs.ForwardingRuleRuleActionForwardGroupConfigArgs.builder()
            .serverGroupTuples(
                serverGroupTuples.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ForwardingRuleRuleActionForwardGroupConfigArgs].
 */
@PulumiTagMarker
public class ForwardingRuleRuleActionForwardGroupConfigArgsBuilder internal constructor() {
    private var serverGroupTuples:
        Output<List<ForwardingRuleRuleActionForwardGroupConfigServerGroupTupleArgs>>? = null

    /**
     * @param value The information about the endpoint group. See `server_group_tuples` below.
     */
    @JvmName("rvlttdcmntekkjve")
    public suspend fun serverGroupTuples(`value`: Output<List<ForwardingRuleRuleActionForwardGroupConfigServerGroupTupleArgs>>) {
        this.serverGroupTuples = value
    }

    @JvmName("dsvalqffpnsrpkhi")
    public suspend fun serverGroupTuples(vararg values: Output<ForwardingRuleRuleActionForwardGroupConfigServerGroupTupleArgs>) {
        this.serverGroupTuples = Output.all(values.asList())
    }

    /**
     * @param values The information about the endpoint group. See `server_group_tuples` below.
     */
    @JvmName("qbiarnlbdktdmixw")
    public suspend fun serverGroupTuples(values: List<Output<ForwardingRuleRuleActionForwardGroupConfigServerGroupTupleArgs>>) {
        this.serverGroupTuples = Output.all(values)
    }

    /**
     * @param value The information about the endpoint group. See `server_group_tuples` below.
     */
    @JvmName("ieyigihvcmnldugk")
    public suspend fun serverGroupTuples(`value`: List<ForwardingRuleRuleActionForwardGroupConfigServerGroupTupleArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serverGroupTuples = mapped
    }

    /**
     * @param argument The information about the endpoint group. See `server_group_tuples` below.
     */
    @JvmName("qbrncjpvdcanrojm")
    public suspend fun serverGroupTuples(argument: List<suspend ForwardingRuleRuleActionForwardGroupConfigServerGroupTupleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ForwardingRuleRuleActionForwardGroupConfigServerGroupTupleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.serverGroupTuples = mapped
    }

    /**
     * @param argument The information about the endpoint group. See `server_group_tuples` below.
     */
    @JvmName("pqvgwosatyxaamem")
    public suspend fun serverGroupTuples(vararg argument: suspend ForwardingRuleRuleActionForwardGroupConfigServerGroupTupleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ForwardingRuleRuleActionForwardGroupConfigServerGroupTupleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.serverGroupTuples = mapped
    }

    /**
     * @param argument The information about the endpoint group. See `server_group_tuples` below.
     */
    @JvmName("bvhotbxypbqgddao")
    public suspend fun serverGroupTuples(argument: suspend ForwardingRuleRuleActionForwardGroupConfigServerGroupTupleArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ForwardingRuleRuleActionForwardGroupConfigServerGroupTupleArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.serverGroupTuples = mapped
    }

    /**
     * @param values The information about the endpoint group. See `server_group_tuples` below.
     */
    @JvmName("krrflcebkqqbaskl")
    public suspend fun serverGroupTuples(vararg values: ForwardingRuleRuleActionForwardGroupConfigServerGroupTupleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serverGroupTuples = mapped
    }

    internal fun build(): ForwardingRuleRuleActionForwardGroupConfigArgs =
        ForwardingRuleRuleActionForwardGroupConfigArgs(
            serverGroupTuples = serverGroupTuples ?: throw PulumiNullFieldException("serverGroupTuples"),
        )
}
