@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.inputs

import com.pulumi.alicloud.ga.inputs.ForwardingRuleRuleConditionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property hostConfigs The configuration of the domain name. See `host_config` below.
 * @property pathConfig The configuration of the path. See `path_config` below.
 * @property ruleConditionType The type of the forwarding conditions. Valid values: `Host`, `Path`.
 */
public data class ForwardingRuleRuleConditionArgs(
    public val hostConfigs: Output<List<ForwardingRuleRuleConditionHostConfigArgs>>? = null,
    public val pathConfig: Output<ForwardingRuleRuleConditionPathConfigArgs>? = null,
    public val ruleConditionType: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.ga.inputs.ForwardingRuleRuleConditionArgs> {
    override fun toJava(): com.pulumi.alicloud.ga.inputs.ForwardingRuleRuleConditionArgs =
        com.pulumi.alicloud.ga.inputs.ForwardingRuleRuleConditionArgs.builder()
            .hostConfigs(
                hostConfigs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .pathConfig(pathConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ruleConditionType(ruleConditionType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ForwardingRuleRuleConditionArgs].
 */
@PulumiTagMarker
public class ForwardingRuleRuleConditionArgsBuilder internal constructor() {
    private var hostConfigs: Output<List<ForwardingRuleRuleConditionHostConfigArgs>>? = null

    private var pathConfig: Output<ForwardingRuleRuleConditionPathConfigArgs>? = null

    private var ruleConditionType: Output<String>? = null

    /**
     * @param value The configuration of the domain name. See `host_config` below.
     */
    @JvmName("jqyfnxuwvveblhdh")
    public suspend fun hostConfigs(`value`: Output<List<ForwardingRuleRuleConditionHostConfigArgs>>) {
        this.hostConfigs = value
    }

    @JvmName("xjiwilqtxkgqwicm")
    public suspend fun hostConfigs(vararg values: Output<ForwardingRuleRuleConditionHostConfigArgs>) {
        this.hostConfigs = Output.all(values.asList())
    }

    /**
     * @param values The configuration of the domain name. See `host_config` below.
     */
    @JvmName("hfnnpaaxnbkwwgsr")
    public suspend fun hostConfigs(values: List<Output<ForwardingRuleRuleConditionHostConfigArgs>>) {
        this.hostConfigs = Output.all(values)
    }

    /**
     * @param value The configuration of the path. See `path_config` below.
     */
    @JvmName("uciqogyjdjdxwxss")
    public suspend fun pathConfig(`value`: Output<ForwardingRuleRuleConditionPathConfigArgs>) {
        this.pathConfig = value
    }

    /**
     * @param value The type of the forwarding conditions. Valid values: `Host`, `Path`.
     */
    @JvmName("xvsmlqgwymdqtuco")
    public suspend fun ruleConditionType(`value`: Output<String>) {
        this.ruleConditionType = value
    }

    /**
     * @param value The configuration of the domain name. See `host_config` below.
     */
    @JvmName("xqluqgfiuclmnhyg")
    public suspend fun hostConfigs(`value`: List<ForwardingRuleRuleConditionHostConfigArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostConfigs = mapped
    }

    /**
     * @param argument The configuration of the domain name. See `host_config` below.
     */
    @JvmName("wcnslsghdisajnwl")
    public suspend fun hostConfigs(argument: List<suspend ForwardingRuleRuleConditionHostConfigArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ForwardingRuleRuleConditionHostConfigArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.hostConfigs = mapped
    }

    /**
     * @param argument The configuration of the domain name. See `host_config` below.
     */
    @JvmName("frcvwemqueqqqjtv")
    public suspend fun hostConfigs(vararg argument: suspend ForwardingRuleRuleConditionHostConfigArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ForwardingRuleRuleConditionHostConfigArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.hostConfigs = mapped
    }

    /**
     * @param argument The configuration of the domain name. See `host_config` below.
     */
    @JvmName("tiopfwjrepqhwysv")
    public suspend fun hostConfigs(argument: suspend ForwardingRuleRuleConditionHostConfigArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ForwardingRuleRuleConditionHostConfigArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.hostConfigs = mapped
    }

    /**
     * @param values The configuration of the domain name. See `host_config` below.
     */
    @JvmName("evfqlgsandvynyoe")
    public suspend fun hostConfigs(vararg values: ForwardingRuleRuleConditionHostConfigArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hostConfigs = mapped
    }

    /**
     * @param value The configuration of the path. See `path_config` below.
     */
    @JvmName("xogntkupwkrpvexj")
    public suspend fun pathConfig(`value`: ForwardingRuleRuleConditionPathConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pathConfig = mapped
    }

    /**
     * @param argument The configuration of the path. See `path_config` below.
     */
    @JvmName("opincovtxgqjayqs")
    public suspend fun pathConfig(argument: suspend ForwardingRuleRuleConditionPathConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ForwardingRuleRuleConditionPathConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.pathConfig = mapped
    }

    /**
     * @param value The type of the forwarding conditions. Valid values: `Host`, `Path`.
     */
    @JvmName("dgwljtbtabxxnojv")
    public suspend fun ruleConditionType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleConditionType = mapped
    }

    internal fun build(): ForwardingRuleRuleConditionArgs = ForwardingRuleRuleConditionArgs(
        hostConfigs = hostConfigs,
        pathConfig = pathConfig,
        ruleConditionType = ruleConditionType ?: throw PulumiNullFieldException("ruleConditionType"),
    )
}
