@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.inputs

import com.pulumi.alicloud.ga.inputs.ForwardingRuleRuleConditionHostConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property values The domain name is 3-128 characters long, which can contain letters, numbers, dashes (-) and width period (.), and supports the use of asterisk (*) and width question mark (?) as wildcard characters.
 */
public data class ForwardingRuleRuleConditionHostConfigArgs(
    public val values: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ga.inputs.ForwardingRuleRuleConditionHostConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.ga.inputs.ForwardingRuleRuleConditionHostConfigArgs =
        com.pulumi.alicloud.ga.inputs.ForwardingRuleRuleConditionHostConfigArgs.builder()
            .values(values?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ForwardingRuleRuleConditionHostConfigArgs].
 */
@PulumiTagMarker
public class ForwardingRuleRuleConditionHostConfigArgsBuilder internal constructor() {
    private var values: Output<List<String>>? = null

    /**
     * @param value The domain name is 3-128 characters long, which can contain letters, numbers, dashes (-) and width period (.), and supports the use of asterisk (*) and width question mark (?) as wildcard characters.
     */
    @JvmName("sqvskimiwoikmxgy")
    public suspend fun values(`value`: Output<List<String>>) {
        this.values = value
    }

    @JvmName("ocqoxjeuyibwmfbk")
    public suspend fun values(vararg values: Output<String>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values The domain name is 3-128 characters long, which can contain letters, numbers, dashes (-) and width period (.), and supports the use of asterisk (*) and width question mark (?) as wildcard characters.
     */
    @JvmName("oqrufjyoaoymktyr")
    public suspend fun values(values: List<Output<String>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value The domain name is 3-128 characters long, which can contain letters, numbers, dashes (-) and width period (.), and supports the use of asterisk (*) and width question mark (?) as wildcard characters.
     */
    @JvmName("unjvkgcxobctiihh")
    public suspend fun values(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param values The domain name is 3-128 characters long, which can contain letters, numbers, dashes (-) and width period (.), and supports the use of asterisk (*) and width question mark (?) as wildcard characters.
     */
    @JvmName("cnymhwsubaxoimdv")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): ForwardingRuleRuleConditionHostConfigArgs =
        ForwardingRuleRuleConditionHostConfigArgs(
            values = values,
        )
}
