@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.inputs

import com.pulumi.alicloud.ga.inputs.ForwardingRuleRuleConditionPathConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property values The domain name is 3-128 characters long, which can contain letters, numbers, dashes (-) and width period (.), and supports the use of asterisk (*) and width question mark (?) as wildcard characters.
 */
public data class ForwardingRuleRuleConditionPathConfigArgs(
    public val values: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ga.inputs.ForwardingRuleRuleConditionPathConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.ga.inputs.ForwardingRuleRuleConditionPathConfigArgs =
        com.pulumi.alicloud.ga.inputs.ForwardingRuleRuleConditionPathConfigArgs.builder()
            .values(values?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ForwardingRuleRuleConditionPathConfigArgs].
 */
@PulumiTagMarker
public class ForwardingRuleRuleConditionPathConfigArgsBuilder internal constructor() {
    private var values: Output<List<String>>? = null

    /**
     * @param value The domain name is 3-128 characters long, which can contain letters, numbers, dashes (-) and width period (.), and supports the use of asterisk (*) and width question mark (?) as wildcard characters.
     */
    @JvmName("ommunktjbohtgpch")
    public suspend fun values(`value`: Output<List<String>>) {
        this.values = value
    }

    @JvmName("evgiwbphvvesssao")
    public suspend fun values(vararg values: Output<String>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values The domain name is 3-128 characters long, which can contain letters, numbers, dashes (-) and width period (.), and supports the use of asterisk (*) and width question mark (?) as wildcard characters.
     */
    @JvmName("ckjnhlkhfmbuwjvj")
    public suspend fun values(values: List<Output<String>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value The domain name is 3-128 characters long, which can contain letters, numbers, dashes (-) and width period (.), and supports the use of asterisk (*) and width question mark (?) as wildcard characters.
     */
    @JvmName("tlnkrdknwagqcewo")
    public suspend fun values(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param values The domain name is 3-128 characters long, which can contain letters, numbers, dashes (-) and width period (.), and supports the use of asterisk (*) and width question mark (?) as wildcard characters.
     */
    @JvmName("repsfspxpxbmpyib")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): ForwardingRuleRuleConditionPathConfigArgs =
        ForwardingRuleRuleConditionPathConfigArgs(
            values = values,
        )
}
