@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.inputs

import com.pulumi.alicloud.ga.inputs.GetAcceleratorSpareIpAttachmentsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAcceleratorSpareIpAttachments.
 * @property acceleratorId The ID of the global acceleration instance.
 * @property ids A list of Accelerator Spare Ip Attachment IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the standby CNAME IP address. Valid values: `active`, `inuse`.
 */
public data class GetAcceleratorSpareIpAttachmentsPlainArgs(
    public val acceleratorId: String,
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ga.inputs.GetAcceleratorSpareIpAttachmentsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ga.inputs.GetAcceleratorSpareIpAttachmentsPlainArgs =
        com.pulumi.alicloud.ga.inputs.GetAcceleratorSpareIpAttachmentsPlainArgs.builder()
            .acceleratorId(acceleratorId.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAcceleratorSpareIpAttachmentsPlainArgs].
 */
@PulumiTagMarker
public class GetAcceleratorSpareIpAttachmentsPlainArgsBuilder internal constructor() {
    private var acceleratorId: String? = null

    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var status: String? = null

    /**
     * @param value The ID of the global acceleration instance.
     */
    @JvmName("tbtbxhhdoosbxmnf")
    public suspend fun acceleratorId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.acceleratorId = mapped
    }

    /**
     * @param value A list of Accelerator Spare Ip Attachment IDs.
     */
    @JvmName("sjdodrrphceiyerl")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Accelerator Spare Ip Attachment IDs.
     */
    @JvmName("wcyndqetyglhagnv")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("nwutbxqseptlanso")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the standby CNAME IP address. Valid values: `active`, `inuse`.
     */
    @JvmName("dtwsphogryjvldjs")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetAcceleratorSpareIpAttachmentsPlainArgs =
        GetAcceleratorSpareIpAttachmentsPlainArgs(
            acceleratorId = acceleratorId ?: throw PulumiNullFieldException("acceleratorId"),
            ids = ids,
            outputFile = outputFile,
            status = status,
        )
}
