@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.inputs

import com.pulumi.alicloud.ga.inputs.GetAcceleratorsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAccelerators.
 * @property bandwidthBillingType The bandwidth billing method. Default value: `BandwidthPackage`. Valid values:
 * - `BandwidthPackage`: billed based on bandwidth plans.
 * - `CDT`: billed based on data transfer.
 * @property ids A list of Accelerator IDs.
 * @property nameRegex A regex string to filter results by Accelerator name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the GA instance. Valid values: `active`, `binding`, `configuring`, `deleting`, `finacialLocked`, `init`, `unbinding`.
 */
public data class GetAcceleratorsPlainArgs(
    public val bandwidthBillingType: String? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ga.inputs.GetAcceleratorsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ga.inputs.GetAcceleratorsPlainArgs =
        com.pulumi.alicloud.ga.inputs.GetAcceleratorsPlainArgs.builder()
            .bandwidthBillingType(bandwidthBillingType?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAcceleratorsPlainArgs].
 */
@PulumiTagMarker
public class GetAcceleratorsPlainArgsBuilder internal constructor() {
    private var bandwidthBillingType: String? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    /**
     * @param value The bandwidth billing method. Default value: `BandwidthPackage`. Valid values:
     * - `BandwidthPackage`: billed based on bandwidth plans.
     * - `CDT`: billed based on data transfer.
     */
    @JvmName("oguabxaddnrqxbyk")
    public suspend fun bandwidthBillingType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.bandwidthBillingType = mapped
    }

    /**
     * @param value A list of Accelerator IDs.
     */
    @JvmName("jjtgathyvnblrxue")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Accelerator IDs.
     */
    @JvmName("pymqqgxfyxolgjwh")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Accelerator name.
     */
    @JvmName("suxjprolqxqawhgd")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("vbsmhijlgtbiycug")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the GA instance. Valid values: `active`, `binding`, `configuring`, `deleting`, `finacialLocked`, `init`, `unbinding`.
     */
    @JvmName("npjbbuduffujjbdd")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetAcceleratorsPlainArgs = GetAcceleratorsPlainArgs(
        bandwidthBillingType = bandwidthBillingType,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        status = status,
    )
}
