@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.inputs

import com.pulumi.alicloud.ga.inputs.GetAdditionalCertificatesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAdditionalCertificates.
 * @property acceleratorId The ID of the GA instance.
 * @property ids A list of Additional Certificate IDs.
 * @property listenerId The ID of the listener. Only HTTPS listeners support this parameter.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetAdditionalCertificatesPlainArgs(
    public val acceleratorId: String,
    public val ids: List<String>? = null,
    public val listenerId: String,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ga.inputs.GetAdditionalCertificatesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ga.inputs.GetAdditionalCertificatesPlainArgs =
        com.pulumi.alicloud.ga.inputs.GetAdditionalCertificatesPlainArgs.builder()
            .acceleratorId(acceleratorId.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .listenerId(listenerId.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAdditionalCertificatesPlainArgs].
 */
@PulumiTagMarker
public class GetAdditionalCertificatesPlainArgsBuilder internal constructor() {
    private var acceleratorId: String? = null

    private var ids: List<String>? = null

    private var listenerId: String? = null

    private var outputFile: String? = null

    /**
     * @param value The ID of the GA instance.
     */
    @JvmName("slhkeqghkfqufxnh")
    public suspend fun acceleratorId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.acceleratorId = mapped
    }

    /**
     * @param value A list of Additional Certificate IDs.
     */
    @JvmName("tlkhsmaqqteayvxt")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Additional Certificate IDs.
     */
    @JvmName("sisgceatanunptud")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The ID of the listener. Only HTTPS listeners support this parameter.
     */
    @JvmName("gmgpguritlkrsqff")
    public suspend fun listenerId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.listenerId = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("hiwjsheywvnqdsok")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetAdditionalCertificatesPlainArgs = GetAdditionalCertificatesPlainArgs(
        acceleratorId = acceleratorId ?: throw PulumiNullFieldException("acceleratorId"),
        ids = ids,
        listenerId = listenerId ?: throw PulumiNullFieldException("listenerId"),
        outputFile = outputFile,
    )
}
