@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.inputs

import com.pulumi.alicloud.ga.inputs.GetBasicAccelerateIpEndpointRelationsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getBasicAccelerateIpEndpointRelations.
 * @property accelerateIpId The ID of the Basic Accelerate IP.
 * @property acceleratorId The ID of the Global Accelerator Basic Accelerator instance.
 * @property endpointId The ID of the Basic Endpoint.
 * @property ids A list of Global Accelerator Basic Accelerate Ip Endpoint Relations IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the Global Accelerator Basic Accelerate Ip Endpoint Relation. Valid Value: `active`.
 */
public data class GetBasicAccelerateIpEndpointRelationsPlainArgs(
    public val accelerateIpId: String? = null,
    public val acceleratorId: String,
    public val endpointId: String? = null,
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ga.inputs.GetBasicAccelerateIpEndpointRelationsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ga.inputs.GetBasicAccelerateIpEndpointRelationsPlainArgs =
        com.pulumi.alicloud.ga.inputs.GetBasicAccelerateIpEndpointRelationsPlainArgs.builder()
            .accelerateIpId(accelerateIpId?.let({ args0 -> args0 }))
            .acceleratorId(acceleratorId.let({ args0 -> args0 }))
            .endpointId(endpointId?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBasicAccelerateIpEndpointRelationsPlainArgs].
 */
@PulumiTagMarker
public class GetBasicAccelerateIpEndpointRelationsPlainArgsBuilder internal constructor() {
    private var accelerateIpId: String? = null

    private var acceleratorId: String? = null

    private var endpointId: String? = null

    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var status: String? = null

    /**
     * @param value The ID of the Basic Accelerate IP.
     */
    @JvmName("kvfjeqpeubeohryi")
    public suspend fun accelerateIpId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.accelerateIpId = mapped
    }

    /**
     * @param value The ID of the Global Accelerator Basic Accelerator instance.
     */
    @JvmName("lbpmcifcvstpsxvl")
    public suspend fun acceleratorId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.acceleratorId = mapped
    }

    /**
     * @param value The ID of the Basic Endpoint.
     */
    @JvmName("ihdrqbysnhvfbpdt")
    public suspend fun endpointId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.endpointId = mapped
    }

    /**
     * @param value A list of Global Accelerator Basic Accelerate Ip Endpoint Relations IDs.
     */
    @JvmName("qcnpbwcsdehvsgvm")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Global Accelerator Basic Accelerate Ip Endpoint Relations IDs.
     */
    @JvmName("xwiixkmfiggaffrk")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("ecmyeiflpivspjag")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the Global Accelerator Basic Accelerate Ip Endpoint Relation. Valid Value: `active`.
     */
    @JvmName("lllqhndulqfjvwcj")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetBasicAccelerateIpEndpointRelationsPlainArgs =
        GetBasicAccelerateIpEndpointRelationsPlainArgs(
            accelerateIpId = accelerateIpId,
            acceleratorId = acceleratorId ?: throw PulumiNullFieldException("acceleratorId"),
            endpointId = endpointId,
            ids = ids,
            outputFile = outputFile,
            status = status,
        )
}
