@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.inputs

import com.pulumi.alicloud.ga.inputs.GetBasicAccelerateIpsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getBasicAccelerateIps.
 * @property accelerateIpAddress The address of the Basic Accelerate IP.
 * @property accelerateIpId The id of the Basic Accelerate IP.
 * @property ids A list of Global Accelerator Basic Accelerate IP IDs.
 * @property ipSetId The ID of the Basic Ip Set.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the Global Accelerator Basic Accelerate IP instance. Valid Value: `active`, `binding`, `bound`, `unbinding`, `deleting`.
 */
public data class GetBasicAccelerateIpsPlainArgs(
    public val accelerateIpAddress: String? = null,
    public val accelerateIpId: String? = null,
    public val ids: List<String>? = null,
    public val ipSetId: String,
    public val outputFile: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ga.inputs.GetBasicAccelerateIpsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ga.inputs.GetBasicAccelerateIpsPlainArgs =
        com.pulumi.alicloud.ga.inputs.GetBasicAccelerateIpsPlainArgs.builder()
            .accelerateIpAddress(accelerateIpAddress?.let({ args0 -> args0 }))
            .accelerateIpId(accelerateIpId?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .ipSetId(ipSetId.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBasicAccelerateIpsPlainArgs].
 */
@PulumiTagMarker
public class GetBasicAccelerateIpsPlainArgsBuilder internal constructor() {
    private var accelerateIpAddress: String? = null

    private var accelerateIpId: String? = null

    private var ids: List<String>? = null

    private var ipSetId: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    /**
     * @param value The address of the Basic Accelerate IP.
     */
    @JvmName("jrofnsfajabbmadd")
    public suspend fun accelerateIpAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.accelerateIpAddress = mapped
    }

    /**
     * @param value The id of the Basic Accelerate IP.
     */
    @JvmName("bgasraddabqhculq")
    public suspend fun accelerateIpId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.accelerateIpId = mapped
    }

    /**
     * @param value A list of Global Accelerator Basic Accelerate IP IDs.
     */
    @JvmName("bwtwkykuhdcfprqm")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Global Accelerator Basic Accelerate IP IDs.
     */
    @JvmName("lflfxpaxvqdymuud")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The ID of the Basic Ip Set.
     */
    @JvmName("oknlviuictdeqlvs")
    public suspend fun ipSetId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ipSetId = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("fvruyjskqsbkqjjo")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the Global Accelerator Basic Accelerate IP instance. Valid Value: `active`, `binding`, `bound`, `unbinding`, `deleting`.
     */
    @JvmName("thophpmavahawwkw")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetBasicAccelerateIpsPlainArgs = GetBasicAccelerateIpsPlainArgs(
        accelerateIpAddress = accelerateIpAddress,
        accelerateIpId = accelerateIpId,
        ids = ids,
        ipSetId = ipSetId ?: throw PulumiNullFieldException("ipSetId"),
        outputFile = outputFile,
        status = status,
    )
}
