@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.inputs

import com.pulumi.alicloud.ga.inputs.GetBasicAcceleratorsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getBasicAccelerators.
 * @property acceleratorId The ID of the Global Accelerator Basic Accelerator instance.
 * @property ids A list of Global Accelerator Basic Accelerator IDs.
 * @property nameRegex A regex string to filter results by Global Accelerator Basic Accelerator name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property pageNumber
 * @property pageSize
 * @property status The status of the Global Accelerator Basic Accelerator instance. Valid Value: `init`, `active`, `configuring`, `binding`, `unbinding`, `deleting`, `finacialLocked`.
 */
public data class GetBasicAcceleratorsPlainArgs(
    public val acceleratorId: String? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ga.inputs.GetBasicAcceleratorsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ga.inputs.GetBasicAcceleratorsPlainArgs =
        com.pulumi.alicloud.ga.inputs.GetBasicAcceleratorsPlainArgs.builder()
            .acceleratorId(acceleratorId?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .pageNumber(pageNumber?.let({ args0 -> args0 }))
            .pageSize(pageSize?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBasicAcceleratorsPlainArgs].
 */
@PulumiTagMarker
public class GetBasicAcceleratorsPlainArgsBuilder internal constructor() {
    private var acceleratorId: String? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var pageNumber: Int? = null

    private var pageSize: Int? = null

    private var status: String? = null

    /**
     * @param value The ID of the Global Accelerator Basic Accelerator instance.
     */
    @JvmName("vrmlxpuuvmnyemcr")
    public suspend fun acceleratorId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.acceleratorId = mapped
    }

    /**
     * @param value A list of Global Accelerator Basic Accelerator IDs.
     */
    @JvmName("hgqiuxrpdkknydcs")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Global Accelerator Basic Accelerator IDs.
     */
    @JvmName("elqfyjfnerkbvsqt")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Global Accelerator Basic Accelerator name.
     */
    @JvmName("lqiyrbmhsoebblhp")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("sdfhdevxodacaiwk")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("ntrnwuojuasvrxpy")
    public suspend fun pageNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("qchfidmrgewgeivl")
    public suspend fun pageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageSize = mapped
    }

    /**
     * @param value The status of the Global Accelerator Basic Accelerator instance. Valid Value: `init`, `active`, `configuring`, `binding`, `unbinding`, `deleting`, `finacialLocked`.
     */
    @JvmName("dhgpymwxgsdksmax")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetBasicAcceleratorsPlainArgs = GetBasicAcceleratorsPlainArgs(
        acceleratorId = acceleratorId,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        pageNumber = pageNumber,
        pageSize = pageSize,
        status = status,
    )
}
