@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.inputs

import com.pulumi.alicloud.ga.inputs.GetBasicEndpointsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getBasicEndpoints.
 * @property endpointGroupId The ID of the Basic Endpoint Group.
 * @property endpointId The ID of the Basic Endpoint.
 * @property endpointType The type of the Basic Endpoint. Valid values: `ENI`, `SLB`, `ECS` and `NLB`.
 * @property ids A list of Global Accelerator Basic Endpoints IDs.
 * @property name The name of the Basic Endpoint.
 * @property nameRegex A regex string to filter results by Global Accelerator Basic Endpoints name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the Global Accelerator Basic Endpoint. Valid Value: `init`, `active`, `updating`, `binding`, `unbinding`, `deleting`, `bound`.
 */
public data class GetBasicEndpointsPlainArgs(
    public val endpointGroupId: String,
    public val endpointId: String? = null,
    public val endpointType: String? = null,
    public val ids: List<String>? = null,
    public val name: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ga.inputs.GetBasicEndpointsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ga.inputs.GetBasicEndpointsPlainArgs =
        com.pulumi.alicloud.ga.inputs.GetBasicEndpointsPlainArgs.builder()
            .endpointGroupId(endpointGroupId.let({ args0 -> args0 }))
            .endpointId(endpointId?.let({ args0 -> args0 }))
            .endpointType(endpointType?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBasicEndpointsPlainArgs].
 */
@PulumiTagMarker
public class GetBasicEndpointsPlainArgsBuilder internal constructor() {
    private var endpointGroupId: String? = null

    private var endpointId: String? = null

    private var endpointType: String? = null

    private var ids: List<String>? = null

    private var name: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    /**
     * @param value The ID of the Basic Endpoint Group.
     */
    @JvmName("tydbtsiukefcdlpm")
    public suspend fun endpointGroupId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.endpointGroupId = mapped
    }

    /**
     * @param value The ID of the Basic Endpoint.
     */
    @JvmName("tgnlticymwhcrugl")
    public suspend fun endpointId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.endpointId = mapped
    }

    /**
     * @param value The type of the Basic Endpoint. Valid values: `ENI`, `SLB`, `ECS` and `NLB`.
     */
    @JvmName("fftlsjdgcwndsind")
    public suspend fun endpointType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.endpointType = mapped
    }

    /**
     * @param value A list of Global Accelerator Basic Endpoints IDs.
     */
    @JvmName("nsqyiwrbghabriut")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Global Accelerator Basic Endpoints IDs.
     */
    @JvmName("kqhswimaeecdbqbm")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The name of the Basic Endpoint.
     */
    @JvmName("wgqwagbxjxfvduwt")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value A regex string to filter results by Global Accelerator Basic Endpoints name.
     */
    @JvmName("sruhmqoojktedant")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("pvgolfqqwpqekvjd")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the Global Accelerator Basic Endpoint. Valid Value: `init`, `active`, `updating`, `binding`, `unbinding`, `deleting`, `bound`.
     */
    @JvmName("aoyjeomlbiycfuux")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetBasicEndpointsPlainArgs = GetBasicEndpointsPlainArgs(
        endpointGroupId = endpointGroupId ?: throw PulumiNullFieldException("endpointGroupId"),
        endpointId = endpointId,
        endpointType = endpointType,
        ids = ids,
        name = name,
        nameRegex = nameRegex,
        outputFile = outputFile,
        status = status,
    )
}
