@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.inputs

import com.pulumi.alicloud.ga.inputs.GetCustomRoutingEndpointGroupDestinationsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getCustomRoutingEndpointGroupDestinations.
 * @property acceleratorId The ID of the GA instance.
 * @property endpointGroupId The ID of the endpoint group.
 * @property fromPort The start port of the backend service port range of the endpoint group. The `from_port` value must be smaller than or equal to the `to_port` value. Valid values: `1` to `65499`.
 * @property ids A list of Custom Routing Endpoint Group Destination IDs.
 * @property listenerId The ID of the listener.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property pageNumber
 * @property pageSize
 * @property protocols The backend service protocol of the endpoint group. Valid values: `TCP`, `UDP`, `TCP, UDP`.
 * @property toPort The end port of the backend service port range of the endpoint group. The `from_port` value must be smaller than or equal to the `to_port` value. Valid values: `1` to `65499`.
 */
public data class GetCustomRoutingEndpointGroupDestinationsPlainArgs(
    public val acceleratorId: String,
    public val endpointGroupId: String? = null,
    public val fromPort: Int? = null,
    public val ids: List<String>? = null,
    public val listenerId: String? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val protocols: List<String>? = null,
    public val toPort: Int? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.ga.inputs.GetCustomRoutingEndpointGroupDestinationsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ga.inputs.GetCustomRoutingEndpointGroupDestinationsPlainArgs =
        com.pulumi.alicloud.ga.inputs.GetCustomRoutingEndpointGroupDestinationsPlainArgs.builder()
            .acceleratorId(acceleratorId.let({ args0 -> args0 }))
            .endpointGroupId(endpointGroupId?.let({ args0 -> args0 }))
            .fromPort(fromPort?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .listenerId(listenerId?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .pageNumber(pageNumber?.let({ args0 -> args0 }))
            .pageSize(pageSize?.let({ args0 -> args0 }))
            .protocols(protocols?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .toPort(toPort?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCustomRoutingEndpointGroupDestinationsPlainArgs].
 */
@PulumiTagMarker
public class GetCustomRoutingEndpointGroupDestinationsPlainArgsBuilder internal constructor() {
    private var acceleratorId: String? = null

    private var endpointGroupId: String? = null

    private var fromPort: Int? = null

    private var ids: List<String>? = null

    private var listenerId: String? = null

    private var outputFile: String? = null

    private var pageNumber: Int? = null

    private var pageSize: Int? = null

    private var protocols: List<String>? = null

    private var toPort: Int? = null

    /**
     * @param value The ID of the GA instance.
     */
    @JvmName("pprwjufllvmlbgwp")
    public suspend fun acceleratorId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.acceleratorId = mapped
    }

    /**
     * @param value The ID of the endpoint group.
     */
    @JvmName("kjvtbrwpfsswvvxl")
    public suspend fun endpointGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.endpointGroupId = mapped
    }

    /**
     * @param value The start port of the backend service port range of the endpoint group. The `from_port` value must be smaller than or equal to the `to_port` value. Valid values: `1` to `65499`.
     */
    @JvmName("kjyajlwbpfccwbod")
    public suspend fun fromPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.fromPort = mapped
    }

    /**
     * @param value A list of Custom Routing Endpoint Group Destination IDs.
     */
    @JvmName("jamaggjpjmaejecu")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Custom Routing Endpoint Group Destination IDs.
     */
    @JvmName("fwmfiwwshkwamguv")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The ID of the listener.
     */
    @JvmName("bvamhewvsvxkilij")
    public suspend fun listenerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.listenerId = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("dmvnknrjiwwyneyt")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("yrcnftnqchnyqvbn")
    public suspend fun pageNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("dykllidcpbjjctde")
    public suspend fun pageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageSize = mapped
    }

    /**
     * @param value The backend service protocol of the endpoint group. Valid values: `TCP`, `UDP`, `TCP, UDP`.
     */
    @JvmName("fvgwwqgrthpkhppe")
    public suspend fun protocols(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.protocols = mapped
    }

    /**
     * @param values The backend service protocol of the endpoint group. Valid values: `TCP`, `UDP`, `TCP, UDP`.
     */
    @JvmName("jpbifrgymkcggwtm")
    public suspend fun protocols(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.protocols = mapped
    }

    /**
     * @param value The end port of the backend service port range of the endpoint group. The `from_port` value must be smaller than or equal to the `to_port` value. Valid values: `1` to `65499`.
     */
    @JvmName("xobfjhdwsgysfypi")
    public suspend fun toPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.toPort = mapped
    }

    internal fun build(): GetCustomRoutingEndpointGroupDestinationsPlainArgs =
        GetCustomRoutingEndpointGroupDestinationsPlainArgs(
            acceleratorId = acceleratorId ?: throw PulumiNullFieldException("acceleratorId"),
            endpointGroupId = endpointGroupId,
            fromPort = fromPort,
            ids = ids,
            listenerId = listenerId,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
            protocols = protocols,
            toPort = toPort,
        )
}
