@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.inputs

import com.pulumi.alicloud.ga.inputs.GetCustomRoutingEndpointGroupsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getCustomRoutingEndpointGroups.
 * @property acceleratorId The ID of the GA instance.
 * @property endpointGroupId The ID of the endpoint group.
 * @property ids A list of Custom Routing Endpoint Group IDs.
 * @property listenerId The ID of the custom routing listener.
 * @property nameRegex A regex string to filter results by Custom Routing Endpoint Group name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property pageNumber
 * @property pageSize
 * @property status The status of the endpoint group. Valid Values: `init`, `active`, `updating`, `deleting`.
 */
public data class GetCustomRoutingEndpointGroupsPlainArgs(
    public val acceleratorId: String,
    public val endpointGroupId: String? = null,
    public val ids: List<String>? = null,
    public val listenerId: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ga.inputs.GetCustomRoutingEndpointGroupsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ga.inputs.GetCustomRoutingEndpointGroupsPlainArgs =
        com.pulumi.alicloud.ga.inputs.GetCustomRoutingEndpointGroupsPlainArgs.builder()
            .acceleratorId(acceleratorId.let({ args0 -> args0 }))
            .endpointGroupId(endpointGroupId?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .listenerId(listenerId?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .pageNumber(pageNumber?.let({ args0 -> args0 }))
            .pageSize(pageSize?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCustomRoutingEndpointGroupsPlainArgs].
 */
@PulumiTagMarker
public class GetCustomRoutingEndpointGroupsPlainArgsBuilder internal constructor() {
    private var acceleratorId: String? = null

    private var endpointGroupId: String? = null

    private var ids: List<String>? = null

    private var listenerId: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var pageNumber: Int? = null

    private var pageSize: Int? = null

    private var status: String? = null

    /**
     * @param value The ID of the GA instance.
     */
    @JvmName("unpkbwkgbjtugxiu")
    public suspend fun acceleratorId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.acceleratorId = mapped
    }

    /**
     * @param value The ID of the endpoint group.
     */
    @JvmName("kgppviyhpeyxejqt")
    public suspend fun endpointGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.endpointGroupId = mapped
    }

    /**
     * @param value A list of Custom Routing Endpoint Group IDs.
     */
    @JvmName("mddmggeuissdpntl")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Custom Routing Endpoint Group IDs.
     */
    @JvmName("teeclgiecowmvoxp")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The ID of the custom routing listener.
     */
    @JvmName("kpdwhwdxddolvobp")
    public suspend fun listenerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.listenerId = mapped
    }

    /**
     * @param value A regex string to filter results by Custom Routing Endpoint Group name.
     */
    @JvmName("eewlipmnmhayvsaw")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("tpscclejqqqpolrq")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("jmrcneubiciidbhg")
    public suspend fun pageNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("heganqprgcwvcuhr")
    public suspend fun pageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageSize = mapped
    }

    /**
     * @param value The status of the endpoint group. Valid Values: `init`, `active`, `updating`, `deleting`.
     */
    @JvmName("odvlqdmqyuqxaion")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetCustomRoutingEndpointGroupsPlainArgs =
        GetCustomRoutingEndpointGroupsPlainArgs(
            acceleratorId = acceleratorId ?: throw PulumiNullFieldException("acceleratorId"),
            endpointGroupId = endpointGroupId,
            ids = ids,
            listenerId = listenerId,
            nameRegex = nameRegex,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
            status = status,
        )
}
