@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.inputs

import com.pulumi.alicloud.ga.inputs.GetCustomRoutingEndpointTrafficPoliciesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getCustomRoutingEndpointTrafficPolicies.
 * @property acceleratorId The ID of the GA instance to which the traffic policies belong.
 * @property address The IP addresses of the traffic policies.
 * @property endpointGroupId The ID of the endpoint group to which the traffic policies belong.
 * @property endpointId The ID of the endpoint to which the traffic policies belong.
 * @property ids A list of Custom Routing Endpoint Traffic Policy IDs.
 * @property listenerId The ID of the listener to which the traffic policies belong.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property pageNumber
 * @property pageSize
 */
public data class GetCustomRoutingEndpointTrafficPoliciesPlainArgs(
    public val acceleratorId: String,
    public val address: String? = null,
    public val endpointGroupId: String? = null,
    public val endpointId: String? = null,
    public val ids: List<String>? = null,
    public val listenerId: String? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.ga.inputs.GetCustomRoutingEndpointTrafficPoliciesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ga.inputs.GetCustomRoutingEndpointTrafficPoliciesPlainArgs =
        com.pulumi.alicloud.ga.inputs.GetCustomRoutingEndpointTrafficPoliciesPlainArgs.builder()
            .acceleratorId(acceleratorId.let({ args0 -> args0 }))
            .address(address?.let({ args0 -> args0 }))
            .endpointGroupId(endpointGroupId?.let({ args0 -> args0 }))
            .endpointId(endpointId?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .listenerId(listenerId?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .pageNumber(pageNumber?.let({ args0 -> args0 }))
            .pageSize(pageSize?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCustomRoutingEndpointTrafficPoliciesPlainArgs].
 */
@PulumiTagMarker
public class GetCustomRoutingEndpointTrafficPoliciesPlainArgsBuilder internal constructor() {
    private var acceleratorId: String? = null

    private var address: String? = null

    private var endpointGroupId: String? = null

    private var endpointId: String? = null

    private var ids: List<String>? = null

    private var listenerId: String? = null

    private var outputFile: String? = null

    private var pageNumber: Int? = null

    private var pageSize: Int? = null

    /**
     * @param value The ID of the GA instance to which the traffic policies belong.
     */
    @JvmName("aqweofpcphhauqaf")
    public suspend fun acceleratorId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.acceleratorId = mapped
    }

    /**
     * @param value The IP addresses of the traffic policies.
     */
    @JvmName("khhngyksjbgokelx")
    public suspend fun address(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.address = mapped
    }

    /**
     * @param value The ID of the endpoint group to which the traffic policies belong.
     */
    @JvmName("xdwtugpxapeuncxc")
    public suspend fun endpointGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.endpointGroupId = mapped
    }

    /**
     * @param value The ID of the endpoint to which the traffic policies belong.
     */
    @JvmName("evvikorbcmqdpjjv")
    public suspend fun endpointId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.endpointId = mapped
    }

    /**
     * @param value A list of Custom Routing Endpoint Traffic Policy IDs.
     */
    @JvmName("yvtkrknoqhehbclw")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Custom Routing Endpoint Traffic Policy IDs.
     */
    @JvmName("eptjjunqlgvvhvtu")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The ID of the listener to which the traffic policies belong.
     */
    @JvmName("isxhjtobbpltuvxl")
    public suspend fun listenerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.listenerId = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("dtajjuhvnnrbgirl")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("tvarvxcbmlquluxx")
    public suspend fun pageNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("koyprkkwsoepmbwr")
    public suspend fun pageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageSize = mapped
    }

    internal fun build(): GetCustomRoutingEndpointTrafficPoliciesPlainArgs =
        GetCustomRoutingEndpointTrafficPoliciesPlainArgs(
            acceleratorId = acceleratorId ?: throw PulumiNullFieldException("acceleratorId"),
            address = address,
            endpointGroupId = endpointGroupId,
            endpointId = endpointId,
            ids = ids,
            listenerId = listenerId,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
        )
}
