@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.inputs

import com.pulumi.alicloud.ga.inputs.GetCustomRoutingEndpointsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getCustomRoutingEndpoints.
 * @property acceleratorId The ID of the GA instance.
 * @property endpointGroupId The ID of the endpoint group.
 * @property ids A list of Custom Routing Endpoint IDs.
 * @property listenerId The ID of the custom routing listener.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property pageNumber
 * @property pageSize
 */
public data class GetCustomRoutingEndpointsPlainArgs(
    public val acceleratorId: String,
    public val endpointGroupId: String? = null,
    public val ids: List<String>? = null,
    public val listenerId: String? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ga.inputs.GetCustomRoutingEndpointsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ga.inputs.GetCustomRoutingEndpointsPlainArgs =
        com.pulumi.alicloud.ga.inputs.GetCustomRoutingEndpointsPlainArgs.builder()
            .acceleratorId(acceleratorId.let({ args0 -> args0 }))
            .endpointGroupId(endpointGroupId?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .listenerId(listenerId?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .pageNumber(pageNumber?.let({ args0 -> args0 }))
            .pageSize(pageSize?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCustomRoutingEndpointsPlainArgs].
 */
@PulumiTagMarker
public class GetCustomRoutingEndpointsPlainArgsBuilder internal constructor() {
    private var acceleratorId: String? = null

    private var endpointGroupId: String? = null

    private var ids: List<String>? = null

    private var listenerId: String? = null

    private var outputFile: String? = null

    private var pageNumber: Int? = null

    private var pageSize: Int? = null

    /**
     * @param value The ID of the GA instance.
     */
    @JvmName("cmosrksdobctrwvp")
    public suspend fun acceleratorId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.acceleratorId = mapped
    }

    /**
     * @param value The ID of the endpoint group.
     */
    @JvmName("mpwisjiknrkowaib")
    public suspend fun endpointGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.endpointGroupId = mapped
    }

    /**
     * @param value A list of Custom Routing Endpoint IDs.
     */
    @JvmName("mfaupgfnehwftvox")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Custom Routing Endpoint IDs.
     */
    @JvmName("okxfveonppckfmxk")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The ID of the custom routing listener.
     */
    @JvmName("livdpuflkaldebqx")
    public suspend fun listenerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.listenerId = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("crltvkfdyaikljdv")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("ehwvpxhonrivlhny")
    public suspend fun pageNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("oiknrpewxfnrdlei")
    public suspend fun pageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageSize = mapped
    }

    internal fun build(): GetCustomRoutingEndpointsPlainArgs = GetCustomRoutingEndpointsPlainArgs(
        acceleratorId = acceleratorId ?: throw PulumiNullFieldException("acceleratorId"),
        endpointGroupId = endpointGroupId,
        ids = ids,
        listenerId = listenerId,
        outputFile = outputFile,
        pageNumber = pageNumber,
        pageSize = pageSize,
    )
}
