@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.inputs

import com.pulumi.alicloud.ga.inputs.GetCustomRoutingPortMappingsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getCustomRoutingPortMappings.
 * @property acceleratorId The ID of the GA instance.
 * @property endpointGroupId The ID of the endpoint group.
 * @property listenerId The ID of the listener.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property pageNumber
 * @property pageSize
 * @property status The access policy of traffic for the backend instance. Valid Values: `allow`, `deny`.
 */
public data class GetCustomRoutingPortMappingsPlainArgs(
    public val acceleratorId: String,
    public val endpointGroupId: String? = null,
    public val listenerId: String? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ga.inputs.GetCustomRoutingPortMappingsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ga.inputs.GetCustomRoutingPortMappingsPlainArgs =
        com.pulumi.alicloud.ga.inputs.GetCustomRoutingPortMappingsPlainArgs.builder()
            .acceleratorId(acceleratorId.let({ args0 -> args0 }))
            .endpointGroupId(endpointGroupId?.let({ args0 -> args0 }))
            .listenerId(listenerId?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .pageNumber(pageNumber?.let({ args0 -> args0 }))
            .pageSize(pageSize?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCustomRoutingPortMappingsPlainArgs].
 */
@PulumiTagMarker
public class GetCustomRoutingPortMappingsPlainArgsBuilder internal constructor() {
    private var acceleratorId: String? = null

    private var endpointGroupId: String? = null

    private var listenerId: String? = null

    private var outputFile: String? = null

    private var pageNumber: Int? = null

    private var pageSize: Int? = null

    private var status: String? = null

    /**
     * @param value The ID of the GA instance.
     */
    @JvmName("nwkwaqcskunwbubr")
    public suspend fun acceleratorId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.acceleratorId = mapped
    }

    /**
     * @param value The ID of the endpoint group.
     */
    @JvmName("klefptwiouaqeroi")
    public suspend fun endpointGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.endpointGroupId = mapped
    }

    /**
     * @param value The ID of the listener.
     */
    @JvmName("rpxqmfyxkocwrkyf")
    public suspend fun listenerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.listenerId = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("gytpiggdriqomdui")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("xaiqxajhfeisjuji")
    public suspend fun pageNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("vsdchaguqktitxre")
    public suspend fun pageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageSize = mapped
    }

    /**
     * @param value The access policy of traffic for the backend instance. Valid Values: `allow`, `deny`.
     */
    @JvmName("yelmdlvbkukpgtiy")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetCustomRoutingPortMappingsPlainArgs =
        GetCustomRoutingPortMappingsPlainArgs(
            acceleratorId = acceleratorId ?: throw PulumiNullFieldException("acceleratorId"),
            endpointGroupId = endpointGroupId,
            listenerId = listenerId,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
            status = status,
        )
}
