@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.inputs

import com.pulumi.alicloud.ga.inputs.GetDomainsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDomains.
 * @property acceleratorId The ID of the global acceleration instance.
 * @property domain The accelerated domain name to be added. only top-level domain names are supported, such as 'example.com'.
 * @property ids A list of Ga Domain IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property pageNumber
 * @property pageSize
 * @property status The status of the resource. Valid values: `illegal`, `inactive`, `active`, `unknown`.
 */
public data class GetDomainsPlainArgs(
    public val acceleratorId: String? = null,
    public val domain: String? = null,
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ga.inputs.GetDomainsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ga.inputs.GetDomainsPlainArgs =
        com.pulumi.alicloud.ga.inputs.GetDomainsPlainArgs.builder()
            .acceleratorId(acceleratorId?.let({ args0 -> args0 }))
            .domain(domain?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .pageNumber(pageNumber?.let({ args0 -> args0 }))
            .pageSize(pageSize?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDomainsPlainArgs].
 */
@PulumiTagMarker
public class GetDomainsPlainArgsBuilder internal constructor() {
    private var acceleratorId: String? = null

    private var domain: String? = null

    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var pageNumber: Int? = null

    private var pageSize: Int? = null

    private var status: String? = null

    /**
     * @param value The ID of the global acceleration instance.
     */
    @JvmName("mjwjjcsuipglgdji")
    public suspend fun acceleratorId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.acceleratorId = mapped
    }

    /**
     * @param value The accelerated domain name to be added. only top-level domain names are supported, such as 'example.com'.
     */
    @JvmName("uwaptudttqyxxjcp")
    public suspend fun domain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.domain = mapped
    }

    /**
     * @param value A list of Ga Domain IDs.
     */
    @JvmName("twfoqfkpwxnvlpbq")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Ga Domain IDs.
     */
    @JvmName("dtrsopvjmjpqsefr")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("jrunaguiwxjhrnlo")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("xknyyctcgkhdbdyu")
    public suspend fun pageNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("wmjybxwfkxixrtfr")
    public suspend fun pageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageSize = mapped
    }

    /**
     * @param value The status of the resource. Valid values: `illegal`, `inactive`, `active`, `unknown`.
     */
    @JvmName("wbfgukbcebtraemp")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetDomainsPlainArgs = GetDomainsPlainArgs(
        acceleratorId = acceleratorId,
        domain = domain,
        ids = ids,
        outputFile = outputFile,
        pageNumber = pageNumber,
        pageSize = pageSize,
        status = status,
    )
}
