@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.inputs

import com.pulumi.alicloud.ga.inputs.GetEndpointGroupIpAddressCidrBlocksPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getEndpointGroupIpAddressCidrBlocks.
 * @property endpointGroupRegion The region ID of the endpoint group.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetEndpointGroupIpAddressCidrBlocksPlainArgs(
    public val endpointGroupRegion: String,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ga.inputs.GetEndpointGroupIpAddressCidrBlocksPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ga.inputs.GetEndpointGroupIpAddressCidrBlocksPlainArgs = com.pulumi.alicloud.ga.inputs.GetEndpointGroupIpAddressCidrBlocksPlainArgs.builder()
        .endpointGroupRegion(endpointGroupRegion.let({ args0 -> args0 }))
        .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEndpointGroupIpAddressCidrBlocksPlainArgs].
 */
@PulumiTagMarker
public class GetEndpointGroupIpAddressCidrBlocksPlainArgsBuilder internal constructor() {
    private var endpointGroupRegion: String? = null

    private var outputFile: String? = null

    /**
     * @param value The region ID of the endpoint group.
     */
    @JvmName("prxkglyfbdprhqef")
    public suspend fun endpointGroupRegion(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.endpointGroupRegion = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("teruiexesjqrvkhf")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetEndpointGroupIpAddressCidrBlocksPlainArgs =
        GetEndpointGroupIpAddressCidrBlocksPlainArgs(
            endpointGroupRegion = endpointGroupRegion ?: throw PulumiNullFieldException("endpointGroupRegion"),
            outputFile = outputFile,
        )
}
