@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.inputs

import com.pulumi.alicloud.ga.inputs.GetEndpointGroupsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getEndpointGroups.
 * @property acceleratorId The ID of the Global Accelerator instance to which the endpoint group will be added.
 * @property endpointGroupType The endpoint group type. Default value: `default`. Valid values: `default`, `virtual`.
 * @property ids A list of Endpoint Group IDs.
 * @property listenerId The ID of the listener that is associated with the endpoint group.
 * @property nameRegex A regex string to filter results by Endpoint Group name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the endpoint group. Valid values: `active`, `configuring`, `creating`, `init`.
 */
public data class GetEndpointGroupsPlainArgs(
    public val acceleratorId: String,
    public val endpointGroupType: String? = null,
    public val ids: List<String>? = null,
    public val listenerId: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ga.inputs.GetEndpointGroupsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ga.inputs.GetEndpointGroupsPlainArgs =
        com.pulumi.alicloud.ga.inputs.GetEndpointGroupsPlainArgs.builder()
            .acceleratorId(acceleratorId.let({ args0 -> args0 }))
            .endpointGroupType(endpointGroupType?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .listenerId(listenerId?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEndpointGroupsPlainArgs].
 */
@PulumiTagMarker
public class GetEndpointGroupsPlainArgsBuilder internal constructor() {
    private var acceleratorId: String? = null

    private var endpointGroupType: String? = null

    private var ids: List<String>? = null

    private var listenerId: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    /**
     * @param value The ID of the Global Accelerator instance to which the endpoint group will be added.
     */
    @JvmName("tctepkmjbobwuiwa")
    public suspend fun acceleratorId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.acceleratorId = mapped
    }

    /**
     * @param value The endpoint group type. Default value: `default`. Valid values: `default`, `virtual`.
     */
    @JvmName("hqiyduefdvxumkck")
    public suspend fun endpointGroupType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.endpointGroupType = mapped
    }

    /**
     * @param value A list of Endpoint Group IDs.
     */
    @JvmName("rselcuvhkyuolysh")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Endpoint Group IDs.
     */
    @JvmName("vncurmukbmhmtoxx")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The ID of the listener that is associated with the endpoint group.
     */
    @JvmName("phbcjxfltpakdhcm")
    public suspend fun listenerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.listenerId = mapped
    }

    /**
     * @param value A regex string to filter results by Endpoint Group name.
     */
    @JvmName("ccixajobihfvleht")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("twmeijvxawnpfviu")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the endpoint group. Valid values: `active`, `configuring`, `creating`, `init`.
     */
    @JvmName("saykpkhechcnpgyy")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetEndpointGroupsPlainArgs = GetEndpointGroupsPlainArgs(
        acceleratorId = acceleratorId ?: throw PulumiNullFieldException("acceleratorId"),
        endpointGroupType = endpointGroupType,
        ids = ids,
        listenerId = listenerId,
        nameRegex = nameRegex,
        outputFile = outputFile,
        status = status,
    )
}
