@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.inputs

import com.pulumi.alicloud.ga.inputs.GetForwardingRulesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getForwardingRules.
 * @property acceleratorId The ID of the Global Accelerator instance.
 * @property ids A list of Forwarding Rule IDs.
 * @property listenerId The ID of the listener.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the acceleration region. Valid values: `active`, `configuring`.
 */
public data class GetForwardingRulesPlainArgs(
    public val acceleratorId: String,
    public val ids: List<String>? = null,
    public val listenerId: String,
    public val outputFile: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ga.inputs.GetForwardingRulesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ga.inputs.GetForwardingRulesPlainArgs =
        com.pulumi.alicloud.ga.inputs.GetForwardingRulesPlainArgs.builder()
            .acceleratorId(acceleratorId.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .listenerId(listenerId.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetForwardingRulesPlainArgs].
 */
@PulumiTagMarker
public class GetForwardingRulesPlainArgsBuilder internal constructor() {
    private var acceleratorId: String? = null

    private var ids: List<String>? = null

    private var listenerId: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    /**
     * @param value The ID of the Global Accelerator instance.
     */
    @JvmName("lwcjkejqiqloqfut")
    public suspend fun acceleratorId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.acceleratorId = mapped
    }

    /**
     * @param value A list of Forwarding Rule IDs.
     */
    @JvmName("lhnxgyqricwruftk")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Forwarding Rule IDs.
     */
    @JvmName("nunveyjbrelkpfih")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The ID of the listener.
     */
    @JvmName("axofatbqjtjgvdau")
    public suspend fun listenerId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.listenerId = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("xoksgpxfjqisccqh")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the acceleration region. Valid values: `active`, `configuring`.
     */
    @JvmName("dxfkfqmrbodwqacf")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetForwardingRulesPlainArgs = GetForwardingRulesPlainArgs(
        acceleratorId = acceleratorId ?: throw PulumiNullFieldException("acceleratorId"),
        ids = ids,
        listenerId = listenerId ?: throw PulumiNullFieldException("listenerId"),
        outputFile = outputFile,
        status = status,
    )
}
