@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.inputs

import com.pulumi.alicloud.ga.inputs.GetListenersPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getListeners.
 * @property acceleratorId The accelerator id.
 * @property ids A list of Listener IDs.
 * @property nameRegex A regex string to filter results by Listener name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the listener. Valid values: `active`, `configuring`, `creating`.
 */
public data class GetListenersPlainArgs(
    public val acceleratorId: String,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ga.inputs.GetListenersPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ga.inputs.GetListenersPlainArgs =
        com.pulumi.alicloud.ga.inputs.GetListenersPlainArgs.builder()
            .acceleratorId(acceleratorId.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetListenersPlainArgs].
 */
@PulumiTagMarker
public class GetListenersPlainArgsBuilder internal constructor() {
    private var acceleratorId: String? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    /**
     * @param value The accelerator id.
     */
    @JvmName("ecettwaeyhmutelx")
    public suspend fun acceleratorId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.acceleratorId = mapped
    }

    /**
     * @param value A list of Listener IDs.
     */
    @JvmName("qbcaiyoweoysjfnn")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Listener IDs.
     */
    @JvmName("wiqqribtxgfgugqp")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Listener name.
     */
    @JvmName("fygatvgowiigjmyl")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("ecuvgtiwdwwdfsdi")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the listener. Valid values: `active`, `configuring`, `creating`.
     */
    @JvmName("olkwonqvdsvonomj")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetListenersPlainArgs = GetListenersPlainArgs(
        acceleratorId = acceleratorId ?: throw PulumiNullFieldException("acceleratorId"),
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        status = status,
    )
}
