@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.inputs

import com.pulumi.alicloud.ga.inputs.ListenerCertificateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property id The id of the certificate.
 */
public data class ListenerCertificateArgs(
    public val id: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ga.inputs.ListenerCertificateArgs> {
    override fun toJava(): com.pulumi.alicloud.ga.inputs.ListenerCertificateArgs =
        com.pulumi.alicloud.ga.inputs.ListenerCertificateArgs.builder()
            .id(id?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ListenerCertificateArgs].
 */
@PulumiTagMarker
public class ListenerCertificateArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value The id of the certificate.
     */
    @JvmName("cmhlxndymlnutqwd")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The id of the certificate.
     */
    @JvmName("mjbcybecjjllaiam")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): ListenerCertificateArgs = ListenerCertificateArgs(
        id = id,
    )
}
