@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.inputs

import com.pulumi.alicloud.ga.inputs.ListenerForwardedForConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property forwardedForGaApEnabled Specifies whether to use the GA-AP header to retrieve the information about acceleration regions. Default value: `false`. Valid values:
 * @property forwardedForGaIdEnabled Specifies whether to use the GA-ID header to retrieve the ID of the GA instance. Default value: `false`. Valid values:
 * @property forwardedForPortEnabled Specifies whether to use the GA-X-Forward-Port header to retrieve the listener ports of the GA instance. Default value: `false`. Valid values:
 * @property forwardedForProtoEnabled Specifies whether to use the GA-X-Forward-Proto header to retrieve the listener protocol of the GA instance. Default value: `false`. Valid values:
 * @property realIpEnabled Specifies whether to use the X-Real-IP header to retrieve client IP addresses. Default value: `false`. Valid values:
 */
public data class ListenerForwardedForConfigArgs(
    public val forwardedForGaApEnabled: Output<Boolean>? = null,
    public val forwardedForGaIdEnabled: Output<Boolean>? = null,
    public val forwardedForPortEnabled: Output<Boolean>? = null,
    public val forwardedForProtoEnabled: Output<Boolean>? = null,
    public val realIpEnabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ga.inputs.ListenerForwardedForConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.ga.inputs.ListenerForwardedForConfigArgs =
        com.pulumi.alicloud.ga.inputs.ListenerForwardedForConfigArgs.builder()
            .forwardedForGaApEnabled(forwardedForGaApEnabled?.applyValue({ args0 -> args0 }))
            .forwardedForGaIdEnabled(forwardedForGaIdEnabled?.applyValue({ args0 -> args0 }))
            .forwardedForPortEnabled(forwardedForPortEnabled?.applyValue({ args0 -> args0 }))
            .forwardedForProtoEnabled(forwardedForProtoEnabled?.applyValue({ args0 -> args0 }))
            .realIpEnabled(realIpEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ListenerForwardedForConfigArgs].
 */
@PulumiTagMarker
public class ListenerForwardedForConfigArgsBuilder internal constructor() {
    private var forwardedForGaApEnabled: Output<Boolean>? = null

    private var forwardedForGaIdEnabled: Output<Boolean>? = null

    private var forwardedForPortEnabled: Output<Boolean>? = null

    private var forwardedForProtoEnabled: Output<Boolean>? = null

    private var realIpEnabled: Output<Boolean>? = null

    /**
     * @param value Specifies whether to use the GA-AP header to retrieve the information about acceleration regions. Default value: `false`. Valid values:
     */
    @JvmName("rvlvpvujiwjsobva")
    public suspend fun forwardedForGaApEnabled(`value`: Output<Boolean>) {
        this.forwardedForGaApEnabled = value
    }

    /**
     * @param value Specifies whether to use the GA-ID header to retrieve the ID of the GA instance. Default value: `false`. Valid values:
     */
    @JvmName("ygxvlrinuvkhtyfh")
    public suspend fun forwardedForGaIdEnabled(`value`: Output<Boolean>) {
        this.forwardedForGaIdEnabled = value
    }

    /**
     * @param value Specifies whether to use the GA-X-Forward-Port header to retrieve the listener ports of the GA instance. Default value: `false`. Valid values:
     */
    @JvmName("ffnbdumybxgasode")
    public suspend fun forwardedForPortEnabled(`value`: Output<Boolean>) {
        this.forwardedForPortEnabled = value
    }

    /**
     * @param value Specifies whether to use the GA-X-Forward-Proto header to retrieve the listener protocol of the GA instance. Default value: `false`. Valid values:
     */
    @JvmName("gedmmkkeeetodmbq")
    public suspend fun forwardedForProtoEnabled(`value`: Output<Boolean>) {
        this.forwardedForProtoEnabled = value
    }

    /**
     * @param value Specifies whether to use the X-Real-IP header to retrieve client IP addresses. Default value: `false`. Valid values:
     */
    @JvmName("ttfcughxivdyjaix")
    public suspend fun realIpEnabled(`value`: Output<Boolean>) {
        this.realIpEnabled = value
    }

    /**
     * @param value Specifies whether to use the GA-AP header to retrieve the information about acceleration regions. Default value: `false`. Valid values:
     */
    @JvmName("vxwnbduecfdfacbe")
    public suspend fun forwardedForGaApEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forwardedForGaApEnabled = mapped
    }

    /**
     * @param value Specifies whether to use the GA-ID header to retrieve the ID of the GA instance. Default value: `false`. Valid values:
     */
    @JvmName("qmdashubhrgvysgv")
    public suspend fun forwardedForGaIdEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forwardedForGaIdEnabled = mapped
    }

    /**
     * @param value Specifies whether to use the GA-X-Forward-Port header to retrieve the listener ports of the GA instance. Default value: `false`. Valid values:
     */
    @JvmName("jllrwekukndmnbxm")
    public suspend fun forwardedForPortEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forwardedForPortEnabled = mapped
    }

    /**
     * @param value Specifies whether to use the GA-X-Forward-Proto header to retrieve the listener protocol of the GA instance. Default value: `false`. Valid values:
     */
    @JvmName("plpvqxtjpmqwordb")
    public suspend fun forwardedForProtoEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forwardedForProtoEnabled = mapped
    }

    /**
     * @param value Specifies whether to use the X-Real-IP header to retrieve client IP addresses. Default value: `false`. Valid values:
     */
    @JvmName("ygtpfbskwrqvhpsc")
    public suspend fun realIpEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.realIpEnabled = mapped
    }

    internal fun build(): ListenerForwardedForConfigArgs = ListenerForwardedForConfigArgs(
        forwardedForGaApEnabled = forwardedForGaApEnabled,
        forwardedForGaIdEnabled = forwardedForGaIdEnabled,
        forwardedForPortEnabled = forwardedForPortEnabled,
        forwardedForProtoEnabled = forwardedForProtoEnabled,
        realIpEnabled = realIpEnabled,
    )
}
