@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.inputs

import com.pulumi.alicloud.ga.inputs.ListenerPortRangeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property fromPort The initial listening port used to receive requests and forward them to terminal nodes.
 * @property toPort The end listening port used to receive requests and forward them to terminal nodes.
 */
public data class ListenerPortRangeArgs(
    public val fromPort: Output<Int>,
    public val toPort: Output<Int>,
) : ConvertibleToJava<com.pulumi.alicloud.ga.inputs.ListenerPortRangeArgs> {
    override fun toJava(): com.pulumi.alicloud.ga.inputs.ListenerPortRangeArgs =
        com.pulumi.alicloud.ga.inputs.ListenerPortRangeArgs.builder()
            .fromPort(fromPort.applyValue({ args0 -> args0 }))
            .toPort(toPort.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ListenerPortRangeArgs].
 */
@PulumiTagMarker
public class ListenerPortRangeArgsBuilder internal constructor() {
    private var fromPort: Output<Int>? = null

    private var toPort: Output<Int>? = null

    /**
     * @param value The initial listening port used to receive requests and forward them to terminal nodes.
     */
    @JvmName("fmifewgopsckykxb")
    public suspend fun fromPort(`value`: Output<Int>) {
        this.fromPort = value
    }

    /**
     * @param value The end listening port used to receive requests and forward them to terminal nodes.
     */
    @JvmName("fjssnerhcmynfcdb")
    public suspend fun toPort(`value`: Output<Int>) {
        this.toPort = value
    }

    /**
     * @param value The initial listening port used to receive requests and forward them to terminal nodes.
     */
    @JvmName("pqpcwowfospsbvpt")
    public suspend fun fromPort(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fromPort = mapped
    }

    /**
     * @param value The end listening port used to receive requests and forward them to terminal nodes.
     */
    @JvmName("crgwpxpisdrrhqwg")
    public suspend fun toPort(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.toPort = mapped
    }

    internal fun build(): ListenerPortRangeArgs = ListenerPortRangeArgs(
        fromPort = fromPort ?: throw PulumiNullFieldException("fromPort"),
        toPort = toPort ?: throw PulumiNullFieldException("toPort"),
    )
}
