@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property entry The IP address(192.168.XX.XX) or CIDR(10.0.XX.XX/24) block that you want to add to the network ACL.
 * @property entryDescription The description of the IP entry. The description must be `1` to `256` characters in length, and can contain letters, digits, hyphens (-), forward slashes (/), periods (.),and underscores (_).
 */
public data class AclAclEntry(
    public val entry: String? = null,
    public val entryDescription: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ga.outputs.AclAclEntry): AclAclEntry =
            AclAclEntry(
                entry = javaType.entry().map({ args0 -> args0 }).orElse(null),
                entryDescription = javaType.entryDescription().map({ args0 -> args0 }).orElse(null),
            )
    }
}
