@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property enableClientipPreservation Indicates whether client IP addresses are reserved. Default Value: `false`. Valid values:
 * @property enableProxyProtocol Specifies whether to preserve client IP addresses by using the ProxyProtocol module. Default Value: `false`. Valid values:
 * @property endpoint The IP address or domain name of Endpoint N in the endpoint group.
 * @property type The type of Endpoint N in the endpoint group. Valid values:
 * - `Domain`: a custom domain name.
 * - `Ip`: a custom IP address.
 * - `PublicIp`: an Alibaba Cloud public IP address.
 * - `ECS`: an Alibaba Cloud Elastic Compute Service (ECS) instance.
 * - `SLB`: an Alibaba Cloud Server Load Balancer (SLB) instance.
 * > **NOTE:** When the terminal node type is ECS or SLB, if the service association role does not exist, the system will automatically create a service association role named aliyunserviceroleforgavpcndpoint.
 * @property weight The weight of Endpoint N in the endpoint group. Valid values: `0` to `255`.
 * > **NOTE:** If the weight of a terminal node is set to 0, global acceleration will terminate the distribution of traffic to the terminal node. Please be careful.
 */
public data class EndpointGroupEndpointConfiguration(
    public val enableClientipPreservation: Boolean? = null,
    public val enableProxyProtocol: Boolean? = null,
    public val endpoint: String,
    public val type: String,
    public val weight: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ga.outputs.EndpointGroupEndpointConfiguration): EndpointGroupEndpointConfiguration = EndpointGroupEndpointConfiguration(
            enableClientipPreservation = javaType.enableClientipPreservation().map({ args0 ->
                args0
            }).orElse(null),
            enableProxyProtocol = javaType.enableProxyProtocol().map({ args0 -> args0 }).orElse(null),
            endpoint = javaType.endpoint(),
            type = javaType.type(),
            weight = javaType.weight(),
        )
    }
}
