@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property forwardGroupConfig Forwarding configuration. See `forward_group_config` below.
 * > **NOTE:** From version 1.207.0, We recommend that you do not use `forward_group_config`, and we recommend that you use the `rule_action_type` and `rule_action_value` to configure forwarding actions.
 * @property order Forwarding priority.
 * @property ruleActionType Forward action type.
 * @property ruleActionValue The value of the forwarding action type. For more information, see [How to use it](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-createforwardingrules).
 */
public data class ForwardingRuleRuleAction(
    public val forwardGroupConfig: ForwardingRuleRuleActionForwardGroupConfig? = null,
    public val order: Int,
    public val ruleActionType: String,
    public val ruleActionValue: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ga.outputs.ForwardingRuleRuleAction): ForwardingRuleRuleAction = ForwardingRuleRuleAction(
            forwardGroupConfig = javaType.forwardGroupConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ga.kotlin.outputs.ForwardingRuleRuleActionForwardGroupConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            order = javaType.order(),
            ruleActionType = javaType.ruleActionType(),
            ruleActionValue = javaType.ruleActionValue().map({ args0 -> args0 }).orElse(null),
        )
    }
}
