@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property hostConfigs The configuration of the domain name. See `host_config` below.
 * @property pathConfig The configuration of the path. See `path_config` below.
 * @property ruleConditionType The type of the forwarding conditions. Valid values: `Host`, `Path`.
 */
public data class ForwardingRuleRuleCondition(
    public val hostConfigs: List<ForwardingRuleRuleConditionHostConfig>? = null,
    public val pathConfig: ForwardingRuleRuleConditionPathConfig? = null,
    public val ruleConditionType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ga.outputs.ForwardingRuleRuleCondition): ForwardingRuleRuleCondition = ForwardingRuleRuleCondition(
            hostConfigs = javaType.hostConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ga.kotlin.outputs.ForwardingRuleRuleConditionHostConfig.Companion.toKotlin(args0)
                })
            }),
            pathConfig = javaType.pathConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ga.kotlin.outputs.ForwardingRuleRuleConditionPathConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            ruleConditionType = javaType.ruleConditionType(),
        )
    }
}
