@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property acceleratorId The ID of the global acceleration instance.
 * @property id The ID of the Accelerator Spare Ip Attachment.
 * @property spareIp The standby IP address of CNAME. When the acceleration area is abnormal, the traffic is switched to the standby IP address.
 * @property status The status of the standby CNAME IP address. Valid values: `active`, `inuse`.
 */
public data class GetAcceleratorSpareIpAttachmentsAttachment(
    public val acceleratorId: String,
    public val id: String,
    public val spareIp: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ga.outputs.GetAcceleratorSpareIpAttachmentsAttachment): GetAcceleratorSpareIpAttachmentsAttachment = GetAcceleratorSpareIpAttachmentsAttachment(
            acceleratorId = javaType.acceleratorId(),
            id = javaType.id(),
            spareIp = javaType.spareIp(),
            status = javaType.status(),
        )
    }
}
